/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.data.cache;

import com.adventnet.la.TimePack;
import com.manageengine.ela.server.common.io.file.FileHandler;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.common.handler.ExecutorServiceHandler;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.data.ActivityDocData;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import com.zoho.za.dae.elastic.BulkProcessListener;
import com.zoho.za.dae.elastic.LogIndexer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;

public class ActivityPrimaryDocHandler {
    private static final Logger LOGGER = Logger.getLogger(ActivityPrimaryDocHandler.class.getName());
    private static final ScheduledExecutorService DISPATCHER;
    public static List<ActivityDocData> primaryDocIDCache;
    private static AtomicBoolean flag;
    private static AtomicInteger rejectCount;
    private static ReentrantLock lock;

    public static void init() {
        String path = CorrConfigInfo.ACTIVITY_STORE_PATH + "docCache.dmp";
        BulkProcessListener.registerCallBack((BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long l, BulkRequest bulkRequest) {
            }

            public void afterBulk(long l, BulkRequest bulkRequest, BulkResponse bulkResponse) {
                try {
                    flag.set(true);
                }
                catch (Throwable exp) {
                    LOGGER.log(Level.WARNING, "Error occurred during activity doc cache processing {0}", new Object[]{exp.getMessage()});
                }
            }

            public void afterBulk(long l, BulkRequest bulkRequest, Throwable throwable) {
            }
        });
        try {
            File file = new File(path);
            if (file.exists()) {
                LOGGER.log(Level.INFO, "Loading activity unprocessed data");
                primaryDocIDCache.addAll((List)FileHandler.readObjectFromFile(file));
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Failed to read activity data. {0}", exp.getMessage());
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                int size = primaryDocIDCache.size();
                if (size > 0) {
                    LOGGER.log(Level.INFO, "Shutdown hook : Backing up unprocessed {0} logs to disk.", size);
                    FileHandler.storeObjectInFIle(primaryDocIDCache, new File(path));
                }
            }));
        }
    }

    public static void insert(ActivityDocData data) {
        lock.lock();
        try {
            primaryDocIDCache.add(data);
            LOGGER.log(Level.FINER, "Primary docID cached {0} for rule {1}", new Object[]{data.getDocID(), data.getRuleType()});
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resolveCachedData() {
        lock.lock();
        try {
            LOGGER.log(Level.FINE, "Bulkprocessor listener callback received for activity. Total docs to process = {0}", primaryDocIDCache.size());
            Iterator<ActivityDocData> cacheIterator = primaryDocIDCache.iterator();
            boolean isEverythingIndexed = true;
            while (cacheIterator.hasNext()) {
                ActivityDocData docEntry = cacheIterator.next();
                try {
                    String primaryDocID = docEntry.getDocID();
                    TimePack timePack = new TimePack(TimeZone.getDefault());
                    String indexName = LogIndexer.getIndexName((Object)docEntry.getTime());
                    Map<String, Object> data = CorrNosqlIndexHandler.getIndexedDocInfo(indexName, primaryDocID, timePack);
                    if (data == null) {
                        LOGGER.log(Level.FINE, "Cached doc is not yet indexed {0}", new Object[]{primaryDocID});
                        isEverythingIndexed = false;
                        continue;
                    }
                    ActivityProviderInfo providerInfo = ActivityProfileContainer.get().getProviderInfo(docEntry.getProfileID(), docEntry.getProviderID());
                    boolean isProcessed = ActivityUtil.getListener(providerInfo).processResolvedLog(docEntry, data, false);
                    if (isProcessed) {
                        cacheIterator.remove();
                        continue;
                    }
                    LOGGER.log(Level.FINER, "[Z]processResolvedLog returned false.");
                }
                catch (Exception exp) {
                    LOGGER.log(Level.WARNING, "Error occurred during activity data processing for entry {0}. StackTrace = {1}", new Object[]{docEntry, exp.getMessage()});
                }
            }
            if (isEverythingIndexed) {
                flag.set(Boolean.FALSE);
            }
        }
        catch (Throwable err) {
            LOGGER.log(Level.WARNING, "Error occurred during data resolution", err);
        }
        finally {
            lock.unlock();
        }
    }

    static {
        lock = new ReentrantLock(true);
        primaryDocIDCache = Collections.synchronizedList(new ArrayList());
        flag = new AtomicBoolean(Boolean.FALSE);
        rejectCount = new AtomicInteger(0);
        DISPATCHER = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
                paramThread.setName("correlation[session][data][dispatcher]");
                super.beforeExecute(paramThread, paramRunnable);
            }
        };
        DISPATCHER.scheduleWithFixedDelay(() -> {
            block7: {
                try {
                    if (flag.get() || rejectCount.get() > 1) {
                        try {
                            ActivityPrimaryDocHandler.resolveCachedData();
                            break block7;
                        }
                        finally {
                            flag.set(Boolean.FALSE);
                            rejectCount.set(0);
                        }
                    }
                    if (!primaryDocIDCache.isEmpty()) {
                        rejectCount.incrementAndGet();
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, "Exception occurred during activity cache resolve {0}", throwable.getMessage());
                }
            }
        }, 0L, 10000L, TimeUnit.MILLISECONDS);
        ExecutorServiceHandler.registerExecutorForShutdown(DISPATCHER);
    }
}

