/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.data.cache;

import com.manageengine.ela.server.common.cache.OffHeapCache;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OffHeapDataHandler {
    private static final Logger LOGGER = Logger.getLogger(OffHeapDataHandler.class.getName());
    private static final OffHeapDataHandler INSTANCE = new OffHeapDataHandler();
    private OffHeapCache terminatorCache = OffHeapCache.getInstance().setCustomStore("terminator");
    private OffHeapCache breakerCache = OffHeapCache.getInstance().setCustomStore("breaker");
    private OffHeapCache initiatorCache = OffHeapCache.getInstance().setCustomStore("initiator");

    private OffHeapDataHandler() {
    }

    public static OffHeapDataHandler get() {
        return INSTANCE;
    }

    public void storeTerminatorDependentData(Long terminatorID, String keyDocID, Map<Long, Map<Long, List<String>>> dependentDocIDs) {
        Map map = this.terminatorCache.get(String.valueOf(terminatorID));
        if (map != null) {
            map.put(keyDocID, dependentDocIDs);
        } else {
            LOGGER.log(Level.WARNING, "Cant store terminator data using MapDB. Null map returned");
        }
    }

    public void storeInitiatorDependentData(Long initiatorID, String keyDocID, Map<Long, Map<Long, List<String>>> dependentDocIDs) {
        Map map = this.initiatorCache.get(String.valueOf(initiatorID));
        if (map != null) {
            map.put(keyDocID, dependentDocIDs);
        } else {
            LOGGER.log(Level.WARNING, "Cant store initiator data using MapDB. Null map returned");
        }
    }

    public void storeBreakerDependentData(Long breakerID, String primaryDocID, Map<Long, Map<Long, List<String>>> dependentDocIDs) {
        Map map = this.breakerCache.get(String.valueOf(breakerID));
        if (map != null) {
            map.put(primaryDocID, dependentDocIDs);
        } else {
            LOGGER.log(Level.WARNING, "Cant store breaker data using MapDB. Null map returned");
        }
    }

    public Map<Long, Map<Long, List<String>>> fetchAndRemoveTerminatorDepData(Long terminatorID, String primaryDocID) {
        Map map = this.terminatorCache.get(String.valueOf(terminatorID));
        if (map != null && map.containsKey(primaryDocID)) {
            return (Map)map.remove(primaryDocID);
        }
        return null;
    }

    public Map<Long, Map<Long, List<String>>> fetchAndRemoveBreakerDepData(Long breakerID, String primaryDocID) {
        Map map = this.breakerCache.get(String.valueOf(breakerID));
        if (map != null && map.containsKey(primaryDocID)) {
            return (Map)map.remove(primaryDocID);
        }
        return null;
    }

    public Map<Long, Map<Long, List<String>>> fetchAndRemoveInitiatorDepData(Long initiatorID, String primaryDocID) {
        Map map = this.initiatorCache.get(String.valueOf(initiatorID));
        if (map != null && map.containsKey(primaryDocID)) {
            return (Map)map.remove(primaryDocID);
        }
        return null;
    }

    public Map<Long, Map<Long, List<String>>> fetchInitiatorDepData(Long initiatorID, String primaryDocID) {
        Map map = this.initiatorCache.get(String.valueOf(initiatorID));
        if (map != null && map.containsKey(primaryDocID)) {
            return (Map)map.get(primaryDocID);
        }
        return null;
    }

    public void deleteTerminatorDependentData(Long terminatorID, String primaryDocID) {
        Map map = this.terminatorCache.get(String.valueOf(terminatorID));
        if (map != null) {
            map.remove(primaryDocID);
        }
    }

    public void deleteBreakerDependentData(Long breakerID, String primaryDocID) {
        Map map = this.breakerCache.get(String.valueOf(breakerID));
        if (map != null) {
            map.remove(primaryDocID);
        }
    }

    public void deleteInitiatorDependentData(Long initiatorID, String docID) {
        Map map = this.initiatorCache.get(String.valueOf(initiatorID));
        if (map != null) {
            map.remove(docID);
        }
    }
}

