/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.dataloader;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ActArchiveDataLoader {
    private static final Logger LOGGER = Logger.getLogger(ActArchiveDataLoader.class.getName());

    public static Map<Long, JSONObject> getActivityStatus(String tableName, Long[] historyID) throws Exception {
        HashMap<Long, JSONObject> response = new HashMap<Long, JSONObject>();
        LinkedList<Map<String, Object>> val = ActArchiveDataLoader.fetchDataFromTable(tableName, Arrays.asList("HISTORY_ID", "STATUS", "START_TIME", "END_TIME", "PROVIDER_ID"), "HISTORY_ID", historyID);
        for (Map map : val) {
            Long st = (Long)map.get("STATUS");
            Long histID = (Long)map.get("HISTORY_ID");
            ActivityStatus status = ActivityStatus.getStatus(st);
            JSONObject entry = new JSONObject();
            entry.put("STATUS", (Object)status.getValue());
            entry.put("HISTORY_ID", (Object)historyID);
            entry.put("END_TIME", map.get("END_TIME"));
            entry.put("START_TIME", map.get("START_TIME"));
            entry.put("PROVIDER_ID", map.get("PROVIDER_ID"));
            response.put(histID, entry);
        }
        return response;
    }

    public static Map<Long, JSONObject> getActivityStatus(Long tableID, Long[] historyID) {
        try {
            return ActArchiveDataLoader.getActivityStatus(ActArchiveDataLoader.resolveTableID(tableID), historyID);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during fetching activity history status from archive {0}", exp.getMessage());
            return new HashMap<Long, JSONObject>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedList<Map<String, Object>> fetchDataFromTable(String tableName, List<String> columns, String primaryCol, Object[] primaryVal) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
        for (String col : columns) {
            query.addSelectColumn(Column.getColumn((String)tableName, (String)col));
        }
        query.setCriteria(new Criteria(Column.getColumn((String)tableName, (String)primaryCol), (Object)primaryVal, 8));
        Connection connection = null;
        DataSet dataSet = null;
        try {
            RelationalAPI api = RelationalAPI.getInstance();
            connection = api.getConnection();
            dataSet = api.getArchiveAdapter().getArchiveData((SelectQuery)query, connection);
            while (dataSet.next()) {
                HashMap<String, Object> response = new HashMap<String, Object>();
                for (String col : columns) {
                    Object value = dataSet.getValue(col);
                    if (value == null) continue;
                    response.put(col, value);
                }
                result.add(response);
            }
        }
        catch (Exception exp) {
            try {
                LOGGER.log(Level.INFO, "Error occurred during fetching activity history data from archive {0}", exp.getMessage());
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetOrDataSet(null, dataSet);
                DBUtil.closeStmtAndConnection(null, connection);
                throw throwable;
            }
            DBUtil.closeResultSetOrDataSet(null, dataSet);
            DBUtil.closeStmtAndConnection(null, connection);
        }
        DBUtil.closeResultSetOrDataSet(null, dataSet);
        DBUtil.closeStmtAndConnection(null, connection);
        return result;
    }

    public static Map<String, Object> fetchActivityHistoryData(Long docTableID, Long historyID) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityArchivedTablesInfo"));
            Join histJoin = new Join(Table.getTable((String)"ActivityArchivedTablesInfo", (String)"ActivityArchivedTablesInfo"), Table.getTable((String)"ArchiveTableDetails", (String)"ArchiveTableDetails_HIST"), new String[]{"HISTORY_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 1);
            Join docJoin = new Join(Table.getTable((String)"ActivityArchivedTablesInfo", (String)"ActivityArchivedTablesInfo"), Table.getTable((String)"ArchiveTableDetails", (String)"ArchiveTableDetails_IDOC"), new String[]{"INIT_DOC_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 1);
            selectQuery.addJoin(histJoin);
            selectQuery.addJoin(docJoin);
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"ARCHIVE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"HISTORY_TABLE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"INIT_DOC_TABLE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ArchiveTableDetails_HIST", (String)"ARCHIVED_TABLENAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ArchiveTableDetails_HIST", (String)"ARCHIVE_TABLE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ArchiveTableDetails_IDOC", (String)"ARCHIVED_TABLENAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ArchiveTableDetails_IDOC", (String)"ARCHIVE_TABLE_ID"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"INIT_DOC_TABLE_ID"), (Object)docTableID, 0));
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            String historyTableName = (String)dataObject.getFirstValue("ArchiveTableDetails_HIST", "ARCHIVED_TABLENAME");
            String docIDTableName = (String)dataObject.getFirstValue("ArchiveTableDetails_IDOC", "ARCHIVED_TABLENAME");
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)historyTableName));
            query.addSelectColumn(Column.getColumn((String)historyTableName, (String)"STATUS"));
            query.addSelectColumn(Column.getColumn((String)historyTableName, (String)"START_TIME"));
            query.addSelectColumn(Column.getColumn((String)historyTableName, (String)"END_TIME"));
            query.addSelectColumn(Column.getColumn((String)historyTableName, (String)"PROVIDER_ID"));
            query.addSelectColumn(Column.getColumn((String)historyTableName, (String)"HISTORY_ID"));
            query.setCriteria(new Criteria(Column.getColumn((String)historyTableName, (String)"HISTORY_ID"), (Object)historyID, 0));
            Map<String, Object> val = ActArchiveDataLoader.fetchDataFromTable(historyTableName, Arrays.asList("STATUS", "START_TIME", "END_TIME", "PROVIDER_ID", "HISTORY_ID"), "HISTORY_ID", new Object[]{historyID}).getFirst();
            val.putAll(ActArchiveDataLoader.fetchDataFromTable(docIDTableName, Arrays.asList("INITIATOR_ID", "DOC_ID", "INDEX_ID", "HISTORY_ID"), "HISTORY_ID", new Object[]{historyID}).getFirst());
            ActivityStatus status = ActivityStatus.getStatus((Long)val.get("STATUS"));
            response.put("STATUS", status.getValue());
            response.put("HISTORY_ID", historyID);
            response.put("END_TIME", val.get("END_TIME"));
            response.put("START_TIME", val.get("START_TIME"));
            response.put("PROVIDER_ID", val.get("PROVIDER_ID"));
            response.put("INDEX_ID", val.get("INDEX_ID"));
            response.put("DOC_ID", val.get("DOC_ID"));
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during fetching activity history data from archive {0}", exp);
        }
        return response;
    }

    private static String resolveTableID(Long tableID) throws Exception {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityArchivedTablesInfo"));
        selectQuery.addJoin(new Join("ActivityArchivedTablesInfo", "ArchiveTableDetails", new String[]{"HISTORY_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"ARCHIVE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"HISTORY_TABLE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"INIT_DOC_TABLE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ArchiveTableDetails", (String)"ARCHIVE_TABLE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ArchiveTableDetails", (String)"ARCHIVED_TABLENAME"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"INIT_DOC_TABLE_ID"), (Object)tableID, 0));
        return (String)PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).getFirstValue("ArchiveTableDetails", "ARCHIVED_TABLENAME");
    }

    public static String getLinkedLogonID(Long initDocTableID, Long historyID) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityArchivedTablesInfo"));
        selectQuery.addJoin(new Join("ActivityArchivedTablesInfo", "ArchiveTableDetails", new String[]{"WIN_LINK_TABLE_ID"}, new String[]{"ARCHIVE_TABLE_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"ARCHIVE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"HISTORY_TABLE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"INIT_DOC_TABLE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"WIN_LINK_TABLE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ArchiveTableDetails", (String)"ARCHIVE_TABLE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ArchiveTableDetails", (String)"ARCHIVED_TABLENAME"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityArchivedTablesInfo", (String)"INIT_DOC_TABLE_ID"), (Object)initDocTableID, 0));
        String winLinkInfoTableName = (String)PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).getFirstValue("ArchiveTableDetails", "ARCHIVED_TABLENAME");
        LinkedList<Map<String, Object>> val = ActArchiveDataLoader.fetchDataFromTable(winLinkInfoTableName, Arrays.asList("PRIMARY_HISTORY_ID", "SECONDARY_HISTORY_ID", "SEC_LOGON_ID"), "PRIMARY_HISTORY_ID", new Long[]{historyID});
        if (val != null && !val.isEmpty()) {
            return (String)val.getFirst().get("SEC_LOG_ID");
        }
        return null;
    }
}

