/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.dataloader;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.DateFormatUtil;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.auditdata.CorrelationNosqlData;
import com.manageengine.ela.server.correlation.common.constants.SyslogSeverityConstants;
import com.manageengine.ela.server.correlation.common.constants.WindowsLogSeverityConstants;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.dispatcher.ResultInflowManager;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.dataloader.ActArchiveDataLoader;
import com.manageengine.ela.server.correlation.session.dataloader.DataLoader;
import com.manageengine.ela.server.correlation.session.dataloader.wrapper.SessionInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.search.historysearch.ActivityHistorySearchHandler;
import com.manageengine.ela.server.correlation.session.search.historysearch.HistorySearchRequest;
import com.manageengine.ela.server.correlation.session.util.ActivityDataTransformUtil;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import com.zoho.za.dae.elastic.LogIndexer;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class DataLoaderImpl
implements DataLoader {
    protected static final Integer WORKSTATION_LOCK_EVENT_ID = 4800;
    protected static final Integer WORKSTATION_UNLOCK_EVENT_ID = 4801;
    protected static final Integer SESSION_RECONNECTED_EVENT_ID = 4778;
    private static final Logger LOGGER = Logger.getLogger(DataLoaderImpl.class.getName());

    @Override
    public JSONObject getActivityHistory(JSONObject jsonRequest, String serverName, Integer serverPort, TimePack timePack) throws BaseStatusCode, JSONException {
        JSONObject reqData = jsonRequest.getJSONObject("REQUEST_FIELDS");
        Long historyID = reqData.getLong("HISTORY_ID");
        Object[] criteriaFields = ActivityUtil.decomposeJSONArray(reqData.getJSONArray("CONF_FIELDS"));
        JSONObject requestParams = reqData.getJSONObject("REQUEST_PARAMS");
        JSONArray sevArray = reqData.getJSONArray("EXCL_SEVERITIES");
        try {
            Long providerID = jsonRequest.getLong("PROVIDER_ID");
            ActivityProviderInfo providerInfo = ActivityUtil.getProviderInfo(providerID);
            SessionInfo sessionData = this.loadActivityData(reqData, historyID, timePack);
            Map<Object, Object> criteriaMap = this.prepareFieldCriteria(criteriaFields, historyID, sessionData.getLog(), sessionData.getDataObject(), reqData);
            Integer resultCount = requestParams.optInt("COUNT", 0);
            boolean isForwardSearch = requestParams.optBoolean("IS_FORWARD_SEARCH", true);
            HistorySearchRequest searchRequest = new HistorySearchRequest(sessionData.getStartTime(), sessionData.getEndTime(), timePack.getTimeZone(), resultCount, isForwardSearch, criteriaMap);
            searchRequest.setLastLoadedDoc(requestParams.optString("LAST_DOC_ID", null));
            searchRequest.setLastResultTime(requestParams.optLong("LAST_LOG_TIME", -1L));
            searchRequest.setRuleSpecificCriteria(this.getRuleSearchCriteria(providerID, historyID));
            if (sevArray != null && sevArray.length() > 0) {
                searchRequest.setCustomQuery(this.prepareSeverityQuery(ActivityUtil.convertJSONArrayToSeveritySet(sevArray)));
            }
            if (providerInfo.getType() == 1) {
                searchRequest.setFilterCriteria(ActivityUtil.getDefaultWinSearchFilterQuery());
            } else if (providerInfo.getType() == 3) {
                searchRequest.setFilterCriteria(ActivityUtil.getDefaultUnixSearchFilterQuery());
            }
            searchRequest.build();
            JSONObject response = ActivityHistorySearchHandler.loadSearchResult(searchRequest);
            if (!searchRequest.isScrollSearch().booleanValue()) {
                String query = this.prepareQuery(criteriaMap, ActivityUtil.convertJSONArrayToSeveritySet(sevArray));
                query = this.handleEscapeChars(query);
                URL searchURL = this.prepareURL(serverName, serverPort, query, sessionData.getStartTime(), sessionData.getEndTime(), timePack.getTimeZone());
                response.put("LINK", (Object)searchURL.getFile());
            }
            return response;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Could not fetch activity history for history id = {0}", new Object[]{historyID});
            LOGGER.log(Level.FINER, "Exception = {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode();
        }
    }

    @Override
    public JSONObject getSearchViewLink(JSONObject jsonRequest, String serverName, Integer serverPort, TimePack timePack) throws BaseStatusCode, JSONException {
        JSONObject response = new JSONObject();
        JSONObject reqData = jsonRequest.getJSONObject("REQUEST_FIELDS");
        Long historyID = reqData.getLong("HISTORY_ID");
        Object[] criteriaFields = ActivityUtil.decomposeJSONArray(reqData.getJSONArray("CONF_FIELDS"));
        JSONArray sevArray = reqData.getJSONArray("EXCL_SEVERITIES");
        try {
            SessionInfo sessionData = this.loadActivityData(reqData, historyID, timePack);
            Map<Object, Object> criteriaMap = this.prepareFieldCriteria(criteriaFields, historyID, sessionData.getLog(), sessionData.getDataObject(), reqData);
            String query = this.prepareQuery(criteriaMap, ActivityUtil.convertJSONArrayToSeveritySet(sevArray));
            query = this.handleEscapeChars(query);
            URL searchURL = this.prepareURL(serverName, serverPort, query, sessionData.getStartTime(), sessionData.getEndTime(), timePack.getTimeZone());
            response.put("LINK", (Object)searchURL.getFile());
            return response;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Could not fetch activity history for history id = {0} Exception = {1}", new Object[]{historyID, exp.getMessage()});
            LOGGER.log(Level.FINER, "Exception = {0}", exp);
            throw BaseStatusCode.getBaseStatusCode();
        }
    }

    @Override
    public JSONObject getActivityHistoryInfo(JSONObject jsonRequest, Locale locale, TimePack timePack) throws BaseStatusCode, JSONException {
        JSONObject reqData = jsonRequest.getJSONObject("REQUEST_FIELDS");
        Long historyID = reqData.getLong("HISTORY_ID");
        JSONObject response = new JSONObject();
        try {
            DataObject dataObject;
            if (reqData.has("ARCHIVE_ID")) {
                Map<String, Object> info = ActArchiveDataLoader.fetchActivityHistoryData(reqData.getLong("ARCHIVE_ID"), historyID);
                Long providerID = (Long)info.get("PROVIDER_ID");
                dataObject = this.loadLinkedFieldDO((Long)info.get("PROVIDER_ID"));
                JSONArray extraFields = this.getSessionSpecificFieldInfo(locale, historyID, ActivityUtil.getIndexedDoc((Long)info.get("INDEX_ID"), (String)info.get("DOC_ID"), timePack), dataObject);
                ActivityStatus status = ActivityStatus.getStatus((Long)info.get("STATUS"));
                response.put("SESSION_INFO", (Object)this.prepareStatusInfo(historyID, providerID, (Long)info.get("START_TIME"), (Long)info.get("END_TIME"), extraFields, status, timePack));
            } else {
                dataObject = this.loadCompleteActivityData(historyID);
                Row activityHistory = dataObject.getFirstRow("ActivityHistory");
                Long providerID = (Long)activityHistory.get("PROVIDER_ID");
                Criteria docCriteria = new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"HISTORY_ID"), (Object)historyID, 0).and(new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"IS_PRIMARY"), (Object)Boolean.TRUE, 0));
                Row initRow = dataObject.getRow("ActivityInitiatorDocID", docCriteria);
                ActivityStatus status = ActivityStatus.getStatus((Long)activityHistory.get("STATUS"));
                Long fromTime = (Long)activityHistory.get("START_TIME");
                Long endTime = null;
                if (activityHistory.get("END_TIME") != null) {
                    endTime = Long.parseLong(activityHistory.get("END_TIME").toString());
                }
                Map<String, Object> initLog = this.fetchResolvedLog(dataObject, "ActivityInitiatorDocID", historyID, "NoSqlIndexDetails", (Long)initRow.get("INDEX_ID"), timePack);
                JSONObject sessionInfo = this.loadSessionStatusInfo(dataObject, locale, initLog, historyID, providerID, timePack, fromTime, endTime, status);
                response.put("SESSION_INFO", (Object)sessionInfo);
            }
            response.put("CONFIG_FIELDS", (Object)this.getSharedFieldInfo(dataObject, locale));
            return response;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Could not fetch activity history for history id = {0} Exception = {1}", new Object[]{historyID, exp.getMessage()});
            LOGGER.log(Level.FINER, "Exception = {0}", exp);
            throw BaseStatusCode.getBaseStatusCode();
        }
    }

    protected QueryBuilder getRuleSearchCriteria(Long providerID, Long historyID) {
        return QueryBuilders.matchQuery((String)ActivityUtil.getProviderIndexFieldName(providerID), (Object)historyID);
    }

    private SessionInfo loadActivityData(JSONObject reqData, Long historyID, TimePack timePack) throws Exception {
        Map<String, Object> initLog;
        Long toTime;
        Long fromTime;
        DataObject dataObject = null;
        if (reqData.has("ARCHIVE_ID")) {
            Map<String, Object> info = ActArchiveDataLoader.fetchActivityHistoryData(reqData.getLong("ARCHIVE_ID"), historyID);
            fromTime = (Long)info.get("START_TIME");
            toTime = (Long)info.get("END_TIME");
            initLog = ActivityUtil.getIndexedDoc((Long)info.get("INDEX_ID"), (String)info.get("DOC_ID"), timePack);
        } else {
            dataObject = this.loadActivityHistoryData(historyID);
            Row activityHistory = dataObject.getFirstRow("ActivityHistory");
            Criteria docCriteria = new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"HISTORY_ID"), (Object)historyID, 0).and(new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"IS_PRIMARY"), (Object)Boolean.TRUE, 0));
            Row initRow = dataObject.getRow("ActivityInitiatorDocID", docCriteria);
            ActivityStatus status = ActivityStatus.getStatus((Long)activityHistory.get("STATUS"));
            fromTime = (Long)activityHistory.get("START_TIME");
            toTime = null;
            initLog = this.fetchResolvedLog(dataObject, "ActivityInitiatorDocID", historyID, "NoSqlIndexDetails", (Long)initRow.get("INDEX_ID"), timePack);
            if ((status == ActivityStatus.TERMINATED || status == ActivityStatus.BROKEN || status == ActivityStatus.IMPROPER_BREAK) && activityHistory.get("END_TIME") != null) {
                toTime = Long.parseLong(activityHistory.get("END_TIME").toString());
            }
        }
        if (toTime == null) {
            toTime = timePack.getEndTimeInLong();
        }
        return new SessionInfo(fromTime, toTime, initLog, dataObject);
    }

    private String handleEscapeChars(String query) {
        return query.replaceAll("(\\\\)", "\\\\\\\\");
    }

    protected DataObject loadLinkedFieldDO(long providerID) throws BaseStatusCode {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table("ActivityRuleLinkedFields"));
            selectQuery.addJoin(new Join("ActivityRuleLinkedFields", "NoSqlIndexFields", new String[]{"INIT_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityRuleLinkedFields", "ActivitySharedFieldStatus", new String[]{"LINKED_FIELD_ID"}, new String[]{"LINKED_FIELD_ID"}, 1));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleLinkedFields", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivitySharedFieldStatus", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityRuleLinkedFields", (String)"PROVIDER_ID"), (Object)providerID, 0);
            selectQuery.setCriteria(criteria);
            return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity history fetch {0}", exp.getMessage());
            LOGGER.log(Level.FINER, "Exception = {0}", exp);
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public JSONArray getLogData(Long time, String docID, Locale locale, TimePack timePack) throws BaseStatusCode {
        JSONArray logData;
        block4: {
            logData = new JSONArray();
            try {
                String indexName = LogIndexer.getIndexName((Object)time);
                Map<String, Object> log = CorrNosqlIndexHandler.getIndexedDocInfo(indexName, docID, timePack);
                if (log != null) {
                    CorrelationNosqlData.normalizeFieldNames(log, locale);
                    for (String key : log.keySet()) {
                        JSONObject entry = new JSONObject();
                        entry.put("NAME", (Object)key);
                        entry.put("VALUE", (Object)log.get(key).toString());
                        logData.put((Object)entry);
                    }
                    break block4;
                }
                throw BaseStatusCode.getBaseStatusCode(16391);
            }
            catch (Exception exp) {
                LOGGER.log(Level.WARNING, "Could not load raw log for the log {0}", docID);
                LOGGER.log(Level.FINER, "Exception = {0}", exp);
                throw BaseStatusCode.getBaseStatusCode(16391);
            }
        }
        return logData;
    }

    protected Map<Object, Object> prepareFieldCriteria(Object[] criteriaFields, Long histID, Map<String, Object> log, DataObject dataObject, JSONObject reqData) throws DataAccessException, JSONException {
        HashMap<Object, Object> criteriaMap = new HashMap<Object, Object>();
        for (Object sharedField : criteriaFields) {
            String field = sharedField.toString();
            criteriaMap.put(field, log.get(field));
        }
        return criteriaMap;
    }

    protected JSONArray getSharedFieldInfo(DataObject dataObject, Locale locale) throws DataAccessException, JSONException {
        JSONArray jsonArray = new JSONArray();
        Iterator iterator = dataObject.getRows("ActivityRuleLinkedFields");
        while (iterator.hasNext()) {
            JSONObject fieldData = new JSONObject();
            Row linkedFields = (Row)iterator.next();
            Criteria criteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), linkedFields.get("INIT_FIELD_ID"), 0);
            Row indexField = dataObject.getRow("NoSqlIndexFields", criteria);
            fieldData.put("ID", linkedFields.get("LINKED_FIELD_ID"));
            fieldData.put("INDEX_NAME", indexField.get("FIELD_INDEX_NAME"));
            fieldData.put("DISPLAY_NAME", (Object)ProductBundle.getInstance().getString(locale, indexField.get("FIELD_DISPLAY_NAME").toString()));
            criteria = new Criteria(Column.getColumn((String)"ActivitySharedFieldStatus", (String)"LINKED_FIELD_ID"), linkedFields.get("LINKED_FIELD_ID"), 0);
            Row row = dataObject.getRow("ActivitySharedFieldStatus", criteria);
            boolean status = false;
            if (row != null) {
                status = (Boolean)row.get("STATUS");
            }
            fieldData.put("STATUS", status);
            jsonArray.put((Object)fieldData);
        }
        return jsonArray;
    }

    private DataObject loadCompleteActivityData(Long historyID) throws BaseStatusCode {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table("ActivityHistory"));
            selectQuery.addJoin(new Join("ActivityHistory", "ActivityRuleLinkedFields", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityHistory", "ActivityInitiatorDocID", new String[]{"HISTORY_ID"}, new String[]{"HISTORY_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityHistory", "WindowsActivityStatus", new String[]{"HISTORY_ID"}, new String[]{"HISTORY_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityHistory", "WinActivityLinkInfo", new String[]{"HISTORY_ID"}, new String[]{"PRIMARY_HISTORY_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityRuleLinkedFields", "NoSqlIndexFields", new String[]{"INIT_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityRuleLinkedFields", "ActivitySharedFieldStatus", new String[]{"LINKED_FIELD_ID"}, new String[]{"LINKED_FIELD_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityInitiatorDocID", "NoSqlIndexDetails", new String[]{"INDEX_ID"}, new String[]{"INDEX_ID"}, 1));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityInitiatorDocID", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"WindowsActivityStatus", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleLinkedFields", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivitySharedFieldStatus", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"WinActivityLinkInfo", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID"), (Object)historyID, 0);
            selectQuery.setCriteria(criteria);
            return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity history fetch {0}", exp.getMessage());
            LOGGER.log(Level.FINER, "Exception = {0}", exp);
            throw BaseStatusCode.getBaseStatusCode();
        }
    }

    private DataObject loadActivityHistoryData(Long historyID) throws BaseStatusCode {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table("ActivityHistory"));
            selectQuery.addJoin(new Join("ActivityHistory", "ActivityInitiatorDocID", new String[]{"HISTORY_ID"}, new String[]{"HISTORY_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityHistory", "WinActivityLinkInfo", new String[]{"HISTORY_ID"}, new String[]{"PRIMARY_HISTORY_ID"}, 1));
            selectQuery.addJoin(new Join("ActivityInitiatorDocID", "NoSqlIndexDetails", new String[]{"INDEX_ID"}, new String[]{"INDEX_ID"}, 1));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityInitiatorDocID", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"WinActivityLinkInfo", (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID"), (Object)historyID, 0);
            selectQuery.setCriteria(criteria);
            return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity history fetch {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode();
        }
    }

    protected Map<String, Object> fetchResolvedLog(DataObject dataObject, String docTable, Long hist, String indexTable, Long indexID, TimePack timePack) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)docTable, (String)"IS_PRIMARY"), (Object)Boolean.TRUE, 0).and(new Criteria(Column.getColumn((String)docTable, (String)"HISTORY_ID"), (Object)hist, 0));
        String endDocID = (String)dataObject.getRow(docTable, criteria).get("DOC_ID");
        String endIndexName = (String)dataObject.getRow(indexTable, new Criteria(Column.getColumn((String)indexTable, (String)"INDEX_ID"), (Object)indexID, 0)).get("INDEX_NAME");
        return CorrNosqlIndexHandler.getIndexedDocInfo(endIndexName, endDocID, timePack);
    }

    protected void updateChanges(DataObject dataObject) {
        try {
            if (!dataObject.getOperations().isEmpty()) {
                ResultInflowManager.put(dataObject);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during database update {0}", exp.getMessage());
            LOGGER.log(Level.FINER, "Exception = {0}", exp);
        }
    }

    protected Map<String, String> getSharedFieldMap(DataObject dataObject) throws DataAccessException {
        Iterator iterator = dataObject.getRows("NoSqlIndexFields");
        ConcurrentHashMap<String, String> fields = new ConcurrentHashMap<String, String>();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String indexName = (String)row.get("FIELD_INDEX_NAME");
            String displayName = (String)row.get("ACTUAL_DISPLAY_NAME");
            fields.put(indexName, displayName);
        }
        return fields;
    }

    private JSONObject loadSessionStatusInfo(DataObject dobj, Locale locale, Map<String, Object> log, Long historyID, Long providerID, TimePack timePack, Long start, Long end, ActivityStatus status) throws Exception {
        JSONArray extraFields = this.getSessionSpecificFieldInfo(locale, historyID, log, dobj);
        return this.prepareStatusInfo(historyID, providerID, start, end, extraFields, status, timePack);
    }

    private JSONObject prepareStatusInfo(Long historyID, Long providerID, Long start, Long end, JSONArray extraFields, ActivityStatus status, TimePack timePack) throws Exception {
        String timeFormat = "%s, %s";
        JSONObject sessionInfo = new JSONObject();
        sessionInfo.put("EXTRA_FIELDS", (Object)extraFields);
        sessionInfo.put("HISTORY_ID", (Object)historyID);
        Map.Entry<String, String> startTime = ActivityUtil.convertUnixTimeToDateTime(start, timePack.getTimeZone());
        sessionInfo.put("INIT_TIME", (Object)String.format(timeFormat, startTime.getKey(), startTime.getValue()));
        JSONObject statusData = null;
        if (status == ActivityStatus.INITIATED) {
            statusData = this.getCurrentActivityStatus((List<Long>)ImmutableList.of((Object)historyID), timePack).get(historyID);
            status = ActivityStatus.getStatus(statusData.getLong("STATUS"));
        }
        sessionInfo.put("STATUS", (Object)ActivityDataTransformUtil.prepareStatusObject(status));
        if (status == ActivityStatus.INITIATED || status == ActivityStatus.LOCKED) {
            Long elapsedTime = Calendar.getInstance(timePack.getTimeZone()).getTimeInMillis() - start;
            if (ActivityUtil.getProviderStatus(providerID) == CorrelationStatus.ENABLE && elapsedTime > 0L) {
                sessionInfo.put("ELAPSED_TIME", (Object)elapsedTime);
            } else {
                sessionInfo.put("ELAPSED_TIME", (Object)"-");
            }
        }
        if (statusData != null && statusData.has("END_TIME")) {
            end = statusData.getLong("END_TIME");
        }
        if (end != null) {
            Map.Entry<String, String> endTime = ActivityUtil.convertUnixTimeToDateTime(end, timePack.getTimeZone());
            sessionInfo.put("END_TIME", (Object)String.format(timeFormat, endTime.getKey(), endTime.getValue()));
            sessionInfo.put("DURATION", (Object)ActivityUtil.getDefaultDurationString(start, end));
        } else {
            sessionInfo.put("END_TIME", (Object)"-");
            sessionInfo.put("DURATION", (Object)"-");
        }
        return sessionInfo;
    }

    protected JSONArray getSessionSpecificFieldInfo(Locale locale, Long histID, Map log, DataObject dobj) throws DataAccessException, JSONException {
        JSONArray extraFields = new JSONArray();
        for (Map.Entry<String, String> field : this.getSharedFieldMap(dobj).entrySet()) {
            JSONObject entry = new JSONObject();
            String displayName = ProductBundle.getInstance().getString(locale, field.getValue());
            if (log != null && log.containsKey(field.getKey())) {
                entry.put(displayName, log.get(field.getKey()));
                extraFields.put((Object)entry);
                continue;
            }
            LOGGER.log(Level.FINE, "Primary action contains insufficient field information.");
        }
        return extraFields;
    }

    private BoolQueryBuilder prepareSeverityQuery(Set<WindowsLogSeverityConstants> excludedSeverities) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().queryName("Severities");
        if (excludedSeverities.contains((Object)WindowsLogSeverityConstants.OTHERS)) {
            Sets.SetView interestedSevs = Sets.difference(ActivityUtil.getDefaultSeverities(), excludedSeverities);
            queryBuilder.should((QueryBuilder)this.loadWinSeverityQuery((Set<WindowsLogSeverityConstants>)interestedSevs, true));
            queryBuilder.should((QueryBuilder)this.loadUnixSeverityQuery((Set<WindowsLogSeverityConstants>)interestedSevs, true));
        } else {
            queryBuilder.should((QueryBuilder)this.loadWinSeverityQuery(excludedSeverities, false));
            queryBuilder.should((QueryBuilder)this.loadUnixSeverityQuery(excludedSeverities, false));
        }
        return queryBuilder;
    }

    private BoolQueryBuilder loadWinSeverityQuery(Set<WindowsLogSeverityConstants> interestedSevs, boolean shouldInclude) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.minimumNumberShouldMatch(1);
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"HOSTTYPE", (String)"windows"));
        for (WindowsLogSeverityConstants needed : interestedSevs) {
            if (shouldInclude) {
                queryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"SEVERITY", (Object)needed.getValue()));
                continue;
            }
            queryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"SEVERITY", (Object)needed.getValue()));
        }
        return queryBuilder;
    }

    private BoolQueryBuilder loadUnixSeverityQuery(Set<WindowsLogSeverityConstants> interestedSevs, boolean shouldInclude) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"HOSTTYPE", (String)"unix"));
        queryBuilder.minimumNumberShouldMatch(1);
        for (WindowsLogSeverityConstants needed : interestedSevs) {
            Set<SyslogSeverityConstants> sysLogSev = ActivityUtil.getUnixSeverityFromWinSeverity(needed);
            if (shouldInclude) {
                sysLogSev.forEach(sev -> queryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"SEVERITY", (Object)sev.getValue())));
                continue;
            }
            sysLogSev.forEach(sev -> queryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"SEVERITY", (Object)sev.getValue())));
        }
        return queryBuilder;
    }

    private URL prepareURL(String serverName, Integer serverPort, String query, Long start, Long end, TimeZone timeZone) {
        try {
            URIBuilder uriBuilder = new URIBuilder("http://" + serverName);
            uriBuilder.setPort(serverPort.intValue());
            uriBuilder.setPath("/event/index2.do");
            uriBuilder.setParameter("url", "allNewSearch");
            uriBuilder.setParameter("flushCache", "true");
            uriBuilder.setParameter("tab", "search");
            uriBuilder.setParameter("newSearch", "true");
            uriBuilder.setParameter("helpP", "newSearch");
            uriBuilder.setParameter("query", query);
            uriBuilder.setParameter("excludeFromSession", "true");
            uriBuilder.setParameter("from", "activity");
            uriBuilder.setParameter("startTime", DateFormatUtil.getFormattedTimeForDatePicker(start, timeZone));
            uriBuilder.setParameter("endTime", DateFormatUtil.getFormattedTimeForDatePicker(end, timeZone));
            return uriBuilder.build().toURL();
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during search query url preparation");
            LOGGER.log(Level.FINER, "Exception = {0}", exp);
            return null;
        }
    }

    private String prepareQuery(Map<Object, Object> criteria, Set<WindowsLogSeverityConstants> excludedSeverities) {
        String query;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : criteria.entrySet()) {
            String fieldName = entry.getKey().toString();
            Iterator value = entry.getValue();
            String query2 = null;
            if (value instanceof List) {
                for (Object ent : (List)((Object)value)) {
                    if (query2 == null) {
                        query2 = String.format("(%s = \"%s\")", fieldName, ent);
                        continue;
                    }
                    query2 = query2 + String.format(" OR (%s = \"%s\")", fieldName, ent);
                }
                query2 = String.format("( %s )", query2);
            } else {
                query2 = String.format("(%s = \"%s\")", fieldName, value);
            }
            if (builder.toString().isEmpty()) {
                builder.append(query2);
                continue;
            }
            builder.append(" AND ").append(query2);
        }
        StringBuilder severities = new StringBuilder();
        if (excludedSeverities.contains((Object)WindowsLogSeverityConstants.OTHERS)) {
            Sets.SetView interestedSevs = Sets.difference(ActivityUtil.getDefaultSeverities(), excludedSeverities);
            for (WindowsLogSeverityConstants needed : interestedSevs) {
                query = String.format("(SEVERITY = \"%s\")", new Object[]{needed});
                if (severities.toString().isEmpty()) {
                    severities.append(query);
                    continue;
                }
                severities.append(" OR ").append(query);
            }
        } else {
            for (WindowsLogSeverityConstants notNeeded : excludedSeverities) {
                query = String.format("(SEVERITY != \"%s\")", new Object[]{notNeeded});
                if (severities.toString().isEmpty()) {
                    severities.append(query);
                    continue;
                }
                severities.append(" AND ").append(query);
            }
        }
        if (!severities.toString().isEmpty()) {
            builder.append(" AND ( ").append(severities.toString()).append(" )");
        }
        return builder.toString();
    }
}

