/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.dataloader;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.DateFormatUtil;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.dataloader.DataLoaderImpl;
import com.manageengine.ela.server.correlation.session.util.ActivityDataTransformUtil;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class DefaultDataLoader
extends DataLoaderImpl {
    private static final Logger LOGGER = Logger.getLogger(DefaultDataLoader.class.getName());
    private static final DefaultDataLoader INSTANCE = new DefaultDataLoader();

    public static DefaultDataLoader get() {
        return INSTANCE;
    }

    @Override
    public Map<Long, JSONObject> getCurrentActivityStatus(List<Long> histIDArray, TimePack timePack) throws BaseStatusCode {
        HashMap<Long, JSONObject> response = new HashMap<Long, JSONObject>();
        try {
            DataObject dataObject = this.getActivityStatusDO(histIDArray.toArray(new Long[histIDArray.size()]));
            Iterator historyIterator = dataObject.getRows("ActivityHistory");
            while (historyIterator.hasNext()) {
                Row activityHistory = (Row)historyIterator.next();
                Long historyID = (Long)activityHistory.get("HISTORY_ID");
                JSONObject data = new JSONObject();
                data.put("STATUS", activityHistory.get("STATUS"));
                response.put(historyID, data);
            }
            return response;
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Error occurred during activity status fetch {0}", exp.getMessage());
            throw BaseStatusCode.getBaseStatusCode(16385);
        }
    }

    @Override
    public JSONObject getDynamicStatusInfo(Long historyID, TimePack timePack) throws BaseStatusCode {
        JSONObject response = new JSONObject();
        try {
            Long endTime;
            DataObject dataObject = this.getActivityStatusDO(new Long[]{historyID});
            Row activityHistory = dataObject.getFirstRow("ActivityHistory");
            ActivityStatus status = ActivityStatus.getStatus((Long)activityHistory.get("STATUS"));
            response.put("STATUS", (Object)ActivityDataTransformUtil.prepareStatusObject(status));
            if (status != ActivityStatus.INITIATED && (endTime = (Long)activityHistory.get("END_TIME")) != null) {
                response.put("END_TIME", (Object)DateFormatUtil.getFormattedTimeForClient_1(endTime, timePack.getTimeZone()));
                response.put("DURATION", (Object)ActivityUtil.getDefaultDurationString((Long)activityHistory.get("START_TIME"), endTime));
            }
            return response;
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during status info fetch for history id {0} exception = {1}", new Object[]{historyID, exp.getMessage()});
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    private DataObject getActivityStatusDO(Long[] histIDs) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityHistory"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID"), (Object)histIDs, 8));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"*"));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }
}

