/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.dataloader;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.google.common.collect.ImmutableList;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.DateFormatUtil;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.dataloader.ActArchiveDataLoader;
import com.manageengine.ela.server.correlation.session.dataloader.DataLoaderImpl;
import com.manageengine.ela.server.correlation.session.search.ActivityNoSqlSearch;
import com.manageengine.ela.server.correlation.session.search.NoSqlSearchRequest;
import com.manageengine.ela.server.correlation.session.util.ActivityDataTransformUtil;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WindowsSessionDataLoader
extends DataLoaderImpl {
    private static final Logger LOGGER = Logger.getLogger(WindowsSessionDataLoader.class.getName());
    private static final String ACTIVITY_HISTORY_SECONDARY = "ActivityHistory_SCY";
    private static final WindowsSessionDataLoader INSTANCE = new WindowsSessionDataLoader();

    public static WindowsSessionDataLoader get() {
        return INSTANCE;
    }

    @Override
    public Map<Long, JSONObject> getCurrentActivityStatus(List<Long> histIDArray, TimePack timePack) throws BaseStatusCode {
        HashMap<Long, JSONObject> response = new HashMap<Long, JSONObject>();
        try {
            DataObject dataObject = this.loadActivityStatusData(histIDArray);
            Iterator historyIterator = dataObject.getRows("ActivityHistory");
            while (historyIterator.hasNext()) {
                Map.Entry<ActivityStatus, Long> statusResponse;
                Row activityHistory = (Row)historyIterator.next();
                Long historyID = (Long)activityHistory.get("HISTORY_ID");
                ActivityStatus status = ActivityStatus.getStatus((Long)activityHistory.get("STATUS"));
                JSONObject entry = new JSONObject();
                entry.put("STATUS", (Object)status.getValue());
                entry.put("HISTORY_ID", (Object)historyID);
                if (status == ActivityStatus.INITIATED && (statusResponse = this.fetchCurrentActivityStatus(dataObject, historyID, timePack)).getKey() != null) {
                    entry.put("STATUS", (Object)statusResponse.getKey().getValue());
                    if (statusResponse.getValue() != null) {
                        entry.put("END_TIME", (Object)statusResponse.getValue());
                    }
                }
                response.put(historyID, entry);
            }
            this.updateChanges(dataObject);
            return response;
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during activity status fetch {0}", exp);
            throw BaseStatusCode.getBaseStatusCode(16385);
        }
    }

    @Override
    public JSONObject getDynamicStatusInfo(Long historyID, TimePack timePack) throws BaseStatusCode {
        JSONObject result = new JSONObject();
        try {
            Long endTime = null;
            DataObject dataObject = this.loadActivityStatusData((List<Long>)ImmutableList.of((Object)historyID));
            Row activityHistory = dataObject.getFirstRow("ActivityHistory");
            ActivityStatus status = ActivityStatus.getStatus((Long)activityHistory.get("STATUS"));
            if (status == ActivityStatus.INITIATED) {
                Map.Entry<ActivityStatus, Long> statusResponse = this.fetchCurrentActivityStatus(dataObject, historyID, timePack);
                status = statusResponse.getKey();
                if (statusResponse.getValue() != null) {
                    endTime = statusResponse.getValue();
                }
            } else {
                endTime = (Long)activityHistory.get("END_TIME");
            }
            result.put("STATUS", (Object)ActivityDataTransformUtil.prepareStatusObject(status));
            if (endTime != null) {
                result.put("END_TIME", (Object)DateFormatUtil.getFormattedTimeForClient_1(endTime, timePack.getTimeZone()));
                result.put("DURATION", (Object)ActivityUtil.getDefaultDurationString((Long)activityHistory.get("START_TIME"), endTime));
            }
            this.updateChanges(dataObject);
            return result;
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during activity status fetch {0}", exp);
            throw BaseStatusCode.getBaseStatusCode(16385);
        }
    }

    @Override
    protected QueryBuilder getRuleSearchCriteria(Long providerID, Long historyID) {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"WinActivityLinkInfo"));
        selectQuery.addSelectColumn(Column.getColumn((String)"WinActivityLinkInfo", (String)"PRIMARY_HISTORY_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"WinActivityLinkInfo", (String)"SECONDARY_HISTORY_ID"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"WinActivityLinkInfo", (String)"PRIMARY_HISTORY_ID"), (Object)historyID, 0));
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            if (dataObject.containsTable("WinActivityLinkInfo")) {
                Row row = dataObject.getFirstRow("WinActivityLinkInfo");
                String fieldName = ActivityUtil.getProviderIndexFieldName(providerID);
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)row.get("PRIMARY_HISTORY_ID").toString()));
                queryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)row.get("SECONDARY_HISTORY_ID").toString()));
                return queryBuilder;
            }
        }
        catch (DataAccessException exp) {
            LOGGER.log(Level.FINE, "Error occurred during preparing rule criteria {0}", exp.getMessage());
        }
        return super.getRuleSearchCriteria(providerID, historyID);
    }

    @Override
    protected Map<Object, Object> prepareFieldCriteria(Object[] criteriaFields, Long histID, Map<String, Object> log, DataObject dataObject, JSONObject reqData) throws DataAccessException, JSONException {
        HashMap<Object, Object> criteriaMap = new HashMap<Object, Object>();
        for (Object sharedField : criteriaFields) {
            String field = sharedField.toString();
            if (field.equalsIgnoreCase("LOGONID")) {
                String linkedLogon = null;
                if (reqData.has("ARCHIVE_ID")) {
                    try {
                        Long archiveID = reqData.getLong("ARCHIVE_ID");
                        linkedLogon = ActArchiveDataLoader.getLinkedLogonID(archiveID, histID);
                    }
                    catch (Exception exp) {
                        LOGGER.log(Level.FINE, "Error occurred during linked logon fetching from archive {0}", exp);
                    }
                } else {
                    linkedLogon = this.getLinkedLogonID(dataObject, histID);
                }
                if (linkedLogon != null) {
                    criteriaMap.put(field, Arrays.asList(log.get(field), linkedLogon));
                    continue;
                }
                criteriaMap.put(field, log.get(field));
                continue;
            }
            criteriaMap.put(field, log.get(field));
        }
        return criteriaMap;
    }

    @Override
    protected JSONArray getSessionSpecificFieldInfo(Locale locale, Long historyID, Map log, DataObject dobj) throws DataAccessException, JSONException {
        JSONArray extraFields = new JSONArray();
        for (Map.Entry<String, String> field : this.getSharedFieldMap(dobj).entrySet()) {
            JSONObject entry = new JSONObject();
            String displayName = ProductBundle.getInstance().getString(locale, field.getValue());
            if (field.getKey().equals("LOGONID")) {
                String extraID = this.getLinkedLogonID(dobj, historyID);
                if (extraID != null) {
                    entry.put(displayName, (Object)String.format("%s, %s", log.get(field.getKey()), extraID));
                } else {
                    entry.put(displayName, log.get(field.getKey()));
                }
            } else {
                entry.put(displayName, log.get(field.getKey()));
            }
            extraFields.put((Object)entry);
        }
        return extraFields;
    }

    private Map.Entry<ActivityStatus, Long> fetchCurrentActivityStatus(DataObject dataObject, Long historyID, TimePack timePack) throws Exception {
        Long endTime = null;
        Row activityHistory = dataObject.getRow("ActivityHistory", new Criteria(Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID"), (Object)historyID, 0));
        ActivityStatus status = ActivityStatus.getStatus((Long)activityHistory.get("STATUS"));
        if (status == ActivityStatus.TERMINATED || status == ActivityStatus.BROKEN || status == ActivityStatus.IMPROPER_BREAK) {
            endTime = (Long)activityHistory.get("END_TIME");
        } else if (status == ActivityStatus.INITIATED) {
            JSONObject resolved;
            if (dataObject.containsTable("WinActivityLinkInfo") && (resolved = this.resolveLinkedStatus(status, historyID, dataObject)).getBoolean("IS_RESOLVED")) {
                status = ActivityStatus.getStatus(resolved.getLong("STATUS"));
                endTime = resolved.getLong("END_TIME");
            }
            if (status == ActivityStatus.INITIATED) {
                status = this.handleWorkstationLock(historyID, dataObject, timePack);
            }
        }
        return new AbstractMap.SimpleEntry<ActivityStatus, Long>(status, endTime);
    }

    protected String getLinkedLogonID(DataObject dataObject, Long primaryHistID) throws DataAccessException {
        if (dataObject != null && dataObject.containsTable("WinActivityLinkInfo")) {
            Criteria criteria = new Criteria(Column.getColumn((String)"WinActivityLinkInfo", (String)"PRIMARY_HISTORY_ID"), (Object)primaryHistID, 0);
            return (String)dataObject.getValue("WinActivityLinkInfo", "SEC_LOGON_ID", criteria);
        }
        return null;
    }

    private ActivityStatus handleWorkstationLock(Long historyID, DataObject dataObject, TimePack timePack) {
        ActivityStatus currentStatus = ActivityStatus.INITIATED;
        try {
            Criteria criteria;
            Row winStatusRow;
            Criteria initCriteria = new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"HISTORY_ID"), (Object)historyID, 0).and(new Criteria(Column.getColumn((String)"ActivityInitiatorDocID", (String)"IS_PRIMARY"), (Object)Boolean.TRUE, 0));
            Row initDoc = dataObject.getRow("ActivityInitiatorDocID", initCriteria);
            Map<String, Object> initLog = this.fetchResolvedLog(dataObject, "ActivityInitiatorDocID", historyID, "NoSqlIndexDetails", (Long)initDoc.get("INDEX_ID"), timePack);
            if (initLog == null) {
                LOGGER.log(Level.FINE, "Given doc is not available in es. Source fetching failed.");
                return null;
            }
            Long fromTime = Long.parseLong(initLog.get("TIME").toString());
            if (dataObject.containsTable("WindowsActivityStatus") && (winStatusRow = dataObject.getRow("WindowsActivityStatus", criteria = new Criteria(Column.getColumn((String)"WindowsActivityStatus", (String)"HISTORY_ID"), (Object)historyID, 0))) != null) {
                currentStatus = ActivityStatus.getStatus((Long)winStatusRow.get("STATUS"));
                fromTime = (Long)winStatusRow.get("LAST_SCAN_TIME");
            }
            RangeQueryBuilder timeRange = QueryBuilders.rangeQuery((String)"TIME").gt((Object)fromTime).to(timePack.getEndTimeInLong());
            BoolQueryBuilder logonIDCriteria = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"LOGONID", (Object)initLog.get("LOGONID")));
            String linkedLogonID = this.getLinkedLogonID(dataObject, historyID);
            if (linkedLogonID != null) {
                logonIDCriteria.should((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"LOGONID", (Object)linkedLogonID)));
            }
            BoolQueryBuilder collectiveCriteria = QueryBuilders.boolQuery().must((QueryBuilder)timeRange);
            collectiveCriteria.must((QueryBuilder)logonIDCriteria);
            BoolQueryBuilder eventCriteria = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"EVENTID", (Object)WORKSTATION_LOCK_EVENT_ID)).should((QueryBuilder)QueryBuilders.matchQuery((String)"EVENTID", (Object)WORKSTATION_UNLOCK_EVENT_ID)).should((QueryBuilder)QueryBuilders.matchQuery((String)"EVENTID", (Object)SESSION_RECONNECTED_EVENT_ID));
            collectiveCriteria.must((QueryBuilder)eventCriteria);
            NoSqlSearchRequest searchRequest = new NoSqlSearchRequest(fromTime, timePack.getEndTimeInLong()).addSort((SortBuilder)SortBuilders.fieldSort((String)"TIME").order(SortOrder.ASC)).setQuery((QueryBuilder)collectiveCriteria).setSize(1000);
            SearchResponse response = ActivityNoSqlSearch.doSearch(searchRequest);
            if (response == null || response.getHits().getTotalHits() <= 0L) {
                return currentStatus;
            }
            ActivityStatus newStatus = this.updateStatus(currentStatus, response);
            if (newStatus != currentStatus) {
                LOGGER.log(Level.FINE, "Activity status updated for session {0} to {1}", new Object[]{historyID, newStatus});
            }
            currentStatus = newStatus;
            this.updateLatestResult(currentStatus, historyID, this.getLastEventTime(response.getHits()), dataObject);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during activity lock status resolving {0}", exp);
        }
        return currentStatus;
    }

    private Long getLastEventTime(SearchHits hits) {
        SearchHit searchHit = hits.getAt(new Long(hits.getTotalHits() - 1L).intValue());
        return Long.parseLong(searchHit.getSource().get("TIME").toString());
    }

    private DataObject loadActivityStatusData(List<Long> historyIDList) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityHistory"));
        selectQuery.addJoin(new Join("ActivityHistory", "ActivityInitiatorDocID", new String[]{"HISTORY_ID"}, new String[]{"HISTORY_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityHistory", "WindowsActivityStatus", new String[]{"HISTORY_ID"}, new String[]{"HISTORY_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityHistory", "WinActivityLinkInfo", new String[]{"HISTORY_ID"}, new String[]{"PRIMARY_HISTORY_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"WinActivityLinkInfo", (String)"WinActivityLinkInfo"), Table.getTable((String)"ActivityHistory", (String)ACTIVITY_HISTORY_SECONDARY), new String[]{"SECONDARY_HISTORY_ID"}, new String[]{"HISTORY_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityInitiatorDocID", "NoSqlIndexDetails", new String[]{"INDEX_ID"}, new String[]{"INDEX_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"WinActivityLinkInfo", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityInitiatorDocID", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"WindowsActivityStatus", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)ACTIVITY_HISTORY_SECONDARY, (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"*"));
        if (historyIDList != null && !historyIDList.isEmpty()) {
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID"), (Object)historyIDList.toArray(), 8));
        }
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    private JSONObject resolveLinkedStatus(ActivityStatus status, Long historyID, DataObject dataObject) throws DataAccessException, BaseStatusCode, JSONException {
        Row linkedActHistory;
        ActivityStatus secStatus;
        Criteria criteria;
        Row winLinkInfo;
        JSONObject resolved = new JSONObject();
        if (dataObject.containsTable("WinActivityLinkInfo") && (winLinkInfo = dataObject.getRow("WinActivityLinkInfo", criteria = new Criteria(Column.getColumn((String)"WinActivityLinkInfo", (String)"PRIMARY_HISTORY_ID"), (Object)historyID, 0))) != null && (secStatus = ActivityStatus.getStatus((Long)(linkedActHistory = dataObject.getRow(ACTIVITY_HISTORY_SECONDARY, criteria = new Criteria(Column.getColumn((String)ACTIVITY_HISTORY_SECONDARY, (String)"HISTORY_ID"), winLinkInfo.get("SECONDARY_HISTORY_ID"), 0))).get("STATUS"))).getValue() > status.getValue()) {
            Long endTime = (Long)linkedActHistory.get("END_TIME");
            this.updateLinkedSessionEnd(dataObject, historyID, endTime, secStatus.getValue());
            resolved.put("IS_RESOLVED", true);
            resolved.put("STATUS", (Object)secStatus.getValue());
            resolved.put("END_TIME", (Object)endTime);
            return resolved;
        }
        resolved.put("IS_RESOLVED", false);
        return resolved;
    }

    private void updateLinkedSessionEnd(DataObject dataObject, Long historyID, Long endTime, Long status) throws DataAccessException {
        Row primaryActivityHistory = dataObject.getRow("ActivityHistory", new Criteria(Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID"), (Object)historyID, 0));
        primaryActivityHistory.set("END_TIME", (Object)endTime);
        primaryActivityHistory.set("STATUS", (Object)status);
        dataObject.updateRow(primaryActivityHistory);
        LOGGER.log(Level.INFO, "Updated linked windows session log to closed where only one is closed");
    }

    private ActivityStatus updateStatus(ActivityStatus currentStatus, SearchResponse response) {
        SearchHits searchHits = response.getHits();
        int i = 0;
        while ((long)i < searchHits.getTotalHits()) {
            Map log = searchHits.getAt(i).getSource();
            int eventID = (Integer)log.get("EVENTID");
            if (eventID == WORKSTATION_LOCK_EVENT_ID) {
                currentStatus = ActivityStatus.LOCKED;
            } else if (eventID == WORKSTATION_UNLOCK_EVENT_ID || eventID == SESSION_RECONNECTED_EVENT_ID) {
                currentStatus = ActivityStatus.INITIATED;
            }
            ++i;
        }
        return currentStatus;
    }

    private void updateLatestResult(ActivityStatus activityStatus, Long historyID, Long lastScannedTime, DataObject dataObject) throws DataAccessException {
        Criteria criteria;
        Row winActivityStatus;
        if (dataObject.containsTable("WindowsActivityStatus") && (winActivityStatus = dataObject.getRow("WindowsActivityStatus", criteria = new Criteria(Column.getColumn((String)"WindowsActivityStatus", (String)"HISTORY_ID"), (Object)historyID, 0))) != null) {
            winActivityStatus.set("STATUS", (Object)activityStatus.getValue());
            winActivityStatus.set("LAST_SCAN_TIME", (Object)lastScannedTime);
            dataObject.updateRow(winActivityStatus);
            return;
        }
        winActivityStatus = new Row("WindowsActivityStatus");
        winActivityStatus.set("HISTORY_ID", (Object)historyID);
        winActivityStatus.set("STATUS", (Object)activityStatus.getValue());
        winActivityStatus.set("LAST_SCAN_TIME", (Object)lastScannedTime);
        dataObject.addRow(winActivityStatus);
        LOGGER.log(Level.FINE, "Updated status of session {0} to {1}", new Object[]{historyID, activityStatus});
    }
}

