/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.info;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ActivityBreakerInfo {
    private final Long breakerID;
    private final Long ruleID;
    private final Long primaryActionID;
    private final Map<String, String> breakerFields;

    public ActivityBreakerInfo(Long breakerID, Long ruleID, Long primaryActionID) {
        this.breakerID = Objects.requireNonNull(breakerID);
        this.ruleID = Objects.requireNonNull(ruleID);
        this.primaryActionID = Objects.requireNonNull(primaryActionID);
        this.breakerFields = new ConcurrentHashMap<String, String>();
    }

    public Long getID() {
        return this.breakerID;
    }

    public Long getRuleID() {
        return this.ruleID;
    }

    public void addBreakerFields(Map<String, String> breakerFieldData) {
        this.breakerFields.putAll(breakerFieldData);
    }

    public void addBreakerFields(String initField, String breakerField) {
        this.breakerFields.put(initField, breakerField);
    }

    public Set<String> getBreakerRuleFields() {
        return new HashSet<String>(this.breakerFields.values());
    }

    public Map<String, String> getBreakerFields() {
        return this.breakerFields;
    }

    public Long getPrimaryActionID() {
        return this.primaryActionID;
    }

    public String toString() {
        return "ActivityBreakerInfo{breakerID=" + this.breakerID + ", ruleID=" + this.ruleID + ", primaryActionID=" + this.primaryActionID + ", breakerFields=" + this.breakerFields + '}';
    }
}

