/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.info;

import com.google.common.collect.ImmutableList;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ActivityProfileInfo {
    private final Long profileID;
    private final Map<Long, ActivityProviderInfo> providers = new ConcurrentHashMap<Long, ActivityProviderInfo>();

    public ActivityProfileInfo(Long profileID) {
        this.profileID = Objects.requireNonNull(profileID);
    }

    public Long getID() {
        return this.profileID;
    }

    public void addProviders(Collection<? extends ActivityProviderInfo> providers) {
        for (ActivityProviderInfo activityProviderInfo : providers) {
            this.providers.put(activityProviderInfo.getID(), activityProviderInfo);
        }
    }

    public void addProvider(ActivityProviderInfo provider) {
        this.providers.put(provider.getID(), provider);
    }

    public ActivityProviderInfo removeProvider(Long providerID) {
        return this.providers.remove(providerID);
    }

    public List<ActivityProviderInfo> getProvidersList() {
        return ImmutableList.copyOf(this.providers.values());
    }

    public ActivityProviderInfo getProviderInfo(Long providerID) {
        return this.providers.get(providerID);
    }

    public boolean isValid() {
        return this.providers.size() > 0 && this.providers.values().stream().allMatch(ActivityProviderInfo::isValid);
    }

    public String toString() {
        return "ActivityProfileInfo{profileID=" + this.profileID + ", providers=" + this.providers + '}';
    }
}

