/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.info;

import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.data.RuleContainer;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.session.info.ActivityBreakerInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityInitiatorInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityTerminatorInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ActivityProviderInfo {
    private final Long providerID;
    private final Long ruleID;
    private ActivityInitiatorInfo initiator = null;
    private ActivityBreakerInfo breaker = null;
    private ActivityTerminatorInfo terminator = null;
    private RuleContainer container;
    private CorrelationExecutor executor;
    private CorrelationStatus status;
    private Map<String, String> linkedFields;
    private Long dataTimeLimit = -1L;
    private Integer type = 0;

    public ActivityProviderInfo(Long profileID, Long ruleID) {
        this.providerID = Objects.requireNonNull(profileID);
        this.ruleID = Objects.requireNonNull(ruleID);
        this.linkedFields = new ConcurrentHashMap<String, String>();
    }

    public Long getID() {
        return this.providerID;
    }

    public ActivityInitiatorInfo getInitiator() {
        return this.initiator;
    }

    public void setInitiator(ActivityInitiatorInfo initiator) {
        this.initiator = initiator;
    }

    public ActivityTerminatorInfo getTerminator() {
        return this.terminator;
    }

    public void setTerminator(ActivityTerminatorInfo terminator) {
        this.terminator = terminator;
    }

    public ActivityBreakerInfo getBreaker() {
        return this.breaker;
    }

    public void setBreaker(ActivityBreakerInfo breaker) {
        this.breaker = breaker;
    }

    public void addLinkedFild(String initField, String termField) {
        this.linkedFields.put(initField, termField);
    }

    public Set<String> getInitLinkedFields() {
        return this.linkedFields.keySet();
    }

    public Set<String> getTermLinkedFields() {
        return new HashSet<String>(this.linkedFields.values());
    }

    public Map<String, String> getLinkedFields() {
        return this.linkedFields;
    }

    public void setLinkedFields(Map<String, String> linkedFieldData) {
        this.linkedFields.putAll(linkedFieldData);
    }

    public Long getRuleID() {
        return this.ruleID;
    }

    public RuleContainer getContainer() {
        return this.container;
    }

    public void setContainer(RuleContainer container) {
        this.container = container;
    }

    public Long getDataTimeLimit() {
        return this.dataTimeLimit;
    }

    public void setDataTimeLimit(Long dataTimeLimit) {
        this.dataTimeLimit = dataTimeLimit;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer providerType) {
        this.type = providerType;
    }

    public CorrelationExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(CorrelationExecutor executor) {
        this.executor = executor;
    }

    public CorrelationStatus getStatus() {
        return this.status;
    }

    public void setStatus(CorrelationStatus status) {
        this.status = status;
    }

    public boolean isValid() {
        return this.terminator != null && this.initiator != null && this.linkedFields != null && !this.terminator.getRuleID().equals(this.initiator.getRuleID()) && (this.breaker == null || !this.breaker.getRuleID().equals(this.initiator.getRuleID()) && this.breaker.getBreakerFields().size() > 0);
    }

    public String toString() {
        return "ActivityProviderInfo{providerID=" + this.providerID + ", ruleID=" + this.ruleID + ", initiator=" + this.initiator + ", breaker=" + this.breaker + ", terminator=" + this.terminator + ", container=" + this.container + ", executor=" + this.executor + ", status=" + (Object)((Object)this.status) + ", linkedFields=" + this.linkedFields + ", dataTimeLimit=" + this.dataTimeLimit + ", type=" + this.type + '}';
    }
}

