/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.listener;

import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.info.ActivityBreakerInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ActivityBreaker
implements CorrelationCallBack {
    private static final Map<Long, Map<Long, Map<Long, ActivityBreakerInfo>>> BREAKER_LIST;
    private static final Lock SYNC;

    public static ActivityBreaker create() {
        return new ActivityBreaker();
    }

    public static void addOrUpdate(ActivityProfileInfo profileInfo) {
        Long profileID = profileInfo.getID();
        List<ActivityProviderInfo> providers = profileInfo.getProvidersList();
        providers.forEach(provider -> {
            if (provider.getStatus() == CorrelationStatus.ENABLE) {
                ActivityBreaker.addOrUpdate(profileID, provider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdate(Long profileID, ActivityProviderInfo provider) {
        SYNC.lock();
        try {
            ActivityBreakerInfo breaker = provider.getBreaker();
            if (breaker != null) {
                Map<Long, Map<Long, ActivityBreakerInfo>> existingRuleMap = BREAKER_LIST.get(breaker.getRuleID());
                if (existingRuleMap == null) {
                    existingRuleMap = new HashMap<Long, Map<Long, ActivityBreakerInfo>>();
                    HashMap<Long, ActivityBreakerInfo> existingProviderMap = new HashMap<Long, ActivityBreakerInfo>();
                    existingProviderMap.put(provider.getID(), breaker);
                    existingRuleMap.put(profileID, existingProviderMap);
                    BREAKER_LIST.put(breaker.getRuleID(), existingRuleMap);
                } else {
                    Map existingProviderMap = existingRuleMap.computeIfAbsent(profileID, k -> new HashMap());
                    existingProviderMap.put(provider.getID(), breaker);
                }
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void remove(ActivityProfileInfo profileInfo) {
        Long profileID = profileInfo.getID();
        List<ActivityProviderInfo> providers = profileInfo.getProvidersList();
        providers.forEach(provider -> ActivityBreaker.remove(profileID, provider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Long profileID, ActivityProviderInfo provider) {
        SYNC.lock();
        try {
            Map<Long, ActivityBreakerInfo> existingProviderMap;
            Map<Long, Map<Long, ActivityBreakerInfo>> existingRuleMap;
            ActivityBreakerInfo breaker = provider.getBreaker();
            if (breaker != null && (existingRuleMap = BREAKER_LIST.get(breaker.getRuleID())) != null && (existingProviderMap = existingRuleMap.get(profileID)) != null) {
                existingProviderMap.remove(provider.getID());
                if (existingProviderMap.isEmpty()) {
                    existingRuleMap.remove(profileID);
                }
                if (existingRuleMap.isEmpty()) {
                    BREAKER_LIST.remove(breaker.getRuleID());
                }
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callBack(Long ruleID, Map<Long, ResponseContainer> response) {
        SYNC.lock();
        try {
            Map<Long, Map<Long, ActivityBreakerInfo>> existingRuleMap = BREAKER_LIST.get(ruleID);
            if (existingRuleMap != null) {
                existingRuleMap.forEach((profileID, breakerMap) -> breakerMap.forEach((provider, breakerInfo) -> ActivityUtil.getListener(ActivityProfileContainer.get().getProviderInfo((Long)profileID, (Long)provider)).processActivityBreaker((Long)profileID, (Long)provider, (ActivityBreakerInfo)breakerInfo, breakerInfo.getPrimaryActionID(), response)));
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static Boolean isRuleInUse(Long ruleID) {
        Map<Long, Map<Long, ActivityBreakerInfo>> profileMap = BREAKER_LIST.get(ruleID);
        return profileMap != null && !profileMap.isEmpty() && profileMap.values().stream().anyMatch(map -> !map.isEmpty());
    }

    public static Set<Long> getEnabledRuleSet() {
        return BREAKER_LIST.keySet();
    }

    static {
        SYNC = new ReentrantLock();
        BREAKER_LIST = new HashMap<Long, Map<Long, Map<Long, ActivityBreakerInfo>>>();
    }
}

