/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.listener;

import com.adventnet.persistence.Row;
import com.google.common.collect.ImmutableList;
import com.manageengine.ela.server.correlation.common.handler.ExecutorServiceHandler;
import com.manageengine.ela.server.correlation.session.constants.ActivityConstants;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.data.cache.ActivityHistoryDataHandler;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivitySuccessListener;
import com.manageengine.ela.server.correlation.session.search.ActivityNoSqlSearch;
import com.manageengine.ela.server.correlation.session.search.NoSqlSearchRequest;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import com.zoho.za.dae.elastic.LogIndexer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class ActivityDelayedSuccessHandler {
    private static final ScheduledExecutorService DISPATCHER;
    private static final List<SuccessEntry> QUEUE;
    private static final Logger LOGGER;

    private static void processEntries() throws Exception {
        ListIterator<SuccessEntry> iterator = QUEUE.listIterator();
        while (iterator.hasNext()) {
            SuccessEntry entry = iterator.next();
            ActivityProviderInfo providerInfo = ActivityUtil.getProviderInfo(entry.getProviderID());
            Row historyRow = ActivityHistoryDataHandler.getInstance().getAndRemoveActivityHistoryData(providerInfo.getID(), entry.getInitDocID());
            if (historyRow == null) {
                if (entry.incrementCount() <= 5) continue;
                LOGGER.log(Level.WARNING, "Could not register activity success since no proper history entry found. Initiator doc = {0} provider = {1}", new Object[]{entry.getInitDocID(), entry.getProviderID()});
                iterator.remove();
                continue;
            }
            Long activityEndTime = entry.getEndTime();
            if (entry.getType() == ActivityRuleType.INIT_BREAKER_RULE) {
                ActivityStatus activityStatus = ActivityStatus.BROKEN;
                activityEndTime = ActivityDelayedSuccessHandler.getActivityEndTime(entry, (Long)historyRow.get("HISTORY_ID"));
                if (activityEndTime.compareTo(entry.getEndTime()) != 0) {
                    activityStatus = ActivityStatus.IMPROPER_BREAK;
                }
                ActivitySuccessListener.get().registerData(providerInfo, historyRow, activityEndTime, entry.getEndTime(), entry.getEndDocID(), entry.getType(), activityStatus);
            } else {
                ActivitySuccessListener.get().registerData(providerInfo, historyRow, activityEndTime, entry.getEndTime(), entry.getEndDocID(), entry.getType(), null);
            }
            LOGGER.log(Level.FINE, "Delayed success handler got history entry after failure of {0}", entry.getFailureCount());
            iterator.remove();
        }
    }

    private static Long getActivityEndTime(SuccessEntry entry, Long histID) {
        block5: {
            try {
                Map<String, Map<String, Object>> data = ActivityNoSqlSearch.resolveLogs((List<String>)ImmutableList.of((Object)entry.getInitDocID(), (Object)entry.getEndDocID()), new String[]{LogIndexer.getIndexName((Object)entry.getEndTime()), LogIndexer.getIndexName((Object)entry.getStartTime())});
                Map<String, Object> endDoc = data.get(entry.getEndDocID());
                int eventID = (Integer)endDoc.get("EVENTID");
                if (eventID == ActivityConstants.WINDOWS_STARTING_EVENT_ID_OLD || eventID == ActivityConstants.WINDOWS_STARTING_EVENT_ID_NEW) {
                    NoSqlSearchRequest request;
                    SearchResponse response;
                    String logonID = (String)data.get(entry.getInitDocID()).get("LOGONID");
                    String linkedLogonID = ActivityUtil.getLinkedLogonID(histID);
                    BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"LOGONID", (Object)logonID));
                    if (linkedLogonID != null) {
                        query = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)"LOGONID", (Object)logonID)).should((QueryBuilder)QueryBuilders.matchQuery((String)"LOGONID", (Object)linkedLogonID));
                    }
                    if ((response = ActivityNoSqlSearch.doSearch(request = new NoSqlSearchRequest(entry.getStartTime(), entry.getEndTime()).setQuery((QueryBuilder)query).setSort((List<SortBuilder>)ImmutableList.of((Object)SortBuilders.fieldSort((String)"TIME").order(SortOrder.DESC))).setSize(1))) != null && response.getHits().getTotalHits() > 0L) {
                        return Long.parseLong(response.getHits().getAt(0).getSource().get("TIME").toString());
                    }
                    break block5;
                }
                return entry.getEndTime();
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINE, "Error occurred during resolving breaker end time for {0}", entry.getEndDocID());
            }
        }
        return entry.getEndTime();
    }

    public static void insert(Long providerID, Long endTime, Long startTime, String initDocID, String endDocID, ActivityRuleType type) {
        QUEUE.add(SuccessEntry.getContainer(providerID, endTime, startTime, initDocID, endDocID, type));
    }

    static {
        LOGGER = Logger.getLogger(ActivityDelayedSuccessHandler.class.getName());
        QUEUE = Collections.synchronizedList(new ArrayList());
        DISPATCHER = new ScheduledThreadPoolExecutor(1){

            @Override
            protected void beforeExecute(Thread paramThread, Runnable paramRunnable) {
                paramThread.setName("correlation[activity][delayed-processor]");
                super.beforeExecute(paramThread, paramRunnable);
            }
        };
        DISPATCHER.scheduleWithFixedDelay(() -> {
            try {
                if (QUEUE.size() > 0) {
                    ActivityDelayedSuccessHandler.processEntries();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }, 0L, 15000L, TimeUnit.MILLISECONDS);
        ExecutorServiceHandler.registerExecutorForShutdown(DISPATCHER);
    }

    static class SuccessEntry {
        Long providerID;
        Long endTime;
        Long startTime;
        String initDocID;
        String endDocID;
        ActivityRuleType type;
        Integer failureCount;

        private SuccessEntry(Long providerID, Long endTime, Long startTime, String initDocID, String endDocID, ActivityRuleType type) {
            this.providerID = providerID;
            this.endTime = endTime;
            this.startTime = startTime;
            this.initDocID = initDocID;
            this.endDocID = endDocID;
            this.type = type;
            this.failureCount = 0;
        }

        public static SuccessEntry getContainer(Long providerID, Long endTime, Long startTime, String initDocID, String endDocID, ActivityRuleType type) {
            return new SuccessEntry(providerID, endTime, startTime, initDocID, endDocID, type);
        }

        public Long getProviderID() {
            return this.providerID;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public String getInitDocID() {
            return this.initDocID;
        }

        public String getEndDocID() {
            return this.endDocID;
        }

        public ActivityRuleType getType() {
            return this.type;
        }

        public Integer incrementCount() {
            this.failureCount = this.failureCount + 1;
            return this.failureCount;
        }

        public Integer getFailureCount() {
            return this.failureCount;
        }

        public Long getStartTime() {
            return this.startTime;
        }
    }
}

