/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.listener;

import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.info.ActivityInitiatorInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ActivityInitiator
implements CorrelationCallBack {
    private static final Map<Long, Map<Long, Map<Long, ActivityInitiatorInfo>>> INITIATORLIST;
    private static final Lock SYNC;

    public static ActivityInitiator create() {
        return new ActivityInitiator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callBack(Long ruleID, Map<Long, ResponseContainer> response) {
        SYNC.lock();
        try {
            Map<Long, Map<Long, ActivityInitiatorInfo>> existingRuleMap = INITIATORLIST.get(ruleID);
            if (existingRuleMap != null) {
                existingRuleMap.forEach((profileID, breakerMap) -> breakerMap.forEach((provider, initiatorInfo) -> ActivityUtil.getListener(ActivityProfileContainer.get().getProviderInfo((Long)profileID, (Long)provider)).processActivityInitiator((Long)profileID, (Long)provider, (ActivityInitiatorInfo)initiatorInfo, initiatorInfo.getPrimaryActionID(), response)));
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void addOrUpdate(ActivityProfileInfo profileInfo) {
        Long profileID = profileInfo.getID();
        List<ActivityProviderInfo> providers = profileInfo.getProvidersList();
        providers.forEach(provider -> {
            if (provider.getStatus() == CorrelationStatus.ENABLE) {
                ActivityInitiator.addOrUpdate(profileID, provider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdate(Long profileID, ActivityProviderInfo provider) {
        SYNC.lock();
        try {
            ActivityInitiatorInfo initiator = provider.getInitiator();
            Map<Long, Map<Long, ActivityInitiatorInfo>> existingRuleMap = INITIATORLIST.get(initiator.getRuleID());
            if (existingRuleMap == null) {
                existingRuleMap = new HashMap<Long, Map<Long, ActivityInitiatorInfo>>();
                HashMap<Long, ActivityInitiatorInfo> existingProviderMap = new HashMap<Long, ActivityInitiatorInfo>();
                existingProviderMap.put(provider.getID(), initiator);
                existingRuleMap.put(profileID, existingProviderMap);
                INITIATORLIST.put(initiator.getRuleID(), existingRuleMap);
            } else {
                Map existingProviderMap = existingRuleMap.computeIfAbsent(profileID, k -> new HashMap());
                existingProviderMap.put(provider.getID(), initiator);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void remove(ActivityProfileInfo profileInfo) {
        Long profileID = profileInfo.getID();
        List<ActivityProviderInfo> providers = profileInfo.getProvidersList();
        providers.forEach(provider -> ActivityInitiator.remove(profileID, provider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Long profileID, ActivityProviderInfo provider) {
        SYNC.lock();
        try {
            Map<Long, ActivityInitiatorInfo> existingProviderMap;
            ActivityInitiatorInfo initiator = provider.getInitiator();
            Map<Long, Map<Long, ActivityInitiatorInfo>> existingRuleMap = INITIATORLIST.get(initiator.getRuleID());
            if (existingRuleMap != null && (existingProviderMap = existingRuleMap.get(profileID)) != null) {
                existingProviderMap.remove(provider.getID());
                if (existingProviderMap.isEmpty()) {
                    existingRuleMap.remove(profileID);
                }
                if (existingRuleMap.isEmpty()) {
                    INITIATORLIST.remove(initiator.getRuleID());
                }
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static Boolean isRuleInUse(Long ruleID) {
        Map<Long, Map<Long, ActivityInitiatorInfo>> profileMap = INITIATORLIST.get(ruleID);
        return profileMap != null && !profileMap.isEmpty() && profileMap.values().stream().anyMatch(map -> !map.isEmpty());
    }

    public static Set<Long> getEnabledRuleSet() {
        return INITIATORLIST.keySet();
    }

    static {
        SYNC = new ReentrantLock();
        INITIATORLIST = new HashMap<Long, Map<Long, Map<Long, ActivityInitiatorInfo>>>();
    }
}

