/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.listener;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.dispatcher.SequentialResultInflowManager;
import com.manageengine.ela.server.correlation.session.config.ActivityConfigMapping;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.data.cache.ActivityHistoryDataHandler;
import com.manageengine.ela.server.correlation.session.data.cache.OffHeapDataHandler;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivityDelayedSuccessHandler;
import com.manageengine.ela.server.correlation.session.search.wrapper.IndexUpdateRequest;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import com.zoho.za.dae.elastic.LogIndexer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivitySuccessListener
implements CorrelationCallBack {
    private static final Logger LOGGER = Logger.getLogger(ActivitySuccessListener.class.getName());
    private static final ActivitySuccessListener INSTANCE = new ActivitySuccessListener();

    private ActivitySuccessListener() {
    }

    public static ActivitySuccessListener get() {
        return INSTANCE;
    }

    @Override
    public void callBack(Long id, Map<Long, ResponseContainer> response) {
        Long providerID = ActivityConfigMapping.get().getProviderFromRule(id);
        this.callBack(response, ActivityUtil.getProviderInfo(providerID), ActivityRuleType.INIT_TERMINATOR_RULE);
    }

    public void callBack(Map<Long, ResponseContainer> response, ActivityProviderInfo providerInfo, ActivityRuleType type) {
        try {
            this.registerSuccess(response, providerInfo, type);
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity success processing {0}", exp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSuccess(Map<Long, ResponseContainer> response, ActivityProviderInfo providerInfo, ActivityRuleType type) throws Exception {
        LOGGER.log(Level.FINE, "Session activity ended. End type {0} for provider {1}", new Object[]{type, providerInfo.getID()});
        Long endActionID = type == ActivityRuleType.INIT_BREAKER_RULE ? providerInfo.getBreaker().getRuleID() : providerInfo.getTerminator().getRuleID();
        ResponseContainer endResponse = response.get(endActionID);
        ResponseContainer initiatorResponse = response.get(providerInfo.getInitiator().getRuleID());
        Map.Entry<Long, Integer> endEntry = endResponse.getSelectedData().firstEntry();
        String endDocID = (String)((List)endResponse.getOriginalContainer().getDirectMap().get(endEntry.getKey())).get(0);
        Lock lock = initiatorResponse.getOriginalContainer().getDataMarker().getLock();
        lock.lock();
        try {
            block3: for (Map.Entry initiatorEntry : initiatorResponse.getSelectedData().entrySet()) {
                Long time = (Long)initiatorEntry.getKey();
                Integer countNeeded = (Integer)initiatorEntry.getValue();
                Integer count = 0;
                for (String initiatorDocID : initiatorResponse.getOriginalContainer().get(time)) {
                    Row historyRow = ActivityHistoryDataHandler.getInstance().getAndRemoveActivityHistoryData(providerInfo.getID(), initiatorDocID);
                    if (historyRow != null && type != ActivityRuleType.INIT_BREAKER_RULE) {
                        this.registerData(providerInfo, historyRow, endEntry.getKey(), endEntry.getKey(), endDocID, type, null);
                    } else {
                        ActivityDelayedSuccessHandler.insert(providerInfo.getID(), endEntry.getKey(), time, initiatorDocID, endDocID, type);
                        LOGGER.log(Level.FINE, "Passing success handling to delayed handler since activity history not yet updated");
                    }
                    if ((count = Integer.valueOf(count + 1)) < countNeeded || type == ActivityRuleType.INIT_BREAKER_RULE) continue;
                    continue block3;
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void registerData(ActivityProviderInfo providerInfo, Row historyRow, Long activityEndTime, Long endLogTime, String endDocID, ActivityRuleType type, ActivityStatus status) throws Exception {
        Long endActionID;
        Long endPrimaryActionID;
        Long endType;
        if (type == ActivityRuleType.INIT_TERMINATOR_RULE) {
            endType = ActivityStatus.TERMINATED.getValue();
            endPrimaryActionID = providerInfo.getTerminator().getPrimaryActionID();
            endActionID = providerInfo.getTerminator().getRuleID();
        } else {
            endType = status != null ? status.getValue() : ActivityStatus.BROKEN.getValue();
            endPrimaryActionID = providerInfo.getBreaker().getPrimaryActionID();
            endActionID = providerInfo.getBreaker().getRuleID();
        }
        Long historyID = (Long)historyRow.get("HISTORY_ID");
        DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
        Map<Long, Map<Long, List<String>>> nonPrimaryDocs = type == ActivityRuleType.INIT_BREAKER_RULE ? OffHeapDataHandler.get().fetchAndRemoveBreakerDepData(providerInfo.getBreaker().getID(), endDocID) : OffHeapDataHandler.get().fetchAndRemoveTerminatorDepData(providerInfo.getTerminator().getID(), endDocID);
        String index = LogIndexer.getIndexName((Object)endLogTime);
        this.insertActivityEndData(historyID, endDocID, endPrimaryActionID, index, Boolean.TRUE, endActionID, endType, dataObject);
        ArrayList<IndexUpdateRequest> updateRequests = new ArrayList<IndexUpdateRequest>();
        updateRequests.add(new IndexUpdateRequest(historyID, providerInfo.getID(), endPrimaryActionID, index, endDocID));
        if (nonPrimaryDocs != null) {
            nonPrimaryDocs.forEach((actionID, timeMap) -> timeMap.forEach((timeVal, docList) -> docList.forEach(docID -> {
                try {
                    String indexName = LogIndexer.getIndexName((Object)timeVal);
                    this.insertActivityEndData(historyID, (String)docID, (Long)actionID, indexName, Boolean.FALSE, endActionID, endType, dataObject);
                    updateRequests.add(new IndexUpdateRequest(historyID, providerInfo.getID(), (Long)actionID, indexName, (String)docID));
                }
                catch (Exception exp) {
                    LOGGER.log(Level.WARNING, "Cant insert terminator non-primary data {0}", exp);
                }
            })));
        }
        historyRow.set("END_TIME", (Object)activityEndTime);
        historyRow.set("STATUS", (Object)endType);
        dataObject.updateBlindly(historyRow);
        SequentialResultInflowManager.put(dataObject);
        ActivityUtil.updateNoSqlRecords(updateRequests);
    }

    private void insertActivityEndData(Long historyID, String docID, Long actionID, String indexName, Boolean isPrimary, Long ruleID, Long endType, DataObject dataObject) throws DataAccessException {
        Row nonPrimaryEntry = new Row("ActivityEndDocID");
        nonPrimaryEntry.set("HISTORY_ID", (Object)historyID);
        nonPrimaryEntry.set("DOC_ID", (Object)docID);
        nonPrimaryEntry.set("ACTION_CONFIG_ID", (Object)actionID);
        nonPrimaryEntry.set("INDEX_ID", (Object)CorrNosqlIndexHandler.getIndexID(indexName));
        nonPrimaryEntry.set("IS_PRIMARY", (Object)isPrimary);
        nonPrimaryEntry.set("RULE_ID", (Object)ruleID);
        nonPrimaryEntry.set("END_TYPE", (Object)endType);
        dataObject.addRow(nonPrimaryEntry);
    }
}

