/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.listener;

import com.manageengine.ela.server.correlation.callback.CorrelationCallBack;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.info.ActivityProfileInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityTerminatorInfo;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ActivityTerminator
implements CorrelationCallBack {
    private static final Map<Long, Map<Long, Map<Long, ActivityTerminatorInfo>>> TERMINATOR_LIST;
    private static final Lock SYNC;

    public static ActivityTerminator create() {
        return new ActivityTerminator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callBack(Long ruleID, Map<Long, ResponseContainer> response) {
        SYNC.lock();
        try {
            Map<Long, Map<Long, ActivityTerminatorInfo>> existingRuleMap = TERMINATOR_LIST.get(ruleID);
            if (existingRuleMap != null) {
                existingRuleMap.forEach((profileID, breakerMap) -> breakerMap.forEach((provider, terminatorInfo) -> ActivityUtil.getListener(ActivityProfileContainer.get().getProviderInfo((Long)profileID, (Long)provider)).processActivityTerminator((Long)profileID, (Long)provider, (ActivityTerminatorInfo)terminatorInfo, terminatorInfo.getPrimaryActionID(), response)));
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void addOrUpdate(ActivityProfileInfo profileInfo) {
        Long profileID = profileInfo.getID();
        List<ActivityProviderInfo> providers = profileInfo.getProvidersList();
        providers.forEach(provider -> {
            if (provider.getStatus() == CorrelationStatus.ENABLE) {
                ActivityTerminator.addOrUpdate(profileID, provider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOrUpdate(Long profileID, ActivityProviderInfo provider) {
        SYNC.lock();
        try {
            ActivityTerminatorInfo terminator = provider.getTerminator();
            Map<Long, Map<Long, ActivityTerminatorInfo>> existingRuleMap = TERMINATOR_LIST.get(terminator.getRuleID());
            if (existingRuleMap == null) {
                existingRuleMap = new HashMap<Long, Map<Long, ActivityTerminatorInfo>>();
                HashMap<Long, ActivityTerminatorInfo> existingProviderMap = new HashMap<Long, ActivityTerminatorInfo>();
                existingProviderMap.put(provider.getID(), terminator);
                existingRuleMap.put(profileID, existingProviderMap);
                TERMINATOR_LIST.put(terminator.getRuleID(), existingRuleMap);
            } else {
                Map existingProviderMap = existingRuleMap.computeIfAbsent(profileID, k -> new HashMap());
                existingProviderMap.put(provider.getID(), terminator);
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static void remove(ActivityProfileInfo profileInfo) {
        Long profileID = profileInfo.getID();
        List<ActivityProviderInfo> providers = profileInfo.getProvidersList();
        providers.forEach(provider -> ActivityTerminator.remove(profileID, provider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Long profileID, ActivityProviderInfo provider) {
        SYNC.lock();
        try {
            Map<Long, ActivityTerminatorInfo> existingProviderMap;
            ActivityTerminatorInfo terminator = provider.getTerminator();
            Map<Long, Map<Long, ActivityTerminatorInfo>> existingRuleMap = TERMINATOR_LIST.get(terminator.getRuleID());
            if (existingRuleMap != null && (existingProviderMap = existingRuleMap.get(profileID)) != null) {
                existingProviderMap.remove(provider.getID());
                if (existingProviderMap.isEmpty()) {
                    existingRuleMap.remove(profileID);
                }
                if (existingRuleMap.isEmpty()) {
                    TERMINATOR_LIST.remove(terminator.getRuleID());
                }
            }
        }
        finally {
            SYNC.unlock();
        }
    }

    public static Boolean isRuleInUse(Long ruleID) {
        Map<Long, Map<Long, ActivityTerminatorInfo>> profileMap = TERMINATOR_LIST.get(ruleID);
        return profileMap != null && !profileMap.isEmpty() && profileMap.values().stream().anyMatch(map -> !map.isEmpty());
    }

    public static Set<Long> getEnabledRuleSet() {
        return TERMINATOR_LIST.keySet();
    }

    static {
        SYNC = new ReentrantLock();
        TERMINATOR_LIST = new HashMap<Long, Map<Long, Map<Long, ActivityTerminatorInfo>>>();
    }
}

