/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.listener.helper;

import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.data.ActivityDocData;
import com.manageengine.ela.server.correlation.session.data.cache.ActivityPrimaryDocHandler;
import com.manageengine.ela.server.correlation.session.info.ActivityBreakerInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityInitiatorInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityTerminatorInfo;
import com.manageengine.ela.server.correlation.session.listener.helper.ListenerHelperImpl;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultListenerHelper
extends ListenerHelperImpl {
    private static final Logger LOGGER = Logger.getLogger(DefaultListenerHelper.class.getName());
    private static final DefaultListenerHelper INSTANCE = new DefaultListenerHelper();

    public static DefaultListenerHelper getInstance() {
        return INSTANCE;
    }

    @Override
    public void processActivityInitiator(Long profileID, Long providerID, ActivityInitiatorInfo initiatorInfo, Long primaryActionID, Map<Long, ResponseContainer> response) {
        Map.Entry<Long, String> primaryDocID = this.getPrimaryDocID(response.get(primaryActionID));
        if (primaryDocID == null) {
            LOGGER.log(Level.FINE, "Invalid Activity initiator info received. Skipping further processing");
            return;
        }
        this.storeInitiatorDependentData(initiatorInfo.getID(), primaryActionID, primaryDocID.getValue(), response);
        ActivityDocData docData = new ActivityDocData(profileID, providerID, initiatorInfo.getRuleID(), primaryDocID.getKey(), ActivityRuleType.INITIATOR_RULE, primaryDocID.getValue());
        ActivityPrimaryDocHandler.insert(docData);
        LOGGER.log(Level.FINEST, "Activity Initiator event received for provider {0}. Data = {1}", new Object[]{providerID, response});
    }

    @Override
    public void processActivityTerminator(Long profileID, Long providerID, ActivityTerminatorInfo termInfo, Long primaryActionID, Map<Long, ResponseContainer> response) {
        LOGGER.log(Level.FINEST, "Activity Terminator event received for provider {0}. Data = {1}", new Object[]{providerID, response});
        Map.Entry<Long, String> primaryDocID = this.getPrimaryDocID(response.get(primaryActionID));
        if (primaryDocID == null) {
            LOGGER.log(Level.FINE, "Invalid Activity Terminator info received. Skipping further processing");
            return;
        }
        this.storeTerminatorDependentData(termInfo.getID(), primaryActionID, primaryDocID.getValue(), response);
        ActivityDocData docData = new ActivityDocData(profileID, providerID, termInfo.getRuleID(), primaryDocID.getKey(), ActivityRuleType.TERMINATOR_RULE, primaryDocID.getValue());
        ActivityPrimaryDocHandler.insert(docData);
    }

    @Override
    public void processActivityBreaker(Long profileID, Long providerID, ActivityBreakerInfo breakerInfo, Long primaryActionID, Map<Long, ResponseContainer> response) {
        LOGGER.log(Level.FINEST, "Activity Breaker event received for provider {0}", providerID);
        Map.Entry<Long, String> primaryDocID = this.getPrimaryDocID(response.get(primaryActionID));
        if (primaryDocID == null) {
            LOGGER.log(Level.FINE, "Invalid Activity Breaker response received. Skipping further processing");
            return;
        }
        this.storeBreakerDependentData(breakerInfo.getID(), primaryActionID, primaryDocID.getValue(), response);
        ActivityDocData docData = new ActivityDocData(profileID, providerID, breakerInfo.getRuleID(), primaryDocID.getKey(), ActivityRuleType.BREAKER_RULE, primaryDocID.getValue());
        ActivityPrimaryDocHandler.insert(docData);
    }
}

