/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.listener.helper;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.core.data.FieldDataContainer;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.core.data.SortedContainer;
import com.manageengine.ela.server.correlation.core.dispatcher.SequentialResultInflowManager;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.session.analyzer.BreakerAnalyzer;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.data.ActivityDataHelper;
import com.manageengine.ela.server.correlation.session.data.ActivityDocData;
import com.manageengine.ela.server.correlation.session.data.cache.ActRuntimeCache;
import com.manageengine.ela.server.correlation.session.data.cache.ActivityHistoryDataHandler;
import com.manageengine.ela.server.correlation.session.data.cache.OffHeapDataHandler;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivitySuccessListener;
import com.manageengine.ela.server.correlation.session.listener.helper.ListenerHelper;
import com.manageengine.ela.server.correlation.session.processor.ActivityRequestExecutor;
import com.manageengine.ela.server.correlation.session.search.wrapper.IndexUpdateRequest;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import com.zoho.za.dae.elastic.LogIndexer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ListenerHelperImpl
implements ListenerHelper {
    private static final Logger LOGGER = Logger.getLogger(ListenerHelperImpl.class.getName());

    protected Map.Entry<Long, String> getPrimaryDocID(ResponseContainer primaryActionResponse) {
        if (primaryActionResponse != null) {
            try {
                SortedContainer orgContainer = primaryActionResponse.getOriginalContainer();
                Map.Entry<Long, Integer> lastIndex = primaryActionResponse.getSelectedData().lastEntry();
                Long time = lastIndex.getKey();
                Integer limit = lastIndex.getValue();
                List<String> original = orgContainer.get(time);
                return new AbstractMap.SimpleEntry<Long, String>(time, original.get(limit - 1));
            }
            catch (Exception exp) {
                return null;
            }
        }
        return null;
    }

    protected void storeTerminatorDependentData(Long terminatorID, Long primaryActionID, String primaryDoc, Map<Long, ResponseContainer> response) {
        Map<Long, Map<Long, List<String>>> data = ActivityDataHelper.normalizeResponse(primaryActionID, response);
        if (!data.isEmpty()) {
            OffHeapDataHandler.get().storeTerminatorDependentData(terminatorID, primaryDoc, data);
        }
    }

    protected void storeInitiatorDependentData(Long initiatorID, Long primaryActionID, String primaryDoc, Map<Long, ResponseContainer> response) {
        Map<Long, Map<Long, List<String>>> data = ActivityDataHelper.normalizeResponse(primaryActionID, response);
        if (!data.isEmpty()) {
            OffHeapDataHandler.get().storeInitiatorDependentData(initiatorID, primaryDoc, data);
        }
    }

    protected void storeBreakerDependentData(Long breakerID, Long primaryActionID, String primaryDoc, Map<Long, ResponseContainer> response) {
        Map<Long, Map<Long, List<String>>> data = ActivityDataHelper.normalizeResponse(primaryActionID, response);
        if (!data.isEmpty()) {
            OffHeapDataHandler.get().storeBreakerDependentData(breakerID, primaryDoc, data);
        }
    }

    @Override
    public boolean processResolvedLog(ActivityDocData docEntry, Map<String, Object> data, boolean isInitHandled) {
        LOGGER.log(Level.FINE, "Resolving indexed log for activity");
        try {
            Long providerID = docEntry.getProviderID();
            ActivityProviderInfo providerInfo = ActivityUtil.getProviderInfo(providerID);
            ActivityRuleType ruleType = docEntry.getRuleType();
            String primaryDocID = docEntry.getDocID();
            ArrayList<IndexUpdateRequest> indexUpdateRequestList = new ArrayList<IndexUpdateRequest>();
            if (ruleType == ActivityRuleType.INITIATOR_RULE || ruleType == ActivityRuleType.TERMINATOR_RULE) {
                Set<String> interestedFields;
                FieldDataContainer container = providerInfo.getContainer().getFieldDataContainer(docEntry.getRuleID());
                Row historyRow = null;
                if (ruleType == ActivityRuleType.TERMINATOR_RULE) {
                    interestedFields = providerInfo.getTermLinkedFields();
                    if (!ActivityDataHelper.checkLogCompatibility(data, interestedFields).booleanValue()) {
                        LOGGER.log(Level.FINER, "Skipping log because of insufficient field info.");
                        OffHeapDataHandler.get().deleteTerminatorDependentData(providerInfo.getTerminator().getID(), primaryDocID);
                        return true;
                    }
                } else {
                    interestedFields = providerInfo.getInitLinkedFields();
                    if (!ActivityDataHelper.checkLogCompatibility(data, interestedFields).booleanValue()) {
                        LOGGER.log(Level.FINER, "Activity initiator does not contain enough field information for activity processing.");
                        OffHeapDataHandler.get().deleteInitiatorDependentData(providerInfo.getInitiator().getID(), primaryDocID);
                        return true;
                    }
                    if (!isInitHandled) {
                        this.insertActivityInitiatorData(docEntry, providerInfo);
                    }
                    if ((historyRow = ActivityHistoryDataHandler.getInstance().getActivityHistoryData(providerInfo.getID(), docEntry.getDocID())) == null) {
                        LOGGER.log(Level.WARNING, "Could not obtain activity history data for doc {0}. Cant update index.", providerID);
                        return false;
                    }
                    Long historyID = (Long)historyRow.get("HISTORY_ID");
                    Map<Long, Map<Long, List<String>>> depData = OffHeapDataHandler.get().fetchAndRemoveInitiatorDepData(providerInfo.getInitiator().getID(), docEntry.getDocID());
                    if (depData != null) {
                        depData.forEach((actionID, timeDocs) -> timeDocs.forEach((time, list2) -> list2.forEach(doc -> {
                            Long remoteActionConfigID;
                            IndexUpdateRequest request = new IndexUpdateRequest(historyID, providerID, (Long)actionID, LogIndexer.getIndexName((Object)time), (String)doc);
                            if (providerInfo.getType() == 2 && (remoteActionConfigID = ActRuntimeCache.fetchValue(ActRuntimeCache.RuntimeConstants.PMP_MAIN_ACTION_CONFIG_ID)) != null && remoteActionConfigID.compareTo((Long)actionID) == 0) {
                                request.insertExtraFields("ACT_FLAG", "IN");
                            }
                            indexUpdateRequestList.add(request);
                        })));
                    }
                }
                interestedFields.forEach(field -> {
                    String fieldValue = String.valueOf(data.get(field));
                    container.store((String)field, fieldValue, docEntry.getTime(), primaryDocID);
                });
                CorrelationExecutor executor = providerInfo.getExecutor();
                ActivityRequestExecutor.add(executor);
                if (docEntry.isIndexUpdateNeeded() && historyRow != null) {
                    String indexName = LogIndexer.getIndexName((Object)docEntry.getTime());
                    IndexUpdateRequest updateRequest = new IndexUpdateRequest((Long)historyRow.get("HISTORY_ID"), providerID, providerInfo.getInitiator().getPrimaryActionID(), indexName, docEntry.getDocID());
                    indexUpdateRequestList.add(updateRequest);
                    LOGGER.log(Level.FINER, "Updated initiator index.");
                }
            } else if (ruleType == ActivityRuleType.BREAKER_RULE) {
                if (!ActivityDataHelper.checkLogCompatibility(data, providerInfo.getBreaker().getBreakerRuleFields()).booleanValue()) {
                    OffHeapDataHandler.get().deleteBreakerDependentData(providerInfo.getBreaker().getID(), primaryDocID);
                    return true;
                }
                FieldDataContainer breakerData = ActivityDataHelper.prepareBreakerContainer(providerInfo, docEntry.getTime(), data, primaryDocID);
                BreakerAnalyzer breakerAnalyzer = new BreakerAnalyzer(ActivityDataHelper.prepareBreakerInput(providerInfo), ActivitySuccessListener.get(), breakerData, providerInfo);
                ActivityRequestExecutor.add(breakerAnalyzer);
            } else {
                LOGGER.log(Level.INFO, "Invalid activity cache entry found {0}", new Object[]{docEntry});
            }
            if (indexUpdateRequestList.size() > 0) {
                ActivityUtil.updateNoSqlRecords(indexUpdateRequestList);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during activity data processing {0}", new Object[]{exp});
            return false;
        }
        return true;
    }

    private void insertActivityInitiatorData(ActivityDocData docData, ActivityProviderInfo providerInfo) {
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
            Row activityHistory = this.insertActivityHistoryData(dataObject, docData.getProviderID(), docData.getTime(), Boolean.TRUE);
            Object historyID = activityHistory.get("HISTORY_ID");
            Long initID = providerInfo.getInitiator().getID();
            Long initRuleID = providerInfo.getInitiator().getRuleID();
            Map<Long, Map<Long, List<String>>> depData = OffHeapDataHandler.get().fetchInitiatorDepData(initID, docData.getDocID());
            if (depData != null) {
                depData.forEach((actionID, timeMap) -> timeMap.forEach((timeVal, docList) -> docList.forEach(docID -> {
                    try {
                        this.insertInitiatorData(dataObject, historyID, initID, initRuleID, (Long)actionID, (Long)timeVal, (String)docID, false);
                    }
                    catch (Exception exp) {
                        LOGGER.log(Level.WARNING, "Cant insert terminator non-primary data {0}", exp);
                    }
                })));
            }
            if (historyID != null) {
                this.insertInitiatorData(dataObject, historyID, initID, initRuleID, providerInfo.getInitiator().getPrimaryActionID(), docData.getTime(), docData.getDocID(), true);
                SequentialResultInflowManager.put(dataObject);
                ActivityHistoryDataHandler.getInstance().storeActivityHistoryData(providerInfo.getID(), docData.getDocID(), activityHistory);
            } else {
                LOGGER.log(Level.FINER, "Initiator process skipped due to invalid primary docID or other docID List");
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Cant save activity initiator entries - {0}", exp.getMessage());
        }
    }

    public Row insertActivityHistoryData(DataObject dataObject, Long providerID, Long startTime, Boolean isPrimary) throws DataAccessException {
        Row activityHistory = new Row("ActivityHistory");
        activityHistory.set("PROVIDER_ID", (Object)providerID);
        activityHistory.set("START_TIME", (Object)startTime);
        activityHistory.set("STATUS", (Object)ActivityStatus.INITIATED.getValue());
        activityHistory.set("IS_PRIMARY", (Object)isPrimary);
        dataObject.addRow(activityHistory);
        return activityHistory;
    }

    public void insertInitiatorData(DataObject dobj, Object historyID, Long initID, Long ruleID, Long actionConfigID, Long time, String docID, boolean isPrimary) throws DataAccessException {
        Row activityInitiatorDocID = new Row("ActivityInitiatorDocID");
        String indexName = LogIndexer.getIndexName((Object)time);
        activityInitiatorDocID.set("HISTORY_ID", historyID);
        activityInitiatorDocID.set("INITIATOR_ID", (Object)initID);
        activityInitiatorDocID.set("RULE_ID", (Object)ruleID);
        activityInitiatorDocID.set("ACTION_CONFIG_ID", (Object)actionConfigID);
        activityInitiatorDocID.set("DOC_ID", (Object)docID);
        activityInitiatorDocID.set("INDEX_ID", (Object)CorrNosqlIndexHandler.getIndexID(indexName));
        activityInitiatorDocID.set("IS_PRIMARY", (Object)isPrimary);
        dobj.addRow(activityInitiatorDocID);
    }
}

