/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.listener.helper;

import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.correlation.core.data.ResponseContainer;
import com.manageengine.ela.server.correlation.session.analyzer.WinActivityInitiatorReqHandler;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.constants.ActivityRuleType;
import com.manageengine.ela.server.correlation.session.data.ActivityDataHelper;
import com.manageengine.ela.server.correlation.session.data.ActivityDocData;
import com.manageengine.ela.server.correlation.session.data.cache.ActivityHistoryDataHandler;
import com.manageengine.ela.server.correlation.session.data.cache.OffHeapDataHandler;
import com.manageengine.ela.server.correlation.session.info.ActivityInitiatorInfo;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.helper.DefaultListenerHelper;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WinListenerHelper
extends DefaultListenerHelper {
    private static final Logger LOGGER = Logger.getLogger(WinListenerHelper.class.getName());
    private static final WinListenerHelper INSTANCE = new WinListenerHelper();

    public static WinListenerHelper getInstance() {
        return INSTANCE;
    }

    @Override
    public void processActivityInitiator(Long profileID, Long providerID, ActivityInitiatorInfo initInfo, Long primaryActionID, Map<Long, ResponseContainer> response) {
        LOGGER.log(Level.FINE, "Windows session activity initiator log received for provider {0}", providerID);
        super.processActivityInitiator(profileID, providerID, initInfo, primaryActionID, response);
    }

    @Override
    public boolean processResolvedLog(ActivityDocData docEntry, Map<String, Object> data, boolean isInitHandled) {
        if (docEntry.getRuleType() != ActivityRuleType.INITIATOR_RULE) {
            return super.processResolvedLog(docEntry, data, false);
        }
        WinActivityInitiatorReqHandler.enqueueDoc(docEntry, data);
        return true;
    }

    @Override
    protected void storeInitiatorDependentData(Long initiatorID, Long primaryActionID, String primaryDoc, Map<Long, ResponseContainer> response) {
        Map<Long, Map<Long, List<String>>> data = ActivityDataHelper.normalizeResponse(primaryActionID, response);
        if (!data.isEmpty()) {
            OffHeapDataHandler.get().storeInitiatorDependentData(initiatorID, primaryDoc, data);
        }
    }

    public Long registerSession(ActivityDocData docData, Map map, Boolean isPrimarySession) {
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
            ActivityProviderInfo providerInfo = ActivityProfileContainer.get().getProviderInfo(docData.getProfileID(), docData.getProviderID());
            Row activityHistory = this.insertActivityHistoryData(dataObject, docData.getProviderID(), docData.getTime(), isPrimarySession);
            Object historyID = activityHistory.get("HISTORY_ID");
            Long initID = providerInfo.getInitiator().getID();
            Long initRuleID = providerInfo.getInitiator().getRuleID();
            Map<Long, Map<Long, List<String>>> nonPrimaryDocs = OffHeapDataHandler.get().fetchAndRemoveInitiatorDepData(providerInfo.getInitiator().getID(), docData.getDocID());
            if (nonPrimaryDocs != null) {
                nonPrimaryDocs.forEach((actionID, timeMap) -> timeMap.forEach((time, docList) -> docList.forEach(docID -> {
                    try {
                        this.insertInitiatorData(dataObject, historyID, initID, initRuleID, (Long)actionID, (Long)time, (String)docID, false);
                    }
                    catch (Exception exp) {
                        LOGGER.log(Level.WARNING, "Cant insert initiator non-primary data {0}", exp);
                    }
                })));
            }
            this.insertInitiatorData(dataObject, historyID, initID, initRuleID, providerInfo.getInitiator().getPrimaryActionID(), docData.getTime(), docData.getDocID(), true);
            PersistenceDBUtil.getPersistence().update(dataObject);
            activityHistory = dataObject.getFirstRow("ActivityHistory");
            Long histID = (Long)activityHistory.get("HISTORY_ID");
            ActivityHistoryDataHandler.getInstance().storeActivityHistoryData(docData.getProviderID(), docData.getDocID(), activityHistory);
            super.processResolvedLog(docData, map, true);
            return histID;
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Exception occurred during win session initiator handling {0}", exp.getMessage());
            return null;
        }
    }
}

