/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.processor;

import com.manageengine.ela.server.common.executors.processor.CommonQueueProcessor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.correlation.core.config.CorrConfigInfo;
import com.manageengine.ela.server.correlation.core.constants.ExecutorStatus;
import com.manageengine.ela.server.correlation.core.executors.CorrelationExecutor;
import com.manageengine.ela.server.correlation.core.executors.ProcessInflowManager;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivityRequestExecutor
extends CommonQueueProcessor<CorrelationExecutor> {
    private static final ProcessorPoolExecutor EXECUTOR;
    private static final ProcessInflowManager<CorrelationExecutor> INFLOW_HANDLER;
    private static final Logger LOGGER;

    private ActivityRequestExecutor(ConcurrentQueue<CorrelationExecutor> queue) throws IllegalArgumentException {
        super(queue);
    }

    @Override
    protected CorrelationExecutor getData() throws InterruptedException {
        return (CorrelationExecutor)this.queue.get();
    }

    public static void add(CorrelationExecutor request) throws Exception {
        INFLOW_HANDLER.add(request);
    }

    @Override
    public void process(CorrelationExecutor data) throws Exception {
        data.setStatus(ExecutorStatus.STARTED);
        try {
            LOGGER.log(Level.FINE, "Executing activity request {0}", data.getIdentity());
            data.execute();
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Unable to process activity rule {0}", exp.getMessage());
        }
        finally {
            data.setStatus(ExecutorStatus.COMPLETED);
        }
    }

    static {
        LOGGER = Logger.getLogger(ActivityRequestExecutor.class.getName());
        CommonQueueImpl<CorrelationExecutor> queue = new CommonQueueImpl<CorrelationExecutor>(new LinkedBlockingQueue());
        ActivityRequestExecutor processor = new ActivityRequestExecutor((ConcurrentQueue<CorrelationExecutor>)queue);
        int maxThreads = CorrConfigInfo.getDefault_max_rule_processors();
        EXECUTOR = new ProcessorPoolExecutorImpl<CorrelationExecutor>(processor, "correlation[activity][processor]", maxThreads);
        INFLOW_HANDLER = new ProcessInflowManager<CorrelationExecutor>(queue, true);
        for (int index = 0; index < maxThreads; ++index) {
            try {
                EXECUTOR.addProcessor();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

