/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.schedule;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.util.ServerUtil;
import com.manageengine.ela.server.correlation.session.auditdata.ActivityArchivedData;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActColdDataProcessor
implements Task {
    private static final Logger LOGGER = Logger.getLogger(ActColdDataProcessor.class.getName());

    public void executeTask(TaskContext taskInput) {
        if (!ServerDetailsBean.getInstance().isAdminServer()) {
            int days = ServerUtil.getGlobalRetentionPeriod();
            if (days != -1) {
                long timeAfterRetention = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS);
                try {
                    List<Map<String, Object>> archivedData = ActivityArchivedData.get().getArchivedTablesInfoFromEnd(timeAfterRetention);
                    if (archivedData.size() > 0) {
                        ArrayList<String> tablesToBeDeleted = new ArrayList<String>();
                        for (Map<String, Object> dataMap : archivedData) {
                            tablesToBeDeleted.add((String)dataMap.get("ActivityHistory"));
                            tablesToBeDeleted.add((String)dataMap.get("ActivityInitiatorDocID"));
                            tablesToBeDeleted.add((String)dataMap.get("ActivityEndDocID"));
                            tablesToBeDeleted.add((String)dataMap.get("WinActivityLinkInfo"));
                            tablesToBeDeleted.add((String)dataMap.get("WindowsActivityStatus"));
                        }
                        RelationalAPI.getInstance().getArchiveAdapter().deleteArchiveTable(tablesToBeDeleted);
                    }
                }
                catch (Exception exp) {
                    LOGGER.log(Level.WARNING, "Error occurred during activity cold data processing {0}", exp.getMessage());
                }
                Criteria criteria = ActivityUtil.getHistoryBeforeTime("ActivityHistory", timeAfterRetention);
                DBUtil.deleteExistingRows("ActivityHistory", criteria, new boolean[0]);
            }
        } else {
            try {
                this.stopTask();
            }
            catch (TaskExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

