/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.schedule;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.archive.ArchiveNotificationHandler;
import com.adventnet.db.archive.ArchivePolicyInfo;
import com.adventnet.db.archive.TableArchiverUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.correlation.session.listener.ActivityDBArchiveListener;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActivityDBArchiveTask
implements Task {
    public static final String HISTORY_ID_MIN = "HISTORY_ID_MIN";
    public static final String HISTORY_ID_MAX = "HISTORY_ID_MAX";
    public static final String TIME_MIN = "TIME_MIN";
    public static final String TIME_MAX = "TIME_MAX";
    private static final Lock SYNC = new ReentrantLock();
    private static final Logger LOGGER = Logger.getLogger(ActivityDBArchiveTask.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext paramTaskContext) throws TaskExecutionException {
        if (!ServerDetailsBean.getInstance().isAdminServer()) {
            SYNC.lock();
            try {
                Iterator iterator = paramTaskContext.getDefaultTaskInputs();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    this.startArchiveProcess(Long.parseLong((String)row.get("VARIABLE_VALUE")));
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            finally {
                SYNC.unlock();
            }
        } else {
            try {
                this.stopTask();
            }
            catch (TaskExecutionException exception) {
                LOGGER.log(Level.WARNING, "Error occurred during Activity Table Archive {0}", exception.getMessage());
                throw exception;
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }

    private void startArchiveProcess(Long policyID) throws Exception {
        ArchivePolicyInfo policyInfo = TableArchiverUtil.getPolicy((Long)policyID);
        while (this.isTableFilled(policyInfo)) {
            Long upperLimit = policyInfo.getThreshold() / 2L;
            int maxRowsAllowed = upperLimit.intValue();
            long time = System.nanoTime();
            Map<String, Long> identity = this.fetchFirstAndLastRows(policyInfo, maxRowsAllowed);
            time = System.nanoTime() - time;
            if (identity == null || identity.size() == 0) break;
            LOGGER.log(Level.INFO, "Time taken to fetch first and last row {0}", new Object[]{time});
            StringBuilder criteriaBuilder = new StringBuilder();
            policyInfo.setCriteria(criteriaBuilder.append(" ( ( $.HISTORY_ID <= ").append(identity.get(HISTORY_ID_MAX)).append(" ) AND ( $.HISTORY_ID >= ").append(identity.get(HISTORY_ID_MIN)).append(" ) AND ( $.STATUS > 0 ) )").toString());
            policyInfo.setNotificationHandler((ArchiveNotificationHandler)new ActivityDBArchiveListener(identity.get(TIME_MIN), identity.get(TIME_MAX)));
            RelationalAPI.getInstance().getArchiveAdapter().startArchive(policyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> fetchFirstAndLastRows(ArchivePolicyInfo policyInfo, int upperLimit) {
        HashMap<String, Long> selectedDetails = new HashMap<String, Long>();
        String tableToArchive = policyInfo.getTableName();
        SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)tableToArchive));
        subQuery.setRange(new Range(1, upperLimit));
        Column pkColumn = Column.getColumn((String)tableToArchive, (String)"HISTORY_ID");
        Column startTimeColumn = Column.getColumn((String)tableToArchive, (String)"START_TIME");
        Column endTimeColumn = Column.getColumn((String)tableToArchive, (String)"END_TIME");
        subQuery.addSelectColumn(pkColumn);
        subQuery.addSelectColumn(startTimeColumn);
        subQuery.addSelectColumn(endTimeColumn);
        subQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableToArchive, (String)"HISTORY_ID"), true));
        subQuery.setCriteria(new Criteria(Column.getColumn((String)tableToArchive, (String)"STATUS"), (Object)0, 5));
        DerivedTable derivedTable = new DerivedTable(tableToArchive, (Query)subQuery);
        SelectQueryImpl selectQuery = new SelectQueryImpl((Table)derivedTable);
        selectQuery.addSelectColumn(pkColumn.minimum());
        selectQuery.addSelectColumn(pkColumn.maximum());
        selectQuery.addSelectColumn(startTimeColumn.minimum());
        selectQuery.addSelectColumn(endTimeColumn.maximum());
        Connection con = null;
        DataSet dSet = null;
        try {
            con = RelationalAPI.getInstance().getConnection();
            dSet = RelationalAPI.getInstance().executeQuery((Query)selectQuery, con);
            while (dSet.next()) {
                selectedDetails.put(HISTORY_ID_MIN, Objects.requireNonNull(dSet.getAsLong(1)));
                selectedDetails.put(HISTORY_ID_MAX, Objects.requireNonNull(dSet.getAsLong(2)));
                selectedDetails.put(TIME_MIN, Objects.requireNonNull(dSet.getAsLong(3)));
                selectedDetails.put(TIME_MAX, Objects.requireNonNull(dSet.getAsLong(4)));
            }
        }
        catch (Exception exp) {
            try {
                exp.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetOrDataSet(null, dSet);
                DBUtil.closeStmtAndConnection(null, con);
                throw throwable;
            }
            DBUtil.closeResultSetOrDataSet(null, dSet);
            DBUtil.closeStmtAndConnection(null, con);
        }
        DBUtil.closeResultSetOrDataSet(null, dSet);
        DBUtil.closeStmtAndConnection(null, con);
        return selectedDetails;
    }

    private boolean isTableFilled(ArchivePolicyInfo policyInfo) {
        return DBUtil.getCountLong(policyInfo.getTableName(), null) > policyInfo.getThreshold();
    }

    @Deprecated
    public void startArchiveManually(Long policyID) throws Exception {
        this.startArchiveProcess(policyID);
    }
}

