/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.search;

import com.manageengine.ela.server.correlation.session.search.NoSqlSearchRequest;
import com.zoho.za.dae.elastic.Node;
import com.zoho.za.dae.schedule.ArchiveManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;

public class ActivityNoSqlSearch {
    private static final Logger LOGGER = Logger.getLogger(ActivityNoSqlSearch.class.getName());

    public static SearchResponse doSearch(NoSqlSearchRequest request) {
        SearchRequestBuilder builder = Node.getClient().prepareSearch(new String[0]).setSize(request.getSize().intValue());
        ActivityNoSqlSearch.unArchiveIndices(request.getStartTime(), request.getEndTime());
        if (request.getQuery() != null) {
            builder.setQuery(request.getQuery());
        }
        if (request.getIndices() != null) {
            builder.setIndices(request.getIndices());
        } else {
            builder.setIndices(new String[]{"logs*"});
        }
        if (request.getSort() != null) {
            request.getSort().forEach(arg_0 -> ((SearchRequestBuilder)builder).addSort(arg_0));
        }
        if (request.getScroll() != null) {
            builder.setScroll(request.getScroll());
        }
        if (request.getAggregation() != null) {
            builder.addAggregation(request.getAggregation());
        }
        try {
            return (SearchResponse)builder.execute().get();
        }
        catch (InterruptedException | ExecutionException exp) {
            LOGGER.log(Level.WARNING, "Error occurred during elastic search {0}", exp);
            exp.printStackTrace();
            return null;
        }
    }

    public static SearchResponse doScroll(String scrollID) throws Exception {
        Client client = Node.getClient();
        SearchScrollRequestBuilder requestBuilder = client.prepareSearchScroll(scrollID).setScroll(ActivityNoSqlSearch.getDefaultSearchScroll());
        return (SearchResponse)requestBuilder.execute().actionGet();
    }

    public static Scroll getDefaultSearchScroll() {
        return new Scroll(TimeValue.timeValueMillis((long)300000L));
    }

    public static Map<String, Map<String, Object>> resolveLogs(List<String> docIDs, String[] indices) {
        int expectedCount = docIDs.size();
        Client client = Node.getClient();
        SearchResponse response = (SearchResponse)client.prepareSearch(indices).setQuery((QueryBuilder)QueryBuilders.idsQuery((String[])new String[0]).addIds(docIDs)).setSize(expectedCount).execute().actionGet();
        if (response.getHits().getTotalHits() < (long)expectedCount) {
            return null;
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (SearchHit hit : response.getHits()) {
            result.put(hit.getId(), hit.getSource());
        }
        return result;
    }

    public static void unArchiveIndices(Long startTime, Long endTime) {
        ArchiveManager.unArchiveIndices((Client)Node.getClient(), (Long)(startTime / 1000L), (Long)(endTime / 1000L), (boolean)true, (String)"logs_");
    }
}

