/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.search.historysearch;

import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.ServerUtil;
import com.manageengine.ela.server.correlation.common.constants.SyslogSeverityConstants;
import com.manageengine.ela.server.correlation.common.constants.WindowsLogSeverityConstants;
import com.manageengine.ela.server.correlation.session.search.ActivityNoSqlSearch;
import com.manageengine.ela.server.correlation.session.search.NoSqlSearchRequest;
import com.manageengine.ela.server.correlation.session.search.historysearch.HistorySearchRequest;
import com.manageengine.ela.server.correlation.session.util.ActivityDataTransformUtil;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityHistorySearchHandler {
    private static final Logger LOGGER = Logger.getLogger(ActivityHistorySearchHandler.class.getName());

    public static JSONObject loadSearchResult(HistorySearchRequest searchRequest) throws Exception {
        JSONObject result = new JSONObject();
        NoSqlSearchRequest request = new NoSqlSearchRequest(searchRequest.getStartTime(), searchRequest.getEndTime()).setQuery((QueryBuilder)searchRequest.getFinalCriteria()).setSort(searchRequest.getSort()).setSize(searchRequest.getResultSize());
        SearchResponse response = ActivityNoSqlSearch.doSearch(request);
        if (response == null) {
            throw BaseStatusCode.getBaseStatusCode(16386);
        }
        result.put("EVENT_LIST", (Object)ActivityHistorySearchHandler.normalizeResult(response, searchRequest));
        result.put("COUNT", response.getHits().getTotalHits());
        return result;
    }

    private static JSONArray normalizeResult(SearchResponse response, HistorySearchRequest request) throws BaseStatusCode {
        try {
            int count = request.getResultSize();
            JSONArray result = new JSONArray();
            SearchHits hits = response.getHits();
            int limit = hits.getHits().length;
            TimeZone timeZone = request.getTimeZone();
            if (request.getIsForwardSearch().booleanValue()) {
                for (int start = ActivityHistorySearchHandler.getOffset(hits, request); start < count && start < limit; ++start) {
                    result.put((Object)ActivityHistorySearchHandler.prepareResponse(hits.getAt(start), timeZone));
                }
            } else {
                int offset = ActivityHistorySearchHandler.getOffset(hits, request);
                for (int start = limit - 1; start >= offset; --start) {
                    result.put((Object)ActivityHistorySearchHandler.prepareResponse(hits.getAt(start), timeZone));
                }
            }
            return result;
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during activity history data loading {0}", exp);
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    private static JSONObject prepareResponse(SearchHit searchHit, TimeZone timeZone) throws JSONException, BaseStatusCode {
        Map log = searchHit.getSource();
        JSONObject event = new JSONObject();
        if (log.containsKey("SEVERITY")) {
            Integer sev = (Integer)log.get("SEVERITY");
            if (ServerUtil.isUnixLog(log)) {
                SyslogSeverityConstants severityConstant = SyslogSeverityConstants.getType(sev);
                event.put("SEVERITY", (Object)ActivityDataTransformUtil.prepareSeverityObject(severityConstant));
            } else {
                WindowsLogSeverityConstants severity = WindowsLogSeverityConstants.getType(sev);
                event.put("SEVERITY", (Object)ActivityDataTransformUtil.prepareSeverityObject(severity));
            }
        } else {
            event.put("SEVERITY", (Object)ActivityDataTransformUtil.prepareSeverityObject(WindowsLogSeverityConstants.OTHERS));
        }
        event.put("DATE_TIME", (Object)ActivityHistorySearchHandler.formatToDateAndTime(Long.parseLong(log.get("TIME").toString()), timeZone));
        if (log.containsKey("MSGFIELD")) {
            event.put("MESSAGE", log.get("MSGFIELD"));
        } else {
            event.put("MESSAGE", (Object)log.getOrDefault("RAWLOG", "-"));
        }
        event.put("DOCID", (Object)searchHit.getId());
        return event;
    }

    private static int getOffset(SearchHits hits, HistorySearchRequest request) {
        int offSet = 0;
        if (request.isScrollSearch().booleanValue()) {
            SearchHit hit;
            Map log;
            Long time;
            for (int i = 0; i < request.getResultSize() && i < hits.getHits().length && (time = Long.valueOf(Long.parseLong((log = (hit = hits.getAt(i)).getSource()).get("TIME").toString()))).compareTo(request.getLastResultTime()) == 0; ++i) {
                if (!hit.getId().equals(request.getLastLoadedDoc())) continue;
                offSet = i + 1;
                break;
            }
        }
        return offSet;
    }

    private static JSONObject formatToDateAndTime(Long time, TimeZone timeZone) throws JSONException {
        JSONObject result = new JSONObject();
        Map.Entry<String, String> map = ActivityUtil.convertUnixTimeToDateTime(time, timeZone);
        result.put("RAW", (Object)time);
        result.put("TIME", (Object)map.getValue());
        result.put("DATE", (Object)map.getKey());
        return result;
    }
}

