/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.search.historysearch;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class HistorySearchRequest {
    private Long startTime;
    private Long endTime;
    private Integer resultSize;
    private Long lastResultTime;
    private String lastLoadedDoc;
    private Map<Object, Object> fieldCriteria;
    private Boolean isForwardSearch;
    private BoolQueryBuilder customQuery;
    private BoolQueryBuilder collectiveCriteria;
    private BoolQueryBuilder filterCriteria;
    private QueryBuilder ruleCriteria;
    private TimeZone timeZone;

    public HistorySearchRequest(Long startTime, Long endTime, TimeZone timeZone, Integer resultSize, Boolean isForwardSearch, Map<Object, Object> fieldCriteria) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.timeZone = timeZone;
        this.resultSize = resultSize;
        this.isForwardSearch = isForwardSearch;
        this.fieldCriteria = fieldCriteria;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public HistorySearchRequest setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    public Long getEndTime() {
        if (this.endTime <= 0L) {
            return null;
        }
        return this.endTime;
    }

    public HistorySearchRequest setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    public Integer getResultSize() {
        return this.resultSize;
    }

    public HistorySearchRequest setResultSize(Integer resultSize) {
        this.resultSize = resultSize;
        return this;
    }

    public Long getLastResultTime() {
        return this.lastResultTime;
    }

    public HistorySearchRequest setLastResultTime(Long lastResultTime) {
        this.lastResultTime = lastResultTime;
        return this;
    }

    public String getLastLoadedDoc() {
        return this.lastLoadedDoc;
    }

    public HistorySearchRequest setLastLoadedDoc(String lastLoadedDoc) {
        this.lastLoadedDoc = lastLoadedDoc;
        return this;
    }

    public Map<Object, Object> getFieldCriteria() {
        return this.fieldCriteria;
    }

    public HistorySearchRequest setFieldCriteria(Map<Object, Object> fieldCriteria) {
        this.fieldCriteria = fieldCriteria;
        return this;
    }

    public Boolean getIsForwardSearch() {
        return this.isForwardSearch;
    }

    public HistorySearchRequest setIsForwardSearch(Boolean forwardSearch) {
        this.isForwardSearch = forwardSearch;
        return this;
    }

    public BoolQueryBuilder getCustomQuery() {
        return this.customQuery;
    }

    public HistorySearchRequest setCustomQuery(BoolQueryBuilder customQuery) {
        this.customQuery = customQuery;
        return this;
    }

    public BoolQueryBuilder getFinalCriteria() {
        return this.collectiveCriteria;
    }

    public HistorySearchRequest setFilterCriteria(BoolQueryBuilder filterCriteria) {
        this.filterCriteria = filterCriteria;
        return this;
    }

    public HistorySearchRequest setRuleSpecificCriteria(QueryBuilder queryBuilder) {
        this.ruleCriteria = queryBuilder;
        return this;
    }

    public QueryBuilder getRuleCriteria() {
        return this.ruleCriteria;
    }

    public List<SortBuilder> getSort() {
        ArrayList<SortBuilder> sortOptions = new ArrayList<SortBuilder>();
        if (this.getIsForwardSearch().booleanValue()) {
            sortOptions.add((SortBuilder)SortBuilders.fieldSort((String)"TIME").order(SortOrder.ASC));
        } else {
            sortOptions.add((SortBuilder)SortBuilders.fieldSort((String)"TIME").order(SortOrder.DESC));
        }
        return sortOptions;
    }

    public Boolean isScrollSearch() {
        return this.lastResultTime != null && this.lastResultTime.compareTo(-1L) != 0 && this.lastLoadedDoc != null && !this.lastLoadedDoc.isEmpty();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public HistorySearchRequest build() {
        RangeQueryBuilder timeRange = this.getIsForwardSearch() != false && this.isScrollSearch() != false ? QueryBuilders.rangeQuery((String)"TIME").from((Object)this.getLastResultTime()).to((Object)this.getEndTime()) : (this.getIsForwardSearch() == false && this.isScrollSearch() != false ? QueryBuilders.rangeQuery((String)"TIME").from((Object)this.getStartTime()).to((Object)this.getLastResultTime()) : QueryBuilders.rangeQuery((String)"TIME").from((Object)this.getStartTime()).to((Object)this.getEndTime()));
        this.collectiveCriteria = QueryBuilders.boolQuery().must((QueryBuilder)timeRange);
        if (this.getCustomQuery() != null) {
            this.collectiveCriteria.must((QueryBuilder)this.getCustomQuery());
        }
        BoolQueryBuilder fieldCriteria = QueryBuilders.boolQuery();
        for (Map.Entry<Object, Object> entry : this.getFieldCriteria().entrySet()) {
            String field = String.valueOf(entry.getKey());
            Object fieldValue = entry.getValue();
            if (fieldValue == null) continue;
            if (fieldValue instanceof List) {
                BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
                for (Object val : (List)fieldValue) {
                    queryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)val.toString()));
                }
                fieldCriteria.must((QueryBuilder)queryBuilder);
                continue;
            }
            fieldCriteria.must((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)fieldValue));
        }
        if (this.getRuleCriteria() != null) {
            BoolQueryBuilder query = QueryBuilders.boolQuery().should((QueryBuilder)fieldCriteria);
            query.should(this.getRuleCriteria());
            this.collectiveCriteria.must((QueryBuilder)query);
        } else {
            this.collectiveCriteria.must((QueryBuilder)fieldCriteria);
        }
        if (this.filterCriteria != null) {
            this.collectiveCriteria.must((QueryBuilder)this.filterCriteria);
        }
        return this;
    }
}

