/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.search.tablesearch;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.la.TimePack;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.correlation.session.constants.ActivityConstants;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.search.ActivityNoSqlSearch;
import com.manageengine.ela.server.correlation.session.search.NoSqlSearchRequest;
import com.manageengine.ela.server.correlation.session.search.tablesearch.TableSearchRequest;
import com.manageengine.ela.server.correlation.session.search.tablesearch.TableSearchResponse;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityTableSearchHandler {
    private static final LoadingCache<String, TableSearchResponse> CACHE;
    private static final Logger LOGGER;

    public static List<Long> loadHistoryListForQuery(TableSearchRequest searchRequest) throws Exception {
        List<Long> historyList = new ArrayList<Long>();
        boolean isCacheLoaded = false;
        String historyFieldName = ActivityUtil.getProviderIndexFieldName(searchRequest.getProviderID());
        if (CACHE.getIfPresent((Object)searchRequest.getUniqueID()) != null) {
            isCacheLoaded = true;
            TableSearchResponse response = (TableSearchResponse)CACHE.get((Object)searchRequest.getUniqueID());
            if (response.getLoadedCount() >= searchRequest.getLastEntryNeeded()) {
                historyList.addAll(response.getHistoryList(searchRequest.getOffset() - 1, searchRequest.getLimit()));
                LOGGER.log(Level.FINE, "Loading table data from stored cache.");
            } else {
                LOGGER.log(Level.FINE, "Need to fetch data from scroll.");
                try {
                    SearchResponse elasticResponse = ActivityNoSqlSearch.doScroll(response.getScrollID());
                    for (Object hit : elasticResponse.getHits()) {
                        Map source = hit.getSource();
                        historyList.add(Long.parseLong(source.get(historyFieldName).toString()));
                    }
                    response.setScrollID(elasticResponse.getScrollId());
                    response.updateHistoryList(historyList);
                    if (elasticResponse.getHits().getHits().length == 0 && response.getLoadedCount() >= searchRequest.getOffset()) {
                        historyList.addAll(response.getHistoryList(searchRequest.getOffset() - 1));
                    }
                }
                catch (Exception exp) {
                    LOGGER.log(Level.INFO, "Search scroll has been expired. Need to refetch data");
                    isCacheLoaded = false;
                }
            }
        }
        if (!isCacheLoaded) {
            SearchResponse elasticResponse;
            Long startTime = System.currentTimeMillis();
            LOGGER.log(Level.INFO, "No search cache exists. Starting fresh search.");
            NoSqlSearchRequest request = new NoSqlSearchRequest(searchRequest.getStartTime(), searchRequest.getEndTime()).setQuery((QueryBuilder)searchRequest.getQuery()).setSize(searchRequest.getLastEntryNeeded()).setScroll(ActivityNoSqlSearch.getDefaultSearchScroll()).addSort(searchRequest.getSort());
            if (searchRequest.isAggregationEnabled().booleanValue()) {
                request = request.setAggregation((AbstractAggregationBuilder)searchRequest.getHistogramAggregation());
            }
            if ((elasticResponse = ActivityNoSqlSearch.doSearch(request)) != null) {
                Map source;
                for (SearchHit hit : elasticResponse.getHits()) {
                    source = hit.getSource();
                    historyList.add(Long.parseLong(source.get(historyFieldName).toString()));
                }
                if (searchRequest.shouldFetchAll()) {
                    while ((long)elasticResponse.getHits().getHits().length < elasticResponse.getHits().getTotalHits()) {
                        try {
                            elasticResponse = ActivityNoSqlSearch.doScroll(elasticResponse.getScrollId());
                            if (elasticResponse.getHits().getHits().length <= 0) break;
                            for (SearchHit hit : elasticResponse.getHits()) {
                                source = hit.getSource();
                                historyList.add(Long.parseLong(source.get(historyFieldName).toString()));
                            }
                        }
                        catch (Exception exp) {
                            LOGGER.log(Level.INFO, "Error occurred during history list - ALL - {0}", exp);
                        }
                    }
                }
                TableSearchResponse response = new TableSearchResponse().setScrollID(elasticResponse.getScrollId()).setTotalCount(elasticResponse.getHits().getTotalHits()).setHistoryList(historyList);
                if (searchRequest.shouldFetchAll()) {
                    response.setCompositeResult(true);
                } else {
                    response.setCompositeResult(false);
                }
                if (elasticResponse.getAggregations() != null) {
                    response = response.setHistogramData((Histogram)elasticResponse.getAggregations().get("HISTOGRAM"));
                }
                if (historyList.size() > searchRequest.getLimit() && !searchRequest.shouldFetchAll()) {
                    historyList = response.getHistoryList(searchRequest.getOffset() - 1, searchRequest.getLimit());
                }
                CACHE.put((Object)searchRequest.getUniqueID(), (Object)response);
                LOGGER.log(Level.FINE, "Search completed within {0} millis", System.currentTimeMillis() - startTime);
            } else {
                LOGGER.log(Level.WARNING, "Could not fetch elastic search result. Search failed");
            }
        }
        return historyList;
    }

    public static Criteria prepareSearchCriteria(Long providerID, int offset, int limit, String uniqueID, boolean isFiltering, JSONObject searchInfo, String tableName, TimePack timePack) throws BaseStatusCode {
        try {
            long interval = timePack.getEndTimeInLong() - timePack.getStartTimeInLong();
            Criteria primaryCriteria = null;
            Criteria statusCriteria = null;
            Criteria dbFieldCriteria = null;
            if (!searchInfo.has("SEARCH_DATA")) {
                return null;
            }
            JSONArray searchData = searchInfo.getJSONArray("SEARCH_DATA");
            int searchType = searchInfo.optInt("TYPE", 1);
            TableSearchRequest request = new TableSearchRequest().enableRegexSearch().setUniqueID(uniqueID).setOffset(offset).setLimit(limit).setStartTime(timePack.getStartTimeInLong()).setEndTime(timePack.getEndTimeInLong()).setSearchType(searchType).setProviderID(providerID).setAggInterval(interval);
            if (searchType == 3) {
                JSONObject data = (JSONObject)searchData.get(0);
                request.setFilterQueryString(data.getString("QUERY"));
            } else {
                statusCriteria = ActivityTableSearchHandler.findStatusCriteria(searchData, tableName);
                dbFieldCriteria = ActivityTableSearchHandler.prepareDatabaseCriteria(searchData, tableName);
                Map<String, Map.Entry<String, Long>> criteriaMap = ActivityUtil.resolveRequestToMap(searchData);
                request.setFieldCriteria(criteriaMap);
                if (!(criteriaMap.isEmpty() || statusCriteria == null && dbFieldCriteria == null)) {
                    limit = -1;
                }
            }
            if (limit == -1) {
                request.setLimit(10);
                request.setFetchAll(true);
            }
            if (isFiltering) {
                request.setCustomQuery((QueryBuilder)QueryBuilders.existsQuery((String)"ACT_FLAG"));
                request = request.enableAggregation();
            }
            if ((request = request.build()).isSearchRequired()) {
                List<Long> histList = ActivityTableSearchHandler.loadHistoryListForQuery(request);
                primaryCriteria = histList != null && !histList.isEmpty() ? new Criteria(Column.getColumn((String)tableName, (String)"HISTORY_ID"), (Object)histList.toArray(), 8) : new Criteria(Column.getColumn((String)tableName, (String)"HISTORY_ID"), (Object)-1, 0);
            }
            if (searchType != 3) {
                if (statusCriteria != null) {
                    primaryCriteria = primaryCriteria != null ? primaryCriteria.and(statusCriteria) : statusCriteria;
                }
                if (dbFieldCriteria != null) {
                    primaryCriteria = primaryCriteria != null ? primaryCriteria.and(dbFieldCriteria) : dbFieldCriteria;
                }
            }
            return primaryCriteria;
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    private static Criteria findStatusCriteria(JSONArray searchData, String tableName) throws JSONException {
        Criteria criteria = null;
        for (int i = 0; i < searchData.length(); ++i) {
            JSONObject critEntry = searchData.getJSONObject(i);
            String id = critEntry.getString("ID");
            if (!id.trim().equals("ActivityHistory_STATUS")) continue;
            int status = critEntry.getInt("VALUE");
            if (status == ActivityConstants.SEARCH_STATUS_ACTIVE) {
                criteria = new Criteria(Column.getColumn((String)tableName, (String)"STATUS"), (Object)ActivityConstants.STATUS_INITIATED, 0);
                continue;
            }
            if (status != ActivityConstants.SEARCH_STATUS_COMPLETED) continue;
            criteria = new Criteria(Column.getColumn((String)tableName, (String)"STATUS"), (Object)ActivityConstants.STATUS_INITIATED, 1);
        }
        return criteria;
    }

    public static Map<Long, Long> getGraphData(String uniqueID) {
        TableSearchResponse response = (TableSearchResponse)CACHE.getIfPresent((Object)uniqueID);
        if (response == null) {
            return null;
        }
        return response.getHistogramData();
    }

    public static Long getTotalHitCount(String uniqueID, Long defCount, Integer offset) throws NullPointerException {
        TableSearchResponse response = (TableSearchResponse)CACHE.getIfPresent((Object)uniqueID);
        if (response == null) {
            return null;
        }
        if (!response.isCompositeResult().booleanValue() || offset > 1) {
            return response.getTotalCount();
        }
        response.setTotalCount(defCount);
        return defCount;
    }

    private static Criteria prepareDatabaseCriteria(JSONArray searchData, String tableName) throws JSONException, BaseStatusCode {
        Criteria dbFieldCriteria = null;
        for (int i = 0; i < searchData.length(); ++i) {
            JSONObject data;
            Long searchVal;
            JSONObject critEntry = searchData.getJSONObject(i);
            Object value = critEntry.get("VALUE");
            if (!(value instanceof JSONObject) || (searchVal = Long.valueOf((data = (JSONObject)value).getLong("VALUE"))) < 0L) continue;
            ActivityStatus status = ActivityStatus.getStatus(searchVal);
            Criteria criteria = status == ActivityStatus.TERMINATED ? new Criteria(Column.getColumn((String)tableName, (String)"STATUS"), (Object)new Object[]{ActivityStatus.TERMINATED.getValue(), ActivityStatus.BROKEN.getValue(), ActivityStatus.IMPROPER_BREAK.getValue()}, 8) : new Criteria(Column.getColumn((String)tableName, (String)"STATUS"), (Object)searchVal, 0);
            dbFieldCriteria = dbFieldCriteria == null ? criteria : dbFieldCriteria.and(criteria);
        }
        return dbFieldCriteria;
    }

    static {
        LOGGER = Logger.getLogger(ActivityTableSearchHandler.class.getName());
        CACHE = CacheBuilder.newBuilder().expireAfterAccess(300000L, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, TableSearchResponse>(){

            public TableSearchResponse load(String key) {
                return null;
            }
        });
    }
}

