/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.search.tablesearch;

import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.util.StringUtil;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;

public class TableSearchRequest {
    private Map<String, Map.Entry<String, Long>> fieldCriteria;
    private Integer offset;
    private Integer limit;
    private Integer searchType;
    private Long startTime;
    private Boolean enableAggregation;
    private Boolean shouldFetchAll = false;
    private Boolean enableRegexSearch;
    private Long endTime;
    private String uniqueID;
    private String filterQueryString;
    private Long providerID;
    private Long aggInterval;
    private BoolQueryBuilder queryBuilder;
    private QueryBuilder customQuery;
    private SortBuilder sortBuilder;
    private DateHistogramBuilder histogramAggregation;

    TableSearchRequest() {
    }

    public Map<String, Map.Entry<String, Long>> getFieldCriteria() {
        return this.fieldCriteria;
    }

    public TableSearchRequest setFieldCriteria(Map<String, Map.Entry<String, Long>> fieldCriteria) {
        this.fieldCriteria = fieldCriteria;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public TableSearchRequest setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public TableSearchRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public TableSearchRequest setStartTime(Long startTime) {
        this.startTime = startTime;
        return this;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public TableSearchRequest setEndTime(Long endTime) {
        this.endTime = endTime;
        return this;
    }

    public Integer getSearchType() {
        return this.searchType;
    }

    public TableSearchRequest setSearchType(Integer searchType) {
        this.searchType = searchType;
        return this;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public TableSearchRequest setUniqueID(String uniqueID) {
        this.uniqueID = uniqueID;
        return this;
    }

    public BoolQueryBuilder getQuery() {
        return this.queryBuilder;
    }

    public SortBuilder getSort() {
        return this.sortBuilder;
    }

    public Integer getLastEntryNeeded() {
        return this.offset + this.limit - 1;
    }

    public Long getAggInterval() {
        return this.aggInterval;
    }

    public TableSearchRequest setAggInterval(Long aggInterval) {
        this.aggInterval = aggInterval;
        return this;
    }

    public DateHistogramBuilder getHistogramAggregation() {
        return this.histogramAggregation;
    }

    public Boolean isAggregationEnabled() {
        return this.enableAggregation != false && this.histogramAggregation != null;
    }

    public Boolean isRegexSearchEnabled() {
        return this.enableRegexSearch;
    }

    public TableSearchRequest enableRegexSearch() {
        this.enableRegexSearch = true;
        return this;
    }

    public TableSearchRequest enableAggregation() {
        this.enableAggregation = true;
        return this;
    }

    public Long getProviderID() {
        return this.providerID;
    }

    public TableSearchRequest setProviderID(Long providerID) {
        this.providerID = providerID;
        this.enableAggregation = false;
        return this;
    }

    public TableSearchRequest setCustomQuery(QueryBuilder query) {
        this.customQuery = query;
        return this;
    }

    public TableSearchRequest setFetchAll(boolean fetchEverything) {
        this.shouldFetchAll = fetchEverything;
        return this;
    }

    public boolean shouldFetchAll() {
        return this.shouldFetchAll;
    }

    public String getFilterQueryString() {
        return this.filterQueryString;
    }

    public TableSearchRequest setFilterQueryString(String filterQueryString) {
        this.filterQueryString = filterQueryString;
        return this;
    }

    public boolean isSearchRequired() {
        if (this.searchType == 3) {
            return this.filterQueryString != null && !this.filterQueryString.isEmpty();
        }
        return this.fieldCriteria != null && !this.fieldCriteria.isEmpty();
    }

    public TableSearchRequest build() throws BaseStatusCode {
        this.queryBuilder = QueryBuilders.boolQuery();
        if (this.customQuery != null) {
            this.queryBuilder.must(this.customQuery);
        }
        RangeQueryBuilder timeRange = QueryBuilders.rangeQuery((String)"TIME").from((Object)this.getStartTime()).to((Object)this.getEndTime());
        this.queryBuilder.must((QueryBuilder)timeRange);
        if (this.getFieldCriteria() != null) {
            for (Map.Entry<String, Map.Entry<String, Long>> entry : this.fieldCriteria.entrySet()) {
                Map.Entry<String, Long> fieldData = entry.getValue();
                String fieldVal = fieldData.getKey();
                if (this.enableRegexSearch.booleanValue()) {
                    fieldVal = String.format("*%s*", StringUtil.escapeString(fieldVal));
                }
                QueryStringQueryBuilder searchQuery = QueryBuilders.queryStringQuery((String)fieldVal).field(entry.getKey()).allowLeadingWildcard(true).analyzeWildcard(true);
                BoolQueryBuilder fieldCriteria = QueryBuilders.boolQuery().must((QueryBuilder)searchQuery);
                if (fieldData.getValue() != null) {
                    fieldCriteria.must((QueryBuilder)QueryBuilders.matchQuery((String)ActivityUtil.getActionConfigIndexFieldName(this.providerID), (Object)fieldData.getValue()));
                }
                this.queryBuilder.must((QueryBuilder)fieldCriteria);
            }
        } else if (this.getFilterQueryString() != null) {
            this.queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)this.filterQueryString));
        } else {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        this.queryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)ActivityUtil.getProviderIndexFieldName(this.providerID)));
        this.sortBuilder = SortBuilders.fieldSort((String)"TIME").order(SortOrder.DESC);
        if (this.getAggInterval() != null) {
            this.histogramAggregation = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"HISTOGRAM").field("TIME")).interval(this.getResolvedInterval());
        }
        return this;
    }

    private DateHistogramInterval getResolvedInterval() {
        long interval = this.getAggInterval();
        if (interval > 31536000000L) {
            return DateHistogramInterval.MONTH;
        }
        if (interval > 2678400000L) {
            return DateHistogramInterval.WEEK;
        }
        if (interval > 86400000L) {
            return DateHistogramInterval.HOUR;
        }
        if (interval > 3600000L) {
            return DateHistogramInterval.MINUTE;
        }
        return DateHistogramInterval.SECOND;
    }
}

