/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.search.tablesearch;

import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.joda.time.DateTime;

public class TableSearchResponse {
    private Long totalCount;
    private String scrollID;
    private List<Long> historyList;
    private Map<Long, Long> histogramData;
    private Boolean isCompositeResult;

    public Integer getLoadedCount() {
        return this.historyList.size();
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public TableSearchResponse setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
        return this;
    }

    public String getScrollID() {
        return this.scrollID;
    }

    public TableSearchResponse setScrollID(String scrollID) {
        this.scrollID = scrollID;
        return this;
    }

    public List<Long> getHistoryList() {
        return this.historyList;
    }

    public TableSearchResponse setHistoryList(List<Long> historyList) {
        this.historyList = historyList;
        return this;
    }

    public void updateHistoryList(List<Long> newResult) {
        this.historyList.addAll(newResult);
    }

    public Map<Long, Long> getHistogramData() {
        return this.histogramData;
    }

    public Boolean isCompositeResult() {
        return this.isCompositeResult;
    }

    public TableSearchResponse setCompositeResult(Boolean compositeResult) {
        this.isCompositeResult = compositeResult;
        return this;
    }

    public TableSearchResponse setHistogramData(Histogram data) {
        if (this.histogramData == null) {
            this.histogramData = new TreeMap<Long, Long>();
        } else {
            this.histogramData.clear();
        }
        for (Histogram.Bucket bucket : data.getBuckets()) {
            DateTime key = (DateTime)bucket.getKey();
            Long timeVal = key.getMillis();
            Long count = bucket.getDocCount();
            if (count <= 0L) continue;
            this.histogramData.put(timeVal, count);
        }
        return this;
    }

    public List<Long> getHistoryList(Integer start, Integer offset) throws BaseStatusCode {
        try {
            int limit = this.getLoadedCount();
            if (offset >= 0) {
                limit = Math.min(start + offset, this.getLoadedCount());
            }
            return this.historyList.subList(Math.max(0, start), limit);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public List<Long> getHistoryList(Integer start) throws BaseStatusCode {
        try {
            return this.historyList.subList(Math.max(0, start), this.historyList.size());
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }
}

