/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.util;

import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.ProductBundle;
import com.manageengine.ela.server.correlation.common.constants.SyslogSeverityConstants;
import com.manageengine.ela.server.correlation.common.constants.WindowsLogSeverityConstants;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityDataTransformUtil {
    public static JSONObject prepareSeverityObject(WindowsLogSeverityConstants severity) throws JSONException {
        JSONObject severityInfo = new JSONObject();
        severityInfo.put("VALUE", severity.getValue());
        switch (severity) {
            case FAILURE: {
                severityInfo.put("CLASS", (Object)"FAILURE");
                break;
            }
            case ERROR: {
                severityInfo.put("CLASS", (Object)"ERROR");
                break;
            }
            case WARNING: {
                severityInfo.put("CLASS", (Object)"WARNING");
                break;
            }
            default: {
                severityInfo.put("CLASS", (Object)"OTHER");
            }
        }
        return severityInfo;
    }

    public static JSONObject prepareSeverityObject(SyslogSeverityConstants severity) throws JSONException {
        JSONObject severityInfo = new JSONObject();
        severityInfo.put("VALUE", severity.getValue());
        switch (severity) {
            case CRITICAL: 
            case EMERGENCY: {
                severityInfo.put("CLASS", (Object)"FAILURE");
                break;
            }
            case ERROR: {
                severityInfo.put("CLASS", (Object)"ERROR");
                break;
            }
            case WARNING: {
                severityInfo.put("CLASS", (Object)"WARNING");
                break;
            }
            default: {
                severityInfo.put("CLASS", (Object)"OTHER");
            }
        }
        return severityInfo;
    }

    public static JSONObject prepareStatusObject(ActivityStatus status) throws JSONException {
        JSONObject statusResult = new JSONObject();
        String statusMessage = null;
        switch (status) {
            case INITIATED: {
                statusMessage = "ela.session.activity.status.initiated";
                break;
            }
            case TERMINATED: {
                statusMessage = "ela.session.activity.status.terminated";
                break;
            }
            case BROKEN: {
                statusMessage = "ela.session.activity.status.broken";
                break;
            }
            case LOCKED: {
                statusMessage = "ela.session.activity.status.locked";
                break;
            }
            case INTERRUPTED: {
                statusMessage = "ela.session.activity.status.interrupted";
                break;
            }
            case IMPROPER_BREAK: {
                statusMessage = "ela.session.activity.status.imp_broken";
            }
        }
        statusResult.put("STATUS_VALUE", (Object)status.getValue());
        statusResult.put("STATUS_MESSAGE", (Object)ProductBundle.getInstance().getString(ResourceBundleMgr.getInstance().getServerLocale(), statusMessage));
        return statusResult;
    }
}

