/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.session.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.TimePack;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.google.common.collect.ImmutableSet;
import com.manageengine.ela.server.common.database.constants.SearchType;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.common.export.utils.TableScheduleUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.export.ActivityExportSchedule;
import com.manageengine.ela.server.correlation.auditdata.CorrNosqlIndexHandler;
import com.manageengine.ela.server.correlation.common.constants.SyslogSeverityConstants;
import com.manageengine.ela.server.correlation.common.constants.WindowsLogSeverityConstants;
import com.manageengine.ela.server.correlation.common.data.NoSqlSearchFilterHelper;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.session.config.ActivityConfigMapping;
import com.manageengine.ela.server.correlation.session.config.ActivityProfileContainer;
import com.manageengine.ela.server.correlation.session.constants.ActivityConstants;
import com.manageengine.ela.server.correlation.session.constants.ActivityFieldConstants;
import com.manageengine.ela.server.correlation.session.constants.ActivityStatus;
import com.manageengine.ela.server.correlation.session.info.ActivityProviderInfo;
import com.manageengine.ela.server.correlation.session.listener.ActivityBreaker;
import com.manageengine.ela.server.correlation.session.listener.ActivityInitiator;
import com.manageengine.ela.server.correlation.session.listener.ActivityTerminator;
import com.manageengine.ela.server.correlation.session.listener.helper.DefaultListenerHelper;
import com.manageengine.ela.server.correlation.session.listener.helper.ListenerHelper;
import com.manageengine.ela.server.correlation.session.listener.helper.WinListenerHelper;
import com.manageengine.ela.server.correlation.session.search.wrapper.IndexUpdateRequest;
import com.manageengine.ela.server.correlation.util.CorrelationUtil;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivityUtil {
    private static final Logger LOGGER = Logger.getLogger(ActivityUtil.class.getName());

    public static DataObject getCompleteActivityData() throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityMonitorProfile"));
        selectQuery.addJoin(new Join("ActivityMonitorProfile", "ActivityRuleProviders", new String[]{"PROFILE_ID"}, new String[]{"PROFILE_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "CorrRuleInfo", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityBreakerInfo", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityBreakerInfo", "ActivityBreakerFields", new String[]{"BREAKER_ID"}, new String[]{"BREAKER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityInitiatorInfo", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityTerminatorInfo", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityRuleLinkedFields", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"ActivityRuleLinkedFields", (String)"ActivityRuleLinkedFields"), Table.getTable((String)"NoSqlIndexFields", (String)"NoSqlIndexFields_INIT"), new String[]{"INIT_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"ActivityRuleLinkedFields", (String)"ActivityRuleLinkedFields"), Table.getTable((String)"NoSqlIndexFields", (String)"NoSqlIndexFields_TERN"), new String[]{"TERM_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"ActivityBreakerFields", (String)"ActivityBreakerFields"), Table.getTable((String)"NoSqlIndexFields", (String)"NoSqlIndexFields_INIT_BREAK"), new String[]{"INIT_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"ActivityBreakerFields", (String)"ActivityBreakerFields"), Table.getTable((String)"NoSqlIndexFields", (String)"NoSqlIndexFields_BREAK"), new String[]{"BREAKER_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    public static Long getDefaultActivityRuleCategory() throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleCategory"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleCategory", (String)"CATEGORY_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleCategory", (String)"DISPLAY_NAME"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrRuleCategory", (String)"DISPLAY_NAME"), (Object)"ela.correlation.categories.activity.rule.1", 0));
        return (Long)PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).getRow("CorrRuleCategory").get("CATEGORY_ID");
    }

    public static Boolean isEditableActivityProvider(Long providerID) {
        Criteria criteria = new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerID, 0);
        return DBUtil.getCountLong("ActivityRuleProviders", criteria = criteria.and(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"IS_EDITABLE"), (Object)Boolean.TRUE, 0))) > 0L;
    }

    public static DataObject getCompleteActivityProviderData(Long providerID) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(new Table("ActivityRuleProviders"));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityBreakerInfo", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "CorrRuleInfo", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityBreakerInfo", "ActivityBreakerFields", new String[]{"BREAKER_ID"}, new String[]{"BREAKER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityInitiatorInfo", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityTerminatorInfo", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityRuleLinkedFields", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityTableViewConfig", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerID, 0);
        selectQuery.setCriteria(criteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    public static JSONArray getActivityProviderInfo(Long providerID, Locale locale) {
        JSONArray rulesInfo = new JSONArray();
        try {
            List<String> tableList = Arrays.asList("ActivityMonitorProfile", "ActivityRuleProviders");
            Criteria ruleCriteria = null;
            if (providerID != null) {
                ruleCriteria = new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerID, 0);
            }
            DataObject dobj = PersistenceDBUtil.getPersistence().get(tableList, ruleCriteria);
            dobj.sortRows("ActivityMonitorProfile", new SortColumn[]{new SortColumn("ActivityMonitorProfile", "DISPLAY_ORDER", true)});
            dobj.sortRows("ActivityRuleProviders", new SortColumn[]{new SortColumn("ActivityRuleProviders", "DISPLAY_ORDER", true)});
            Iterator profileIterator = dobj.getRows("ActivityMonitorProfile");
            while (profileIterator.hasNext()) {
                String ruleCategory;
                Row profileRow = (Row)profileIterator.next();
                Criteria criteria = new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROFILE_ID"), profileRow.get("PROFILE_ID"), 0).and(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"VISIBILITY"), (Object)true, 0));
                Iterator activityRuleIterator = dobj.getRows("ActivityRuleProviders", criteria);
                String string = ruleCategory = (Boolean)profileRow.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)profileRow.get("DISPLAY_NAME")) : (String)profileRow.get("DISPLAY_NAME");
                if (!activityRuleIterator.hasNext()) continue;
                JSONObject category = new JSONObject();
                category.put("NAME", (Object)ruleCategory);
                JSONArray rules = new JSONArray();
                category.put("HASCHILD", (Object)Boolean.TRUE);
                while (activityRuleIterator.hasNext()) {
                    Row providerRow = (Row)activityRuleIterator.next();
                    String ruleName = (Boolean)providerRow.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)providerRow.get("DISPLAY_NAME")) : (String)providerRow.get("DISPLAY_NAME");
                    JSONObject rule = new JSONObject();
                    rule.put("NAME", (Object)ruleName);
                    rule.put("ID", providerRow.get("PROVIDER_ID"));
                    rule.put("TYPE", 2);
                    int providerType = (Integer)providerRow.get("TYPE");
                    boolean isWinDefault = providerType == 1 || providerType == 2;
                    rule.put("IS_WIN_DEFAULT", isWinDefault);
                    rule.put("IS_SYSTEM_GENERATED", providerRow.get("IS_SYSTEMGENERATED"));
                    rule.put("IS_ENABLED", (Long)providerRow.get("STATUS") > 0L);
                    rules.put((Object)rule);
                }
                category.put("LIST", (Object)rules);
                rulesInfo.put((Object)category);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Exception during fetching provider info = {0}", exp);
        }
        return rulesInfo;
    }

    public static long getProfileIDIfAvailable(String categoryName, Locale locale) throws BaseStatusCode {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityMonitorProfile"));
            Column categoryNameColumn = Column.getColumn((String)"ActivityMonitorProfile", (String)"DISPLAY_NAME");
            Column categoryIDColumn = Column.getColumn((String)"ActivityMonitorProfile", (String)"PROFILE_ID");
            Column conditionColumn = Column.getColumn((String)"ActivityMonitorProfile", (String)"IS_SYSTEMGENERATED", (String)"RULE_CATEGORY_SYS_GEN");
            selectQuery.addSelectColumn(categoryNameColumn);
            selectQuery.addSelectColumn(categoryIDColumn);
            LinkedList<HashMap<Column, Object>> result = DefaultDataSource.getKeyBasedSearchResult(categoryNameColumn, categoryName, (SelectQuery)selectQuery, conditionColumn, locale, 1, 1, SearchType.EQUALS_IGNORE_CASE).getResultList();
            return result.isEmpty() ? -1L : (Long)((HashMap)result.get(0)).get(categoryIDColumn);
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static Object[] decomposeJSONArray(JSONArray array) throws JSONException {
        Object[] objArray = new Object[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            objArray[i] = array.get(i);
        }
        return objArray;
    }

    public static Criteria getTimeBasedCustomTableSuccessCriteria(String tableName, TimePack pack) {
        return ActivityUtil.getTimeBasedCustomTableSuccessCriteria(tableName, pack.getStartTimeInLong(), pack.getEndTimeInLong());
    }

    public static Criteria getTimeBasedCustomTableSuccessCriteria(String tableName, Long startTime, Long endTime) {
        Criteria criteria = null;
        if (startTime != null) {
            criteria = new Criteria(Column.getColumn((String)tableName, (String)"START_TIME"), (Object)startTime, 4);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"START_TIME"), (Object)endTime, 6));
        }
        return criteria;
    }

    public static Criteria getHistoryBeforeTime(String tableName, Long time) {
        Criteria criteria = null;
        if (time != null) {
            criteria = new Criteria(Column.getColumn((String)tableName, (String)"START_TIME"), (Object)time, 6);
        }
        return criteria;
    }

    public static void updateIndexedLog(Map<String, Object> updateMap, String docID, String indexName) {
        try {
            LOGGER.log(Level.FINE, "Updating index for log {0}", docID);
            LogIndexingAPI.updateIndexedRecord((String)indexName, (String)"logs", (String)docID, updateMap);
        }
        catch (Throwable exp) {
            LOGGER.log(Level.WARNING, "Error occurred during index update", exp.getMessage());
        }
    }

    public static JSONArray appendTableName(String tableName, JSONArray jsonArray) throws JSONException {
        JSONArray result = new JSONArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject newObj = new JSONObject();
            JSONObject entry = jsonArray.getJSONObject(i);
            Iterator iterator = entry.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                newObj.put(String.format("%s_%s", tableName, key), (Object)entry.getString(key));
            }
            result.put((Object)newObj);
        }
        return result;
    }

    public static String getDefaultDurationString(Long startTime, Long endTime) {
        if (startTime <= endTime) {
            Long millis = endTime - startTime;
            return ActivityUtil.getDefaultDurationString(millis);
        }
        return "-";
    }

    public static String getDefaultDurationString(Long deltaMillis) {
        Long days = TimeUnit.MILLISECONDS.toDays(deltaMillis);
        Long hours = TimeUnit.MILLISECONDS.toHours(deltaMillis) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(deltaMillis));
        Long minutes = TimeUnit.MILLISECONDS.toMinutes(deltaMillis) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(deltaMillis));
        Long seconds = TimeUnit.MILLISECONDS.toSeconds(deltaMillis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(deltaMillis));
        StringBuilder duration = new StringBuilder();
        if (days > 0L) {
            duration.append(String.format("%d days", days)).append(" : ");
        }
        duration.append(String.format("%02d hrs", hours)).append(" : ").append(String.format("%02d min", minutes)).append(" : ").append(String.format("%02d sec", seconds));
        return duration.toString();
    }

    public static JSONObject getDefaultDuration(Long startTime, Long endTime) throws JSONException {
        JSONObject response = new JSONObject();
        if (endTime == null) {
            Long currentTime = System.currentTimeMillis();
            if (currentTime > startTime) {
                response.put("DURATION", System.currentTimeMillis() - startTime);
            } else {
                response.put("DURATION", (Object)"-");
            }
        } else {
            response.put("DURATION", (Object)ActivityUtil.getDefaultDurationString(startTime, endTime));
        }
        return response;
    }

    public static Set<WindowsLogSeverityConstants> getDefaultSeverities() {
        HashSet<WindowsLogSeverityConstants> list = new HashSet<WindowsLogSeverityConstants>();
        list.add(WindowsLogSeverityConstants.ERROR);
        list.add(WindowsLogSeverityConstants.FAILURE);
        list.add(WindowsLogSeverityConstants.WARNING);
        list.add(WindowsLogSeverityConstants.OTHERS);
        return list;
    }

    public static Map.Entry<String, String> convertUnixTimeToDateTime(Long time, TimeZone timeZone) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy");
        dateFormat.setTimeZone(timeZone);
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        timeFormat.setTimeZone(timeZone);
        Date dateTime = new Date(time);
        return new AbstractMap.SimpleEntry<String, String>(timeFormat.format(dateTime), dateFormat.format(dateTime));
    }

    public static Map<String, Object> getIndexedDoc(Long indexID, String docID, TimePack timePack) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"NoSqlIndexDetails"));
        selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_NAME"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"NoSqlIndexDetails", (String)"INDEX_ID"), (Object)indexID, 0));
        String indexName = (String)PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).getFirstValue("NoSqlIndexDetails", "INDEX_NAME");
        return CorrNosqlIndexHandler.getIndexedDocInfo(indexName, docID, timePack);
    }

    public static Set<WindowsLogSeverityConstants> convertJSONArrayToSeveritySet(JSONArray sArray) throws JSONException, BaseStatusCode {
        HashSet<WindowsLogSeverityConstants> excludedSeverities = new HashSet<WindowsLogSeverityConstants>();
        if (sArray != null) {
            for (int i = 0; i < sArray.length(); ++i) {
                excludedSeverities.add(WindowsLogSeverityConstants.getType(sArray.getInt(i)));
            }
        }
        return excludedSeverities;
    }

    public static Map<String, Map.Entry<String, Long>> resolveRequestToMap(JSONArray array) {
        HashMap<String, Map.Entry<String, Long>> response = new HashMap<String, Map.Entry<String, Long>>();
        try {
            HashMap<Long, AbstractMap.SimpleEntry<String, Long>> fieldVal = new HashMap<Long, AbstractMap.SimpleEntry<String, Long>>();
            for (int i = 0; i < array.length(); ++i) {
                String fieldIndexName;
                JSONObject critEntry = array.getJSONObject(i);
                Object value = critEntry.get("VALUE");
                if (value == null || !(value instanceof String)) continue;
                String val = value.toString();
                String id = critEntry.getString("ID");
                if (val.isEmpty()) continue;
                if (NumberUtils.isNumber((String)id)) {
                    fieldIndexName = ActivityFieldConstants.getResolvedField(ActivityFieldConstants.get(Integer.parseInt(id)));
                    response.put(fieldIndexName, new AbstractMap.SimpleEntry<String, Object>(val, null));
                    continue;
                }
                if (id.contains("_Field")) {
                    String[] data = StringUtils.substringsBetween((String)id, (String)"_", (String)"_");
                    Long fieldKey = Long.parseLong(data[2]);
                    Long actionConfigID = Long.parseLong(data[1]);
                    fieldVal.put(fieldKey, new AbstractMap.SimpleEntry<String, Long>(val, actionConfigID));
                    continue;
                }
                if (!id.contains("_Index")) continue;
                fieldIndexName = id.split("_Index")[0];
                response.put(fieldIndexName, new AbstractMap.SimpleEntry<String, Object>(val, null));
            }
            if (fieldVal.isEmpty()) {
                return response;
            }
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrActionCondnFields"));
            selectQuery.addJoin(new Join("CorrActionCondnFields", "NoSqlIndexFields", new String[]{"CONDN_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_INDEX_NAME"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"FIELD_CONFIG_ID"), (Object)fieldVal.keySet().toArray(), 8));
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("CorrActionCondnFields");
            while (iterator.hasNext()) {
                Row condnField = (Row)iterator.next();
                Long fieldConfigID = (Long)condnField.get("FIELD_CONFIG_ID");
                Row indexField = dataObject.getRow("NoSqlIndexFields", new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), condnField.get("CONDN_FIELD_ID"), 0));
                String fieldIndexName = (String)indexField.get("FIELD_INDEX_NAME");
                response.put(fieldIndexName, (Map.Entry<String, Long>)fieldVal.get(fieldConfigID));
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during field resolving {0}", exp);
        }
        return response;
    }

    public static String getProviderName(Long providerID) throws DataAccessException {
        String providerName = null;
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityRuleProviders"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"DISPLAY_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"IS_SYSTEMGENERATED"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerID, 0));
        DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        Row row = dataObject.getFirstRow("ActivityRuleProviders");
        if (row != null) {
            String name = (String)row.get("DISPLAY_NAME");
            boolean isSystemGen = (Boolean)row.get("IS_SYSTEMGENERATED");
            providerName = isSystemGen ? ProductBundle.getInstance().getString(name) : name;
        }
        return providerName;
    }

    public static BoolQueryBuilder getDefaultWinSearchFilterQuery() {
        Object[] notedEvents = new Object[]{ActivityConstants.EVENT_OBJECT_REQUEST_HANDLE, ActivityConstants.EVENT_OBJECT_HANDLE_CLOSED, ActivityConstants.EVENT_OBJECT_DELETED, ActivityConstants.EVENT_ACTION_PERFORMED_ON_OBJECT, ActivityConstants.EVENT_OBJECT_ACCESS};
        BoolQueryBuilder parent = QueryBuilders.boolQuery();
        BoolQueryBuilder queryBuilder = NoSqlSearchFilterHelper.takeIfExistsAndEquals("EVENTID", notedEvents);
        queryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"ACCESSES"));
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"HOSTTYPE", (String)"windows"));
        queryBuilder.minimumNumberShouldMatch(1);
        parent.should((QueryBuilder)queryBuilder);
        parent.should((QueryBuilder)NoSqlSearchFilterHelper.takeIfExistsAndNotEquals("EVENTID", notedEvents));
        return parent;
    }

    public static BoolQueryBuilder getDefaultUnixSearchFilterQuery() {
        BoolQueryBuilder parent = QueryBuilders.boolQuery();
        parent.must((QueryBuilder)QueryBuilders.termQuery((String)"HOSTTYPE", (String)"unix"));
        return parent;
    }

    public static JSONArray getActivityProfiles(Locale locale) {
        JSONArray profiles = new JSONArray();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityMonitorProfile"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityMonitorProfile", (String)"PROFILE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityMonitorProfile", (String)"DISPLAY_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityMonitorProfile", (String)"IS_SYSTEMGENERATED"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Iterator profileIterator = dobj.getRows("ActivityMonitorProfile");
            while (profileIterator.hasNext()) {
                Row row = (Row)profileIterator.next();
                String profileName = (Boolean)row.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)row.get("DISPLAY_NAME")) : (String)row.get("DISPLAY_NAME");
                JSONObject entry = new JSONObject();
                entry.put("ID", row.get("PROFILE_ID"));
                entry.put("NAME", (Object)profileName);
                profiles.put((Object)entry);
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Exception during getting activity profiles = {0}", exp);
        }
        return profiles;
    }

    public static ActivityProviderInfo getProviderInfoByRuleID(Long ruleID) {
        Long providerID = ActivityConfigMapping.get().getProviderFromRule(ruleID);
        Long profileID = ActivityConfigMapping.get().getProfileID(providerID);
        ActivityProviderInfo providerInfo = ActivityProfileContainer.get().getProviderInfo(profileID, providerID);
        if (providerInfo == null) {
            LOGGER.log(Level.WARNING, "Could not find any matching provider for the given rule {0}", ruleID);
        }
        return providerInfo;
    }

    public static ActivityProviderInfo getProviderInfo(Long providerID) {
        return ActivityProfileContainer.get().getProviderInfo(ActivityConfigMapping.get().getProfileID(providerID), providerID);
    }

    public static ListenerHelper getListener(ActivityProviderInfo providerInfo) {
        if (providerInfo.getType() == 1) {
            return WinListenerHelper.getInstance();
        }
        return DefaultListenerHelper.getInstance();
    }

    public static JSONObject getConfiguredActivityProvider(Long providerID, Locale locale) {
        JSONObject response = new JSONObject();
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityRuleProviders"));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityInitiatorInfo", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityTerminatorInfo", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join("ActivityRuleProviders", "ActivityRuleLinkedFields", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"ActivityRuleLinkedFields", (String)"ActivityRuleLinkedFields"), Table.getTable((String)"NoSqlIndexFields", (String)"NoSqlIndexFields_INIT"), new String[]{"INIT_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
        selectQuery.addJoin(new Join(Table.getTable((String)"ActivityRuleLinkedFields", (String)"ActivityRuleLinkedFields"), Table.getTable((String)"NoSqlIndexFields", (String)"NoSqlIndexFields_TERN"), new String[]{"TERM_FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityInitiatorInfo", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityTerminatorInfo", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleLinkedFields", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields_INIT", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields_TERN", (String)"*"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerID, 0));
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Row providerInfo = dataObject.getFirstRow("ActivityRuleProviders");
            Row initInfo = dataObject.getFirstRow("ActivityInitiatorInfo");
            Row termInfo = dataObject.getFirstRow("ActivityTerminatorInfo");
            Long initRuleID = (Long)initInfo.get("RULE_ID");
            Long termRuleID = (Long)termInfo.get("RULE_ID");
            JSONObject initRuleData = CorrelationUtil.getConfiguredCorrelationRule(initRuleID, locale);
            JSONObject endRuleData = CorrelationUtil.getConfiguredCorrelationRule(termRuleID, locale);
            initRuleData.put("PRIMARY_ACTION_CONFIG_ID", initInfo.get("PRIMARY_ACTIONID"));
            endRuleData.put("PRIMARY_ACTION_CONFIG_ID", termInfo.get("PRIMARY_ACTIONID"));
            JSONObject providerData = new JSONObject();
            JSONObject profileData = new JSONObject();
            profileData.put("ID", providerInfo.get("PROFILE_ID"));
            providerData.put("PROFILE", (Object)profileData);
            boolean isSystemGenerated = (Boolean)providerInfo.get("IS_SYSTEMGENERATED");
            String displayName = isSystemGenerated ? ProductBundle.getInstance().getString(locale, (String)providerInfo.get("DISPLAY_NAME")) : (String)providerInfo.get("DISPLAY_NAME");
            String description = isSystemGenerated ? ProductBundle.getInstance().getString(locale, (String)providerInfo.get("DESCRIPTION")) : (String)providerInfo.get("DESCRIPTION");
            providerData.put("DISPLAY_NAME", (Object)displayName);
            providerData.put("DESCRIPTION", (Object)description);
            providerData.put("PROVIDER_ID", (Object)providerID);
            JSONArray sharedFieldData = new JSONArray();
            Iterator iterator = dataObject.getRows("ActivityRuleLinkedFields");
            while (iterator.hasNext()) {
                Row linkedField = (Row)iterator.next();
                JSONObject entry = new JSONObject();
                Long initFieldID = (Long)linkedField.get("INIT_FIELD_ID");
                Long termFieldID = (Long)linkedField.get("TERM_FIELD_ID");
                entry.put("INIT_FIELD_ID", (Object)initFieldID);
                entry.put("TERM_FIELD_ID", (Object)termFieldID);
                Criteria criteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields_INIT", (String)"FIELD_ID"), (Object)initFieldID, 0);
                String fieldName = (String)dataObject.getValue("NoSqlIndexFields_INIT", "FIELD_DISPLAY_NAME", criteria);
                entry.put("INIT_FIELD_NAME", (Object)ProductBundle.getInstance().getString(locale, fieldName));
                criteria = new Criteria(Column.getColumn((String)"NoSqlIndexFields_TERN", (String)"FIELD_ID"), (Object)termFieldID, 0);
                fieldName = (String)dataObject.getValue("NoSqlIndexFields_TERN", "FIELD_DISPLAY_NAME", criteria);
                entry.put("TERM_FIELD_NAME", (Object)ProductBundle.getInstance().getString(locale, fieldName));
                sharedFieldData.put((Object)entry);
            }
            response.put("INITIATOR", (Object)initRuleData);
            response.put("TERMINATOR", (Object)endRuleData);
            response.put("SHARED_FIELDS", (Object)sharedFieldData);
            response.put("PROVIDER_INFO", (Object)providerData);
        }
        catch (Exception exp) {
            LOGGER.log(Level.FINE, "Exception during fetching activity provider data = {0}", exp);
        }
        return response;
    }

    public static Set<Long> getActEnabledRules() {
        HashSet<Long> activityDepRules = new HashSet<Long>();
        activityDepRules.addAll(ActivityInitiator.getEnabledRuleSet());
        activityDepRules.addAll(ActivityTerminator.getEnabledRuleSet());
        activityDepRules.addAll(ActivityBreaker.getEnabledRuleSet());
        return activityDepRules;
    }

    public static void addUpdateSchedule(JSONObject request, Long userID, Locale locale) throws BaseStatusCode {
        try {
            String exportHandlerClass = ActivityExportSchedule.class.getCanonicalName();
            if (request.getString("OPERATION").equals("CREATE")) {
                Long providerID = request.getLong("PROVIDER_ID");
                ActivityProviderInfo providerInfo = ActivityUtil.getProviderInfo(providerID);
                if (providerInfo == null) {
                    throw BaseStatusCode.getBaseStatusCode(16385);
                }
                Long ruleID = providerInfo.getRuleID();
                Long exportID = CorrelationUtil.configureSchedule(request, userID, 2, ruleID, exportHandlerClass, locale);
                TableScheduleUtil.addScheduleCriteria(exportID, request);
            } else {
                Long exportID = CorrelationUtil.configureSchedule(request, userID, 2, null, exportHandlerClass, locale);
                TableScheduleUtil.addScheduleCriteria(exportID, request);
            }
        }
        catch (BaseStatusCode bsc) {
            throw bsc;
        }
        catch (Exception exp) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static String getProviderIndexFieldName(Long providerID) {
        return String.format("ACTDATA_%d", providerID);
    }

    public static String getActionConfigIndexFieldName(Long providerID) {
        return String.format("ACTION_%d", providerID);
    }

    public static Map<String, Object> getDefaultIndexUpdateData(IndexUpdateRequest updateRequest) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(ActivityUtil.getProviderIndexFieldName(updateRequest.getProviderID()), updateRequest.getHistoryID());
        paramMap.put(ActivityUtil.getActionConfigIndexFieldName(updateRequest.getProviderID()), updateRequest.getActionConfigID());
        return paramMap;
    }

    public static Map<String, Object> getDefaultIndexUpdateData(Long providerID, Long histID, Long actionConfigID) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(ActivityUtil.getProviderIndexFieldName(providerID), histID);
        paramMap.put(ActivityUtil.getActionConfigIndexFieldName(providerID), actionConfigID);
        return paramMap;
    }

    public static void updateNoSqlRecords(List<IndexUpdateRequest> updateRequests) {
        for (IndexUpdateRequest updateRequest : updateRequests) {
            ActivityUtil.updateIndexedLog(updateRequest.fetchIndexFields(), updateRequest.getDocID(), updateRequest.getIndexName());
        }
    }

    public static boolean isPMPConfigured() throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"FormatDetails"));
        selectQuery.addJoin(new Join("FormatDetails", "AppResources", new String[]{"FORMATID"}, new String[]{"FORMATID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"FORMATID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"AppResources", (String)"FORMATID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"AppResources", (String)"APPID"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)"PMP", 0));
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).containsTable("AppResources");
    }

    public static Integer[] getEnabledRuleTypes() throws DataAccessException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(0);
        list.add(1);
        if (ActivityUtil.isPMPConfigured()) {
            list.add(2);
        }
        return list.toArray(new Integer[list.size()]);
    }

    public static void enablePMPRules() {
        try {
            LOGGER.log(Level.FINE, "Enabling activity rules for PMP");
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"TYPE"), (Object)2, 0).and(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"VISIBILITY"), (Object)false, 0));
            UpdateQueryImpl updateQuery = new UpdateQueryImpl("ActivityRuleProviders");
            updateQuery.setUpdateColumn("VISIBILITY", (Object)true);
            updateQuery.setCriteria(criteria);
            PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQuery);
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during enabling PMP specific rules.");
        }
    }

    public static String getProviderNameFromRule(Long ruleID) throws DataAccessException {
        String providerName = null;
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityRuleProviders"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"DISPLAY_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"IS_SYSTEMGENERATED"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"RULE_ID"), (Object)ruleID, 0));
        DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        Row row = dataObject.getFirstRow("ActivityRuleProviders");
        if (row != null) {
            String name = (String)row.get("DISPLAY_NAME");
            boolean isSystemGen = (Boolean)row.get("IS_SYSTEMGENERATED");
            providerName = isSystemGen ? ProductBundle.getInstance().getString(name) : name;
        }
        return providerName;
    }

    public static CorrelationStatus getProviderStatus(Long providerID) throws DataAccessException {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityRuleProviders"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"STATUS"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerID, 0));
            Long status = (Long)PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).getFirstValue("ActivityRuleProviders", "STATUS");
            return CorrelationStatus.getStatus(status);
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during resolving activity status for provider {0}. Exception = {1}", new Object[]{providerID, exp});
            return CorrelationStatus.ENABLE;
        }
    }

    public static String getLinkedLogonID(Long historyID) {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"WinActivityLinkInfo"));
        selectQuery.addSelectColumn(Column.getColumn((String)"WinActivityLinkInfo", (String)"*"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"WinActivityLinkInfo", (String)"PRIMARY_HISTORY_ID"), (Object)historyID, 0));
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            if (dataObject.containsTable("WinActivityLinkInfo")) {
                Row row = dataObject.getFirstRow("WinActivityLinkInfo");
                return (String)row.get("SEC_LOGON_ID");
            }
        }
        catch (DataAccessException exp) {
            LOGGER.log(Level.FINE, "Error occurred during preparing rule criteria {0}", exp.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, JSONObject> getOverviewData(TimePack time, Range range, Locale locale, boolean sortAscending) {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ActivityHistory"));
        query.addJoin(new Join("ActivityHistory", "ActivityRuleProviders", new String[]{"PROVIDER_ID"}, new String[]{"PROVIDER_ID"}, 1));
        Column countColumn = Column.getColumn((String)"ActivityHistory", (String)"HISTORY_ID").count();
        countColumn.setColumnAlias("ACTIVITY_COUNT");
        query.addSelectColumn(countColumn);
        query.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"PROVIDER_ID"));
        query.setGroupByClause(new GroupByClause(Collections.singletonList(Column.getColumn((String)"ActivityHistory", (String)"PROVIDER_ID"))));
        query.addSortColumn(new SortColumn(countColumn, sortAscending));
        Criteria criteria = ActivityUtil.getTimeBasedCustomTableSuccessCriteria("ActivityHistory", time);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"ActivityHistory", (String)"IS_PRIMARY"), (Object)true, 0));
        query.setCriteria(criteria);
        query.setRange(range);
        Connection connection = null;
        DataSet dataSet = null;
        LinkedHashMap<Long, JSONObject> overviewData = new LinkedHashMap<Long, JSONObject>();
        try {
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)query, connection);
            while (dataSet.next()) {
                JSONObject obj2 = new JSONObject().put("HITS", dataSet.getValue(1));
                overviewData.put((Long)dataSet.getValue(2), obj2);
            }
        }
        catch (Exception exp) {
            try {
                LOGGER.log(Level.INFO, "Exception during fetching activity overview data= {0}", exp.getMessage());
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetOrDataSet(null, dataSet);
                DBUtil.closeStmtAndConnection(null, connection);
                throw throwable;
            }
            DBUtil.closeResultSetOrDataSet(null, dataSet);
            DBUtil.closeStmtAndConnection(null, connection);
        }
        DBUtil.closeResultSetOrDataSet(null, dataSet);
        DBUtil.closeStmtAndConnection(null, connection);
        try {
            query = new SelectQueryImpl(Table.getTable((String)"ActivityRuleProviders"));
            query.setCriteria(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)overviewData.keySet().toArray(), 8));
            query.addJoin(new Join("ActivityRuleProviders", "ActivityMonitorProfile", new String[]{"PROFILE_ID"}, new String[]{"PROFILE_ID"}, 1));
            query.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"));
            query.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"PROFILE_ID"));
            query.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"DISPLAY_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"IS_SYSTEMGENERATED"));
            query.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"TYPE"));
            query.addSelectColumn(Column.getColumn((String)"ActivityMonitorProfile", (String)"PROFILE_ID"));
            query.addSelectColumn(Column.getColumn((String)"ActivityMonitorProfile", (String)"DISPLAY_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ActivityMonitorProfile", (String)"IS_SYSTEMGENERATED"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            overviewData.forEach((providerID, obj) -> {
                try {
                    Row row = dobj.getRow("ActivityRuleProviders", new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), providerID, 0));
                    if (row != null) {
                        int type = (Integer)row.get("TYPE");
                        boolean isSystemGenerated = (Boolean)row.get("IS_SYSTEMGENERATED");
                        String ruleName = isSystemGenerated ? ProductBundle.getInstance().getString(locale, (String)row.get("DISPLAY_NAME")) : (String)row.get("DISPLAY_NAME");
                        row = dobj.getRow("ActivityMonitorProfile", new Criteria(Column.getColumn((String)"ActivityMonitorProfile", (String)"PROFILE_ID"), row.get("PROFILE_ID"), 0));
                        String categoryName = (Boolean)row.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)row.get("DISPLAY_NAME")) : (String)row.get("DISPLAY_NAME");
                        obj.put("RULE_NAME", (Object)ruleName);
                        obj.put("CATEGORY_NAME", (Object)categoryName);
                        obj.put("IS_SYSTEMGENERATED", isSystemGenerated);
                        obj.put("IS_WINDOWS_DEFAULT", type == 1 || type == 2);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Exception during fetching activity overview data= {0}", ex);
                }
            });
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Exception during fetching activity overview data= {0}", exp.getMessage());
        }
        return overviewData;
    }

    public static long getActivityOverviewTotalCount(TimePack time) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ActivityHistory"));
        Criteria criteria = ActivityUtil.getTimeBasedCustomTableSuccessCriteria("ActivityHistory", time);
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn((String)"ActivityHistory", (String)"PROVIDER_ID").distinct().count());
        return DBUtil.getTotalCountDirect((SelectQuery)query);
    }

    public static Set<SyslogSeverityConstants> getUnixSeverityFromWinSeverity(WindowsLogSeverityConstants sev) {
        switch (sev) {
            case ERROR: {
                return ImmutableSet.of((Object)((Object)SyslogSeverityConstants.ERROR));
            }
            case WARNING: {
                return ImmutableSet.of((Object)((Object)SyslogSeverityConstants.WARNING));
            }
            case FAILURE: {
                return ImmutableSet.of((Object)((Object)SyslogSeverityConstants.ALERT));
            }
        }
        return ImmutableSet.of((Object)((Object)SyslogSeverityConstants.OTHERS));
    }

    public static void updateActiveSessionsToInterrupted(Long[] providerIDs) {
        try {
            UpdateQueryImpl updateQuery = new UpdateQueryImpl("ActivityHistory");
            Criteria criteria = new Criteria(Column.getColumn((String)"ActivityHistory", (String)"PROVIDER_ID"), (Object)providerIDs, 8).and(new Criteria(Column.getColumn((String)"ActivityHistory", (String)"STATUS"), (Object)new long[]{ActivityStatus.INITIATED.getValue(), ActivityStatus.LOCKED.getValue()}, 8));
            updateQuery.setCriteria(criteria);
            updateQuery.setUpdateColumn("STATUS", (Object)ActivityStatus.INTERRUPTED.getValue());
            PersistenceDBUtil.getPersistence().update((UpdateQuery)updateQuery);
        }
        catch (DataAccessException exp) {
            LOGGER.log(Level.WARNING, "Error occurred during updating session status to interrupted {0}", exp.getMessage());
        }
    }

    public static ActivityFieldConstants getOmitField(String uniqueID) {
        ActivityFieldConstants omitField = null;
        try {
            String regex = "FIELD_(\\d+)";
            Matcher matcher = Pattern.compile(regex).matcher(uniqueID);
            if (matcher.find()) {
                omitField = ActivityFieldConstants.get(Integer.parseInt(matcher.group(1)));
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Invalid table unique-id {0}", uniqueID);
        }
        return omitField;
    }

    public static boolean shouldOmitField(ActivityFieldConstants omitField, String displayName) {
        if (omitField == null || displayName == null) {
            return false;
        }
        if (omitField == ActivityFieldConstants.USERNAME && displayName.equals(ActivityFieldConstants.getDisplayName(ActivityFieldConstants.USERNAME))) {
            return true;
        }
        return omitField == ActivityFieldConstants.HOSTNAME && displayName.equals(ActivityFieldConstants.getDisplayName(ActivityFieldConstants.HOSTNAME));
    }

    public static Long getRuleIDForProvider(Long providerID) {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityRuleProviders"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"RULE_ID"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"), (Object)providerID, 0));
            return (Long)PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).getFirstValue("ActivityRuleProviders", "RULE_ID");
        }
        catch (Exception exp) {
            LOGGER.log(Level.INFO, "Error occurred during resolving provider id to rule id {0}", exp.getMessage());
            return null;
        }
    }

    public static String getActivityNameForRequest(JSONObject request) throws JSONException, DataAccessException {
        Long providerID = request.getLong("PROVIDER_ID");
        String providerName = ActivityUtil.getProviderName(providerID);
        try {
            ActivityFieldConstants field = null;
            if (request.has("CUSTOM_STRUCTURE") && request.getJSONObject("CUSTOM_STRUCTURE").has("UNIQUE_ID")) {
                field = ActivityUtil.getOmitField(request.getJSONObject("CUSTOM_STRUCTURE").getString("UNIQUE_ID"));
            }
            String fieldDisplayName = null;
            if (field == null) {
                return providerName;
            }
            if (field == ActivityFieldConstants.USERNAME) {
                fieldDisplayName = ProductBundle.getInstance().getString(ResourceBundleMgr.getInstance().getServerLocale(), ActivityFieldConstants.getDisplayName(ActivityFieldConstants.USERNAME));
            } else if (field == ActivityFieldConstants.HOSTNAME) {
                fieldDisplayName = ProductBundle.getInstance().getString(ResourceBundleMgr.getInstance().getServerLocale(), ActivityFieldConstants.getDisplayName(ActivityFieldConstants.HOSTNAME));
            } else {
                return providerName;
            }
            JSONArray jsonArray = request.getJSONObject("SEARCH_DATA").getJSONArray("SEARCH_DATA");
            for (int i = 0; i < jsonArray.length(); ++i) {
                int parsedID;
                JSONObject searchEntry = jsonArray.getJSONObject(i);
                String id = searchEntry.getString("ID");
                if (!StringUtils.isNumeric((CharSequence)id) || (parsedID = Integer.parseInt(id)) != field.getValue()) continue;
                String val = searchEntry.getString("VALUE");
                providerName = String.format("%s \n(%s:%s)", providerName, fieldDisplayName, val);
                return providerName;
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Error occurred during processing export request", exp.getMessage());
        }
        return providerName;
    }

    public static boolean isRuleNameAlreadyUsed(String ruleName, Locale locale) {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ActivityRuleProviders"));
            Column ruleNameColumn = Column.getColumn((String)"ActivityRuleProviders", (String)"DISPLAY_NAME");
            Column conditionColumn = Column.getColumn((String)"ActivityRuleProviders", (String)"IS_SYSTEMGENERATED", (String)"RULE_SYS_GEN");
            selectQuery.addSelectColumn(ruleNameColumn);
            selectQuery.addSelectColumn(Column.getColumn((String)"ActivityRuleProviders", (String)"PROVIDER_ID"));
            return !DefaultDataSource.getKeyBasedSearchResult(ruleNameColumn, ruleName.trim(), (SelectQuery)selectQuery, conditionColumn, locale, 1, 1, SearchType.EQUALS_IGNORE_CASE).isEmpty();
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, "Exception occurred {0}", exp.getMessage());
            return false;
        }
    }
}

