/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.correlation.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Operation;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.TimePack;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.common.database.constants.SearchType;
import com.manageengine.ela.server.common.delegation.DelegationRoleContainer;
import com.manageengine.ela.server.common.ember.datasource.DefaultDataSource;
import com.manageengine.ela.server.common.export.utils.TableExportUtil;
import com.manageengine.ela.server.common.export.utils.TableScheduleUtil;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.criteria.ScheduleCriteria;
import com.manageengine.ela.server.common.schedule.export.CorrelationExportSchedule;
import com.manageengine.ela.server.common.util.JSONUtil;
import com.manageengine.ela.server.correlation.common.constants.SharedConstants;
import com.manageengine.ela.server.correlation.core.constants.CorrelationStatus;
import com.manageengine.ela.server.correlation.session.util.ActivityUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CorrelationUtil {
    public static final long DEFAULT_CORR_TYPE = -1001L;
    public static final long DEFAULT_CORR_RULE_NOTIF_TYPE = -1002L;
    public static final long ACTIVITY_CORR_RULE_NOTIF_TYPE = -1003L;
    public static final String CORR_ACCESS_STATUS = "CORR_ACCESS";
    private static final Logger LOGGER = Logger.getLogger(CorrelationUtil.class.getName());
    public static final String ME_APP_OPM_SYSCONFIG = "MEApp_OPM";
    public static final String ME_APP_PMP_SYSCONFIG = "MEApp_PMP";
    public static final String ME_APP_OPM = "OPM";
    public static final String ME_APP_PMP = "PMP";

    public static JSONArray getCorrelationRuleCategories(Locale locale) {
        JSONArray ruleCategories = new JSONArray();
        try {
            DataObject dobj = PersistenceDBUtil.getPersistence().get("CorrRuleCategory", new Criteria(Column.getColumn((String)"CorrRuleCategory", (String)"IS_ENABLED"), (Object)true, 0));
            Iterator categoryItr = dobj.getRows("CorrRuleCategory");
            while (categoryItr.hasNext()) {
                Row row = (Row)categoryItr.next();
                String categoryName = (Boolean)row.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)row.get("DISPLAY_NAME")) : (String)row.get("DISPLAY_NAME");
                JSONObject category = new JSONObject();
                category.put("ID", (Object)row.get("CATEGORY_ID").toString());
                category.put("NAME", (Object)categoryName);
                ruleCategories.put((Object)category);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return ruleCategories;
    }

    public static Criteria getTimeBasedCustomTableSuccessCriteria(String tableName, TimePack pack) {
        return CorrelationUtil.getTimeBasedCustomTableSuccessCriteria(tableName, pack.getStartTimeInLong(), pack.getEndTimeInLong());
    }

    public static Criteria getTimeBasedCustomTableSuccessCriteria(String tableName, Long startTime, Long endTime) {
        Criteria criteria = null;
        if (startTime != null) {
            criteria = new Criteria(Column.getColumn((String)tableName, (String)"START_TIME"), (Object)startTime, 5);
        }
        if (endTime != null) {
            criteria = criteria == null ? new Criteria(Column.getColumn((String)tableName, (String)"END_TIME"), (Object)endTime, 6) : criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"END_TIME"), (Object)endTime, 6));
        }
        return criteria;
    }

    public static boolean checkIfRuleAvailable(String ruleName, Locale locale) throws Exception {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
        Column ruleNameColumn = Column.getColumn((String)"CorrRuleInfo", (String)"RULE_DISPLAY_NAME");
        Column conditionColumn = Column.getColumn((String)"CorrRuleInfo", (String)"IS_SYSTEMGENERATED", (String)"RULE_SYS_GEN");
        selectQuery.addSelectColumn(ruleNameColumn);
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
        return !DefaultDataSource.getKeyBasedSearchResult(ruleNameColumn, ruleName, (SelectQuery)selectQuery, conditionColumn, locale, 1, 1, SearchType.EQUALS_IGNORE_CASE).isEmpty();
    }

    public static long getCategoryIDIfAvailable(String categoryName, Locale locale) throws Exception {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleCategory"));
        Column categoryNameColumn = Column.getColumn((String)"CorrRuleCategory", (String)"DISPLAY_NAME");
        Column categoryIDColumn = Column.getColumn((String)"CorrRuleCategory", (String)"CATEGORY_ID");
        Column conditionColumn = Column.getColumn((String)"CorrRuleCategory", (String)"IS_SYSTEMGENERATED", (String)"RULE_CATEGORY_SYS_GEN");
        selectQuery.addSelectColumn(categoryNameColumn);
        selectQuery.addSelectColumn(categoryIDColumn);
        LinkedList<HashMap<Column, Object>> result = DefaultDataSource.getKeyBasedSearchResult(categoryNameColumn, categoryName, (SelectQuery)selectQuery, conditionColumn, locale, 1, 1, SearchType.EQUALS_IGNORE_CASE).getResultList();
        return result.isEmpty() ? -1L : (Long)((HashMap)result.get(0)).get(categoryIDColumn);
    }

    @Deprecated
    public static long getCorrelationOverviewTotalCount(TimePack time) throws Exception {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrRuleSuccessHistory"));
        query.addJoin(new Join("CorrRuleSuccessHistory", "CorrRuleInfo", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 2));
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"REPORT_ENABLED"), (Object)true, 0);
        criteria = criteria.and(CorrelationUtil.getTimeBasedCustomTableSuccessCriteria("CorrRuleSuccessHistory", time));
        query.setCriteria(criteria);
        query.addSelectColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"RULE_ID").distinct().count());
        long corrCount = DBUtil.getTotalCountDirect((SelectQuery)query);
        return corrCount + ActivityUtil.getActivityOverviewTotalCount(time);
    }

    public static JSONArray getCorrelationRuleInfo(Long ruleID, Locale locale) {
        JSONArray rulesInfo = new JSONArray();
        try {
            List<String> tableList = Arrays.asList("CorrRuleCategory", "CorrRuleInfo");
            Criteria ruleCriteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"TYPE"), (Object)1, 0);
            if (ruleID != null) {
                ruleCriteria.and(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 0));
            }
            DataObject dobj = PersistenceDBUtil.getPersistence().get(tableList, ruleCriteria);
            dobj.sortRows("CorrRuleCategory", new SortColumn[]{new SortColumn("CorrRuleCategory", "CATEGORY_ORDER", true)});
            dobj.sortRows("CorrRuleInfo", new SortColumn[]{new SortColumn("CorrRuleInfo", "DISPLAY_ORDER", true)});
            Iterator categoryItr = dobj.getRows("CorrRuleCategory");
            String[] omittedRules = CorrelationUtil.getOmitedRules();
            while (categoryItr.hasNext()) {
                String ruleCategory;
                Row row = (Row)categoryItr.next();
                Criteria criteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"CATEGORY_ID"), row.get("CATEGORY_ID"), 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"REPORT_ENABLED"), (Object)true, 0));
                criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)omittedRules, 9));
                Iterator ruleItr = dobj.getRows("CorrRuleInfo", criteria);
                String string = ruleCategory = (Boolean)row.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)row.get("DISPLAY_NAME")) : (String)row.get("DISPLAY_NAME");
                if (!ruleItr.hasNext()) continue;
                JSONObject category = new JSONObject();
                category.put("NAME", (Object)ruleCategory);
                JSONArray rules = new JSONArray();
                category.put("HASCHILD", (Object)Boolean.TRUE);
                while (ruleItr.hasNext()) {
                    Row innerRow = (Row)ruleItr.next();
                    String ruleName = (Boolean)innerRow.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)innerRow.get("RULE_DISPLAY_NAME")) : (String)innerRow.get("RULE_DISPLAY_NAME");
                    JSONObject rule = new JSONObject();
                    rule.put("NAME", (Object)ruleName);
                    rule.put("ID", innerRow.get("RULE_ID"));
                    rule.put("TYPE", 1);
                    rules.put((Object)rule);
                }
                category.put("LIST", (Object)rules);
                rulesInfo.put((Object)category);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return rulesInfo;
    }

    public static String[] getOmitedRules() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
            query.addJoin(new Join("CorrRuleInfo", "CorrConfiguredActions", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 2));
            query.addJoin(new Join("CorrConfiguredActions", "CorrActionInfo", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
            query.addJoin(new Join("CorrActionInfo", "CorrActionCategory", new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 2));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrActionCategory", (String)"CATEGORY_ID"), (Object)CorrelationUtil.getDisabledActionCategories(), 8);
            query.setCriteria(criteria);
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            ArrayList<String> ruleList = new ArrayList<String>();
            Iterator iterator = dObj.getRows("CorrRuleInfo");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                ruleList.add(row.get("RULE_ID").toString());
            }
            return JSONUtil.listToStringArray(ruleList);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return new String[0];
        }
    }

    public static String[] getDisabledActionCategories() {
        try {
            ArrayList<String> excludingApps = new ArrayList<String>();
            String meAppOpmStatus = (String)CommonUtil.getSysConfiguration(ME_APP_OPM_SYSCONFIG);
            String meAppPmpStatus = (String)CommonUtil.getSysConfiguration(ME_APP_PMP_SYSCONFIG);
            if (!Boolean.valueOf(meAppOpmStatus).booleanValue()) {
                excludingApps.add(ME_APP_OPM);
            }
            if (!Boolean.valueOf(meAppPmpStatus).booleanValue()) {
                excludingApps.add(ME_APP_PMP);
            }
            if (excludingApps.size() > 0) {
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrActionCategory"));
                query.addJoin(new Join("CorrActionCategory", "FormatDetails", new String[]{"FORMAT_ID"}, new String[]{"FORMATID"}, 2));
                query.addSelectColumn(Column.getColumn((String)"CorrActionCategory", (String)"CATEGORY_ID"));
                query.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"FORMATID"));
                query.setCriteria(new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)JSONUtil.listToStringArray(excludingApps), 8));
                DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
                ArrayList<String> categoryList = new ArrayList<String>();
                Iterator iterator = dObj.getRows("CorrActionCategory");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    categoryList.add(row.get("CATEGORY_ID").toString());
                }
                return JSONUtil.listToStringArray(categoryList);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return new String[0];
    }

    public static String[] getOmitedAlertProfiles() {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrNotificationMapping", (String)"RULE_ID"), (Object)CorrelationUtil.getOmitedRules(), 8);
            DataObject dObj = PersistenceDBUtil.getPersistence().get("CorrNotificationMapping", criteria);
            ArrayList<String> ruleList = new ArrayList<String>();
            Iterator iterator = dObj.getRows("CorrNotificationMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                ruleList.add(row.get("NOTIFID").toString());
            }
            return JSONUtil.listToStringArray(ruleList);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return new String[0];
        }
    }

    public static JSONArray getCorrelationActionList(Locale locale) throws BaseStatusCode {
        JSONArray actionInfo = new JSONArray();
        try {
            List<String> tableList = Arrays.asList("CorrActionCategory", "CorrActionInfo");
            Criteria actionSelectionCriteria = new Criteria(Column.getColumn((String)"CorrActionCategory", (String)"TYPE"), (Object)SharedConstants.COMMON_CORR_ACTION, 0);
            DataObject dobj = PersistenceDBUtil.getPersistence().get(tableList, actionSelectionCriteria);
            dobj.sortRows("CorrActionCategory", new SortColumn[]{new SortColumn("CorrActionCategory", "CATEGORY_ORDER", true)});
            dobj.sortRows("CorrActionInfo", new SortColumn[]{new SortColumn("CorrActionInfo", "ACTION_ORDER", true)});
            Iterator itr = dobj.getRows("CorrActionCategory", new Criteria(Column.getColumn((String)"CorrActionCategory", (String)"CATEGORY_ID"), (Object)CorrelationUtil.getDisabledActionCategories(), 9));
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                JSONObject category = new JSONObject();
                String categoryName = (Boolean)row.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)row.get("DISPLAY_NAME")) : (String)row.get("DISPLAY_NAME");
                category.put("NAME", (Object)categoryName);
                Criteria criteria = new Criteria(Column.getColumn((String)"CorrActionInfo", (String)"CATEGORY_ID"), row.get("CATEGORY_ID"), 0);
                Iterator innerItr = dobj.getRows("CorrActionInfo", criteria);
                if (innerItr.hasNext()) {
                    JSONArray actions = new JSONArray();
                    category.put("HASCHILD", (Object)Boolean.TRUE);
                    category.put("NAME", (Object)categoryName);
                    while (innerItr.hasNext()) {
                        Row innerRow = (Row)innerItr.next();
                        String actionName = (Boolean)innerRow.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)innerRow.get("DISPLAY_NAME")) : (String)innerRow.get("DISPLAY_NAME");
                        JSONObject action = new JSONObject();
                        action.put("NAME", (Object)actionName);
                        action.put("ID", innerRow.get("ACTION_ID"));
                        actions.put((Object)action);
                    }
                    category.put("LIST", (Object)actions);
                }
                actionInfo.put((Object)category);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return actionInfo;
    }

    public static JSONObject getActionProperties(Long actionID, Locale locale) throws BaseStatusCode {
        JSONObject actionProperties = new JSONObject();
        try {
            JSONArray fields = new JSONArray();
            List<String> tableList = Arrays.asList("CorrActionInfo", "CorrActionCondnFields", "NoSqlIndexFields", "NoSqlIndexCriteria", "NoSqlIndexCriteriaFields");
            Criteria actionCriteria = new Criteria(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID"), (Object)actionID, 0);
            DataObject dobj = PersistenceDBUtil.getPersistence().get(tableList, actionCriteria);
            Row actionRow = dobj.getFirstRow("CorrActionInfo");
            actionProperties.put("NAME", (Object)ProductBundle.getInstance().getString(locale, actionRow.get("DISPLAY_NAME").toString()));
            actionProperties.put("DESCRIPTION", (Object)ProductBundle.getInstance().getString(locale, actionRow.get("DESCRIPTION").toString()));
            Iterator subInnerIter = dobj.getRows("CorrActionCondnFields");
            while (subInnerIter.hasNext()) {
                Row subRow = (Row)subInnerIter.next();
                JSONObject field = new JSONObject();
                dobj.sortRows("NoSqlIndexCriteria", new SortColumn[]{new SortColumn("NoSqlIndexCriteria", "CRITERIA_ORDER", true)});
                Iterator conditionRow = dobj.getRows("NoSqlIndexCriteria", new Criteria(Column.getColumn((String)"NoSqlIndexCriteriaFields", (String)"FIELD_ID"), subRow.get("CONDN_FIELD_ID"), 0));
                JSONArray fieldCondition = CorrelationUtil.getFieldCondition(conditionRow, subRow.get("CONDN_FIELD_ID"));
                field.put("ID", subRow.get("CONDN_FIELD_ID"));
                field.put("IS_SHARE_ALLOWED", subRow.get("SHAREDACTION_ALLOWED"));
                field.put("IS_UNIQUE_ALLOWED", subRow.get("UNIQUEACTION_ALLOWED"));
                Criteria fieldCrit = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), subRow.get("CONDN_FIELD_ID"), 0);
                subRow = dobj.getRow("NoSqlIndexFields", fieldCrit);
                field.put("NAME", (Object)ProductBundle.getInstance().getString(locale, subRow.get("FIELD_DISPLAY_NAME").toString()));
                field.put("FIELD_CONDITION", (Object)fieldCondition);
                fields.put((Object)field);
            }
            actionProperties.put("FIELDS", (Object)fields);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return actionProperties;
    }

    public static JSONObject getTotalCondition(Locale locale) {
        return CorrelationUtil.getTotalCondition(locale, null);
    }

    public static JSONObject getTotalCondition(Locale locale, Integer[] supportedOps) {
        JSONObject result = new JSONObject();
        JSONArray advanced = new JSONArray();
        JSONArray notAdvanced = new JSONArray();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NoSqlIndexCriteria"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            if (supportedOps != null) {
                query.setCriteria(new Criteria(Column.getColumn((String)"NoSqlIndexCriteria", (String)"OPERATION"), (Object)supportedOps, 8));
            }
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            dobj.sortRows("NoSqlIndexCriteria", new SortColumn[]{new SortColumn("NoSqlIndexCriteria", "CRITERIA_ORDER", true)});
            Iterator constantItr = dobj.getRows("NoSqlIndexCriteria");
            while (constantItr.hasNext()) {
                Row conditionItr = (Row)constantItr.next();
                JSONObject conditionFields = new JSONObject();
                conditionFields.put("CRITERIA_NAME", (Object)ProductBundle.getInstance().getString(locale, conditionItr.get("CRITERIA_NAME").toString()));
                conditionFields.put("VALUE", conditionItr.get("OPERATION"));
                conditionFields.put("DATA-REPRESENTATION", (Object)ProductBundle.getInstance().getString(locale, conditionItr.get("DATA_REPRESENTATION").toString()));
                conditionFields.put("DATA-EMPTY_VALUE", (Object)ProductBundle.getInstance().getString(locale, conditionItr.get("DATA_EMPTY_VALUE").toString()));
                if (!((Boolean)conditionItr.get("IS_ADVANCED")).booleanValue()) {
                    notAdvanced.put((Object)conditionFields);
                    continue;
                }
                advanced.put((Object)conditionFields);
            }
            result.put("NOT_ADVANCED", (Object)notAdvanced);
            result.put("ADVANCED", (Object)advanced);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    private static <E> JSONArray getFieldCondition(Iterator<?> conditionRow, Object fieldID) {
        JSONArray result = new JSONArray();
        try {
            while (conditionRow.hasNext()) {
                Row conditionItr = (Row)conditionRow.next();
                result.put(conditionItr.get("OPERATION"));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return result;
    }

    public static JSONObject getConfiguredCorrelationRule(Long ruleID, Locale locale) {
        JSONObject configuredRuleInfo = new JSONObject();
        try {
            DataObject dobj = CorrelationUtil.getCorrelationRuleCompleteData(ruleID);
            dobj.sortRows("CorrConfiguredActions", new SortColumn[]{new SortColumn("CorrConfiguredActions", "CONFIG_ORDER", true)});
            dobj.sortRows("CorrActionGroups", new SortColumn[]{new SortColumn("CorrActionGroups", "GROUP_ORDER", true)});
            dobj.sortRows("CorrActionConditions", new SortColumn[]{new SortColumn("CorrActionConditions", "CONDITION_ORDER", true)});
            Row ruleInfo = dobj.getRow("CorrRuleInfo");
            String str = (Boolean)ruleInfo.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)ruleInfo.get("RULE_DISPLAY_NAME")) : (String)ruleInfo.get("RULE_DISPLAY_NAME");
            JSONObject ruleDetails = new JSONObject();
            ruleDetails.put("RULE_NAME", (Object)str);
            if (ruleInfo.get("DESCRIPTION") != null) {
                str = (Boolean)ruleInfo.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)ruleInfo.get("DESCRIPTION")) : (String)ruleInfo.get("DESCRIPTION");
                ruleDetails.put("DESCRIPTION", (Object)str);
            }
            ruleDetails.put("REPORT_ENABLED", ruleInfo.get("REPORT_ENABLED"));
            ruleDetails.put("RULE_ID", ruleInfo.get("RULE_ID"));
            JSONObject ruleCategory = new JSONObject();
            ruleCategory.put("ID", ruleInfo.get("CATEGORY_ID"));
            ruleDetails.put("CATEGORY", (Object)ruleCategory);
            configuredRuleInfo.put("RULE_INFO", (Object)ruleDetails);
            JSONArray actionList = new JSONArray();
            JSONObject fieldLinks = new JSONObject();
            Iterator itr = dobj.getRows("CorrConfiguredActions");
            while (itr.hasNext()) {
                Row configuredAction = (Row)itr.next();
                Row actionInfo = dobj.getRow("CorrActionInfo", new Criteria(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID"), configuredAction.get("ACTION_ID"), 0));
                Row actionDynamics = dobj.getRow("CorrActionDynamics", new Criteria(Column.getColumn((String)"CorrActionDynamics", (String)"ACTION_CONFIG_ID"), configuredAction.get("CONFIG_ID"), 0));
                JSONArray fields = new JSONArray();
                Iterator condnFieldsItr = dobj.getRows("CorrActionCondnFields", new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"), configuredAction.get("ACTION_ID"), 0));
                while (condnFieldsItr.hasNext()) {
                    Row condnField = (Row)condnFieldsItr.next();
                    Row fieldRow = dobj.getRow("NoSqlIndexFields", new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), condnField.get("CONDN_FIELD_ID"), 0));
                    JSONObject fieldInfo = new JSONObject();
                    Iterator conditionRow = dobj.getRows("NoSqlIndexCriteria", new Criteria(Column.getColumn((String)"NoSqlIndexCriteriaFields", (String)"FIELD_ID"), condnField.get("CONDN_FIELD_ID"), 0));
                    JSONArray fieldCondition = CorrelationUtil.getFieldCondition(conditionRow, condnField.get("CONDN_FIELD_ID"));
                    fieldInfo.put("NAME", (Object)ProductBundle.getInstance().getString(locale, (String)fieldRow.get("FIELD_DISPLAY_NAME")));
                    fieldInfo.put("ID", fieldRow.get("FIELD_ID"));
                    fieldInfo.put("IS_SHARE_ALLOWED", condnField.get("SHAREDACTION_ALLOWED"));
                    fieldInfo.put("IS_UNIQUE_ALLOWED", condnField.get("UNIQUEACTION_ALLOWED"));
                    fieldInfo.put("FIELD_CONDITION", (Object)fieldCondition);
                    fields.put((Object)fieldInfo);
                }
                JSONArray groups = new JSONArray();
                Iterator groupItr = dobj.getRows("CorrActionGroups", new Criteria(Column.getColumn((String)"CorrActionGroups", (String)"ACTION_CONFIG_ID"), configuredAction.get("CONFIG_ID"), 0));
                while (groupItr.hasNext()) {
                    Row groupRow = (Row)groupItr.next();
                    Iterator conditionItr = dobj.getRows("CorrActionConditions", new Criteria(Column.getColumn((String)"CorrActionConditions", (String)"GROUP_ID"), groupRow.get("GROUP_ID"), 0));
                    Boolean isHidden = (Integer)groupRow.get("REPRESENTATION_TYPE") == 1;
                    JSONArray conditions = new JSONArray();
                    while (conditionItr.hasNext()) {
                        Row conditionInfo = (Row)conditionItr.next();
                        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"NoSqlIndexCriteria"));
                        query.addSelectColumn(Column.getColumn(null, (String)"*"));
                        query.setCriteria(new Criteria(Column.getColumn((String)"NoSqlIndexCriteria", (String)"OPERATION"), conditionInfo.get("OPERATION"), 0));
                        DataObject dob = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
                        Row conditionType = dob.getFirstRow("NoSqlIndexCriteria");
                        Integer type = (Integer)conditionType.get("TYPE");
                        Object criteriaString = null;
                        switch (type) {
                            case 0: {
                                Row comparisonRow = dobj.getRow("CorrCondnComparisons", new Criteria(Column.getColumn((String)"CorrCondnComparisons", (String)"CONDITION_ID"), conditionInfo.get("CONDITION_ID"), 0));
                                criteriaString = comparisonRow.get("CRITERIA_STRING");
                                break;
                            }
                            case 2: {
                                Iterator linkedRows = dobj.getRows("CorrConditionLinkedFields", new Criteria(Column.getColumn((String)"CorrConditionLinkedFields", (String)"CONDITION_ID"), conditionInfo.get("CONDITION_ID"), 0));
                                String actionUID = configuredAction.get("CONFIG_ID").toString();
                                String fieldID = conditionInfo.get("FIELD_ID").toString();
                                if (!fieldLinks.has(actionUID)) {
                                    fieldLinks.put(actionUID, (Object)new JSONObject());
                                }
                                if (!fieldLinks.getJSONObject(actionUID).has(fieldID)) {
                                    fieldLinks.getJSONObject(actionUID).put(fieldID, (Object)new JSONObject());
                                }
                                while (linkedRows.hasNext()) {
                                    Row row = (Row)linkedRows.next();
                                    String linkedAction = row.get("LINKED_ACTION_CONFIG_ID").toString();
                                    String linkedFieldID = row.get("LINKED_FIELD_ID").toString();
                                    Boolean isImplied = (Boolean)row.get("IS_IMPLIED");
                                    JSONObject linkedObj = new JSONObject();
                                    linkedObj.put("fieldId", (Object)linkedFieldID);
                                    Row fieldRow = dobj.getRow("NoSqlIndexFields", new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), row.get("LINKED_FIELD_ID"), 0));
                                    linkedObj.put("fieldName", (Object)ProductBundle.getInstance().getString(locale, (String)fieldRow.get("FIELD_DISPLAY_NAME")));
                                    linkedObj.put("isImplied", (Object)isImplied);
                                    fieldLinks.getJSONObject(actionUID).getJSONObject(fieldID).put(linkedAction, (Object)linkedObj);
                                }
                                break;
                            }
                        }
                        if (isHidden.booleanValue()) continue;
                        JSONObject condition = new JSONObject();
                        condition.put("FIELD_ID", conditionInfo.get("FIELD_ID"));
                        condition.put("LINK_TO_PREV", conditionInfo.get("LINK_TO_PREV"));
                        condition.put("OPERATION", conditionInfo.get("OPERATION"));
                        condition.put("CRITERIA_STRING", criteriaString);
                        condition.put("TYPE", (Object)type);
                        conditions.put((Object)condition);
                    }
                    if (isHidden.booleanValue()) continue;
                    JSONObject groupInfo = new JSONObject();
                    groupInfo.put("CONDITIONS", (Object)conditions);
                    groupInfo.put("LINK_TO_PREV", groupRow.get("LINK_TO_PREV"));
                    groups.put((Object)groupInfo);
                }
                JSONObject actionData = new JSONObject();
                actionData.put("CONFIG_ID", configuredAction.get("CONFIG_ID"));
                actionData.put("DESCRIPTION", (Boolean)actionInfo.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)actionInfo.get("DESCRIPTION")) : actionInfo.get("DESCRIPTION"));
                actionData.put("ACTION_ID", configuredAction.get("ACTION_ID"));
                actionData.put("FOLLOWEDBY_TIME", actionDynamics.get("FOLLOWEDBY_TIME"));
                actionData.put("THRESHOLD_HITS", actionDynamics.get("THRESHOLD_HITS"));
                actionData.put("THRESHOLD_TIME", actionDynamics.get("THRESHOLD_TIME"));
                actionData.put("FIELDS", (Object)fields);
                actionData.put("GROUPS", (Object)groups);
                actionList.put((Object)actionData);
            }
            configuredRuleInfo.put("ACTIONS", (Object)actionList);
            configuredRuleInfo.put("FIELD_LINKS", (Object)fieldLinks);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return configuredRuleInfo;
    }

    public static Row getCorrelationInfo(Object ruleID) throws DataAccessException {
        Criteria ruleCriteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), ruleID, 0);
        return PersistenceDBUtil.getPersistence().get("CorrRuleInfo", ruleCriteria).getFirstRow("CorrRuleInfo");
    }

    public static DataObject getCorrelationAlertDO(Long ruleID) throws DataAccessException {
        List<String> tableList = Arrays.asList("CorrRuleInfo", "CorrNotificationMapping");
        Criteria ruleCriteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 0);
        return PersistenceDBUtil.getPersistence().get(tableList, ruleCriteria);
    }

    public static DataObject getCorrelationRuleCompleteData(Long ruleID) throws DataAccessException {
        List<String> tableList = Arrays.asList("CorrRuleInfo", "CorrConfiguredActions", "CorrActionInfo", "CorrActionCondnFields", "NoSqlIndexFields", "NoSqlIndexCriteria", "NoSqlIndexCriteriaFields", "CorrActionDynamics");
        Criteria ruleCriteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 0);
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
        selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        List joinList = QueryConstructor.getJoins(tableList);
        for (Object join : joinList) {
            selectQuery.addJoin((Join)join);
        }
        selectQuery.addJoin(new Join("CorrConfiguredActions", "CorrActionGroups", new String[]{"CONFIG_ID"}, new String[]{"ACTION_CONFIG_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionGroups", "CorrActionConditions", new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionConditions", "CorrCondnComparisons", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionConditions", "CorrCondnUniqueConstrain", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionConditions", "CorrConditionLinkedFields", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1));
        selectQuery.addJoin(new Join("CorrRuleInfo", "CorrNotificationMapping", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
        selectQuery.setCriteria(ruleCriteria);
        return PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
    }

    public static DataObject getCompleteCorrelationRuleActionNotifData(Long ruleID, int ruleType) throws DataAccessException {
        return CorrelationUtil.getCompleteCorrelationRuleActionNotifData(ruleType, ruleID);
    }

    public static DataObject getCompleteCorrelationRuleActionNotifData(int ruleType, Long ... ruleID) throws DataAccessException {
        List<String> tableList = Arrays.asList("CorrRuleInfo", "CorrConfiguredActions", "CorrActionInfo", "CorrActionCondnFields", "NoSqlIndexFields", "CorrActionProfileMapping", "NotificationType");
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"TYPE"), (Object)ruleType, 0);
        selectQuery.setCriteria(criteria);
        if (ruleID != null && ruleID.length > 0 && ruleID[0] != null) {
            selectQuery.setCriteria(criteria.and(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 8)));
        }
        selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        List joinList = QueryConstructor.getJoins(tableList);
        for (Object join : joinList) {
            selectQuery.addJoin((Join)join);
        }
        selectQuery.addJoin(new Join("CorrConfiguredActions", "CorrActionDynamics", new String[]{"CONFIG_ID"}, new String[]{"ACTION_CONFIG_ID"}, 1));
        selectQuery.addJoin(new Join("CorrConfiguredActions", "CorrActionGroups", new String[]{"CONFIG_ID"}, new String[]{"ACTION_CONFIG_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionGroups", "CorrActionConditions", new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionConditions", "CorrCondnComparisons", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionConditions", "CorrCondnUniqueConstrain", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionConditions", "CorrConditionLinkedFields", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1));
        selectQuery.addJoin(new Join("CorrActionCondnFields", "CorrAssociatedFieldsInfo", new String[]{"FIELD_CONFIG_ID"}, new String[]{"FIELD_CONFIG_ID"}, 1));
        DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        return dobj;
    }

    public static DataObject getPartialCorrelationRuleActionNotifData(Long ... ruleID) throws DataAccessException {
        List<String> tableList = Arrays.asList("CorrRuleInfo", "CorrConfiguredActions", "CorrActionInfo", "CorrActionProfileMapping", "NotificationType");
        Criteria criteria = null;
        if (ruleID != null && ruleID.length > 0) {
            criteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 8);
        }
        return PersistenceDBUtil.getPersistence().get(tableList, criteria);
    }

    public static DataObject getPartialCorrelationActionNotifData(Long ... actionIds) throws DataAccessException {
        List<String> tableList = Arrays.asList("CorrActionInfo", "CorrActionProfileMapping", "NotificationType");
        Criteria criteria = null;
        if (actionIds != null && actionIds.length > 0) {
            criteria = new Criteria(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID"), (Object)actionIds, 8);
        }
        return PersistenceDBUtil.getPersistence().get(tableList, criteria);
    }

    public static DataObject getCorrelationRuleInfoDO(Long ... ruleID) throws DataAccessException {
        Criteria ruleCriteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 8);
        return PersistenceDBUtil.getPersistence().get(Arrays.asList("CorrRuleInfo", "CorrRuleCategory"), ruleCriteria);
    }

    public static JSONObject getCorrelationRuleInfoJSON(Long ruleID, Locale locale) throws DataAccessException, JSONException {
        DataObject dobj = CorrelationUtil.getCorrelationRuleInfoDO(ruleID);
        JSONObject ruleInfo = new JSONObject();
        Row row = dobj.getRow("CorrRuleInfo");
        JSONObject ruleINfo = row.getAsJSON();
        ProductBundle prdctbunle = ProductBundle.getInstance();
        if (ruleINfo.has("RULE_DISPLAY_NAME")) {
            ruleINfo.put("DISPLAY_NAME", (Object)prdctbunle.getString(locale, ruleINfo.getString("RULE_DISPLAY_NAME")));
        }
        if (ruleINfo.has("DESCRIPTION")) {
            ruleINfo.put("DESCRIPTION", (Object)prdctbunle.getString(locale, ruleINfo.getString("DESCRIPTION")));
        }
        ruleInfo.put("RULE_INFO", (Object)ruleINfo);
        return ruleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, JSONObject> getOverviewData(TimePack time, Range range, Locale locale, boolean sortAscending) {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrRuleSuccessHistory"));
        query.addJoin(new Join("CorrRuleSuccessHistory", "CorrRuleInfo", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
        Column history_count = Column.getColumn((String)"CorrRuleSuccessHistory", (String)"HISTORY_ID").count();
        history_count.setColumnAlias("Corr_Incident_Count");
        query.addSelectColumn(history_count);
        query.addSelectColumn(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"RULE_ID"));
        query.setGroupByClause(new GroupByClause(Arrays.asList(Column.getColumn((String)"CorrRuleSuccessHistory", (String)"RULE_ID"))));
        query.addSortColumn(new SortColumn(history_count, sortAscending));
        Criteria criteria = CorrelationUtil.getTimeBasedCustomTableSuccessCriteria("CorrRuleSuccessHistory", time);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"REPORT_ENABLED"), (Object)true, 0));
        query.setCriteria(criteria);
        query.setRange(range);
        Connection connection = null;
        DataSet dataSet = null;
        LinkedHashMap<Long, JSONObject> overviewData = new LinkedHashMap<Long, JSONObject>();
        try {
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)query, connection);
            while (dataSet.next()) {
                JSONObject obj2 = new JSONObject().put("HITS", dataSet.getValue(1));
                overviewData.put((Long)dataSet.getValue(2), obj2);
            }
        }
        catch (Exception exp) {
            try {
                exp.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSetOrDataSet(null, dataSet);
                DBUtil.closeStmtAndConnection(null, connection);
                throw throwable;
            }
            DBUtil.closeResultSetOrDataSet(null, dataSet);
            DBUtil.closeStmtAndConnection(null, connection);
        }
        DBUtil.closeResultSetOrDataSet(null, dataSet);
        DBUtil.closeStmtAndConnection(null, connection);
        try {
            query = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
            query.setCriteria(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)overviewData.keySet().toArray(), 8));
            query.addJoin(new Join("CorrRuleInfo", "CorrRuleCategory", new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 1));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID", (String)"CORR_RULE_ID"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"CATEGORY_ID", (String)"CORR_RULE_CATEGORY_ID"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleCategory", (String)"CATEGORY_ID", (String)"CORR_CATEGORY_ID"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_DISPLAY_NAME", (String)"RULE_DISPLAY_NAME"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleCategory", (String)"DISPLAY_NAME", (String)"DISPLAY_NAME"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"IS_SYSTEMGENERATED", (String)"IS_RULE_SYS_GENERATED"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleCategory", (String)"IS_SYSTEMGENERATED", (String)"IS_CATEGORY_SYS_GENERATED"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            overviewData.forEach((ruleID, obj) -> {
                try {
                    Row row = dobj.getRow("CorrRuleInfo", new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), ruleID, 0));
                    if (row != null) {
                        String displayName = (Boolean)row.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)row.get("RULE_DISPLAY_NAME")) : (String)row.get("RULE_DISPLAY_NAME");
                        obj.put("RULE_NAME", (Object)displayName);
                        row = dobj.getRow("CorrRuleCategory", new Criteria(Column.getColumn((String)"CorrRuleCategory", (String)"CATEGORY_ID"), row.get("CATEGORY_ID"), 0));
                        displayName = (Boolean)row.get("IS_SYSTEMGENERATED") != false ? ProductBundle.getInstance().getString(locale, (String)row.get("DISPLAY_NAME")) : (String)row.get("DISPLAY_NAME");
                        obj.put("CATEGORY_NAME", (Object)displayName);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return overviewData;
    }

    public static Boolean isEditableRule(Long ruleid) {
        Criteria criteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleid, 0);
        return DBUtil.getCountLong("CorrRuleInfo", criteria = criteria.and(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"IS_EDITABLE"), (Object)Boolean.TRUE, 0))) > 0L;
    }

    public static Vector<Properties> getMETrackerData() {
        Vector<Properties> vec = new Vector<Properties>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"STATUS"), (Object)CorrelationStatus.ENABLE.getValue(), 0);
            query.setCriteria(criteria);
            Join join = new Join("CorrRuleInfo", "CorrRuleCategory", new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 2);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_DISPLAY_NAME"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"ACCESSCOUNT"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"IS_SYSTEMGENERATED"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"STATUS"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"CATEGORY_ID"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleCategory", (String)"DISPLAY_NAME"));
            query.addSelectColumn(Column.getColumn((String)"CorrRuleCategory", (String)"CATEGORY_ID"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)query);
            if (!dobj.isEmpty()) {
                TimePack time = new TimePack("LastDay", TimeZone.getDefault());
                Range range = new Range(1, Integer.MAX_VALUE);
                Locale locale = Locale.getDefault();
                boolean sortAscending = false;
                Map<Long, JSONObject> map = CorrelationUtil.getOverviewData(time, range, locale, sortAscending);
                HashMap<Long, HashMap<String, Integer>> criteriaInfo = CorrelationUtil.getCriteriaInfo();
                Iterator itr = dobj.getRows("CorrRuleInfo");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    Properties pro = new Properties();
                    Long ruleID = (Long)row.get("RULE_ID");
                    String ruleName = (String)row.get("RULE_DISPLAY_NAME");
                    Long accessCount = (Long)row.get("ACCESSCOUNT");
                    Boolean isSystemGenerated = (Boolean)row.get("IS_SYSTEMGENERATED");
                    Long status = (Long)row.get("STATUS");
                    HashMap<String, Integer> ruleCrtInfo = criteriaInfo.get(ruleID);
                    Row row2 = dobj.getRow("CorrRuleCategory", row, join);
                    String categoryName = (String)row2.get("DISPLAY_NAME");
                    Integer hitCount = 0;
                    JSONObject obj = map.get(ruleID);
                    if (obj != null && obj.has("HITS")) {
                        hitCount = (Integer)obj.get("HITS");
                    }
                    pro.put("RuleName", ruleName);
                    pro.put("Hits", hitCount);
                    pro.put("Accesses", accessCount);
                    pro.put("Status", status);
                    pro.put("RuleCategory", categoryName);
                    pro.put("IsSystemGenerated", isSystemGenerated);
                    pro.put("IsUsingSharedField", ruleCrtInfo.containsKey("hasSharedField") ? ruleCrtInfo.get("hasSharedField") : "0");
                    pro.put("IsUsingUniqueField", ruleCrtInfo.containsKey("hasUniqueField") ? ruleCrtInfo.get("hasUniqueField") : "0");
                    vec.add(pro);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vec;
    }

    private static HashMap<Long, HashMap<String, Integer>> getCriteriaInfo() {
        HashMap<Long, HashMap<String, Integer>> criteriaInfo = new HashMap<Long, HashMap<String, Integer>>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
            Join join1 = new Join("CorrRuleInfo", "CorrConfiguredActions", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1);
            Join join2 = new Join("CorrConfiguredActions", "CorrActionGroups", new String[]{"CONFIG_ID"}, new String[]{"ACTION_CONFIG_ID"}, 1);
            Join join3 = new Join("CorrActionGroups", "CorrActionConditions", new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 1);
            Join join4 = new Join("CorrActionConditions", "CorrCondnUniqueConstrain", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1);
            Join join5 = new Join("CorrActionConditions", "CorrConditionLinkedFields", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1);
            selectQuery.addJoin(join1);
            selectQuery.addJoin(join2);
            selectQuery.addJoin(join3);
            selectQuery.addJoin(join4);
            selectQuery.addJoin(join5);
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"RULE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionGroups", (String)"ACTION_CONFIG_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionConditions", (String)"FIELD_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrCondnUniqueConstrain", (String)"CONFIG_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrConditionLinkedFields", (String)"CONFIG_ID"));
            DataObject dObj = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            if (dObj != null) {
                Iterator rules = dObj.getRows("CorrRuleInfo");
                while (rules.hasNext()) {
                    Row rule = (Row)rules.next();
                    Long ruleID = (Long)rule.get("RULE_ID");
                    Integer hasSharedField = 0;
                    Integer hasUniqueField = 0;
                    Iterator actions = dObj.getRows("CorrConfiguredActions", rule, join1);
                    while (actions.hasNext()) {
                        Row action = (Row)actions.next();
                        Iterator groups = dObj.getRows("CorrActionGroups", action, join2);
                        block4: while (groups.hasNext() && (hasSharedField == 0 || hasUniqueField == 0)) {
                            Row group = (Row)groups.next();
                            Iterator conditions = dObj.getRows("CorrActionConditions", group, join3);
                            while (conditions.hasNext()) {
                                Row condition = (Row)conditions.next();
                                Iterator uniqueCriteria = dObj.getRows("CorrCondnUniqueConstrain", condition, join4);
                                Iterator sharedCriteria = dObj.getRows("CorrConditionLinkedFields", condition, join5);
                                if (!sharedCriteria.hasNext() && !uniqueCriteria.hasNext()) continue block4;
                                if (hasSharedField == 0 && sharedCriteria.hasNext()) {
                                    hasSharedField = 1;
                                }
                                if (hasUniqueField != 0 || !uniqueCriteria.hasNext()) continue;
                                hasUniqueField = 1;
                            }
                        }
                    }
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("hasSharedField", hasSharedField);
                    map.put("hasUniqueField", hasUniqueField);
                    criteriaInfo.put(ruleID, map);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return criteriaInfo;
    }

    public static void incAccessCount(Long ruleId) {
        try {
            UpdateQueryImpl uq = new UpdateQueryImpl("CorrRuleInfo");
            Criteria crt = new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleId, 0);
            uq.setCriteria(crt);
            Operation incrHits = Column.createOperation((Operation.operationType)Operation.operationType.ADD, (Object)Column.getColumn((String)"CorrRuleInfo", (String)"ACCESSCOUNT"), (Object)1L);
            incrHits.setType(-5);
            uq.setUpdateColumn("ACCESSCOUNT", (Object)incrHits);
            PersistenceDBUtil.getPersistence().update((UpdateQuery)uq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long[] getAllConfiguredRuleIds() {
        Long[] array = null;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Iterator iter = dobj.getRows("CorrRuleInfo");
            int i = 0;
            array = new Long[dobj.size("CorrRuleInfo")];
            while (iter.hasNext()) {
                array[i] = (Long)((Row)iter.next()).get("RULE_ID");
                ++i;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return array;
    }

    public static boolean checkIfActionAvailable(String ruleName, Locale locale) throws Exception {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrActionInfo"));
        Column ruleNameColumn = Column.getColumn((String)"CorrActionInfo", (String)"DISPLAY_NAME");
        Column conditionColumn = Column.getColumn((String)"CorrActionInfo", (String)"IS_SYSTEMGENERATED", (String)"RULE_SYS_GEN");
        selectQuery.addSelectColumn(ruleNameColumn);
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"ACTION_ID"));
        return !DefaultDataSource.getKeyBasedSearchResult(ruleNameColumn, ruleName, (SelectQuery)selectQuery, conditionColumn, locale, 1, 1, SearchType.EQUALS_IGNORE_CASE).isEmpty();
    }

    public static String getRuleName(Long ruleID) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_DISPLAY_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"IS_SYSTEMGENERATED"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 0));
        Row row = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).getRow("CorrRuleInfo");
        String displayName = (String)row.get("RULE_DISPLAY_NAME");
        if (((Boolean)row.get("IS_SYSTEMGENERATED")).booleanValue()) {
            displayName = ProductBundle.getInstance().getString(displayName);
        }
        return displayName;
    }

    public static void raiseReportExportRequest(JSONObject request, String format) throws BaseStatusCode {
        try {
            String displayName = null;
            if (request.has("RULE_ID")) {
                displayName = CorrelationUtil.getRuleName(request.getLong("RULE_ID"));
            } else if (request.has("PROVIDER_ID")) {
                displayName = ActivityUtil.getActivityNameForRequest(request);
            }
            request.put("IS_SCHEDULED", false);
            switch (format) {
                case "CSV": {
                    TableExportUtil.exportToCSV(displayName, request);
                    break;
                }
                case "PDF": {
                    TableExportUtil.exportToPDF(displayName, request);
                    break;
                }
                default: {
                    throw BaseStatusCode.getBaseStatusCode(7428);
                }
            }
        }
        catch (DataAccessException | JSONException e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static Long addUpdateSchedule(JSONObject request, Long userID, Locale locale) throws BaseStatusCode {
        try {
            Long ruleID = null;
            if (request.getString("OPERATION").equals("CREATE")) {
                ruleID = request.getLong("RULE_ID");
            }
            String exportHandlerClass = CorrelationExportSchedule.class.getCanonicalName();
            return CorrelationUtil.configureSchedule(request, userID, 1, ruleID, exportHandlerClass, locale);
        }
        catch (BaseStatusCode bs) {
            bs.printStackTrace();
            throw bs;
        }
        catch (JSONException je) {
            je.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        catch (Exception dae) {
            dae.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7430);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long configureSchedule(JSONObject request, Long userID, Integer ruleType, Long ruleID, String exportHandlerClass, Locale locale) throws Exception {
        DataObject dobj;
        request.put("SCHEDULE_CLASS", (Object)exportHandlerClass);
        if (request.getString("OPERATION").equals("CREATE")) {
            Row scheduleRow;
            String defaultSubject;
            String ruleName;
            if (ruleType == 1) {
                ruleName = CorrelationUtil.getRuleName(ruleID);
                defaultSubject = ProductBundle.getInstance().getString(locale, "ela.schedule.defaultCorrMailSubject");
            } else {
                ruleName = ActivityUtil.getProviderName(request.getLong("PROVIDER_ID"));
                defaultSubject = ProductBundle.getInstance().getString(locale, "ela.schedule.defaultActivityMailSubject");
            }
            if (request.optString("EMAIL_SUBJECT", "").isEmpty()) {
                request.put("EMAIL_SUBJECT", (Object)(defaultSubject + " : " + ruleName));
            }
            if ((scheduleRow = (dobj = TableScheduleUtil.getNewScheduleDO(request, userID, locale)).getRow("ELATableExportSchedules")) == null) throw BaseStatusCode.getBaseStatusCode(7428);
            Row row = new Row("CorrScheduledReports");
            row.set("EXPORT_ID", scheduleRow.get("EXPORT_ID"));
            row.set("RULE_ID", (Object)ruleID);
            dobj.addRow(row);
        } else {
            dobj = TableScheduleUtil.getUpdatedScheduleDO(request);
        }
        PersistenceDBUtil.getScheduler().updateSchedule(dobj);
        Row scheduleRow = dobj.getRow("ELATableExportSchedules");
        return (Long)scheduleRow.get("EXPORT_ID");
    }

    public static void removeSchedulesForRule(Long ruleID) throws BaseStatusCode {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrScheduledReports", (String)"RULE_ID"), (Object)ruleID, 0);
            DataObject dobj = PersistenceDBUtil.getPersistence().get("CorrScheduledReports", criteria);
            Iterator iter = dobj.getRows("CorrScheduledReports");
            JSONArray exportIDs = new JSONArray();
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                exportIDs.put(row.get("EXPORT_ID"));
            }
            TableScheduleUtil.deleteExportSchedule(exportIDs);
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public static boolean isCorrelationAccessAllowed(String userType) {
        DelegationRoleContainer.UserRole userRole = DelegationRoleContainer.UserRole.getRole(userType);
        return CorrelationUtil.isCorrelationAccessAllowed(userRole);
    }

    public static boolean isCorrelationAccessAllowed(DelegationRoleContainer.UserRole userRole) {
        String correlationAccess = (String)CommonUtil.getSysConfiguration(CORR_ACCESS_STATUS);
        if ("ALL".equals(correlationAccess) || userRole == DelegationRoleContainer.UserRole.ADMIN) {
            return true;
        }
        if (userRole == DelegationRoleContainer.UserRole.OPERATOR) {
            return "ADMIN_OPERATOR".equals(correlationAccess);
        }
        if (userRole == DelegationRoleContainer.UserRole.GUEST) {
            return "ADMIN_GUEST".equals(correlationAccess);
        }
        return false;
    }

    public static boolean isValidOperation(DataObject fieldConditionDobj, int type, int operation, long fieldID, Long actionID) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"), (Object)actionID, 0).and(new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"CONDN_FIELD_ID"), (Object)fieldID, 0));
            Row row = fieldConditionDobj.getRow("CorrActionCondnFields", criteria);
            if (!(operation <= 100 || ((Boolean)row.get("SHAREDACTION_ALLOWED")).booleanValue() && ((Boolean)row.get("UNIQUEACTION_ALLOWED")).booleanValue())) {
                return false;
            }
            criteria = new Criteria(Column.getColumn((String)"NoSqlIndexCriteriaFields", (String)"FIELD_ID"), (Object)fieldID, 0);
            Iterator constantItr = fieldConditionDobj.getRows("NoSqlIndexCriteria", criteria);
            while (constantItr.hasNext()) {
                Row constant = (Row)constantItr.next();
                int oprationCheck = Integer.parseInt(constant.get("OPERATION").toString());
                int typeCheck = Integer.parseInt(constant.get("TYPE").toString());
                if (typeCheck != type || oprationCheck != operation) continue;
                return true;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return false;
    }

    public static JSONArray getCorrelationActionsAndFieldsList(Long notifId, Locale locale, boolean excludeMessage) throws BaseStatusCode {
        JSONArray actionsFieldsInfo = new JSONArray();
        ProductBundle rb = ProductBundle.getInstance();
        try {
            List<String> tableList = Arrays.asList("CorrNotificationMapping", "CorrRuleInfo", "CorrConfiguredActions", "CorrActionInfo", "CorrActionCondnFields", "NoSqlIndexFields");
            Criteria notifCriteria = new Criteria(Column.getColumn((String)"CorrNotificationMapping", (String)"NOTIFID"), (Object)notifId, 0);
            DataObject dobj = PersistenceDBUtil.getPersistence().get(tableList, notifCriteria);
            if (dobj != null) {
                dobj.sortRows("CorrConfiguredActions", new SortColumn[]{new SortColumn("CorrConfiguredActions", "CONFIG_ORDER", true)});
                dobj.sortRows("CorrActionCondnFields", new SortColumn[]{new SortColumn("CorrActionCondnFields", "CONDN_FIELD_ID", true)});
                Iterator configActionItr = dobj.getRows("CorrConfiguredActions");
                int i = 1;
                while (configActionItr.hasNext()) {
                    Row configActionRow = (Row)configActionItr.next();
                    Row actionInfo = dobj.getRow("CorrActionInfo", configActionRow);
                    JSONObject action = new JSONObject();
                    action.put("ACTION_CONFIG_ID", (Object)((Long)configActionRow.get("CONFIG_ID")));
                    action.put("NAME", (Object)rb.getString(locale, (String)actionInfo.get("DESCRIPTION")));
                    action.put("HASCHILD", true);
                    action.put("TOOLTIP", (Object)(rb.getString(locale, "Action") + " " + i + " : " + action.getString("NAME")));
                    Criteria actionCriteria = new Criteria(Column.getColumn((String)"CorrActionCondnFields", (String)"ACTION_ID"), (Object)((Long)configActionRow.get("ACTION_ID")), 0);
                    Iterator fieldIterator = dobj.getRows("CorrActionCondnFields", actionCriteria);
                    JSONArray fields = new JSONArray();
                    while (fieldIterator.hasNext()) {
                        Row fieldRow = (Row)fieldIterator.next();
                        JSONObject field = new JSONObject();
                        field.put("ACTION_CONFIG_ID", configActionRow.get("CONFIG_ID"));
                        field.put("ACTION_INDEX", i);
                        field.put("FIELD_ID", fieldRow.get("CONDN_FIELD_ID"));
                        Criteria fieldCrit = new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), fieldRow.get("CONDN_FIELD_ID"), 0);
                        fieldRow = dobj.getRow("NoSqlIndexFields", fieldCrit);
                        if (fieldRow.get("FIELD_INDEX_NAME").toString().equals("MESSAGE") && excludeMessage) continue;
                        field.put("FIELD_INDEX_NAME", fieldRow.get("FIELD_INDEX_NAME"));
                        field.put("NAME", (Object)rb.getString(locale, fieldRow.get("FIELD_DISPLAY_NAME").toString()));
                        fields.put((Object)field);
                    }
                    JSONObject actionNameField = new JSONObject();
                    actionNameField.put("NAME", (Object)rb.getString("DESCRIPTION"));
                    actionNameField.put("FIELD_INDEX_NAME", (Object)"ACTNDESC");
                    actionNameField.put("ACTION_INDEX", i);
                    fields.put((Object)actionNameField);
                    actionNameField = new JSONObject();
                    actionNameField.put("NAME", (Object)rb.getString("TIME"));
                    actionNameField.put("FIELD_INDEX_NAME", (Object)"ACTNTIME");
                    actionNameField.put("ACTION_INDEX", i);
                    fields.put((Object)actionNameField);
                    actionNameField = new JSONObject();
                    actionNameField.put("NAME", (Object)rb.getString("DATE"));
                    actionNameField.put("FIELD_INDEX_NAME", (Object)"ACTNDATE");
                    actionNameField.put("ACTION_INDEX", i);
                    fields.put((Object)actionNameField);
                    action.put("LIST", (Object)fields);
                    actionsFieldsInfo.put((Object)action);
                    ++i;
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return actionsFieldsInfo;
    }

    public static List<String> getAssociatedFields(Long actionConfigId, String fieldName) throws BaseStatusCode {
        ArrayList<String> associatedFields = new ArrayList<String>();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrConfiguredActions"));
            selectQuery.addJoin(new Join("CorrConfiguredActions", "CorrActionInfo", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
            selectQuery.addJoin(new Join("CorrActionInfo", "CorrActionCondnFields", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
            selectQuery.addJoin(new Join("CorrActionCondnFields", "NoSqlIndexFields", new String[]{"CONDN_FIELD_ID"}, new String[]{"FIELD_ID"}, 2));
            selectQuery.addJoin(new Join("CorrActionCondnFields", "CorrAssociatedFieldsInfo", new String[]{"FIELD_CONFIG_ID"}, new String[]{"FIELD_CONFIG_ID"}, 2));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrAssociatedFieldsInfo", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionInfo", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrActionCondnFields", (String)"*"));
            Criteria actionCriteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"), (Object)actionConfigId, 0);
            actionCriteria = actionCriteria.and(new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_INDEX_NAME"), (Object)fieldName, 0));
            selectQuery.setCriteria(actionCriteria);
            DataObject dobj = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            if (dobj != null) {
                Iterator conditions = dobj.getRows("CorrActionCondnFields");
                while (conditions.hasNext()) {
                    Row field = (Row)conditions.next();
                    Iterator assFieldsIterator = dobj.getRows("CorrAssociatedFieldsInfo", new Criteria(Column.getColumn((String)"CorrAssociatedFieldsInfo", (String)"FIELD_CONFIG_ID"), field.get("FIELD_CONFIG_ID"), 0));
                    while (assFieldsIterator.hasNext()) {
                        Row r = (Row)assFieldsIterator.next();
                        Row assField = dobj.getRow("NoSqlIndexFields", new Criteria(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"), r.get("FIELD_ID"), 0));
                        if (assField == null) continue;
                        associatedFields.add((String)assField.get("FIELD_INDEX_NAME"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return associatedFields;
    }

    public static JSONArray getActionsAndFields(Long ruleId) {
        JSONArray actionsAndFields = new JSONArray();
        try {
            List<String> tableList = Arrays.asList("CorrRuleInfo", "CorrConfiguredActions", "CorrActionDynamics", "CorrActionInfo", "CorrActionCondnFields", "NoSqlIndexFields");
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
            selectQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            List joinList = QueryConstructor.getJoins(tableList);
            for (Object join : joinList) {
                selectQuery.addJoin((Join)join);
            }
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleId, 0));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ORDER"), true));
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            if (dataObject != null) {
                Iterator actions = dataObject.getRows("CorrConfiguredActions");
                while (actions.hasNext()) {
                    Row action = (Row)actions.next();
                    Row actionInfo = dataObject.getRow("CorrActionInfo", action);
                    Row actionDynamics = dataObject.getRow("CorrActionDynamics", action);
                    JSONObject actn = new JSONObject();
                    actn.put("ACTION_CONFIG_ID", action.get("CONFIG_ID"));
                    actn.put("ACTION_ID", actionInfo.get("ACTION_ID"));
                    actn.put("DESCRIPTION", (Object)ProductBundle.getInstance().getString((String)actionInfo.get("DESCRIPTION")));
                    actn.put("HITS", actionDynamics.get("THRESHOLD_HITS") != null ? actionDynamics.get("THRESHOLD_HITS") : Integer.valueOf(1));
                    Iterator conditionFields = dataObject.getRows("CorrActionCondnFields", actionInfo);
                    JSONArray fields = new JSONArray();
                    while (conditionFields.hasNext()) {
                        Row conditionField = (Row)conditionFields.next();
                        Row field = dataObject.getRow("NoSqlIndexFields", conditionField);
                        JSONObject fieldObj = new JSONObject();
                        fieldObj.put("NAME", (Object)ProductBundle.getInstance().getString(field.get("FIELD_DISPLAY_NAME").toString()));
                        fieldObj.put("FIELD_INDEX_NAME", field.get("FIELD_INDEX_NAME"));
                        fields.put((Object)fieldObj);
                    }
                    actn.put("FIELDS", (Object)fields);
                    actionsAndFields.put((Object)actn);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionsAndFields;
    }

    public static String getActionDescription(Long actionConfigId) {
        String desc = "";
        try {
            List<String> tableList = Arrays.asList("CorrConfiguredActions", "CorrActionInfo");
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrConfiguredActions", (String)"CONFIG_ID"), (Object)actionConfigId, 0);
            DataObject actionDo = PersistenceDBUtil.getPersistence().get(tableList, criteria);
            if (actionDo != null) {
                Row action = actionDo.getFirstRow("CorrActionInfo");
                desc = ProductBundle.getInstance().getString(action.get("DESCRIPTION").toString());
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return desc;
    }

    public static int getRuleType(Long ruleID) throws DataAccessException {
        SelectQueryImpl selectQuery = new SelectQueryImpl(new Table("CorrRuleInfo"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"TYPE"));
        selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 0));
        return (Integer)PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery).getFirstValue("CorrRuleInfo", "TYPE");
    }

    public static JSONObject getScheduleInfo(Long exportID, Locale locale) throws BaseStatusCode {
        JSONObject scheduleData = TableScheduleUtil.getScheduleInfo(exportID);
        try {
            JSONArray fields = CorrelationUtil.getScheduleCriteriaFieldData(CorrelationUtil.getRuleIDFromExportID(exportID), locale);
            if (fields.length() > 0) {
                scheduleData.put("FIELDS", (Object)fields);
                JSONObject criteriaGroups = TableScheduleUtil.loadScheduleCriteria(exportID);
                if (criteriaGroups.has("GROUPS")) {
                    scheduleData.put("CRITERIA", (Object)criteriaGroups);
                }
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        return scheduleData;
    }

    public static JSONArray getScheduleCriteriaFieldData(Locale locale, Long providerID) {
        return CorrelationUtil.getScheduleCriteriaFieldData(ActivityUtil.getRuleIDForProvider(providerID), locale);
    }

    public static Long getRuleIDFromExportID(Long exportID) {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrScheduledReports"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrScheduledReports", (String)"EXPORT_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrScheduledReports", (String)"RULE_ID"));
            Criteria criteria = new Criteria(Column.getColumn((String)"CorrScheduledReports", (String)"EXPORT_ID"), (Object)exportID, 0);
            selectQuery.setCriteria(criteria);
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            if (dataObject.containsTable("CorrScheduledReports")) {
                return (Long)dataObject.getFirstValue("CorrScheduledReports", "RULE_ID");
            }
        }
        catch (DataAccessException exp) {
            LOGGER.log(Level.INFO, "Error occurred during resolving activity id from export id {0}", exp.getMessage());
        }
        return null;
    }

    public static JSONArray getScheduleCriteriaFieldData(Long ruleID, Locale locale) {
        JSONArray fields = new JSONArray();
        try {
            JSONArray fieldOps = new JSONArray();
            for (Integer supportedOp : ScheduleCriteria.SUPPORTED_OPERATIONS) {
                fieldOps.put((Object)supportedOp);
            }
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"CorrRuleInfo"));
            selectQuery.addJoin(new Join("CorrRuleInfo", "CorrScheduleCriteriaFields", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
            selectQuery.addJoin(new Join("CorrScheduleCriteriaFields", "NoSqlIndexFields", new String[]{"FIELD_ID"}, new String[]{"FIELD_ID"}, 1));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"CorrScheduleCriteriaFields", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"NoSqlIndexFields", (String)"FIELD_DISPLAY_NAME"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"CorrRuleInfo", (String)"RULE_ID"), (Object)ruleID, 0));
            DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Iterator iterator = dataObject.getRows("NoSqlIndexFields");
            while (iterator.hasNext()) {
                JSONObject entry = new JSONObject();
                Row row = (Row)iterator.next();
                entry.put("ID", row.get("FIELD_ID"));
                entry.put("NAME", (Object)ProductBundle.getInstance().getString(locale, (String)row.get("FIELD_DISPLAY_NAME")));
                entry.put("IS_UNIQUE_ALLOWED", false);
                entry.put("IS_SHARE_ALLOWED", false);
                entry.put("FIELD_CONDITION", (Object)fieldOps);
                fields.put((Object)entry);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return fields;
    }
}

