/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.manageengine.ela.server.common.constants.RegularExpressionConstants;
import com.manageengine.ela.server.common.io.file.pattern.PatternDetailsBean;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import java.util.regex.Matcher;

public class ImportFile {
    private Matcher matcher = RegularExpressionConstants.FILE_PATH_PATTERN.matcher("");
    private String filePath;
    private String filename = null;
    private int importFileType;
    private PatternDetailsBean patternDetailsBean = null;

    public ImportFile(String filePath, int importFileType) throws BaseStatusCode {
        if (filePath == null) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        this.filePath = this.normalizeFilePath(filePath);
        this.importFileType = importFileType;
    }

    private String normalizeFilePath(String filePath) {
        filePath = filePath.trim();
        this.matcher = this.matcher.reset(filePath);
        try {
            if (this.matcher.matches() && this.matcher.groupCount() > 1) {
                filePath = this.matcher.group(1);
                this.filename = this.matcher.group(2);
            } else {
                this.filename = filePath;
                filePath = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = this.normalizeFilePath(filePath);
    }

    public PatternDetailsBean getPatternDetailsBean() {
        return this.patternDetailsBean;
    }

    public void setPatternDetailsBean(PatternDetailsBean patternDetailsBean) {
        this.patternDetailsBean = patternDetailsBean;
    }

    public int getImportFileType() {
        return this.importFileType;
    }

    public void setImportFileType(int importFileType) {
        this.importFileType = importFileType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

