/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.manageengine.ela.server.importlog.LogProperties;
import org.elasticsearch.common.Strings;

public class ImportFileProperties {
    private final Boolean isLocal;
    private final String localFilePath;
    private final LogProperties logProperties;
    private String windowsLogType = "Security";

    public ImportFileProperties(Boolean isLocal, String localFilePath, LogProperties logProperties) {
        this.isLocal = isLocal;
        this.localFilePath = !Strings.isNullOrEmpty((String)localFilePath) && localFilePath.length() > 1 && localFilePath.endsWith("/") ? localFilePath.substring(0, localFilePath.length() - 1) : localFilePath;
        this.logProperties = logProperties;
        if (!Strings.isNullOrEmpty((String)logProperties.getWindowsLogType())) {
            this.setWindowsLogType(logProperties.getWindowsLogType());
        }
    }

    public Boolean getLocal() {
        return this.isLocal;
    }

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    public String getWindowsLogType() {
        return this.windowsLogType;
    }

    public void setWindowsLogType(String windowsLogType) {
        this.windowsLogType = windowsLogType;
    }

    public LogProperties getLogProperties() {
        return this.logProperties;
    }
}

