/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.importlog.filter.TimeFilter;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportFilters {
    private TimeFilter timeFilter = null;

    public ImportFilters(JSONObject filterObject) throws JSONException {
        if (!filterObject.isNull("TIME") && filterObject.getJSONObject("TIME").has("startTime")) {
            this.timeFilter = new TimeFilter(filterObject.getJSONObject("TIME"));
        }
    }

    public ImportFilters(Long sourceId) throws JSONException, DataAccessException {
        SelectQueryImpl filterDetailsSelectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportFilterDetails"));
        filterDetailsSelectQuery.addJoin(new Join("ELAImportFilterDetails", "ELAImportFilter", new String[]{"FILTER_TYPE"}, new String[]{"FILTER_ID"}, 2));
        filterDetailsSelectQuery.addJoin(new Join("ELAImportFilterDetails", "ELAImportLogConfigurations", new String[]{"IMPORT_ID"}, new String[]{"IMPORT_ID"}, 2));
        filterDetailsSelectQuery.addSelectColumn(Column.getColumn((String)"ELAImportFilterDetails", (String)"*"));
        filterDetailsSelectQuery.addSelectColumn(Column.getColumn((String)"ELAImportFilter", (String)"*"));
        filterDetailsSelectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogConfigurations", (String)"*"));
        Criteria filterDetailsCriteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        filterDetailsSelectQuery.setCriteria(filterDetailsCriteria);
        DataObject filterDetailsDataObject = PersistenceDBUtil.getPersistenceLite().get((SelectQuery)filterDetailsSelectQuery);
        if (!filterDetailsDataObject.isEmpty()) {
            Iterator filterIterator = filterDetailsDataObject.getRows("ELAImportFilter");
            Iterator filterDetailsIterator = filterDetailsDataObject.getRows("ELAImportFilterDetails");
            while (filterIterator.hasNext() && filterDetailsIterator.hasNext()) {
                Row filterRow = (Row)filterIterator.next();
                Row filterDetailsRow = (Row)filterDetailsIterator.next();
                String filterType = (String)filterRow.get("FILTER_NAME");
                Long filterId = Long.parseLong(String.valueOf(filterDetailsRow.get("FILTER_TYPE_ID")));
                String filterName = (String)filterRow.get("FILTER_TABLE");
                switch (filterType.toUpperCase()) {
                    case "TIME": {
                        this.timeFilter = new TimeFilter(filterId, filterName);
                    }
                }
            }
        }
    }

    public TimeFilter getTimeFilter() {
        return this.timeFilter;
    }

    public void setTimeFilter(TimeFilter timeFilter) {
        this.timeFilter = timeFilter;
    }

    public boolean applyAllFilters(HashMap<String, Object> fields) {
        boolean filterPassed = true;
        if (this.timeFilter != null && NumberUtils.isNumber((String)String.valueOf(fields.get("TIME")))) {
            filterPassed = this.timeFilter.isFilterPassed(fields);
        }
        return filterPassed;
    }

    public void addFiltersToDatabase(Object import_id) throws DataAccessException {
        if (this.timeFilter != null) {
            this.timeFilter.addToDb(import_id);
        }
    }

    public JSONObject getJSON() {
        return null;
    }
}

