/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.Iterator;
import org.apache.commons.lang3.math.NumberUtils;

public class ImportLogAuditDetails {
    private Long lastImport = null;
    private Long lineCount = null;
    private Double totalParsedSize = null;
    private String recordMarker = null;
    private Long currentLineCount = null;
    private long timeTaken = 0L;
    private Long logStartsTime = null;
    private Long logEndsTime = null;
    private String headerRow = null;

    public Long getCurrentLineCount() {
        return this.currentLineCount;
    }

    public void setCurrentLineCount(Long currentLineCount) {
        this.currentLineCount = currentLineCount;
    }

    public void reset() {
        this.lastImport = null;
        this.lineCount = 0L;
        this.totalParsedSize = 0.0;
        this.timeTaken = 0L;
        this.logStartsTime = null;
        this.logEndsTime = null;
        this.recordMarker = null;
    }

    public Long getLastImport() {
        return this.lastImport;
    }

    public void setLastImport(Long lastImport) {
        this.lastImport = lastImport;
    }

    public Long getLineCount() {
        return this.lineCount;
    }

    public void setLineCount(Long lineCount) {
        this.lineCount = lineCount;
    }

    public Double getTotalParsedSize() {
        return this.totalParsedSize;
    }

    public void setTotalParsedSize(Double totalParsedSize) {
        this.totalParsedSize = totalParsedSize;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public void setLogStartsTime(long starts_time) {
        if (this.logStartsTime == null) {
            this.logStartsTime = starts_time;
        } else if (starts_time > 0L && this.logStartsTime > starts_time) {
            this.logStartsTime = starts_time;
        }
    }

    public void setLogEndsTime(long ends_time) {
        if (this.logEndsTime == null) {
            this.logEndsTime = ends_time;
        } else if (ends_time > 0L && this.logEndsTime < ends_time) {
            this.logEndsTime = ends_time;
        }
    }

    public Long getLogStartsTime() {
        return this.logStartsTime;
    }

    public Long getLogEndsTime() {
        return this.logEndsTime;
    }

    public String getHeaderRow() {
        return this.headerRow;
    }

    public void setHeaderRow(String headerRow) {
        this.headerRow = headerRow;
    }

    public static ImportLogAuditDetails getLatestAuditDetails(long sourceId) throws DataAccessException {
        Iterator importLogAuditIterator;
        ImportLogAuditDetails importLogAuditDetails = new ImportLogAuditDetails();
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportLogAudit"));
        SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"AUDIT_ID"), false);
        selectQuery.addSortColumn(sortColumn);
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogAudit", (String)"SOURCE_ID"), (Object)sourceId, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
        if (dataObject != null && (importLogAuditIterator = dataObject.getRows("ELAImportLogAudit")).hasNext()) {
            Row row = (Row)importLogAuditIterator.next();
            Long readCount = NumberUtils.toLong((String)String.valueOf(row.get("NO_OF_LINE_READ")), (long)0L);
            String headerRow = (String)row.get("HEADER_FIELDS");
            String recordMarker = (String)row.get("RECORD_MARKER");
            importLogAuditDetails.setLineCount(readCount);
            importLogAuditDetails.setHeaderRow(headerRow);
            importLogAuditDetails.setRecordMarker(recordMarker);
        }
        return importLogAuditDetails;
    }

    public String getRecordMarker() {
        return this.recordMarker;
    }

    public void setRecordMarker(String recordMarker) {
        this.recordMarker = recordMarker;
    }
}

