/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Persistence;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutor;
import com.manageengine.ela.server.common.executors.processor.ProcessorPoolExecutorImpl;
import com.manageengine.ela.server.common.executors.queue.CommonQueueImpl;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.processors.BaseLogProcessor;
import java.util.logging.Logger;

public class ImportLogManager {
    private static final Logger LOGGER = Logger.getLogger(ImportLogManager.class.getName());
    private static ImportLogManager importLogManager = null;
    private static CommonQueueImpl<LogProperties> logPropertiesCommonQueue = new CommonQueueImpl();
    private static BaseLogProcessor logProcessor = new BaseLogProcessor((ConcurrentQueue<LogProperties>)logPropertiesCommonQueue);
    private static ProcessorPoolExecutor poolExecutor = new ProcessorPoolExecutorImpl<LogProperties>(logProcessor, 5);

    private ImportLogManager() {
    }

    public static ImportLogManager getInstance() throws IllegalAccessException {
        if (importLogManager == null) {
            importLogManager = new ImportLogManager();
            new Thread(() -> {
                try {
                    Persistence persistence = PersistenceDBUtil.getPersistence();
                    UpdateQueryImpl updateConfigQuery = new UpdateQueryImpl("ELAImportLogConfigurations");
                    updateConfigQuery.setUpdateColumn("IMPORT_STATUS", (Object)12197L);
                    Criteria configCriteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"IMPORT_STATUS"), (Object)new Long[]{12145L, 12195L, 12198L}, 8);
                    updateConfigQuery.setCriteria(configCriteria);
                    persistence.update((UpdateQuery)updateConfigQuery);
                    UpdateQueryImpl updateAuditQuery = new UpdateQueryImpl("ELAImportLogAudit");
                    updateAuditQuery.setUpdateColumn("STATUS", (Object)12197L);
                    Criteria auditCriteria = new Criteria(Column.getColumn((String)"ELAImportLogAudit", (String)"STATUS"), (Object)new Long[]{12145L, 12195L, 12198L}, 8);
                    updateAuditQuery.setCriteria(auditCriteria);
                    persistence.update((UpdateQuery)updateAuditQuery);
                }
                catch (DataAccessException e) {
                    e.printStackTrace();
                }
            }).start();
        }
        for (int index = 0; index < 4 && poolExecutor.getCurrentProcessors() < poolExecutor.getMaxProcessors(); ++index) {
            poolExecutor.addProcessor();
        }
        return importLogManager;
    }

    public void addNewFile(LogProperties logProperties) throws Exception {
        LOGGER.info("New Import File Arrived");
        logPropertiesCommonQueue.add(logProperties);
    }

    public void shutdown() throws InterruptedException {
        poolExecutor.waitForCompletion();
        logProcessor.stopIfQueueIsEmpty();
    }
}

