/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.UniqueValueGeneration;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.i18n.ResourceBundleMgr;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import com.manageengine.ela.server.application.webserver.iis.config.IISConfigHandler;
import com.manageengine.ela.server.common.application.util.ApplicationUtil;
import com.manageengine.ela.server.common.config.technician.TechnicianUtil;
import com.manageengine.ela.server.common.device.LogSourceCategoryContainer;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternDetailsBean;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import com.manageengine.ela.server.importlog.ImportFile;
import com.manageengine.ela.server.importlog.ImportScheduler;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONObject;

public class ImportLogMigrationUtil {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(ImportLogMigrationUtil.class.getName());
    private static Map<String, String> formatNameUvhMap = new HashMap<String, String>();

    public static void addAuditDetails(LogProperties logProperty) throws DataAccessException {
        Row row = new Row("ELAImportLogAudit");
        row.set("SOURCE_ID", (Object)logProperty.getSourceId());
        row.set("FILE_NAME", (Object)logProperty.getFileName());
        row.set("MATCHED_FORMAT_ID", (Object)logProperty.getLogFormatId());
        row.set("START_TIME", (Object)(logProperty.getLastImport() - logProperty.getTimeTaken()));
        row.set("END_TIME", (Object)logProperty.getLastImport());
        row.set("LOG_START_TIME", (Object)logProperty.getLogStartsTime());
        row.set("LOG_END_TIME", (Object)logProperty.getLogEndsTime());
        row.set("NO_OF_LINE_READ", (Object)logProperty.getLineCount());
        row.set("CURRENT_LINE_READ", (Object)logProperty.getLineCount());
        row.set("RECORD_MARKER", (Object)logProperty.getRecordMarker());
        row.set("STATUS", (Object)logProperty.getStatus());
        row.set("TIME_TAKEN", (Object)logProperty.getTimeTaken());
        row.set("CONTENT_SIZE", (Object)logProperty.getSize());
        row.set("HEADER_FIELDS", (Object)logProperty.getHeaderLine());
        DataObject dataObject = DataAccess.constructDataObject();
        dataObject.addRow(row);
        DataAccess.add((DataObject)dataObject);
    }

    public static void migrateImportTrendTable() throws Exception {
        ArrayList<String> trendTableSkipList = new ArrayList<String>();
        trendTableSkipList.add("Oracle_Hr_Trend");
        trendTableSkipList.add("PrinterLogs_Hr_Trend");
        trendTableSkipList.add("Mssql_Audit_Hr_Trend");
        trendTableSkipList.add("TerminalServiceLogs_Hr_Trend");
        trendTableSkipList.add("ela_import_app_hr_trend_sa");
        DataObject dataObject = PERSISTENCELITE.get("FormatDetails", (Criteria)null);
        Iterator rows = dataObject.getRows("FormatDetails");
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            String trendTable = (String)row.get("HRTRENDTABLENAME");
            if (trendTableSkipList.contains(trendTable)) continue;
            if (trendTable != null) {
                if (MetaDataUtil.getTableDefinitionByName((String)trendTable) == null) {
                    ImportLogMigrationUtil.addAppTrendTableDefinition(trendTable);
                }
                ImportLogMigrationUtil.migrateTrendTable(trendTable);
                trendTableSkipList.add(trendTable);
            }
            row.set("HRTRENDTABLENAME", (Object)"ela_import_app_hr_trend_sa");
            row.set("ISTABLECREATED", (Object)1);
            dataObject.updateRow(row);
        }
        PERSISTENCELITE.update(dataObject);
    }

    private static void migrateTrendTable(String hrTrendTable) {
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)hrTrendTable));
            selectQuery.addSelectColumn(Column.getColumn((String)hrTrendTable, (String)"*"));
            selectQuery.setCriteria(null);
            int count = 0;
            selectQuery.setRange(new Range(0, 1000));
            DataObject hrDataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
            Iterator iterator = hrDataObject.getRows(hrTrendTable);
            while (true) {
                if (iterator.hasNext()) {
                    ++count;
                    Row hrTrendOldRow = (Row)iterator.next();
                    Row hrTrendNewRow = new Row("ela_import_app_hr_trend_sa");
                    hrTrendNewRow.set("APPID", hrTrendOldRow.get("APPID"));
                    hrTrendNewRow.set("HOUROFDAY", hrTrendOldRow.get("HOUROFDAY"));
                    hrTrendNewRow.set("HOUR", hrTrendOldRow.get("HOUR"));
                    hrTrendNewRow.set("CRITICAL_CNT", hrTrendOldRow.get("CRITICAL_CNT"));
                    hrTrendNewRow.set("ERROR_CNT", hrTrendOldRow.get("ERROR_CNT"));
                    hrTrendNewRow.set("WARNING_CNT", hrTrendOldRow.get("WARNING_CNT"));
                    hrTrendNewRow.set("INFORMATION_CNT", hrTrendOldRow.get("INFORMATION_CNT"));
                    hrTrendNewRow.set("TOTAL_CNT", hrTrendOldRow.get("TOTAL_CNT"));
                    dataObject.addRow(hrTrendNewRow);
                    continue;
                }
                PersistenceDBUtil.getPersistence().add(dataObject);
                dataObject = PersistenceDBUtil.getPersistence().constructDataObject();
                selectQuery.setRange(new Range(++count, 1000));
                hrDataObject = PersistenceDBUtil.getPersistence().get((SelectQuery)selectQuery);
                iterator = hrDataObject.getRows(hrTrendTable);
                if (!iterator.hasNext()) break;
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private static void addAppTrendTableDefinition(String trendTable) {
        try {
            TableDefinition tableDef = new TableDefinition(false);
            tableDef.setTableName(trendTable);
            ColumnDefinition idCol = new ColumnDefinition();
            idCol.setTableName(trendTable);
            idCol.setColumnName("ID");
            idCol.setDataType("BIGINT");
            UniqueValueGeneration uniqueValueGeneration = new UniqueValueGeneration();
            uniqueValueGeneration.setGeneratorName(trendTable + ".ID");
            idCol.setUniqueValueGeneration(uniqueValueGeneration);
            tableDef.addColumnDefinition(idCol);
            ColumnDefinition appID = new ColumnDefinition();
            appID.setTableName(trendTable);
            appID.setColumnName("APPID");
            appID.setDataType("BIGINT");
            appID.setNullable(false);
            appID.setUnique(false);
            tableDef.addColumnDefinition(appID);
            ColumnDefinition criticalCnt = new ColumnDefinition();
            criticalCnt.setTableName(trendTable);
            criticalCnt.setColumnName("CRITICAL_CNT");
            criticalCnt.setDataType("BIGINT");
            criticalCnt.setNullable(true);
            criticalCnt.setUnique(false);
            tableDef.addColumnDefinition(criticalCnt);
            ColumnDefinition errorCnt = new ColumnDefinition();
            errorCnt.setTableName(trendTable);
            errorCnt.setColumnName("ERROR_CNT");
            errorCnt.setDataType("BIGINT");
            errorCnt.setNullable(true);
            errorCnt.setUnique(false);
            tableDef.addColumnDefinition(errorCnt);
            ColumnDefinition warningCnt = new ColumnDefinition();
            warningCnt.setTableName(trendTable);
            warningCnt.setColumnName("WARNING_CNT");
            warningCnt.setDataType("BIGINT");
            warningCnt.setNullable(true);
            warningCnt.setUnique(false);
            tableDef.addColumnDefinition(warningCnt);
            ColumnDefinition infoCnt = new ColumnDefinition();
            infoCnt.setTableName(trendTable);
            infoCnt.setColumnName("INFORMATION_CNT");
            infoCnt.setDataType("BIGINT");
            infoCnt.setNullable(true);
            infoCnt.setUnique(false);
            tableDef.addColumnDefinition(infoCnt);
            ColumnDefinition totalCnt = new ColumnDefinition();
            totalCnt.setTableName(trendTable);
            totalCnt.setColumnName("TOTAL_CNT");
            totalCnt.setDataType("BIGINT");
            totalCnt.setNullable(true);
            totalCnt.setUnique(false);
            tableDef.addColumnDefinition(totalCnt);
            ColumnDefinition hourOfDay = new ColumnDefinition();
            hourOfDay.setTableName(trendTable);
            hourOfDay.setColumnName("HOUROFDAY");
            hourOfDay.setDataType("INTEGER");
            hourOfDay.setNullable(false);
            hourOfDay.setUnique(false);
            tableDef.addColumnDefinition(hourOfDay);
            ColumnDefinition dateTime = new ColumnDefinition();
            dateTime.setTableName(trendTable);
            dateTime.setColumnName("HOUR");
            dateTime.setDataType("DATETIME");
            dateTime.setNullable(true);
            dateTime.setUnique(false);
            tableDef.addColumnDefinition(dateTime);
            PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
            pkDef.setName(trendTable + "_PK");
            pkDef.setTableName(trendTable);
            pkDef.addColumnName("ID");
            tableDef.setPrimaryKey(pkDef);
            MetaDataUtil.addTableDefinition((String)"EventLogAnalyzer", (TableDefinition)tableDef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void updateSeqNumber(String tableName, String columnName) {
        try {
            Row row;
            Long newSeqNum;
            LOGGER.info("updating CURRENTBATCHEND for table : " + tableName);
            String seqGenName = MetaDataUtil.getTableDefinitionByName((String)tableName).getColumnDefinitionByName(columnName).getUniqueValueGeneration().getGeneratorName();
            LOGGER.info("sequence name : " + seqGenName);
            SortColumn sortColumn = new SortColumn(Column.getColumn((String)tableName, (String)columnName), false);
            DataObject dataObject = DataAccess.get((String)tableName, (Criteria)null);
            dataObject.sortRows(tableName, new SortColumn[]{sortColumn});
            Long l = newSeqNum = (Long)dataObject.getFirstValue(tableName, columnName);
            Long l2 = newSeqNum = Long.valueOf(newSeqNum + 1L);
            LOGGER.info("new CURRENTBATCHEND for table : " + tableName + " is : " + newSeqNum.toString());
            Criteria criteria = new Criteria(Column.getColumn((String)"SeqGenState", (String)"SEQNAME"), (Object)seqGenName, 0);
            dataObject = DataAccess.get((String)"SeqGenState", (Criteria)criteria);
            if (dataObject.isEmpty()) {
                row = new Row("SeqGenState");
                row.set("SEQNAME", (Object)seqGenName);
                row.set("CURRENTBATCHEND", (Object)newSeqNum);
                dataObject.addRow(row);
                DataAccess.add((DataObject)dataObject);
            } else {
                row = dataObject.getFirstRow("SeqGenState");
                row.set("CURRENTBATCHEND", (Object)newSeqNum);
                dataObject.updateRow(row);
                DataAccess.update((DataObject)dataObject);
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception occured while updating CURRENTBATCHEND for table : " + tableName);
            e.printStackTrace();
        }
    }

    public static void migrateLogFileImports() {
        long failedcount = 0L;
        ImportLogMigrationUtil.handleAppFgroupChanges();
        try {
            ImportLogMigrationUtil.alterReportTables();
            ImportLogMigrationUtil.updateMssqlServerLogFormat();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String oldImportLogTable_ImportedAppLogs = "ImportedAppLogs";
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)oldImportLogTable_ImportedAppLogs));
            selectQuery.addJoin(new Join(oldImportLogTable_ImportedAppLogs, "AppResources", new String[]{"APPID"}, new String[]{"APPID"}, 2));
            selectQuery.addJoin(new Join("AppResources", "FormatDetails", new String[]{"FORMATID"}, new String[]{"FORMATID"}, 2));
            selectQuery.addSelectColumn(Column.getColumn((String)oldImportLogTable_ImportedAppLogs, (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"*"));
            DataObject dataObject = DataAccess.get((SelectQuery)selectQuery);
            if (!dataObject.isEmpty()) {
                ImportScheduler importScheduler = new ImportScheduler();
                Iterator iterator = dataObject.getRows(oldImportLogTable_ImportedAppLogs);
                while (iterator.hasNext()) {
                    try {
                        JSONObject request;
                        Long protocolId;
                        String location;
                        JSONObject time = new JSONObject();
                        Row importedAppLogsRow = (Row)iterator.next();
                        Long appId = NumberUtils.toLong((String)String.valueOf(importedAppLogsRow.get("APPID")));
                        Long importId = (Long)importedAppLogsRow.get("IL_ID");
                        Criteria appIdCriteria = new Criteria(Column.getColumn((String)"AppResources", (String)"APPID"), (Object)appId, 0);
                        Row appResourceTableRow = dataObject.getRow("AppResources", appIdCriteria);
                        Long attachedDeviceId = null;
                        if (appResourceTableRow != null && (attachedDeviceId = (Long)appResourceTableRow.get("HOSTID")) <= 0L) continue;
                        Long formatId = NumberUtils.toLong((String)String.valueOf(importedAppLogsRow.get("FORMATID")));
                        String formatName = FormatIdentifier.getReportName(formatId);
                        if (formatName.equals("iis_w3cweb") || formatName.equals("iis_w3cftp")) {
                            IISConfigHandler.handleIISImport(attachedDeviceId);
                        }
                        Criteria formatIdCriteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATID"), (Object)formatId, 0);
                        Row formatDetailsRow = dataObject.getRow("FormatDetails", formatIdCriteria);
                        if (formatName.equalsIgnoreCase("mssql")) {
                            formatDetailsRow.set("FORMATNAME", (Object)"mssql_server_log");
                        }
                        String windowLogType = (String)importedAppLogsRow.get("LOG_TYPE");
                        String fileName = (String)importedAppLogsRow.get("FILE_NAME");
                        String localFileLocation = (String)importedAppLogsRow.get("LOCATION");
                        String importType = (String)importedAppLogsRow.get("IMPORT_TYPE");
                        String remoteClient = (String)importedAppLogsRow.get("REMOTE_CLIENT");
                        String protocolName = (String)importedAppLogsRow.get("PROTOCOL");
                        String importTime = (String)importedAppLogsRow.get("IMPORTED_TIME");
                        Timestamp startTime = (Timestamp)importedAppLogsRow.get("START_TIME");
                        Timestamp endTime = (Timestamp)importedAppLogsRow.get("END_TIME");
                        String fileSize = (String)importedAppLogsRow.get("SIZE");
                        if (fileSize != null) {
                            if (fileSize.endsWith("MB")) {
                                fileSize = String.valueOf((long)Double.parseDouble(fileSize.substring(0, fileSize.lastIndexOf(" MB"))) * 1024L * 1024L);
                            } else if (fileSize.endsWith("KB")) {
                                fileSize = String.valueOf((long)Double.parseDouble(fileSize.substring(0, fileSize.lastIndexOf(" KB"))) * 1024L);
                            } else if (fileSize.endsWith("Bytes")) {
                                fileSize = String.valueOf((long)Double.parseDouble(fileSize.substring(0, fileSize.lastIndexOf(" Bytes"))));
                            }
                        }
                        Long numberOfRecords = NumberUtils.toLong((String)String.valueOf(importedAppLogsRow.get("RECORDS")));
                        Long timeTaken = NumberUtils.toLong((String)String.valueOf(importedAppLogsRow.get("TIME_TAKEN")));
                        Long status = NumberUtils.toLong((String)String.valueOf(importedAppLogsRow.get("STATUS")));
                        Double totalParsedSize = NumberUtils.toDouble((String)String.valueOf(importedAppLogsRow.get("TOTAL_PARSED_SIZE")));
                        String recordMarker = (String)importedAppLogsRow.get("RECORD_MARKER");
                        String linkedDeviceName = importedAppLogsRow.get("REMOTE_HOSTNAME") != null ? URLDecoder.decode((String)importedAppLogsRow.get("REMOTE_HOSTNAME")) : null;
                        String username = importedAppLogsRow.get("REMOTE_USERNAME") != null ? URLDecoder.decode((String)importedAppLogsRow.get("REMOTE_USERNAME")) : null;
                        String password = importedAppLogsRow.get("REMOTE_PASSWORD") != null ? URLDecoder.decode((String)importedAppLogsRow.get("REMOTE_PASSWORD")) : null;
                        String remoteFileLocation = (String)importedAppLogsRow.get("REMOTE_DIR");
                        String remotePort = (String)importedAppLogsRow.get("FTPPORT");
                        Long timeInterval = (Long)importedAppLogsRow.get("TIME_INTERVAL");
                        String dynamicPatternStr = (String)importedAppLogsRow.get("DYNAMIC_PATTERN");
                        String headerRecord = (String)importedAppLogsRow.get("HEADER_RECORD");
                        String remoteDeviceName = null;
                        boolean isLinuxShare = false;
                        if (remoteFileLocation == null || remoteFileLocation.isEmpty()) {
                            location = localFileLocation;
                            if (location != null) {
                                if (location.startsWith("\\\\")) {
                                    location = location.substring(2);
                                    remoteDeviceName = location.substring(0, location.indexOf("\\"));
                                    location = location.substring(location.indexOf("\\") + 1);
                                } else {
                                    remoteDeviceName = linkedDeviceName;
                                    isLinuxShare = true;
                                }
                                location = location.replaceAll("\\\\", "/");
                                location = location.substring(0, location.lastIndexOf("/")) + "/" + fileName;
                            }
                        } else {
                            location = remoteFileLocation;
                            remoteDeviceName = linkedDeviceName;
                        }
                        ImportFile importFile = new ImportFile(location, 0);
                        importFile.setFilename(fileName);
                        DynamicPattern dynamicPattern = new DynamicPattern(dynamicPatternStr);
                        ArrayList<DynamicPattern> dynamicPatterns = new ArrayList<DynamicPattern>();
                        dynamicPatterns.add(dynamicPattern);
                        PatternDetailsBean patternDetailsBean = new PatternDetailsBean(dynamicPatterns);
                        importFile.setPatternDetailsBean(patternDetailsBean);
                        LogProperties logProperty = new LogProperties(importFile);
                        logProperty.setRecordMarker(recordMarker);
                        logProperty.setAppId(appId);
                        logProperty.setSize(NumberUtils.toLong((String)fileSize));
                        logProperty.setLastImport(importTime != null ? Long.valueOf(dateFormat.parse(importTime).getTime()) : null);
                        logProperty.setLogStartsTime(startTime != null ? Long.valueOf(startTime.getTime()) : null);
                        logProperty.setLogEndsTime(endTime != null ? Long.valueOf(endTime.getTime()) : null);
                        logProperty.setReportId(formatId);
                        logProperty.setLinuxShare(isLinuxShare);
                        logProperty.setHeaderLine(headerRecord);
                        Long importFormatId = FormatIdentifier.getFormatId(formatId);
                        if (importFormatId == -4L) {
                            importFormatId = ImportLogMigrationUtil.addNewFormat(formatName);
                        }
                        logProperty.setLogFormatId(importFormatId);
                        logProperty.setWindowsLogType(windowLogType);
                        logProperty.setLineCount(numberOfRecords);
                        if (timeTaken != null) {
                            logProperty.setTimeTaken(timeTaken);
                        } else {
                            logProperty.setTimeTaken(0L);
                        }
                        logProperty.setAppId(appId);
                        if (remoteDeviceName != null) {
                            logProperty.setLinkedDeviceName(remoteDeviceName);
                        } else if (linkedDeviceName == null || linkedDeviceName.isEmpty()) {
                            if (remoteClient != null) {
                                logProperty.setLinkedDeviceName(remoteClient);
                            } else {
                                logProperty.setLinkedDeviceName(InetAddress.getLocalHost().getHostName());
                            }
                        } else {
                            logProperty.setLinkedDeviceName(linkedDeviceName);
                        }
                        logProperty.setDeviceId(attachedDeviceId);
                        ScheduleUtil.Frequency executeFrequencyType = ScheduleUtil.Frequency.EVERY;
                        Long timeIntervalValue = 10L;
                        if (timeInterval == null || timeInterval < 0L) {
                            if (importType.equals("remote")) {
                                executeFrequencyType = ScheduleUtil.Frequency.ONCE;
                                time.put("SCHEDULE_AT", System.currentTimeMillis());
                            } else {
                                time = null;
                            }
                        } else if (timeInterval == 60L) {
                            executeFrequencyType = ScheduleUtil.Frequency.HOURLY;
                            time.put("MINUTES", 0);
                        } else if (timeInterval == 1440L) {
                            executeFrequencyType = ScheduleUtil.Frequency.DAILY;
                            time.put("MINUTES", 0);
                            time.put("HOURS", 0);
                        } else {
                            executeFrequencyType = ScheduleUtil.Frequency.EVERY;
                            time.put("EVERY_MINUTES", (Object)timeInterval);
                        }
                        switch (protocolName) {
                            case "FTP": {
                                protocolId = ImportProtocolUtils.getProtocolId("FTP");
                                break;
                            }
                            case "SFTP": 
                            case "SSH": 
                            case "SFTP/SSH": {
                                protocolId = ImportProtocolUtils.getProtocolId("SFTP");
                                break;
                            }
                            default: {
                                protocolId = ImportProtocolUtils.getProtocolId("SMB-Windows");
                            }
                        }
                        ImportProtocolBean importProtocolBean = logProperty.getImportProtocolBean();
                        importProtocolBean.setUsername(username);
                        importProtocolBean.setPassword(password);
                        importProtocolBean.setProtocolId(protocolId);
                        if (remotePort != null && !remotePort.isEmpty()) {
                            importProtocolBean.setPort(Integer.parseInt(remotePort));
                        }
                        logProperty.setImportProtocolBean(importProtocolBean);
                        switch (Math.toIntExact(status)) {
                            case 1011: {
                                logProperty.setStatus(12193L);
                                break;
                            }
                            case 1004: {
                                logProperty.setStatus(12196L);
                                break;
                            }
                            case 1005: {
                                logProperty.setStatus(12197L);
                                break;
                            }
                            case 1012: 
                            case 1013: {
                                logProperty.setStatus(12199L);
                            }
                            default: {
                                logProperty.setStatus(12196L);
                            }
                        }
                        if (time == null) {
                            request = null;
                        } else {
                            request = new JSONObject();
                            request.put("SCHEDULE_DISPLAY_NAME", (Object)("ImportOldSChedule_" + importId.toString()));
                            request.put("SCHEDULE_CLASS", (Object)ImportScheduler.class.getCanonicalName());
                            request.put("TIME", (Object)time);
                            request.put("FREQUENCY", executeFrequencyType.getValue());
                            request.put("EMAIL_SUBJECT", (Object)"Import log schedule");
                        }
                        Long scheduleId = ImportLogMigrationUtil.addAndGetScheduleId(request, TechnicianUtil.getDefaultAdminUserID(), ResourceBundleMgr.getInstance().getServerLocale());
                        importScheduler.schedule(logProperty, scheduleId, false);
                        ImportLogMigrationUtil.addAuditDetails(logProperty);
                        dataObject.updateRow(formatDetailsRow);
                        DataAccess.update((DataObject)dataObject);
                    }
                    catch (Exception e) {
                        ++failedcount;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info("IMPLOG : " + failedcount + " imports could not be migrated");
        ImportLogMigrationUtil.updateSeqNumber("FormatFields", "FIELDID");
        ImportLogMigrationUtil.migrateEvtFileImports();
    }

    private static void updateMssqlServerLogFormat() {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)"mssql", 0);
            DataObject dataObject = PERSISTENCELITE.get("FormatDetails", criteria);
            Row row = dataObject.getRow("FormatDetails");
            row.set("FORMATNAME", (Object)"mssql_server_log");
            dataObject.updateRow(row);
            PERSISTENCELITE.update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void migrateEvtFileImports() {
        try {
            String oldImportLogTable_ImportedEvtLogs = "ImportedLogs";
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)oldImportLogTable_ImportedEvtLogs));
            selectQuery.addSelectColumn(Column.getColumn((String)oldImportLogTable_ImportedEvtLogs, (String)"*"));
            DataObject dataObject = DataAccess.get((SelectQuery)selectQuery);
            if (!dataObject.isEmpty()) {
                ImportScheduler importScheduler = new ImportScheduler();
                Iterator iterator = dataObject.getRows(oldImportLogTable_ImportedEvtLogs);
                while (iterator.hasNext()) {
                    try {
                        JSONObject request;
                        Long protocolId;
                        String location;
                        JSONObject time = new JSONObject();
                        Row importedLogsRow = (Row)iterator.next();
                        Long formatId = (Long)importedLogsRow.get("FORMATID");
                        Long importId = (Long)importedLogsRow.get("IL_ID");
                        Long attachedDeviceId = (Long)importedLogsRow.get("HOST_ID");
                        if (attachedDeviceId == null || attachedDeviceId <= 0L) {
                            attachedDeviceId = DeviceUtil.addAndGetDeviceId(InetAddressHandler.getLocalHost().getHostName(), LogSourceCategoryContainer.DeviceCategory.WINDOWS);
                        }
                        Long appId = ApplicationUtil.addAndGetAppId(attachedDeviceId, formatId);
                        String windowLogType = (String)importedLogsRow.get("LOG_TYPE");
                        String fileName = (String)importedLogsRow.get("FILE_NAME");
                        String localFileLocation = (String)importedLogsRow.get("LOCATION");
                        String importType = (String)importedLogsRow.get("IMPORT_TYPE");
                        String protocolName = (String)importedLogsRow.get("PROTOCOL");
                        String remoteClient = (String)importedLogsRow.get("REMOTE_CLIENT");
                        Timestamp importTime = (Timestamp)importedLogsRow.get("IMPORTED_TIME");
                        Timestamp startTime = (Timestamp)importedLogsRow.get("START_TIME");
                        Timestamp endTime = (Timestamp)importedLogsRow.get("END_TIME");
                        Long numberOfRecords = NumberUtils.toLong((String)String.valueOf(importedLogsRow.get("RECORDS")));
                        String linkedDeviceName = importedLogsRow.get("REMOTE_HOSTNAME") != null && !importedLogsRow.get("REMOTE_HOSTNAME").equals("-") ? URLDecoder.decode((String)importedLogsRow.get("REMOTE_HOSTNAME")) : null;
                        String username = importedLogsRow.get("REMOTE_USERNAME") != null && !importedLogsRow.get("REMOTE_USERNAME").equals("-") ? URLDecoder.decode((String)importedLogsRow.get("REMOTE_USERNAME")) : null;
                        String password = importedLogsRow.get("REMOTE_PASSWORD") != null && !importedLogsRow.get("REMOTE_PASSWORD").equals("-") ? URLDecoder.decode((String)importedLogsRow.get("REMOTE_PASSWORD")) : null;
                        String remoteFileLocation = (String)importedLogsRow.get("REMOTE_DIR");
                        int remotePort = (Integer)importedLogsRow.get("FTPPORT");
                        Long timeInterval = (Long)importedLogsRow.get("TIME_INTERVAL");
                        String remoteDeviceName = null;
                        if (remoteFileLocation == null || remoteFileLocation.isEmpty()) {
                            location = localFileLocation;
                            if (location != null) {
                                if (location.startsWith("\\\\")) {
                                    location = location.substring(2);
                                    remoteDeviceName = location.substring(0, location.indexOf("\\"));
                                    location = location.substring(location.indexOf("\\") + 1);
                                }
                                location = location.replaceAll("\\\\", "/");
                                location = location.substring(0, location.lastIndexOf("/")) + "/" + fileName;
                            }
                        } else {
                            location = remoteFileLocation;
                            remoteDeviceName = linkedDeviceName;
                        }
                        ImportFile importFile = new ImportFile(location, 0);
                        importFile.setFilename(fileName);
                        LogProperties logProperty = new LogProperties(importFile);
                        logProperty.setAppId(appId);
                        logProperty.setLastImport(importTime != null ? Long.valueOf(importTime.getTime()) : null);
                        logProperty.setLogStartsTime(startTime != null ? Long.valueOf(startTime.getTime()) : null);
                        logProperty.setLogEndsTime(endTime != null ? Long.valueOf(endTime.getTime()) : null);
                        logProperty.setReportId(formatId);
                        logProperty.setLogFormatId(FormatIdentifier.getFormatId(formatId));
                        logProperty.setWindowsLogType(windowLogType);
                        logProperty.setLineCount(numberOfRecords);
                        logProperty.setAppId(appId);
                        if (remoteDeviceName != null) {
                            logProperty.setLinkedDeviceName(remoteDeviceName);
                        } else if (linkedDeviceName == null || linkedDeviceName.isEmpty()) {
                            if (remoteClient != null) {
                                logProperty.setLinkedDeviceName(remoteClient);
                            } else {
                                logProperty.setLinkedDeviceName(InetAddress.getLocalHost().getHostName());
                            }
                        } else {
                            logProperty.setLinkedDeviceName(linkedDeviceName);
                        }
                        logProperty.setDeviceId(attachedDeviceId);
                        ScheduleUtil.Frequency executeFrequencyType = ScheduleUtil.Frequency.EVERY;
                        Long timeIntervalValue = 10L;
                        if (timeInterval == null || timeInterval < 0L) {
                            if (importType.equals("remote")) {
                                executeFrequencyType = ScheduleUtil.Frequency.ONCE;
                                time.put("SCHEDULE_AT", System.currentTimeMillis());
                            } else {
                                time = null;
                            }
                        } else if (timeInterval < 1440L) {
                            executeFrequencyType = ScheduleUtil.Frequency.EVERY;
                            timeIntervalValue = Math.round((double)timeInterval.longValue() * 1.0 / 5.0) * 5L;
                            time.put("EVERY_MINUTES", (Object)timeIntervalValue);
                        } else {
                            executeFrequencyType = ScheduleUtil.Frequency.EVERY;
                            timeIntervalValue = 1410L;
                            time.put("EVERY_MINUTES", (Object)timeIntervalValue);
                        }
                        switch (protocolName) {
                            case "FTP": {
                                protocolId = ImportProtocolUtils.getProtocolId("FTP");
                                break;
                            }
                            case "SFTP": 
                            case "SSH": 
                            case "SFTP/SSH": {
                                protocolId = ImportProtocolUtils.getProtocolId("SFTP");
                                break;
                            }
                            default: {
                                protocolId = ImportProtocolUtils.getProtocolId("SMB-Windows");
                            }
                        }
                        ImportProtocolBean importProtocolBean = logProperty.getImportProtocolBean();
                        importProtocolBean.setUsername(username);
                        importProtocolBean.setPassword(password);
                        importProtocolBean.setProtocolId(protocolId);
                        importProtocolBean.setPort(remotePort);
                        logProperty.setImportProtocolBean(importProtocolBean);
                        if (importedLogsRow.get("MESSAGE") != null && importedLogsRow.get("MESSAGE").toString().contains("Importing of Evt File is over")) {
                            logProperty.setStatus(12196L);
                        } else {
                            logProperty.setStatus(12197L);
                        }
                        if (time == null) {
                            request = null;
                        } else {
                            request = new JSONObject();
                            request.put("SCHEDULE_DISPLAY_NAME", (Object)("ImportEvtOldSChedule_" + importId.toString()));
                            request.put("SCHEDULE_CLASS", (Object)ImportScheduler.class.getCanonicalName());
                            request.put("TIME", (Object)time);
                            request.put("FREQUENCY", executeFrequencyType.getValue());
                            request.put("EMAIL_SUBJECT", (Object)"Import log schedule");
                        }
                        Long scheduleId = ImportLogMigrationUtil.addAndGetScheduleId(request, TechnicianUtil.getDefaultAdminUserID(), ResourceBundleMgr.getInstance().getServerLocale());
                        importScheduler.schedule(logProperty, scheduleId, false);
                        ImportLogMigrationUtil.addAuditDetails(logProperty);
                        DataAccess.update((DataObject)dataObject);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void alterReportTables() {
        try {
            ArrayList<String> alteredTableList = new ArrayList<String>();
            alteredTableList.add("sys_archive_reports_hr_trend_sa");
            alteredTableList.add("ibm_as400_reports_hr_trend_sa");
            alteredTableList.add("win_archive_reports_hr_trend_sa");
            DataObject dataObject = PERSISTENCELITE.get("FormatDetails", (Criteria)null);
            Iterator rows = dataObject.getRows("FormatDetails");
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                String reportTableName = (String)row.get("REPORTTABLENAME");
                if (!alteredTableList.contains(reportTableName)) {
                    ImportLogMigrationUtil.alterReportTable(reportTableName);
                }
                alteredTableList.add(reportTableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void alterReportTable(String reportTableName) {
        if (reportTableName == null) {
            return;
        }
        ColumnDefinition importedTime = new ColumnDefinition();
        importedTime.setTableName(reportTableName);
        importedTime.setColumnName("IMPORTED_TIME");
        importedTime.setDataType("BIGINT");
        importedTime.setNullable(true);
        importedTime.setUnique(false);
        ColumnDefinition isThrowAway = new ColumnDefinition();
        isThrowAway.setTableName(reportTableName);
        isThrowAway.setColumnName("IS_THROWAWAY");
        isThrowAway.setDataType("CHAR");
        isThrowAway.setNullable(true);
        isThrowAway.setUnique(false);
        AlterTableQueryImpl alterTableQuery = new AlterTableQueryImpl(reportTableName);
        try {
            alterTableQuery.addColumn(importedTime);
            alterTableQuery.addColumn(isThrowAway);
            RelationalAPI.getInstance().alterTable((AlterTableQuery)alterTableQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Long addNewFormat(String format) {
        try {
            DataObject dataObject = PERSISTENCELITE.constructDataObject();
            Row logFormatRow = new Row("Parser_LogFormats");
            logFormatRow.set("FORMAT_NAME", (Object)format);
            logFormatRow.set("FORMAT_DESC", (Object)format);
            logFormatRow.set("USER_DEFINED", (Object)true);
            logFormatRow.set("IS_FILE_IMPORT_SUPPORTED", (Object)true);
            dataObject.addRow(logFormatRow);
            PERSISTENCELITE.add(dataObject);
            return (Long)dataObject.getFirstValue("Parser_LogFormats", "FORMAT_ID");
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return -4L;
        }
    }

    private static long addAndGetScheduleId(JSONObject scheduleParams, Long userId, Locale locale) throws Exception {
        Long scheduleInstanceId;
        if (scheduleParams == null) {
            scheduleInstanceId = -1L;
        } else {
            String scheduleName = "Import_old_schedule" + String.valueOf(System.currentTimeMillis());
            scheduleParams.put("SCHEDULE_DISPLAY_NAME", (Object)("ImportSchedule_" + scheduleName));
            scheduleParams.put("SCHEDULE_CLASS", (Object)ImportScheduler.class.getCanonicalName());
            scheduleParams.remove("SCHEDULE_NAME");
            DataObject scheduleDataObject = ScheduleUtil.getNewScheduleDO(scheduleParams, userId, locale);
            DataAccess.update((DataObject)scheduleDataObject);
            scheduleInstanceId = (Long)scheduleDataObject.getFirstValue("ELATableExportSchedules", "EXPORT_ID");
        }
        return scheduleInstanceId;
    }

    public static void handleAppFgroupChanges() {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"AppResources"));
            Join join = new Join("AppResources", "FormatDetails", new String[]{"FORMATID"}, new String[]{"FORMATID"}, 2);
            selectQuery.addJoin(join);
            selectQuery.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)"FormatDetails", (String)"*"));
            selectQuery.setCriteria(null);
            DataObject dataObject = DataAccess.get((SelectQuery)selectQuery);
            Iterator approws = dataObject.getRows("AppResources");
            while (approws.hasNext()) {
                Row appRow = (Row)approws.next();
                Row formatRow = dataObject.getRow("FormatDetails", appRow, join);
                String fGroup = (String)appRow.get("FGROUP");
                if (fGroup.equals("iis")) {
                    appRow.set("FGROUP", formatRow.get("FORMATNAME"));
                }
                if (fGroup.equals("mssql")) {
                    appRow.set("FGROUP", (Object)"mssql_server_log");
                }
                if (fGroup.equals("unsupported_apps")) {
                    appRow.set("FGROUP", formatRow.get("FORMATNAME"));
                }
                dataObject.updateRow(appRow);
            }
            DataAccess.update((DataObject)dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getUVHFromFormatName(String formatName) {
        return formatNameUvhMap.get(formatName);
    }

    public static void updateFormatId(DataObject diffDataObject, Long formatId, String formatName) {
        Criteria criteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)formatName, 0);
        Criteria formatIdCriteria = new Criteria(Column.getColumn((String)"FormatToReportMapping", (String)"FORMATID"), (Object)formatId, 0);
        try {
            DBUtil.deleteExistingRows("FormatToReportMapping", formatIdCriteria, new boolean[0]);
            Iterator formatToReportMappingIterator = diffDataObject.getRows("FormatToReportMapping", criteria);
            while (formatToReportMappingIterator.hasNext()) {
                Row formatToReportMappingRow = (Row)formatToReportMappingIterator.next();
                formatToReportMappingRow.set("FORMATID", (Object)formatId);
                diffDataObject.updateRow(formatToReportMappingRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        formatNameUvhMap.put("apache_logs", "FormatDetails:FORMATID:150");
        formatNameUvhMap.put("cisco_archive", "FormatDetails:FORMATID:160");
        formatNameUvhMap.put("csv_file", "FormatDetails:FORMATID:170");
        formatNameUvhMap.put("dhcp_linux", "FormatDetails:FORMATID:180");
        formatNameUvhMap.put("dhcp_windows", "FormatDetails:FORMATID:190");
        formatNameUvhMap.put("eventlog_serverout", "FormatDetails:FORMATID:200");
        formatNameUvhMap.put("ibm_as400", "FormatDetails:FORMATID:210");
        formatNameUvhMap.put("ibm_maximo", "FormatDetails:FORMATID:220");
        formatNameUvhMap.put("iis_w3cftp", "FormatDetails:FORMATID:230");
        formatNameUvhMap.put("iis_w3cweb", "FormatDetails:FORMATID:240");
        formatNameUvhMap.put("mssql_server_log", "FormatDetails:FORMATID:250");
        formatNameUvhMap.put("sys_archive", "FormatDetails:FORMATID:260");
        formatNameUvhMap.put("syslog", "FormatDetails:FORMATID:270");
        formatNameUvhMap.put("win_archive", "FormatDetails:FORMATID:280");
    }
}

