/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import com.manageengine.ela.server.common.credential.Credential;
import com.manageengine.ela.server.common.credential.CredentialHandler;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternDetailsBean;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import com.manageengine.ela.server.common.util.JSONUtil;
import com.manageengine.ela.server.importlog.ImportFile;
import com.manageengine.ela.server.importlog.ImportFilters;
import com.manageengine.ela.server.importlog.ImportLogManager;
import com.manageengine.ela.server.importlog.ImportUtils;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImportScheduler
implements Task {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Persistence PERSISTENCE = PersistenceDBUtil.getPersistence();
    private static final Logger LOGGER = Logger.getLogger(ImportScheduler.class.getName());
    private static ImportLogManager importLogManager = null;
    private static Boolean isSuspended = false;

    public static Boolean getIsSuspended() {
        return isSuspended;
    }

    public static void setIsSuspended(Boolean isSuspended) {
        ImportScheduler.isSuspended = isSuspended;
    }

    public ImportScheduler() throws IllegalAccessException {
        if (importLogManager == null) {
            importLogManager = ImportLogManager.getInstance();
        }
    }

    public boolean schedule(ArrayList<LogProperties> logProperties) throws BaseStatusCode {
        return this.schedule(logProperties, null, null, null);
    }

    public boolean schedule(ArrayList<LogProperties> logProperties, JSONObject scheduleParams, Long userId, Locale locale) throws BaseStatusCode {
        if (isSuspended.booleanValue()) {
            LOGGER.info("IMPLOG : Importing File(s) are suspended now. Possible reasons are 1.Low Disk space, 2.Licence Expired");
            throw BaseStatusCode.getBaseStatusCode(12036);
        }
        for (LogProperties logProperty : logProperties) {
            Long scheduleId;
            try {
                scheduleId = this.addAndGetScheduleID(scheduleParams, userId, locale);
            }
            catch (Exception e) {
                LOGGER.info("unable to add schedule");
                scheduleId = -1L;
            }
            this.schedule(logProperty, scheduleId, true);
        }
        return true;
    }

    public long addAndGetScheduleID(JSONObject scheduleParams, Long userId, Locale locale) throws Exception {
        Long scheduleInstanceId;
        if (scheduleParams == null) {
            scheduleInstanceId = -1L;
        } else {
            String scheduleName = "Import_new_schedule" + String.valueOf(System.currentTimeMillis());
            scheduleParams.put("SCHEDULE_DISPLAY_NAME", (Object)("ImportSchedule_" + scheduleName));
            scheduleParams.put("SCHEDULE_CLASS", (Object)ImportScheduler.class.getCanonicalName());
            scheduleParams.remove("SCHEDULE_NAME");
            DataObject scheduleDataObject = ScheduleUtil.getNewScheduleDO(scheduleParams, userId, locale);
            PersistenceDBUtil.getScheduler().updateSchedule(scheduleDataObject);
            scheduleInstanceId = (Long)scheduleDataObject.getFirstValue("ELATableExportSchedules", "EXPORT_ID");
        }
        return scheduleInstanceId;
    }

    public boolean schedule(LogProperties logProperty, Long scheduleInstanceId, boolean executeImmediately) {
        try {
            Long credentialId = null;
            DataObject dataObject = PERSISTENCE.constructDataObject();
            ImportProtocolBean importProtocolBean = logProperty.getImportProtocolBean();
            if (importProtocolBean.getUsername() != null) {
                Credential credential = CredentialHandler.getCustomCredential(importProtocolBean.getUsername(), importProtocolBean.getPassword(), null, null);
                CredentialHandler.createNewCredentialEntry(credential, false);
                credentialId = credential.getCredentialID();
            }
            Row importSourceConfigRow = ImportScheduler.getImportSourceConfigRow(logProperty, importProtocolBean, credentialId);
            Row importLogConfigurations = this.getImportConfigRow(logProperty, scheduleInstanceId, importSourceConfigRow);
            PatternDetailsBean patternDetailsBean = logProperty.getDynamicPatternDetails();
            if (patternDetailsBean != null && patternDetailsBean.getDynamicPatterns() != null) {
                for (DynamicPattern dynamicPattern : patternDetailsBean.getDynamicPatterns()) {
                    Row dynamicPatternRow = new Row("ELADynamicPatterns");
                    dynamicPatternRow.set("RESOLVER_ID", (Object)PatternUtils.getDynamicPatternResolverId(dynamicPattern.getDynamicPattern()));
                    dynamicPatternRow.set("SOURCE_ID", importSourceConfigRow.get("SOURCE_ID"));
                    dynamicPatternRow.set("DYNAMIC_PATTERN", (Object)dynamicPattern.getDynamicPattern());
                    dynamicPatternRow.set("TIME_ZONE", (Object)dynamicPattern.getTimeZone().getID());
                    dataObject.addRow(dynamicPatternRow);
                }
            }
            dataObject.addRow(importSourceConfigRow);
            dataObject.addRow(importLogConfigurations);
            PERSISTENCE.add(dataObject);
            logProperty.setSourceId(Long.parseLong(importSourceConfigRow.get("SOURCE_ID").toString()));
            if (logProperty.getImportFilters() != null) {
                logProperty.getImportFilters().addFiltersToDatabase(importLogConfigurations.get("IMPORT_ID"));
            }
            if (executeImmediately) {
                Column column = Column.getColumn((String)"ELAImportLogConfigurations", (String)"IMPORT_ID");
                Criteria criteria = new Criteria(column, importLogConfigurations.get("IMPORT_ID"), 0);
                this.executeSchedule(criteria);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                logProperty.setStatus(12197L);
                ImportUtils.updateDb(logProperty);
            }
            catch (DataAccessException e1) {
                e1.printStackTrace();
            }
        }
        return true;
    }

    private Row getImportConfigRow(LogProperties logProperty, Long scheduleInstanceId, Row importSourceConfigurationRow) {
        Row importLogConfigurations = new Row("ELAImportLogConfigurations");
        importLogConfigurations.set("SCHEDULE_ID", (Object)scheduleInstanceId);
        importLogConfigurations.set("FORMAT_LOCALE_MAP_ID", (Object)logProperty.getLogFormatId());
        importLogConfigurations.set("SOURCE_ID", importSourceConfigurationRow.get("SOURCE_ID"));
        importLogConfigurations.set("IMPORT_TYPE", (Object)logProperty.getFileSourceType());
        importLogConfigurations.set("IS_THROWAWAY", (Object)logProperty.isThrowAway());
        if (logProperty.getStatus() == 0L) {
            importLogConfigurations.set("IMPORT_STATUS", (Object)12194L);
        } else {
            importLogConfigurations.set("IMPORT_STATUS", (Object)logProperty.getStatus());
        }
        return importLogConfigurations;
    }

    private static Row getImportSourceConfigRow(LogProperties logProperty, ImportProtocolBean importProtocolBean, Long credentialId) throws DataAccessException {
        Row importSourceConfigurationRow = new Row("ELAImportSourceConfigurations");
        importSourceConfigurationRow.set("PROTOCOL_ID", (Object)importProtocolBean.getProtocolId());
        importSourceConfigurationRow.set("APP_ID", (Object)logProperty.getAppId());
        importSourceConfigurationRow.set("REMOTE_DEVICE_ID", (Object)ImportScheduler.addAndGetRemoteDeviceId(logProperty.getLinkedDeviceName(), credentialId));
        importSourceConfigurationRow.set("ATTACHED_DEVICE_ID", (Object)logProperty.getAttachedDeviceId());
        importSourceConfigurationRow.set("CUSTOM_PORT", (Object)importProtocolBean.getPort());
        importSourceConfigurationRow.set("FILE_NAME", (Object)logProperty.getFileName());
        importSourceConfigurationRow.set("DIRECTORY", (Object)logProperty.getFileDirectory());
        importSourceConfigurationRow.set("IS_LINUX_SHARE", (Object)logProperty.isLinuxShare());
        if (logProperty.getSize() != null && logProperty.getSize() > 0L) {
            importSourceConfigurationRow.set("SIZE", (Object)logProperty.getSize());
        }
        return importSourceConfigurationRow;
    }

    private static Long addAndGetRemoteDeviceId(String deviceName, Long credentialId) throws DataAccessException {
        Row row = new Row("ElaImportRemoteDeviceConfiguration");
        row.set("CREDENTIAL_ID", (Object)credentialId);
        row.set("COMPUTER_NAME", (Object)deviceName);
        DataObject dataObject = PERSISTENCE.constructDataObject();
        dataObject.addRow(row);
        PERSISTENCE.update(dataObject);
        return (Long)dataObject.getFirstValue("ElaImportRemoteDeviceConfiguration", "REMOTE_DEVICE_ID");
    }

    public void updateSchedule(ArrayList<Long> importIds, JSONObject updateParams, Long userId, Locale locale) throws Exception {
        for (Long importId : importIds) {
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(importId);
            list = ImportUtils.getScheduleInstanceIds(list);
            Long exportId = list.size() > 0 ? list.get(0) : Long.valueOf(-1L);
            if (updateParams != null && updateParams.length() > 0) {
                UpdateQueryImpl updateQuery;
                LogProperties logProperties = new LogProperties(importId);
                if (!updateParams.isNull("LOG_FORMATID")) {
                    UpdateQueryImpl updateQuery2 = new UpdateQueryImpl("ELAImportLogConfigurations");
                    Column column = Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID");
                    Criteria formatCriteria = new Criteria(column, (Object)importId, 0);
                    updateQuery2.setCriteria(formatCriteria);
                    updateQuery2.setUpdateColumn("FORMAT_LOCALE_MAP_ID", (Object)updateParams.getLong("LOG_FORMATID"));
                    PERSISTENCE.update((UpdateQuery)updateQuery2);
                    this.executeSchedule(formatCriteria);
                    return;
                }
                if (!updateParams.isNull("DYNAMIC_FILENAME")) {
                    this.executeSchedule(new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID"), (Object)importId, 0));
                    String dynamicPatternStr = updateParams.getString("DYNAMIC_FILENAME");
                    Criteria sourceIdCriteria = new Criteria(Column.getColumn((String)"ELADynamicPatterns", (String)"SOURCE_ID"), (Object)logProperties.getSourceId(), 0);
                    DataObject dataObject = PERSISTENCE.get("ELADynamicPatterns", sourceIdCriteria);
                    if (dataObject.isEmpty()) {
                        dataObject = PERSISTENCE.constructDataObject();
                        Row dynamicPatternRow = new Row("ELADynamicPatterns");
                        dynamicPatternRow.set("RESOLVER_ID", (Object)PatternUtils.getDynamicPatternResolverId(dynamicPatternStr));
                        dynamicPatternRow.set("SOURCE_ID", (Object)logProperties.getSourceId());
                        dynamicPatternRow.set("DYNAMIC_PATTERN", (Object)dynamicPatternStr);
                        dynamicPatternRow.set("TIME_ZONE", (Object)TimeZone.getDefault().getID());
                        dataObject.addRow(dynamicPatternRow);
                        PERSISTENCE.add(dataObject);
                    } else {
                        updateQuery = new UpdateQueryImpl("ELADynamicPatterns");
                        updateQuery.setCriteria(sourceIdCriteria);
                        updateQuery.setUpdateColumn("DYNAMIC_PATTERN", (Object)dynamicPatternStr);
                        PERSISTENCE.update((UpdateQuery)updateQuery);
                    }
                }
                if (!updateParams.isNull("SCHEDULE_PARAMS")) {
                    Boolean removeSchedule;
                    JSONObject scheduleParams = updateParams.getJSONObject("SCHEDULE_PARAMS");
                    JSONObject oldScheduleInfo = ScheduleUtil.getScheduleInfo(exportId);
                    if (!scheduleParams.has("EXPORT_ID")) {
                        scheduleParams.put("EXPORT_ID", (Object)exportId);
                    }
                    if ((removeSchedule = Boolean.valueOf(scheduleParams.optBoolean("IS_SCHEDULE_DISABLED", false))).booleanValue()) {
                        JSONObject time = new JSONObject();
                        time.put("TYPE", 0);
                        time.put("SCHEDULE_AT", System.currentTimeMillis());
                        scheduleParams.put("FREQUENCY", 0);
                        scheduleParams.put("TIME", (Object)time);
                    }
                    if (oldScheduleInfo.getInt("FREQUENCY") == ScheduleUtil.Frequency.ONCE.getValue() && scheduleParams.getInt("FREQUENCY") != ScheduleUtil.Frequency.ONCE.getValue()) {
                        ScheduleUtil.deleteSchedule(new JSONArray().put(oldScheduleInfo.getLong("SCHEDULE_ID")));
                        scheduleParams.put("SCHEDULE_CLASS", (Object)ImportScheduler.class.getCanonicalName());
                        scheduleParams.put("SCHEDULE_DISPLAY_NAME", (Object)("Import_new_schedule" + String.valueOf(System.currentTimeMillis())));
                        DataObject newScheduleDobj = ScheduleUtil.getNewScheduleDO(scheduleParams, userId, locale);
                        PersistenceDBUtil.getScheduler().updateSchedule(newScheduleDobj);
                        exportId = (Long)newScheduleDobj.getFirstValue("ELATableExportSchedules", "EXPORT_ID");
                    } else {
                        scheduleParams.put("SCHEDULE_CLASS", (Object)ImportScheduler.class.getCanonicalName());
                        if (scheduleParams.getInt("FREQUENCY") == ScheduleUtil.Frequency.EVERY.getValue()) {
                            scheduleParams.put("TIME", (Object)scheduleParams.getJSONObject("TIME").put("HOURS", 0).put("MINUTES", 0));
                        }
                        DataObject updateScheduleDobj = ScheduleUtil.getUpdatedScheduleDO(scheduleParams);
                        exportId = (Long)updateScheduleDobj.getFirstValue("ELATableExportSchedules", "EXPORT_ID");
                        PersistenceDBUtil.getScheduler().updateSchedule(updateScheduleDobj);
                    }
                    updateQuery = new UpdateQueryImpl("ELAImportLogConfigurations");
                    updateQuery.setUpdateColumn("SCHEDULE_ID", (Object)exportId);
                    Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID"), (Object)importId, 0);
                    updateQuery.setCriteria(criteria);
                    PERSISTENCE.update((UpdateQuery)updateQuery);
                }
                if (!updateParams.isNull("IS_DEFAULT_CREDENTIAL")) {
                    boolean isDefaultCredential = updateParams.getBoolean("IS_DEFAULT_CREDENTIAL");
                    Long credentialId = null;
                    DataObject dataObject = PERSISTENCE.get(Arrays.asList("ELAImportSourceConfigurations", "ElaImportRemoteDeviceConfiguration"), new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)importId, 0));
                    if (!isDefaultCredential) {
                        Credential credential;
                        String customUsername = updateParams.getString("CUSTOM_USERNAME");
                        String customPassword = updateParams.getString("CUSTOM_PASSWORD");
                        credentialId = (Long)dataObject.getFirstValue("ElaImportRemoteDeviceConfiguration", "CREDENTIAL_ID");
                        if (!dataObject.isEmpty() && credentialId != null) {
                            credential = CredentialHandler.getCustomCredential(customUsername, EnDecryptImplSingleton.getInstance().encrypt(customPassword), null, null);
                            credential.setCredentialID(credentialId);
                            CredentialHandler.updateCredentialEntry(credential);
                        } else {
                            credential = CredentialHandler.getCustomCredential(customUsername, customPassword, null, null);
                            CredentialHandler.createNewCredentialEntry(credential, false);
                            credentialId = credential.getCredentialID();
                        }
                    }
                    UpdateQueryImpl updateQuery3 = new UpdateQueryImpl("ElaImportRemoteDeviceConfiguration");
                    updateQuery3.setUpdateColumn("CREDENTIAL_ID", credentialId);
                    Criteria criteria = new Criteria(Column.getColumn((String)"ElaImportRemoteDeviceConfiguration", (String)"REMOTE_DEVICE_ID"), dataObject.getFirstValue("ELAImportSourceConfigurations", "REMOTE_DEVICE_ID"), 0);
                    updateQuery3.setCriteria(criteria);
                    PERSISTENCE.update((UpdateQuery)updateQuery3);
                }
            }
            if (exportId != -1L) {
                ArrayList<Long> exportIdList = new ArrayList<Long>();
                exportIdList.add(exportId);
                ScheduleUtil.enableDisableELASchedules(new JSONArray(exportIdList), Boolean.TRUE);
            }
            if (updateParams == null || updateParams.isNull("FORCE_IMPORT") || !updateParams.getBoolean("FORCE_IMPORT")) continue;
            Column column = Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID");
            Criteria executeCriteria = new Criteria(column, (Object)importId, 0);
            this.executeSchedule(executeCriteria);
        }
    }

    public void enabledisableSchedule(ArrayList<Long> importIds, boolean status) throws Exception {
        ArrayList<Long> scheduleInstaceIds = ImportUtils.getScheduleInstanceIds(importIds);
        JSONArray exportIdArray = new JSONArray(scheduleInstaceIds);
        ScheduleUtil.enableDisableELASchedules(exportIdArray, status);
        UpdateQueryImpl updateQuery = new UpdateQueryImpl("ELAImportLogConfigurations");
        updateQuery.setUpdateColumn("IMPORT_STATUS", (Object)(status ? 12194L : 12193L));
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SCHEDULE_ID"), (Object)scheduleInstaceIds.toArray(), 8);
        updateQuery.setCriteria(criteria);
        PERSISTENCE.update((UpdateQuery)updateQuery);
        if (status) {
            for (Long scheduleId : scheduleInstaceIds) {
                criteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                this.executeSchedule(criteria);
            }
        }
    }

    public void cancelCurrentImport(Long sourceId) throws BaseStatusCode {
        try {
            UpdateQueryImpl updateQuery = new UpdateQueryImpl("ELAImportLogConfigurations");
            Column column = Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID");
            Criteria cancelCriteria = new Criteria(column, (Object)sourceId, 0);
            updateQuery.setCriteria(cancelCriteria);
            updateQuery.setUpdateColumn("IMPORT_STATUS", (Object)12199L);
            PERSISTENCE.update((UpdateQuery)updateQuery);
        }
        catch (Exception e) {
            throw BaseStatusCode.getBaseStatusCode(1);
        }
    }

    public void deleteSchedule(ArrayList<Long> sourceIds) throws BaseStatusCode {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID"), (Object)sourceIds.toArray(), 8);
            DataObject dataObject = PERSISTENCE.get(Arrays.asList("ELAImportSourceConfigurations", "ElaImportRemoteDeviceConfiguration", "ELAImportLogConfigurations"), criteria);
            if (!dataObject.isEmpty()) {
                Row row;
                HashSet<Long> credentialIds = new HashSet<Long>();
                Iterator configurationIterator = dataObject.getRows("ELAImportLogConfigurations");
                JSONArray exportIdList = new JSONArray();
                while (configurationIterator.hasNext()) {
                    Row row2 = (Row)configurationIterator.next();
                    exportIdList.put(NumberUtils.toLong((String)String.valueOf(row2.get("SCHEDULE_ID")), (long)-1L));
                }
                Criteria delCriteria = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"EXPORT_ID"), (Object)JSONUtil.toLongArray(exportIdList), 8);
                DataObject dobj = PersistenceDBUtil.getPersistence().get("ELATableExportSchedules", delCriteria);
                Iterator iter = dobj.getRows("ELATableExportSchedules");
                if (iter.hasNext()) {
                    JSONArray scheduleIDs = new JSONArray();
                    while (iter.hasNext()) {
                        row = (Row)iter.next();
                        scheduleIDs.put(row.get("SCHEDULE_ID"));
                    }
                    ScheduleUtil.deleteSchedule(scheduleIDs);
                }
                Iterator remoteDeviceIterator = dataObject.getRows("ElaImportRemoteDeviceConfiguration");
                while (remoteDeviceIterator.hasNext()) {
                    row = (Row)remoteDeviceIterator.next();
                    Object credentialId = row.get("CREDENTIAL_ID");
                    if (credentialId == null) continue;
                    credentialIds.add(NumberUtils.toLong((String)String.valueOf(credentialId)));
                }
                Criteria fileIdCriteria = new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)sourceIds.toArray(), 8);
                PERSISTENCE.delete(fileIdCriteria);
                if (credentialIds.size() > 0) {
                    DeleteQueryImpl deleteQuery = new DeleteQueryImpl("ELACredentials");
                    Criteria credentialCriteria = new Criteria(Column.getColumn((String)"ELACredentials", (String)"CREDENTIAL_ID"), (Object)credentialIds.toArray(), 8);
                    deleteQuery.setCriteria(credentialCriteria);
                    PERSISTENCE.delete((DeleteQuery)deleteQuery);
                }
            }
        }
        catch (Exception e) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
    }

    public void executeTask(TaskContext taskContext) throws TaskExecutionException {
        Long scheduleId = taskContext.getID();
        Column column = Column.getColumn((String)"ELAImportLogConfigurations", (String)"SCHEDULE_ID");
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ELATableExportSchedules", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            Long exportId = (Long)PERSISTENCE.get("ELATableExportSchedules", criteria).getFirstValue("ELATableExportSchedules", "EXPORT_ID");
            Criteria scheduleCriteria = new Criteria(column, (Object)exportId, 0);
            this.executeSchedule(scheduleCriteria);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private void executeSchedule(Criteria criteria) {
        SelectQuery selectQuery = ImportUtils.getDefaultImportSelectQuery();
        selectQuery.setCriteria(criteria);
        try {
            DataObject dataObject = PERSISTENCE.get(selectQuery);
            if (dataObject != null) {
                Iterator importLogConfigIterator = dataObject.getRows("ELAImportLogConfigurations");
                Iterator importLogSourceConfigIterator = dataObject.getRows("ELAImportSourceConfigurations");
                Iterator importRemoteDeviceConfigIterator = dataObject.getRows("ElaImportRemoteDeviceConfiguration");
                Iterator importLogProtocolsIterator = dataObject.getRows("ELAImportProtocols");
                if (importLogConfigIterator.hasNext() && importLogSourceConfigIterator.hasNext() && importLogProtocolsIterator.hasNext()) {
                    Row importLogConfigRow = (Row)importLogConfigIterator.next();
                    Row importSourceDetailsRow = (Row)importLogSourceConfigIterator.next();
                    Row importRemoteDeviceRow = (Row)importRemoteDeviceConfigIterator.next();
                    String filePath = (String)importSourceDetailsRow.get("DIRECTORY");
                    String fileName = (String)importSourceDetailsRow.get("FILE_NAME");
                    int importType = NumberUtils.toInt((String)importLogConfigRow.get("IMPORT_TYPE").toString());
                    Long appId = (Long)importSourceDetailsRow.get("APP_ID");
                    Long sourceId = NumberUtils.toLong((String)importSourceDetailsRow.get("SOURCE_ID").toString());
                    List<DynamicPattern> dynamicPatterns = PatternUtils.getDynamicPatternList(dataObject);
                    ImportFile importFile = new ImportFile(filePath, importType);
                    importFile.setFilename(fileName);
                    importFile.setPatternDetailsBean(new PatternDetailsBean(dynamicPatterns));
                    LogProperties logProperty = new LogProperties(importFile);
                    logProperty.setSourceId(sourceId);
                    logProperty.setAppId(appId);
                    logProperty.setLocalImport((Long)importLogConfigRow.get("SCHEDULE_ID") < 0L);
                    logProperty.setLogFormatId(NumberUtils.toLong((String)importLogConfigRow.get("FORMAT_LOCALE_MAP_ID").toString()));
                    ImportProtocolBean importProtocolBean = ImportProtocolUtils.getImportProtocolBeanFromDb(sourceId);
                    logProperty.setImportProtocolBean(importProtocolBean);
                    Long attachedDeviceId = NumberUtils.toLong((String)importSourceDetailsRow.get("ATTACHED_DEVICE_ID").toString());
                    logProperty.setAttachedDeviceId(attachedDeviceId);
                    String deviceName = (String)importRemoteDeviceRow.get("COMPUTER_NAME");
                    logProperty.setLinkedDeviceName(deviceName);
                    logProperty.setThrowAway((Boolean)importLogConfigRow.get("IS_THROWAWAY"));
                    logProperty.setImportFilters(new ImportFilters(logProperty.getSourceId()));
                    importLogManager.addNewFile(logProperty);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

