/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.constants.RegularExpressionConstants;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.schedule.config.ScheduleUtil;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.protocols.BaseProtocolHandler;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportUtils {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Persistence PERSISTENCE = PersistenceDBUtil.getPersistence();
    private static JSONArray protocolList = null;
    private static Matcher dateMatcher = RegularExpressionConstants.dynamicDateFilePatternRegex.matcher("");
    private static Matcher keywordMatcher = RegularExpressionConstants.dynamicKeywordFilePatternRegex.matcher("");
    private static final Logger LOGGER = Logger.getLogger(ImportUtils.class.getName());
    private static ArrayList<String> unsupportedFileExtensions = new ArrayList();

    public static JSONArray getAllSupportedFormatNames() throws DataAccessException, JSONException {
        JSONArray formatsList = new JSONArray();
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"Parser_LogFormats"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_DESC"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_LogFormats", (String)"IS_FILE_IMPORT_SUPPORTED"));
        Criteria criteria = new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"IS_FILE_IMPORT_SUPPORTED"), (Object)true, 0);
        selectQuery.setCriteria(criteria);
        selectQuery.addSortColumn(new SortColumn("Parser_LogFormats", "FORMAT_DESC", true));
        DataObject dataObject = PERSISTENCE.get((SelectQuery)selectQuery);
        if (dataObject != null) {
            Iterator rowIterator = dataObject.getRows("Parser_LogFormats");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                Object formatId = row.get("FORMAT_ID");
                Object formatName = row.get("FORMAT_DESC");
                if (formatName == null || formatId == null || !System.getProperty("isPremium").equals("true") && !formatName.equals("Windows Archive File") && !formatName.equals("Syslog Archive File")) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("FormatID", formatId);
                jsonObject.put("FormatName", formatName);
                formatsList.put((Object)jsonObject);
            }
        }
        return formatsList;
    }

    public static JSONArray getAllWindowsLogTypes() throws DataAccessException, JSONException {
        JSONArray formatsList = new JSONArray();
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"LogTypeMapping"));
        selectQuery.addSelectColumn(Column.getColumn((String)"LogTypeMapping", (String)"*"));
        selectQuery.addSortColumn(new SortColumn("LogTypeMapping", "LTYPE", true));
        DataObject dataObject = PERSISTENCE.get((SelectQuery)selectQuery);
        if (dataObject != null) {
            Iterator rowIterator = dataObject.getRows("LogTypeMapping");
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                String formatType = (String)row.get("LTYPE");
                Object formatValue = row.get("LVALUE");
                if (Strings.isNullOrEmpty((String)formatType) || formatValue == null) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("FormatValue", formatValue);
                jsonObject.put("FormatName", (Object)formatType);
                formatsList.put((Object)jsonObject);
            }
        }
        return formatsList;
    }

    public static long getCurrentMinOfDay() {
        Calendar now = Calendar.getInstance();
        long hr = now.get(11) * 60;
        long min = now.get(12);
        return hr + min;
    }

    public static synchronized void updateDb(LogProperties logProperty) throws DataAccessException, IllegalArgumentException {
        Long sourceId = logProperty.getSourceId();
        if (sourceId == -1L) {
            throw new IllegalArgumentException();
        }
        SelectQuery selectQuery = ImportUtils.getDefaultImportSelectQuery();
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "ELAImportLogAudit", new String[]{"SOURCE_ID"}, new String[]{"SOURCE_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"*"));
        SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"AUDIT_ID"), false);
        selectQuery.addSortColumn(sortColumn);
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCE.get(selectQuery);
        if (!dataObject.isEmpty()) {
            Iterator appResourcesIterator = dataObject.getRows("AppResources");
            Iterator importLogConfigIterator = dataObject.getRows("ELAImportLogConfigurations");
            Iterator importSourceConfigurations = dataObject.getRows("ELAImportSourceConfigurations");
            Iterator importLogAuditDetailsIterator = dataObject.getRows("ELAImportLogAudit");
            if (appResourcesIterator.hasNext()) {
                Row appResourcesRow = (Row)appResourcesIterator.next();
                if (logProperty.getSourceId() > 0L && (appResourcesRow.get("FORMATID") == null || (Long)appResourcesRow.get("FORMATID") <= 0L)) {
                    appResourcesRow.set("FORMATID", (Object)logProperty.getReportId());
                    appResourcesRow.set("FGROUP", (Object)FormatIdentifier.getReportName(logProperty.getReportId()));
                }
                dataObject.updateRow(appResourcesRow);
            }
            if (importLogConfigIterator.hasNext() && importSourceConfigurations.hasNext() && importLogAuditDetailsIterator.hasNext()) {
                Row importLogConfigRow = (Row)importLogConfigIterator.next();
                Row importSourceDetailsRow = (Row)importSourceConfigurations.next();
                importLogConfigRow.set("IMPORT_STATUS", (Object)logProperty.getStatus());
                importSourceDetailsRow.set("FILE_NAME", (Object)logProperty.getFileName());
                importSourceDetailsRow.set("SIZE", (Object)logProperty.getSize());
                Row importLogAuditDetailsRow = (Row)importLogAuditDetailsIterator.next();
                if (logProperty.getSupportedFormatId() != null) {
                    importLogAuditDetailsRow.set("MATCHED_FORMAT_ID", (Object)logProperty.getSupportedFormatId());
                }
                if (logProperty.getLastImport() != null && logProperty.getTimeTaken() >= 0L) {
                    importLogAuditDetailsRow.set("START_TIME", (Object)(logProperty.getLastImport() - logProperty.getTimeTaken()));
                    importLogAuditDetailsRow.set("END_TIME", (Object)logProperty.getLastImport());
                    importLogAuditDetailsRow.set("TIME_TAKEN", (Object)logProperty.getTimeTaken());
                }
                if (logProperty.getLogStartsTime() != null && logProperty.getLogStartsTime() > 0L) {
                    importLogAuditDetailsRow.set("LOG_START_TIME", (Object)logProperty.getLogStartsTime());
                }
                if (logProperty.getLogEndsTime() != null && logProperty.getLogEndsTime() > 0L) {
                    importLogAuditDetailsRow.set("LOG_END_TIME", (Object)logProperty.getLogEndsTime());
                }
                if (logProperty.getCurrentLineCount() != null) {
                    importLogAuditDetailsRow.set("CURRENT_LINE_READ", (Object)logProperty.getCurrentLineCount());
                } else {
                    importLogAuditDetailsRow.set("CURRENT_LINE_READ", (Object)0);
                }
                if (logProperty.getLineCount() != null) {
                    importLogAuditDetailsRow.set("NO_OF_LINE_READ", (Object)logProperty.getLineCount());
                }
                if (logProperty.getRecordMarker() != null) {
                    importLogAuditDetailsRow.set("RECORD_MARKER", (Object)logProperty.getRecordMarker());
                }
                if (!Strings.isNullOrEmpty((String)logProperty.getHeaderLine())) {
                    importLogAuditDetailsRow.set("HEADER_FIELDS", (Object)logProperty.getHeaderLine());
                }
                importLogAuditDetailsRow.set("CONTENT_SIZE", (Object)logProperty.getTotalParsedSize());
                importLogAuditDetailsRow.set("STATUS", (Object)logProperty.getStatus());
                if (logProperty.getSourceId() > 0L) {
                    importLogConfigRow.set("FORMAT_LOCALE_MAP_ID", (Object)logProperty.getLogFormatId());
                }
                dataObject.updateRow(importLogConfigRow);
                dataObject.updateRow(importSourceDetailsRow);
                dataObject.updateRow(importLogAuditDetailsRow);
            }
            PERSISTENCE.update(dataObject);
        }
    }

    public static synchronized void updateImportStatus(LogProperties logProperty, String customStatusMsg) {
        try {
            Long sourceId = logProperty.getSourceId();
            SelectQuery selectQuery = ImportUtils.getDefaultImportSelectQuery();
            Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
            selectQuery.setCriteria(criteria);
            DataObject dataObject = PERSISTENCE.get(selectQuery);
            if (!dataObject.isEmpty()) {
                Iterator importLogConfigIterator = dataObject.getRows("ELAImportLogConfigurations");
                if (importLogConfigIterator.hasNext()) {
                    Row importLogConfigRow = (Row)importLogConfigIterator.next();
                    if (!Strings.isNullOrEmpty((String)customStatusMsg)) {
                        importLogConfigRow.set("CUSTOM_STATUS_MSG", (Object)customStatusMsg);
                    }
                    dataObject.updateRow(importLogConfigRow);
                }
                PERSISTENCE.update(dataObject);
            }
        }
        catch (DataAccessException e) {
            LOGGER.info("IMPLOG : Exception while updating custom error status message");
            e.printStackTrace();
        }
    }

    public static void updateAppId(LogProperties logProperties) throws DataAccessException, IllegalArgumentException {
        Long sourceId = logProperties.getSourceId();
        Long appId = logProperties.getAppId();
        if (appId == null) {
            throw new IllegalArgumentException("IMPLOG: Invalid AppId");
        }
        Criteria sourceIdCriteria = new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        UpdateQueryImpl updateQuery = new UpdateQueryImpl("ELAImportSourceConfigurations");
        updateQuery.setCriteria(sourceIdCriteria);
        updateQuery.setUpdateColumn("APP_ID", (Object)appId);
        PERSISTENCE.update((UpdateQuery)updateQuery);
    }

    public static Long getAlreadyReadCount(long importId) throws DataAccessException {
        Row row;
        Object readCount;
        Iterator importLogAuditIterator;
        long count = 0L;
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportLogAudit"));
        SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"AUDIT_ID"), false);
        selectQuery.addSortColumn(sortColumn);
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogAudit", (String)"SOURCE_ID"), (Object)importId, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCE.get((SelectQuery)selectQuery);
        if (dataObject != null && (importLogAuditIterator = dataObject.getRows("ELAImportLogAudit")).hasNext() && (readCount = (row = (Row)importLogAuditIterator.next()).get("NO_OF_LINE_READ")) != null) {
            return Long.parseLong(readCount.toString());
        }
        return count;
    }

    public static SelectQuery getDefaultImportSelectQuery() {
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportSourceConfigurations"));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "AppResources", new String[]{"APP_ID"}, new String[]{"APPID"}, 1));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "ELAImportLogConfigurations", new String[]{"SOURCE_ID"}, new String[]{"SOURCE_ID"}, 2));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "HostDetails", new String[]{"ATTACHED_DEVICE_ID"}, new String[]{"HOST_ID"}, 2));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "ELAImportProtocols", new String[]{"PROTOCOL_ID"}, new String[]{"PROTOCOL_ID"}, 2));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "ELADynamicPatterns", new String[]{"SOURCE_ID"}, new String[]{"SOURCE_ID"}, 1));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "ElaImportRemoteDeviceConfiguration", new String[]{"REMOTE_DEVICE_ID"}, new String[]{"REMOTE_DEVICE_ID"}, 2));
        selectQuery.addJoin(new Join("ElaImportRemoteDeviceConfiguration", "ELACredentials", new String[]{"CREDENTIAL_ID"}, new String[]{"CREDENTIAL_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"AppResources", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogConfigurations", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportProtocols", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELADynamicPatterns", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ElaImportRemoteDeviceConfiguration", (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELACredentials", (String)"*"));
        return selectQuery;
    }

    public static JSONArray getProtocolList() throws DataAccessException, JSONException {
        if (protocolList != null && protocolList.length() > 0) {
            return protocolList;
        }
        protocolList = new JSONArray();
        DataObject dataObject = PERSISTENCE.get("ELAImportProtocols", (Criteria)null);
        if (!dataObject.isEmpty()) {
            Iterator protocolsIterator = dataObject.getRows("ELAImportProtocols");
            while (protocolsIterator.hasNext()) {
                Row protocols = (Row)protocolsIterator.next();
                Long protocolId = Long.parseLong(protocols.get("PROTOCOL_ID").toString());
                String protocolName = (String)protocols.get("PROTOCOL_NAME");
                Integer protocolDefaultPort = Integer.parseInt(protocols.get("DEFAULT_PORT").toString());
                Boolean supportCustomPort = (Boolean)protocols.get("SUPPORT_CUSTOM_PORT");
                JSONObject protocolObject = new JSONObject();
                protocolObject.put("PROTOCOL_ID", (Object)protocolId);
                protocolObject.put("PROTOCOL_NAME", (Object)protocolName);
                protocolObject.put("DEFAULT_PORT", (Object)protocolDefaultPort);
                protocolObject.put("SUPPORT_CUSTOM_PORT", (Object)supportCustomPort);
                protocolList.put((Object)protocolObject);
            }
        }
        return protocolList;
    }

    public static ArrayList<Long> getScheduleInstanceIds(ArrayList<Long> importIds) throws DataAccessException {
        ArrayList<Long> scheduleInstanceIds = new ArrayList<Long>();
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportLogConfigurations"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogConfigurations", (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"IMPORT_ID"), (Object)importIds.toArray(), 8);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCE.get((SelectQuery)selectQuery);
        if (!dataObject.isEmpty()) {
            Iterator iterator = dataObject.getRows("ELAImportLogConfigurations");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long scheduleInstanceId = NumberUtils.toLong((String)String.valueOf(row.get("SCHEDULE_ID")), (long)-1L);
                if (scheduleInstanceId == -1L) continue;
                scheduleInstanceIds.add(scheduleInstanceId);
            }
        }
        return scheduleInstanceIds;
    }

    public static JSONObject getIntervalJSON(long importId) throws DataAccessException, JSONException, BaseStatusCode {
        ArrayList<Long> importIds = new ArrayList<Long>();
        importIds.add(importId);
        ArrayList<Long> scheduleInstanceIds = ImportUtils.getScheduleInstanceIds(importIds);
        if (scheduleInstanceIds.size() > 0) {
            JSONObject scheduleInfo = ScheduleUtil.getScheduleInfo(scheduleInstanceIds.get(0));
            int frequency = scheduleInfo.getInt("FREQUENCY");
            if (ScheduleUtil.Frequency.getFrequency(frequency) == ScheduleUtil.Frequency.ONCE) {
                String scheduleTime = scheduleInfo.optString("SCHEDULE_TIME");
                if (scheduleTime != null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                    try {
                        Date date = dateFormat.parse(scheduleTime);
                        if (date.getTime() > System.currentTimeMillis()) {
                            scheduleInfo.put("IS_SCHEDULE_DISABLED", false);
                            return scheduleInfo;
                        }
                        scheduleInfo.put("IS_SCHEDULE_DISABLED", true);
                        return scheduleInfo;
                    }
                    catch (ParseException e) {
                        scheduleInfo.put("IS_SCHEDULE_DISABLED", true);
                        LOGGER.info("Exception while parsing schedule time");
                        return scheduleInfo;
                    }
                }
                scheduleInfo.put("IS_SCHEDULE_DISABLED", true);
                return scheduleInfo;
            }
            scheduleInfo.put("IS_SCHEDULE_DISABLED", false);
            return scheduleInfo;
        }
        JSONObject intervalJsonObject = new JSONObject();
        intervalJsonObject.put("IS_SCHEDULE_DISABLED", true);
        return intervalJsonObject;
    }

    @Deprecated
    private static synchronized String generateNewFileName(String dynamicPattern, String oldName) throws BaseStatusCode {
        try {
            int count;
            dateMatcher = dateMatcher.reset(dynamicPattern);
            for (count = 0; dateMatcher.find() && count < 100; ++count) {
                String key = dateMatcher.group(1);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(key);
                String param = simpleDateFormat.format(new Date());
                dynamicPattern = dynamicPattern.replaceAll("\\$\\{" + key + "\\}", param);
                dateMatcher.reset(dynamicPattern);
            }
            if (count >= 100) {
                throw BaseStatusCode.getBaseStatusCode(12035);
            }
            keywordMatcher = keywordMatcher.reset(dynamicPattern);
            int nextNumber = ImportUtils.getNextNumber(dynamicPattern, oldName);
            for (count = 0; keywordMatcher.find() && count < 100; ++count) {
                String key = keywordMatcher.group(1).toUpperCase();
                if (key.startsWith("NUMBER_")) {
                    int numberOfDigits = NumberUtils.toInt((String)key.substring(7), (int)0);
                    dynamicPattern = dynamicPattern.replaceAll("\\$\\{\\{" + key + "\\}\\}", String.format("%0" + numberOfDigits + "d", nextNumber));
                }
                keywordMatcher.reset(dynamicPattern);
            }
            if (count >= 100) {
                throw BaseStatusCode.getBaseStatusCode(12035);
            }
        }
        catch (Exception e) {
            throw BaseStatusCode.getBaseStatusCode(12035);
        }
        return dynamicPattern;
    }

    @Deprecated
    public static int getNextNumber(String dynamicPattern, String oldName) {
        int nextNumber = 0;
        if (oldName != null && StringUtils.difference((String)oldName, (String)dynamicPattern).startsWith("$")) {
            int diffIndex = StringUtils.indexOfDifference((CharSequence)dynamicPattern, (CharSequence)oldName);
            StringBuilder numberStringBuilder = new StringBuilder();
            for (int i = diffIndex; i < oldName.length() && StringUtils.isNumeric((CharSequence)String.valueOf(oldName.charAt(i))); ++i) {
                numberStringBuilder.append(oldName.charAt(i));
            }
            nextNumber = NumberUtils.toInt((String)numberStringBuilder.toString(), (int)1);
        }
        return nextNumber + 1;
    }

    public static String getWindowsLogType(int windowsLogType) throws DataAccessException {
        Row row;
        String formatType;
        Iterator rowIterator;
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"LogTypeMapping"));
        selectQuery.addSelectColumn(Column.getColumn((String)"LogTypeMapping", (String)"*"));
        Criteria criteria = new Criteria(Column.getColumn((String)"LogTypeMapping", (String)"LVALUE"), (Object)windowsLogType, 0);
        selectQuery.addSortColumn(new SortColumn("LogTypeMapping", "LTYPE", true));
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCE.get((SelectQuery)selectQuery);
        if (!dataObject.isEmpty() && (rowIterator = dataObject.getRows("LogTypeMapping")).hasNext() && !Strings.isNullOrEmpty((String)(formatType = (String)(row = (Row)rowIterator.next()).get("LTYPE")))) {
            return formatType;
        }
        return null;
    }

    public static JSONObject getMisMatchFormatDetails(Long sourceId) throws DataAccessException, JSONException {
        JSONObject result = new JSONObject().put("FILE_ID", (Object)sourceId);
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportSourceConfigurations"));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "ELAImportLogConfigurations", new String[]{"SOURCE_ID"}, new String[]{"SOURCE_ID"}, 2));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "ELAImportLogAudit", new String[]{"SOURCE_ID"}, new String[]{"SOURCE_ID"}, 2));
        selectQuery.addJoin(new Join("ELAImportSourceConfigurations", "Hosts", new String[]{"ATTACHED_DEVICE_ID"}, new String[]{"HOST_ID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogConfigurations", (String)"IMPORT_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogConfigurations", (String)"FORMAT_LOCALE_MAP_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID", (String)"CONFIG_SOURCE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID", (String)"SOURCE_ID_PK"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"FILE_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"AUDIT_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"SOURCE_ID", (String)"AUDIT_SOURCE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"MATCHED_FORMAT_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
        Criteria fileIdCriteria = new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        selectQuery.setCriteria(fileIdCriteria);
        SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"AUDIT_ID"), false);
        selectQuery.addSortColumn(sortColumn);
        selectQuery.setRange(new Range(0, 1));
        DataObject dataObject = PERSISTENCE.get((SelectQuery)selectQuery);
        if (!dataObject.isEmpty()) {
            Row importAuditDetailsRow;
            Long formatId;
            Iterator importAuditDetailsIterator;
            Iterator importDeviceDetailsIterator;
            Iterator importFileDetailsIterator;
            Iterator importLogConfigurationsIterator = dataObject.getRows("ELAImportLogConfigurations");
            if (importLogConfigurationsIterator.hasNext()) {
                Row importLogConfigurationRow = (Row)importLogConfigurationsIterator.next();
                Long formatId2 = NumberUtils.toLong((String)String.valueOf(importLogConfigurationRow.get("FORMAT_LOCALE_MAP_ID")), (long)-1L);
                result.put("FORMAT_NAME", (Object)FormatIdentifier.getFormatDesc(formatId2));
            }
            if ((importFileDetailsIterator = dataObject.getRows("ELAImportSourceConfigurations")).hasNext()) {
                Row importFileDetailsRow = (Row)importFileDetailsIterator.next();
                result.put("FILE_NAME", (Object)String.valueOf(importFileDetailsRow.get("FILE_NAME")));
            }
            if ((importDeviceDetailsIterator = dataObject.getRows("Hosts")).hasNext()) {
                Row importDeviceDetailsRow = (Row)importDeviceDetailsIterator.next();
                result.put("DEVICE_NAME", (Object)String.valueOf(importDeviceDetailsRow.get("DISPLAY_NAME")));
            }
            if ((importAuditDetailsIterator = dataObject.getRows("ELAImportLogAudit")).hasNext() && (formatId = Long.valueOf(NumberUtils.toLong((String)String.valueOf((importAuditDetailsRow = (Row)importAuditDetailsIterator.next()).get("MATCHED_FORMAT_ID")), (long)-4L))) != -4L) {
                String formatName = FormatIdentifier.getFormatDesc(formatId);
                result.put("SUPPORTED_FORMAT", (Object)new JSONObject().put("FORMAT_ID", (Object)formatId).put("FORMAT_NAME", (Object)formatName));
            }
        }
        return result;
    }

    public static boolean isInvalidFileFormat(String filename) throws DataAccessException {
        DataObject dataObject;
        if (unsupportedFileExtensions.size() == 0 && !(dataObject = PERSISTENCE.get("ELAImportFileTypeFilter", (Criteria)null)).isEmpty()) {
            Iterator fileExtensionsIterator = dataObject.getRows("ELAImportFileTypeFilter");
            while (fileExtensionsIterator.hasNext()) {
                Row fileExtensionsRow = (Row)fileExtensionsIterator.next();
                unsupportedFileExtensions.add(((String)fileExtensionsRow.get("FILE_EXTENTION")).toUpperCase());
            }
        }
        return unsupportedFileExtensions.stream().anyMatch(filename.toUpperCase()::endsWith);
    }

    public static JSONObject getCredentialJSON(long sourceId) throws DataAccessException, JSONException {
        Criteria importIdCriteria = new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        DataObject dataObject = PERSISTENCE.get(Arrays.asList("ELAImportSourceConfigurations", "ElaImportRemoteDeviceConfiguration", "ELACredentials"), importIdCriteria);
        JSONObject credentialJsonObject = new JSONObject();
        if (!dataObject.isEmpty()) {
            Iterator deviceConfigurationIterator = dataObject.getRows("ElaImportRemoteDeviceConfiguration");
            if (deviceConfigurationIterator.hasNext()) {
                Row deviceConfigurationRow = (Row)deviceConfigurationIterator.next();
                Long credentialId = (Long)deviceConfigurationRow.get("CREDENTIAL_ID");
                if (credentialId == null) {
                    credentialJsonObject.put("USE_DEFAULT_CREDENTIAL", true);
                } else {
                    Iterator credentialIterator = dataObject.getRows("ELACredentials");
                    if (credentialIterator.hasNext()) {
                        Row credentialRow = (Row)credentialIterator.next();
                        credentialJsonObject.put("USE_DEFAULT_CREDENTIAL", false);
                        credentialJsonObject.put("USERNAME", credentialRow.get("USERNAME"));
                    }
                }
            }
        } else {
            credentialJsonObject.put("USE_DEFAULT_CREDENTIAL", true);
        }
        return credentialJsonObject;
    }

    public static HashMap<String, String> getCredentials(long sourceId) throws DataAccessException, JSONException {
        Iterator credentialIterator;
        Row deviceConfigurationRow;
        Long credentialId;
        Iterator deviceConfigurationIterator;
        Criteria importIdCriteria = new Criteria(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        DataObject dataObject = PERSISTENCE.get(Arrays.asList("ELAImportSourceConfigurations", "ElaImportRemoteDeviceConfiguration", "ELACredentials"), importIdCriteria);
        HashMap<String, String> credentialHashMap = null;
        if (!dataObject.isEmpty() && (deviceConfigurationIterator = dataObject.getRows("ElaImportRemoteDeviceConfiguration")).hasNext() && (credentialId = (Long)(deviceConfigurationRow = (Row)deviceConfigurationIterator.next()).get("CREDENTIAL_ID")) != null && (credentialIterator = dataObject.getRows("ELACredentials")).hasNext()) {
            Row credentialRow = (Row)credentialIterator.next();
            credentialHashMap = new HashMap<String, String>();
            credentialHashMap.put("USERNAME", (String)credentialRow.get("USERNAME"));
            credentialHashMap.put("PASSWORD", EnDecryptImplSingleton.getInstance().decrypt((String)credentialRow.get("PASSWORD")));
        }
        return credentialHashMap;
    }

    public static boolean hasAlphanumericCharacter(String line) {
        char[] charArray;
        for (char c : charArray = line.toCharArray()) {
            if (!Character.isLetterOrDigit(c)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<JSONObject> getFileListAsJson(JSONObject returnObject, String filePath, ImportProtocolBean importProtocolBean) throws Exception {
        Class<?> dynamicClass = Class.forName(importProtocolBean.getProtocolHandlerClass());
        BaseProtocolHandler model = (BaseProtocolHandler)dynamicClass.getConstructor(String.class, ImportProtocolBean.class, LogProperties.class).newInstance(filePath, importProtocolBean, null);
        ArrayList<JSONObject> jsonObjects = model.listFiles(importProtocolBean.getDeviceName(), filePath, returnObject);
        model.close();
        return jsonObjects;
    }
}

