/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.adventnet.persistence.DataAccessException;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.Encryption256Bit;
import com.adventnet.sa.server.imp.EncryptionAPI;
import com.google.code.regexp.NamedPattern;
import com.google.common.base.Strings;
import com.manageengine.ela.server.common.io.file.FileUtils;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FileSource;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.protocols.BaseProtocolHandler;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import org.json.JSONException;

public class LogBuilder
implements Iterable {
    private static final Logger LOGGER = Logger.getLogger(LogBuilder.class.getName());
    private boolean isCustomFieldExtraction = false;
    private BaseProtocolHandler protocolHandler = null;
    private LogProperties logProperties;
    private FileSource fileSource;
    private ArrayList<BufferedReader> bufferedReaderList;
    private BufferedReader bufferedReader = null;
    private boolean isOpen = false;
    private String next = null;
    private long totalFileSize = 0L;
    private long totalProcessedSize = 0L;
    private long lineCount = 0L;
    private int bufferedReaderListIndex = 0;
    private static final Long MAX_CHAR_TO_READ = 10000L;
    private String headerLine = null;

    public void setIsCustomFieldExtraction(boolean isCustomFieldExtraction) {
        this.isCustomFieldExtraction = isCustomFieldExtraction;
    }

    public LogBuilder(LogProperties logProperties) throws IOException, DataAccessException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, BaseStatusCode {
        this.logProperties = logProperties;
    }

    private Long automaticLogSourceType(BufferedReader bufferedReader) throws IOException, DataAccessException, BaseStatusCode, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        FormatIdentifier formatIdentifier = new FormatIdentifier(bufferedReader, this.fileSource);
        long formatId = formatIdentifier.getFormatId();
        LOGGER.info("IMPLOG : Header Format id for file " + this.logProperties.getCompleteFilePath() + " is " + formatId);
        if (formatId == -4L) {
            this.logProperties.setLogFormatId(FormatIdentifier.createNewFormat(this.logProperties, bufferedReader));
            return formatId;
        }
        if (this.logProperties.getLogFormatId() < 0L) {
            this.logProperties.setLogFormatId(formatId);
        } else if (formatId != this.logProperties.getLogFormatId()) {
            if (FormatIdentifier.isUserDefined(this.logProperties.getLogFormatId())) {
                formatId = this.logProperties.getLogFormatId();
            } else if (this.isCustomFieldExtraction) {
                this.logProperties.setLogFormatId(formatId);
            } else {
                this.logProperties.setSupportedFormatId(formatId);
                throw BaseStatusCode.getBaseStatusCode(12033);
            }
        }
        return formatId;
    }

    public String getHeaderLine() {
        return this.headerLine;
    }

    public boolean open() throws BaseStatusCode {
        block14: {
            try {
                this.bufferedReaderListIndex = 0;
                this.protocolHandler = ImportProtocolUtils.resolveProtocolHandler(this.logProperties);
                if (this.protocolHandler == null) {
                    throw BaseStatusCode.getBaseStatusCode(6657);
                }
                this.fileSource = this.protocolHandler.downloadFile(FileUtils.location);
                if (this.fileSource == null) {
                    throw BaseStatusCode.getBaseStatusCode(6657);
                }
                this.bufferedReaderList = this.fileSource.getBufferedReaders();
                if (this.bufferedReaderList == null || this.bufferedReaderList.size() == 0) {
                    throw BaseStatusCode.getBaseStatusCode(6657);
                }
                this.totalProcessedSize = 0L;
                this.totalFileSize = this.protocolHandler.getFileSize();
                this.bufferedReader = this.bufferedReaderList.get(this.bufferedReaderListIndex);
                this.automaticLogSourceType(this.bufferedReader);
                String filePath = this.fileSource.getFilePathMap().get(this.bufferedReader);
                if (!Strings.isNullOrEmpty((String)filePath) && filePath.endsWith("_enc")) {
                    AbstractEncryptionHandler encryptionBaseObj = filePath.endsWith("_256_enc") ? Encryption256Bit.getInstance(filePath) : EncryptionAPI.getInstance(filePath);
                    String encryptedLine = encryptionBaseObj.readEncryptedLine(this.bufferedReader);
                    this.next = encryptionBaseObj.decryptLog(encryptedLine, false);
                    this.isOpen = true;
                    break block14;
                }
                try {
                    Long alreadyReadCount = this.logProperties.getLineCount();
                    if (alreadyReadCount == null) {
                        alreadyReadCount = 0L;
                    }
                    if (alreadyReadCount > 0L) {
                        this.headerLine = this.logProperties.getHeaderLine();
                    }
                    int i = 0;
                    while ((long)i < alreadyReadCount) {
                        ++this.lineCount;
                        this.next = this.bufferedReader.readLine();
                        if (this.next == null && !this.hasMoreBufferedReader() || this.lineCount == alreadyReadCount && this.logProperties.getRecordMarker() != null && !this.logProperties.getRecordMarker().equals(this.next)) {
                            this.logProperties.setLineCount(0L);
                            this.resetBufferedReader();
                            break;
                        }
                        ++i;
                    }
                    this.isOpen = true;
                }
                catch (DataAccessException e) {
                    e.printStackTrace();
                    this.isOpen = false;
                }
                this.next = this.bufferedReader.readLine();
                while (this.next == null && this.hasMoreBufferedReader()) {
                    this.next = this.bufferedReader.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(6663);
            }
            catch (DataAccessException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | JSONException e) {
                e.printStackTrace();
                throw BaseStatusCode.getBaseStatusCode(6657);
            }
        }
        return this.isOpen;
    }

    private void resetBufferedReader() throws IOException, BaseStatusCode {
        this.bufferedReader.close();
        this.fileSource = this.protocolHandler.downloadFile(FileUtils.location);
        this.bufferedReaderList = this.fileSource.getBufferedReaders();
        this.bufferedReader = this.bufferedReaderList.get(0);
        this.lineCount = 0L;
    }

    private boolean hasMoreBufferedReader() throws IOException, NoSuchMethodException, DataAccessException, BaseStatusCode, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        ++this.bufferedReaderListIndex;
        if (this.bufferedReaderListIndex < this.bufferedReaderList.size()) {
            this.bufferedReader.close();
            this.bufferedReader = this.bufferedReaderList.get(this.bufferedReaderListIndex);
            this.automaticLogSourceType(this.bufferedReader);
            return true;
        }
        return false;
    }

    public void close() {
        try {
            if (this.bufferedReader != null && this.isOpen) {
                this.bufferedReader.close();
            }
        }
        catch (IOException e) {
            LOGGER.info("Exception : Unable to close the file");
            e.printStackTrace();
        }
        try {
            if (this.protocolHandler != null) {
                this.protocolHandler.close();
            }
        }
        catch (BaseStatusCode e) {
            LOGGER.info("Exception : Unable to close the file");
            e.printStackTrace();
        }
        this.isOpen = false;
        this.totalProcessedSize = this.totalFileSize;
    }

    public Iterator iterator() {
        return new LogIterator();
    }

    public long getTotalFileSize() {
        return this.totalFileSize;
    }

    public void setTotalFileSize(long totalFileSize) {
        this.totalFileSize = totalFileSize;
    }

    public long getTotalProcessedSize() {
        return this.totalProcessedSize;
    }

    public void setTotalProcessedSize(long totalProcessedSize) {
        this.totalProcessedSize = totalProcessedSize;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public long getLineCount() {
        return this.lineCount;
    }

    private class LogIterator
    implements Iterator<String> {
        private String prefix = null;
        private String suffix = null;

        public LogIterator() {
            try {
                this.prefix = FormatIdentifier.getFormatLogPrefix(LogBuilder.this.logProperties.getLogFormatId());
                this.suffix = FormatIdentifier.getFormatLogSuffix(LogBuilder.this.logProperties.getLogFormatId());
            }
            catch (DataAccessException e) {
                LOGGER.info("IMPLOG : Unable to find prefix/suffix from database");
                e.printStackTrace();
            }
        }

        @Override
        public String next() {
            StringBuilder currentLogLine = new StringBuilder(LogBuilder.this.next);
            LogBuilder.this.totalProcessedSize = LogBuilder.this.totalProcessedSize + (long)currentLogLine.length();
            while (LogBuilder.this.isOpen && !this.isEndOfLog(LogBuilder.this.next)) {
                currentLogLine.append(" ").append(LogBuilder.this.next = this.readNextLine());
            }
            if (LogBuilder.this.isOpen) {
                LogBuilder.this.next = this.readNextLine();
            }
            try {
                while (LogBuilder.this.isOpen && !this.isNewLogStart(LogBuilder.this.next)) {
                    currentLogLine.append(" ").append(LogBuilder.this.next);
                    LogBuilder.this.next = this.readNextLine();
                    if ((long)currentLogLine.length() <= MAX_CHAR_TO_READ) continue;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return currentLogLine.toString();
        }

        private boolean isNewLogStart(String nextLine) {
            return this.prefix == null || nextLine == null || nextLine.matches(NamedPattern.compile((String)this.prefix).standardPattern());
        }

        private boolean isEndOfLog(String nextLine) {
            return this.suffix == null || nextLine == null || nextLine.endsWith(this.suffix);
        }

        @Override
        public boolean hasNext() {
            return LogBuilder.this.next != null && LogBuilder.this.isOpen;
        }

        private String readNextLine() {
            String nextLine = null;
            LogBuilder.this.lineCount++;
            try {
                String filePath = LogBuilder.this.fileSource.getFilePathMap().get(LogBuilder.this.bufferedReader);
                if (!Strings.isNullOrEmpty((String)filePath) && filePath.endsWith("_enc")) {
                    AbstractEncryptionHandler encryptionBaseObj = filePath.endsWith("_256_enc") ? Encryption256Bit.getInstance(filePath) : EncryptionAPI.getInstance(filePath);
                    String encryptedLine = encryptionBaseObj.readEncryptedLine(LogBuilder.this.bufferedReader);
                    nextLine = encryptedLine != null ? encryptionBaseObj.decryptLog(encryptedLine, false) : null;
                    while (nextLine == null && LogBuilder.this.hasMoreBufferedReader()) {
                        encryptedLine = encryptionBaseObj.readEncryptedLine(LogBuilder.this.bufferedReader);
                        if (encryptedLine != null) {
                            nextLine = encryptionBaseObj.decryptLog(encryptedLine, false);
                            continue;
                        }
                        nextLine = null;
                    }
                } else {
                    nextLine = LogBuilder.this.bufferedReader.readLine();
                    while (nextLine == null && LogBuilder.this.hasMoreBufferedReader()) {
                        nextLine = LogBuilder.this.bufferedReader.readLine();
                    }
                }
            }
            catch (IOException e) {
                LogBuilder.this.isOpen = false;
                e.printStackTrace();
            }
            catch (DataAccessException | BaseStatusCode | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return nextLine;
        }
    }
}

