/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternDetailsBean;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportFile;
import com.manageengine.ela.server.importlog.ImportFilters;
import com.manageengine.ela.server.importlog.ImportLogAuditDetails;
import com.manageengine.ela.server.importlog.ImportUtils;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolBean;
import com.manageengine.ela.server.importlog.protocols.ImportProtocolUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LogProperties {
    public static final long DISABLE = 12193L;
    public static final long NOT_STARTED = 12194L;
    public static final long IN_PROGRESS = 12195L;
    public static final long SUCCESS = 12196L;
    public static final long FAILED = 12197L;
    public static final long PAUSED = 12198L;
    public static final long INITIAL_PROCESSING = 12145L;
    public static final long FORMAT_MISMATCH = 12033L;
    public static final long IMPORT_NOT_SUPPORTED = 12200L;
    public static final long IMPORT_CANCELLED = 12199L;
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private long sourceId = -1L;
    private Long importId = -1L;
    private Long appId = null;
    private Long status = 0L;
    private Long size = null;
    private long logFormatId = -1L;
    private Long supportedFormatId = null;
    private String windowsLogType = null;
    private ImportFilters importFilters = null;
    private ImportFile importFile;
    private ImportProtocolBean importProtocolBean = null;
    private ImportLogAuditDetails importLogAuditDetails = new ImportLogAuditDetails();
    private Long linkedDeviceId = null;
    private boolean isThrowAway = false;
    private boolean useDefaultCredential = true;
    private long reportId = -1L;
    private Long attachedDeviceId = null;
    private String attachedDeviceName = null;
    private boolean isLinuxShare = false;
    private boolean isLocalImport = false;
    private TimeZone timeZone = TimeZone.getDefault();

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public LogProperties(ImportFile importFile) throws BaseStatusCode {
        if (importFile == null) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        this.importFile = importFile;
    }

    public LogProperties(Long sourceId) throws DataAccessException, JSONException, BaseStatusCode {
        SelectQuery selectQuery = ImportUtils.getDefaultImportSelectQuery();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCELITE.get(selectQuery);
        if (!dataObject.isEmpty()) {
            Iterator importLogConfigurationIterator = dataObject.getRows("ELAImportLogConfigurations");
            if (importLogConfigurationIterator.hasNext()) {
                Row importLogDetailsRow = (Row)importLogConfigurationIterator.next();
                this.sourceId = sourceId;
                this.importId = NumberUtils.toLong((String)String.valueOf(importLogDetailsRow.get("IMPORT_ID")));
                this.logFormatId = NumberUtils.toLong((String)String.valueOf(importLogDetailsRow.get("FORMAT_LOCALE_MAP_ID")));
            }
            Iterator importLogSourceIterator = dataObject.getRows("ELAImportSourceConfigurations");
            Iterator importProtocolsIterator = dataObject.getRows("ELAImportProtocols");
            Iterator importRemoteDeviceIterator = dataObject.getRows("ElaImportRemoteDeviceConfiguration");
            if (importLogSourceIterator.hasNext() && importProtocolsIterator.hasNext() && importRemoteDeviceIterator.hasNext()) {
                Row importLogSourceRow = (Row)importLogSourceIterator.next();
                Row importRemoteDeviceRow = (Row)importRemoteDeviceIterator.next();
                String filename = (String)importLogSourceRow.get("FILE_NAME");
                String filePath = (String)importLogSourceRow.get("DIRECTORY");
                List<DynamicPattern> dynamicPatternList = PatternUtils.getDynamicPatternList(dataObject);
                ImportFile importFile = new ImportFile(filePath, 0);
                importFile.setFilename(filename);
                importFile.setPatternDetailsBean(new PatternDetailsBean(dynamicPatternList));
                this.importFile = importFile;
                this.importProtocolBean = ImportProtocolUtils.getImportProtocolBeanFromDb(sourceId);
                this.attachedDeviceId = NumberUtils.toLong((String)String.valueOf(importLogSourceRow.get("ATTACHED_DEVICE_ID")));
                this.setDeviceId(this.attachedDeviceId);
                this.setLinkedDeviceName(String.valueOf(importRemoteDeviceRow.get("COMPUTER_NAME")));
            }
            this.importFilters = new ImportFilters(sourceId);
        }
    }

    public String getCompleteFilePath() {
        if (this.importFile == null) {
            return null;
        }
        return this.importFile.getFilePath() + this.importFile.getFilename();
    }

    public String getFileDirectory() {
        if (this.importFile == null) {
            return null;
        }
        return this.importFile.getFilePath();
    }

    public long getLogFormatId() {
        return this.logFormatId;
    }

    public void setLogFormatId(long logFormatId) {
        this.logFormatId = logFormatId;
    }

    public long getProtocolId() {
        return this.importProtocolBean.getProtocolId();
    }

    public void setProtocolId(long protocol) {
        if (this.importProtocolBean == null) {
            this.importProtocolBean = new ImportProtocolBean(protocol);
        } else {
            this.importProtocolBean.setProtocolId(protocol);
        }
    }

    public Integer getFileSourceType() {
        if (this.importFile == null) {
            return null;
        }
        return this.importFile.getImportFileType();
    }

    public void setDeviceId(Long attachedDeviceId) throws DataAccessException, BaseStatusCode {
        this.setAttachedDeviceId(attachedDeviceId);
    }

    public Long getLinkedDeviceId() {
        return this.linkedDeviceId;
    }

    public void setLinkedDeviceName(String deviceName) throws DataAccessException, BaseStatusCode {
        if (this.importProtocolBean == null) {
            try {
                this.importProtocolBean = new ImportProtocolBean();
            }
            catch (DataAccessException | BaseStatusCode baseStatusCode) {
                throw BaseStatusCode.getBaseStatusCode(12034);
            }
        }
        this.importProtocolBean.setDeviceName(deviceName);
    }

    public void setLinkedDevice(Long linkedDeviceId, String linkedDeviceName) throws BaseStatusCode {
        this.setLinkedDevice(linkedDeviceId, linkedDeviceName, linkedDeviceId, linkedDeviceName);
    }

    public void setLinkedDevice(Long linkedDeviceId, String linkedDeviceName, Long attachedDeviceId, String attachedDeviceName) throws BaseStatusCode {
        this.linkedDeviceId = linkedDeviceId;
        if (this.importProtocolBean == null) {
            try {
                this.importProtocolBean = new ImportProtocolBean();
            }
            catch (DataAccessException | BaseStatusCode baseStatusCode) {
                throw BaseStatusCode.getBaseStatusCode(12034);
            }
        }
        this.importProtocolBean.setDeviceName(linkedDeviceName);
        this.attachedDeviceId = attachedDeviceId;
        this.attachedDeviceName = attachedDeviceName;
    }

    public Long getAttachedDeviceId() {
        return this.attachedDeviceId;
    }

    public void setAttachedDeviceId(Long attachedDeviceId) throws DataAccessException, BaseStatusCode {
        this.attachedDeviceId = attachedDeviceId;
        this.setAttachedDeviceName(DeviceUtil.getDeviceName(this.attachedDeviceId).getDeviceName());
    }

    public String getAttachedDeviceName() {
        return this.attachedDeviceName == null ? this.importProtocolBean.getDeviceName() : this.attachedDeviceName;
    }

    private void setAttachedDeviceName(String attachedDeviceName) {
        this.attachedDeviceName = attachedDeviceName;
    }

    public boolean isThrowAway() {
        return this.isThrowAway;
    }

    public void setThrowAway(boolean throwAway) {
        this.isThrowAway = throwAway;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(long importId) {
        this.sourceId = importId;
    }

    public Long getStatus() {
        return this.status;
    }

    public void setStatus(Long status) {
        this.status = status;
    }

    public Double getTotalParsedSize() {
        return this.importLogAuditDetails.getTotalParsedSize();
    }

    public void setTotalParsedSize(Double totalParsedSize) {
        this.importLogAuditDetails.setTotalParsedSize(totalParsedSize);
    }

    public long getTimeTaken() {
        return this.importLogAuditDetails.getTimeTaken();
    }

    public void setTimeTaken(long timeTaken) {
        this.importLogAuditDetails.setTimeTaken(timeTaken);
    }

    public void setHeaderLine(String line) {
        this.importLogAuditDetails.setHeaderRow(line);
    }

    public String getHeaderLine() {
        return this.importLogAuditDetails.getHeaderRow();
    }

    public String getFileName() {
        if (this.importFile == null) {
            return null;
        }
        return this.importFile.getFilename();
    }

    public Long getLastImport() {
        return this.importLogAuditDetails.getLastImport();
    }

    public void setLastImport(Long lastImport) {
        this.importLogAuditDetails.setLastImport(lastImport);
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public Long getLineCount() {
        return this.importLogAuditDetails.getLineCount();
    }

    public void setLineCount(Long lineCount) {
        this.importLogAuditDetails.setLineCount(lineCount);
    }

    public Long getCurrentLineCount() {
        return this.importLogAuditDetails.getCurrentLineCount();
    }

    public void setCurrentLineCount(Long currentLineCount) {
        this.importLogAuditDetails.setCurrentLineCount(currentLineCount);
    }

    public ImportFilters getImportFilters() {
        return this.importFilters;
    }

    public void resetAuditDetails() {
        if (this.importLogAuditDetails == null) {
            this.importLogAuditDetails = new ImportLogAuditDetails();
        } else {
            this.importLogAuditDetails.reset();
        }
        this.supportedFormatId = null;
    }

    public void setImportFilters(ImportFilters importFilters) {
        this.importFilters = importFilters;
    }

    public ImportProtocolBean getImportProtocolBean() {
        return this.importProtocolBean;
    }

    public void setImportProtocolBean(ImportProtocolBean importProtocolBean) {
        this.importProtocolBean = importProtocolBean;
    }

    public String getLinkedDeviceName() {
        if (this.importProtocolBean != null) {
            return this.importProtocolBean.getDeviceName();
        }
        return null;
    }

    public JSONObject getJSON() throws JSONException, DataAccessException, BaseStatusCode {
        JSONObject returnObject = new JSONObject();
        returnObject.put("IMPORT_ID", this.getSourceId());
        returnObject.put("FILE_NAME", (Object)this.getFileName());
        returnObject.put("FORMAT_ID", this.getLogFormatId());
        returnObject.put("DEVICE_NAME", (Object)this.getLinkedDeviceName());
        returnObject.put("PROTOCOL_USED", (Object)ImportProtocolUtils.getProtocolName(this.getProtocolId()));
        returnObject.put("PORT", (Object)this.importProtocolBean.getPort());
        List dynamicPatterns = this.getDynamicPatternsAsList();
        if (dynamicPatterns != null && dynamicPatterns.size() > 0) {
            returnObject.put("DYNAMIC_FILENAME", dynamicPatterns.get(dynamicPatterns.size() - 1));
        }
        returnObject.put("FILTER", (Object)new ImportFilters(this.getSourceId()).getJSON());
        returnObject.put("INTERVAL_JSON", (Object)ImportUtils.getIntervalJSON(this.importId));
        returnObject.put("CREDENTIAL", (Object)ImportUtils.getCredentialJSON(this.getSourceId()));
        return returnObject;
    }

    public PatternDetailsBean getDynamicPatternDetails() {
        if (this.importFile == null) {
            return null;
        }
        return this.importFile.getPatternDetailsBean();
    }

    public void setDynamicPatternDetails(PatternDetailsBean dynamicFilename) {
        if (this.importFile != null) {
            this.importFile.setPatternDetailsBean(dynamicFilename);
        }
    }

    public JSONArray getDynamicPatternsAsJson() {
        List dynamicPatterns = this.getDynamicPatternsAsList();
        if (dynamicPatterns != null) {
            return new JSONArray((Collection)dynamicPatterns);
        }
        return null;
    }

    public List getDynamicPatternsAsList() {
        if (this.importFile == null || this.importFile.getPatternDetailsBean() == null) {
            return null;
        }
        return this.importFile.getPatternDetailsBean().getDynamicPatternList();
    }

    public void setImportFile(ImportFile importFile) {
        this.importFile = importFile;
    }

    public long getReportId() {
        if (this.reportId > 0L) {
            return this.reportId;
        }
        try {
            if (this.logFormatId > 0L) {
                this.reportId = FormatIdentifier.getReportID(this.logFormatId);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return this.reportId;
    }

    public void setReportId(long reportId) {
        this.reportId = reportId;
    }

    public Long getLogStartsTime() {
        return this.importLogAuditDetails.getLogStartsTime();
    }

    public void setLogTime(Long logTime) {
        this.importLogAuditDetails.setLogStartsTime(logTime);
        this.importLogAuditDetails.setLogEndsTime(logTime);
    }

    public void setLogStartsTime(Long time) {
        this.importLogAuditDetails.setLogStartsTime(time);
    }

    public void setLogEndsTime(Long time) {
        this.importLogAuditDetails.setLogEndsTime(time);
    }

    public Long getLogEndsTime() {
        return this.importLogAuditDetails.getLogEndsTime();
    }

    public String getWindowsLogType() {
        return this.windowsLogType;
    }

    public void setWindowsLogType(String windowsLogType) {
        this.windowsLogType = windowsLogType;
    }

    public Long getSupportedFormatId() {
        return this.supportedFormatId;
    }

    public void setSupportedFormatId(Long supportedFormatId) {
        this.supportedFormatId = supportedFormatId;
    }

    public boolean isUseDefaultCredential() {
        return this.useDefaultCredential;
    }

    public void setUseDefaultCredential(boolean useDefaultCredential) {
        this.useDefaultCredential = useDefaultCredential;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public boolean isLinuxShare() {
        return this.isLinuxShare;
    }

    public void setLinuxShare(boolean linuxShare) {
        this.isLinuxShare = linuxShare;
    }

    public boolean isLocalImport() {
        return this.isLocalImport;
    }

    public void setLocalImport(boolean localImport) {
        this.isLocalImport = localImport;
    }

    public String getRecordMarker() {
        return this.importLogAuditDetails.getRecordMarker();
    }

    public void setRecordMarker(String recordMarker) {
        this.importLogAuditDetails.setRecordMarker(recordMarker);
    }
}

