/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.datasource;

import com.manageengine.ela.server.common.io.file.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.FutureTask;
import java.util.logging.Logger;

public class FileSource {
    private long fileSize = 0L;
    private HashMap<BufferedReader, String> filePathMap = new HashMap();
    private ArrayList<BufferedReader> bufferedReaders;
    private static final Logger LOGGER = Logger.getLogger(FileSource.class.getName());
    private ArrayList<FutureTask> futureTasks = new ArrayList();

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public void setBufferedReaders(ArrayList<BufferedReader> bufferedReaders) {
        this.bufferedReaders = bufferedReaders;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public HashMap<BufferedReader, String> getFilePathMap() {
        return this.filePathMap;
    }

    public void setFilePathMap(HashMap<BufferedReader, String> filePathMap) {
        this.filePathMap = filePathMap;
    }

    public ArrayList<BufferedReader> getBufferedReaders() {
        return this.bufferedReaders;
    }

    public void addFutureTasks(FutureTask closeTask) {
        if (closeTask != null) {
            this.futureTasks.add(closeTask);
        }
    }

    public void close() {
        if (this.futureTasks != null && this.futureTasks.size() > 0) {
            this.futureTasks.forEach(futureTask -> {
                try {
                    futureTask.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.info("IMPLOG : Unable to close the stream or the stream is already closed");
                }
            });
            LOGGER.info("IMPLOG : Future Task Execute, File Closed");
        }
        StringBuffer tempBuf = new StringBuffer();
        tempBuf.append(System.getProperty("server.dir"));
        tempBuf.append(File.separator);
        tempBuf.append("bin");
        tempBuf.append(File.separator);
        tempBuf.append(System.getProperty("server.home"));
        tempBuf.append(File.separator);
        tempBuf.append("bin");
        tempBuf.append(File.separator);
        tempBuf.append("evt_");
        this.filePathMap.forEach((bufferedReader, s) -> {
            File file;
            if ((s.startsWith(FileUtils.location) || s.startsWith(tempBuf.toString())) && (file = new File((String)s)).exists()) {
                file.delete();
            }
        });
    }
}

