/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.datasource;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.Encryption256Bit;
import com.adventnet.sa.server.imp.EncryptionAPI;
import com.adventnet.sa.server.parser.DbUtil;
import com.google.code.regexp.NamedPattern;
import com.manageengine.ela.server.common.cache.Cache;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportUtils;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FileSource;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;

public class FormatIdentifier {
    private static final Long MAX_CHECK_LINE = 5L;
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static final Logger LOGGER = Logger.getLogger(FormatIdentifier.class.getName());
    private static Cache<Long, String> formatIdNameCache = new Cache();
    private static Cache<Long, String> formatIdReportTableCache = new Cache();
    private static Cache<Long, String> formatIdTrendTableCache = new Cache();
    private static Cache<Long, String> formatIdDescCache = new Cache();
    private static Cache<Long, Long> formatReportIdCache = new Cache();
    private static Cache<Long, String> formatIdReportName = new Cache();
    private static Cache<Long, Boolean> formatIdUserDefined = new Cache();
    public static Cache<String, String> formatDescReportURLCache = new Cache();
    private ArrayList<String> headerLines = new ArrayList();
    private static final int READ_AHEAD_LIMIT = 10240;
    public static final long CSV_FORMAT = 101L;
    public static final long UNSUPPORTED_FORMAT = -4L;
    private static Cache<Long, String> formatIdPrefixCache = new Cache();
    private static Cache<Long, String> formatIdSuffixCache = new Cache();

    public FormatIdentifier(BufferedReader bufferedReader, FileSource fileSource) throws IOException, DataAccessException {
        try {
            bufferedReader.mark(10240);
            String filePath = fileSource.getFilePathMap().get(bufferedReader);
            if (!Strings.isNullOrEmpty((String)filePath) && filePath.endsWith("_enc")) {
                String line;
                AbstractEncryptionHandler encryptionBaseObj;
                AbstractEncryptionHandler abstractEncryptionHandler = encryptionBaseObj = filePath.endsWith("_256_enc") ? Encryption256Bit.getInstance(filePath) : EncryptionAPI.getInstance(filePath);
                while ((line = encryptionBaseObj.readEncryptedLine(bufferedReader)) != null && (long)this.headerLines.size() <= MAX_CHECK_LINE) {
                    if (Strings.isNullOrEmpty((String)(line = encryptionBaseObj.decryptLog(line, false)))) continue;
                    this.headerLines.add(line);
                }
            } else {
                String line;
                while ((line = bufferedReader.readLine()) != null && (long)this.headerLines.size() <= MAX_CHECK_LINE) {
                    if (Strings.isNullOrEmpty((String)line)) continue;
                    this.headerLines.add(line);
                }
            }
            bufferedReader.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadToCache() {
        try {
            DataObject dataObject = PersistenceDBUtil.getPersistence().get("FormatDescriptonToReportURLMapping", (Criteria)null);
            Iterator rows = dataObject.getRows("FormatDescriptonToReportURLMapping");
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                String formatName = (String)row.get("FORMAT_DESC");
                String url = (String)row.get("REPORT_URL");
                formatDescReportURLCache.put(formatName, url);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getHeaderLines() {
        return this.headerLines;
    }

    public static synchronized long getFormatId(String formatName) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_NAME"), (Object)formatName, 0);
        DataObject dataObject = PERSISTENCELITE.get("Parser_LogFormats", criteria);
        Iterator resultIterator = dataObject.getRows("Parser_LogFormats");
        if (resultIterator.hasNext()) {
            Row resultRow = (Row)resultIterator.next();
            Long formatId = Long.parseLong(resultRow.get("FORMAT_ID").toString());
            return formatId;
        }
        return -4L;
    }

    public static synchronized long getFormatId(Long reportId) throws DataAccessException {
        return FormatIdentifier.getFormatId(FormatIdentifier.getReportName(reportId));
    }

    public static String getFormatKey(Long formatId, String key) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_ID"), (Object)formatId, 0);
        return FormatIdentifier.getKey(criteria, key, "Parser_LogFormats");
    }

    public static String getKey(Criteria criteria, String key, String tableName) throws DataAccessException {
        Iterator iterator;
        DataObject dataObject = PERSISTENCELITE.get(tableName, criteria);
        if (dataObject != null && (iterator = dataObject.getRows(tableName)).hasNext()) {
            Row row = (Row)iterator.next();
            return (String)row.get(key);
        }
        return null;
    }

    public static String getReportKey(Long reportId, String key) throws DataAccessException {
        Criteria criteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATID"), (Object)reportId, 0);
        return FormatIdentifier.getKey(criteria, key, "FormatDetails");
    }

    public static String getReportTableName(Long reportId) throws DataAccessException {
        if (formatIdReportTableCache.containsKey(reportId) && formatIdReportTableCache.get(reportId) != null) {
            return formatIdReportTableCache.get(reportId);
        }
        String reportTable = FormatIdentifier.getReportKey(reportId, "REPORTTABLENAME");
        if (reportTable != null) {
            formatIdReportTableCache.put(reportId, reportTable);
        }
        return reportTable;
    }

    public static void updateReportTableName(Long reportId, String tableName) {
        formatIdReportTableCache.put(reportId, tableName);
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATID"), (Object)reportId, 0);
            DataObject dataObject = PERSISTENCELITE.get("FormatDetails", criteria);
            dataObject.set("FormatDetails", "REPORTTABLENAME", (Object)tableName);
            PERSISTENCELITE.update(dataObject);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static String getReportUrl(String formatDesc) {
        if (!formatDescReportURLCache.containsKey(formatDesc) || Strings.isNullOrEmpty((String)formatDescReportURLCache.get(formatDesc))) {
            FormatIdentifier.loadToCache();
        }
        if (formatDescReportURLCache.containsKey(formatDesc)) {
            return formatDescReportURLCache.get(formatDesc);
        }
        return null;
    }

    public static String getTrendTableName(Long reportId) throws DataAccessException {
        if (formatIdTrendTableCache.containsKey(reportId) && formatIdTrendTableCache.get(reportId) != null) {
            return formatIdTrendTableCache.get(reportId);
        }
        String trendTable = FormatIdentifier.getReportKey(reportId, "HRTRENDTABLENAME");
        if (trendTable != null) {
            formatIdTrendTableCache.put(reportId, trendTable);
        }
        return trendTable;
    }

    public static String getFormatDesc(Long formatId) throws DataAccessException {
        if (formatIdDescCache.containsKey(formatId) && formatIdDescCache.get(formatId) != null) {
            return formatIdDescCache.get(formatId);
        }
        String formatDesc = FormatIdentifier.getFormatKey(formatId, "FORMAT_DESC");
        if (formatDesc != null) {
            formatIdDescCache.put(formatId, formatDesc);
        }
        return formatDesc;
    }

    public static String getFormatName(Long formatId) throws DataAccessException {
        if (formatIdNameCache.containsKey(formatId) && formatIdNameCache.get(formatId) != null) {
            return formatIdNameCache.get(formatId);
        }
        String formatName = FormatIdentifier.getFormatKey(formatId, "FORMAT_NAME");
        if (formatName != null) {
            formatIdNameCache.put(formatId, formatName);
        }
        return formatName;
    }

    public static synchronized long createNewFormat(LogProperties logProperties, BufferedReader bufferedReader) throws DataAccessException, BaseStatusCode {
        if (logProperties.getLogFormatId() > 0L) {
            return logProperties.getLogFormatId();
        }
        String formatName = Strings.cleanTruncate((String)logProperties.getLinkedDeviceName().replaceAll(":", "-"), (int)90).concat("_").concat(Strings.cleanTruncate((String)logProperties.getFileName(), (int)90));
        Long formatId = FormatIdentifier.getFormatId(formatName);
        if (formatId > 0L) {
            return formatId;
        }
        String prefix = null;
        try {
            String line;
            bufferedReader.mark(10240);
            int count = 0;
            while ((line = bufferedReader.readLine()) != null && count++ < 10) {
                NamedPattern namedPattern;
                if (Strings.isNullOrEmpty((String)line) || !ImportUtils.hasAlphanumericCharacter(line) || (namedPattern = com.adventnet.sa.server.univlogparser.FormatIdentifier.getInstance().findPatternForUnSupportedLog(line)) == null) continue;
                prefix = namedPattern.namedPattern();
                break;
            }
            bufferedReader.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw BaseStatusCode.getBaseStatusCode(12200L);
        }
        formatId = FormatIdentifier.addNewFormat(formatName, prefix);
        return formatId;
    }

    public static synchronized Long addNewFormat(String formatName) throws DataAccessException {
        return FormatIdentifier.addNewFormat(formatName, null);
    }

    public static synchronized Long addNewFormat(String formatName, String prefix) throws DataAccessException {
        Row parserLocaleFirstRow;
        Long formatId = FormatIdentifier.getFormatId(formatName);
        if (formatId > 0L) {
            return formatId;
        }
        DataObject dataObject = PERSISTENCELITE.constructDataObject();
        Row logFormatRow = new Row("Parser_LogFormats");
        logFormatRow.set("FORMAT_NAME", (Object)formatName);
        logFormatRow.set("FORMAT_DESC", (Object)formatName);
        logFormatRow.set("USER_DEFINED", (Object)true);
        logFormatRow.set("IS_FILE_IMPORT_SUPPORTED", (Object)true);
        logFormatRow.set("LOG_PREFIX", (Object)prefix);
        dataObject.addRow(logFormatRow);
        Row formatDetailsRow = new Row("FormatDetails");
        formatDetailsRow.set("FORMATNAME", (Object)formatName);
        formatDetailsRow.set("FORMATDESC", (Object)formatName);
        formatDetailsRow.set("ISTABLECREATED", (Object)1);
        formatDetailsRow.set("HRTRENDTABLENAME", (Object)"ela_import_app_hr_trend_sa");
        formatDetailsRow.set("REPORTTABLENAME", (Object)"ela_import_app_reports_hr_trend_sa");
        dataObject.addRow(formatDetailsRow);
        Criteria criteria = new Criteria(Column.getColumn((String)"Parser_Locale", (String)"LOCALE"), (Object)"en_US", 0);
        DataObject parserLocaleDataObject = PERSISTENCELITE.get("Parser_Locale", criteria);
        if (!parserLocaleDataObject.isEmpty() && (parserLocaleFirstRow = parserLocaleDataObject.getFirstRow("Parser_Locale")) != null) {
            Row localeFormatMappingRow = new Row("Parser_Locale2FormatMapping");
            localeFormatMappingRow.set("LOCALE_ID", parserLocaleFirstRow.get("LOCALE_ID"));
            localeFormatMappingRow.set("FORMAT_ID", logFormatRow.get("FORMAT_ID"));
            dataObject.addRow(localeFormatMappingRow);
        }
        PERSISTENCELITE.add(dataObject);
        formatId = NumberUtils.toLong((String)String.valueOf(FormatIdentifier.getFormatId(formatName)), (long)-1L);
        LOGGER.info(String.format("IMPLOG : New Format created with name %s and id %d", formatName, formatId));
        DbUtil.get_instance().addToFormatMap(FormatIdentifier.getReportID(formatId), formatName);
        return formatId;
    }

    public static long getReportID(Long formatID) throws DataAccessException {
        if (formatReportIdCache.containsKey(formatID) && formatReportIdCache.get(formatID) != null && formatReportIdCache.get(formatID) > 0L) {
            return formatReportIdCache.get(formatID);
        }
        long reportId = FormatIdentifier.getReportID(FormatIdentifier.getFormatName(formatID));
        if (reportId > 0L) {
            formatReportIdCache.put(formatID, reportId);
        }
        return reportId;
    }

    public static long getReportID(String formatName) throws DataAccessException {
        Iterator formatDetailsIterator;
        long reportId = -1L;
        Criteria formatNameCriteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATNAME"), (Object)formatName, 0);
        DataObject formatDetailsDataObject = PERSISTENCELITE.get("FormatDetails", formatNameCriteria);
        if (!formatDetailsDataObject.isEmpty() && (formatDetailsIterator = formatDetailsDataObject.getRows("FormatDetails")).hasNext()) {
            Row formatDetailsRow = (Row)formatDetailsIterator.next();
            reportId = NumberUtils.toLong((String)String.valueOf(formatDetailsRow.get("FORMATID")), (long)-1L);
        }
        return reportId;
    }

    public static String getReportName(long formatId) throws DataAccessException {
        Iterator iterator;
        if (formatIdReportName.containsKey(formatId) && formatIdReportName.get(formatId) != null) {
            return formatIdReportName.get(formatId);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATID"), (Object)formatId, 0);
        DataObject dataObject = PERSISTENCELITE.get("FormatDetails", criteria);
        if (dataObject != null && (iterator = dataObject.getRows("FormatDetails")).hasNext()) {
            Row row = (Row)iterator.next();
            String formatName = (String)row.get("FORMATNAME");
            if (formatName != null) {
                if (formatName.length() > 50) {
                    formatName = Strings.cleanTruncate((String)formatName, (int)49);
                }
                formatIdReportName.put(formatId, formatName);
            }
            return formatName;
        }
        return "unsupported_apps";
    }

    public Long getFormatId() throws DataAccessException, IOException {
        SelectQueryImpl headerRulesSelectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportHeaderIdentityRules"));
        headerRulesSelectQuery.addSelectColumn(Column.getColumn((String)"ELAImportHeaderIdentityRules", (String)"*"));
        headerRulesSelectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"ELAImportHeaderIdentityRules", (String)"PRIORITY"), true));
        DataObject dataObject = PERSISTENCELITE.get((SelectQuery)headerRulesSelectQuery);
        if (!dataObject.isEmpty() && this.headerLines.size() > 0) {
            Iterator iterator = dataObject.getRows("ELAImportHeaderIdentityRules");
            Integer lineIndex = 0;
            String headerLine = this.headerLines.get(lineIndex);
            while (iterator.hasNext()) {
                Row ruleRow = (Row)iterator.next();
                Long ruleId = Long.parseLong(ruleRow.get("RULE_ID").toString());
                Long formatId = Long.parseLong(ruleRow.get("LOCALE_FORMAT_MAP_ID").toString());
                String regex = (String)ruleRow.get("HEADER_REGEX_PATTERN");
                Matcher headerMatcher = Pattern.compile(regex).matcher(headerLine);
                if (!headerMatcher.find(0)) continue;
                Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportSubIdentityRules", (String)"HEADER_RULE_ID"), (Object)ruleId, 0);
                lineIndex = lineIndex + 1;
                return this.getChildFormatId(criteria, lineIndex, formatId);
            }
        }
        return -4L;
    }

    private Long getChildFormatId(Criteria criteria, Integer lineIndex, Long parentFormatID) throws DataAccessException {
        if (criteria == null || lineIndex == null || lineIndex < 1 || (long)lineIndex.intValue() >= MAX_CHECK_LINE) {
            return parentFormatID;
        }
        SelectQueryImpl subRulesSelectQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportSubIdentityRules"));
        subRulesSelectQuery.addSelectColumn(Column.getColumn((String)"ELAImportSubIdentityRules", (String)"*"));
        subRulesSelectQuery.addSortColumn(new SortColumn(Column.getColumn((String)"ELAImportSubIdentityRules", (String)"PRIORITY"), true));
        subRulesSelectQuery.setCriteria(criteria);
        DataObject subRuleDataObject = PERSISTENCELITE.get((SelectQuery)subRulesSelectQuery);
        if (!subRuleDataObject.isEmpty()) {
            Iterator subRulesIterator = subRuleDataObject.getRows("ELAImportSubIdentityRules");
            lineIndex = lineIndex + 1;
            String nextLine = this.headerLines.get(lineIndex);
            while (subRulesIterator.hasNext()) {
                Row subRuleRow = (Row)subRulesIterator.next();
                Long subRuleId = Long.parseLong(subRuleRow.get("RULE_ID").toString());
                Long subFormatId = Long.parseLong(subRuleRow.get("FORMATMAP_ID").toString());
                String subRegex = (String)subRuleRow.get("REGEX_PATTERN");
                Matcher subMatcher = Pattern.compile(subRegex).matcher(nextLine);
                if (!subMatcher.find(0)) continue;
                Criteria subRegexCriteria = new Criteria(Column.getColumn((String)"ELAImportSubIdentityRules", (String)"PARENT_RULE_ID"), (Object)subRuleId, 0);
                lineIndex = lineIndex + 1;
                return this.getChildFormatId(subRegexCriteria, lineIndex, subFormatId);
            }
        } else {
            return parentFormatID;
        }
        lineIndex = lineIndex + 1;
        return this.getChildFormatId(criteria, lineIndex, parentFormatID);
    }

    public static String getFormatLogPrefix(long logFormatId) throws DataAccessException {
        Iterator iterator;
        if (formatIdPrefixCache.containsKey(logFormatId) && formatIdPrefixCache.get(logFormatId) != null) {
            return formatIdPrefixCache.get(logFormatId);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_ID"), (Object)logFormatId, 0);
        DataObject dataObject = PERSISTENCELITE.get("Parser_LogFormats", criteria);
        if (dataObject != null && (iterator = dataObject.getRows("Parser_LogFormats")).hasNext()) {
            Row row = (Row)iterator.next();
            String logPrefix = (String)row.get("LOG_PREFIX");
            if (logPrefix != null) {
                formatIdPrefixCache.put(logFormatId, logPrefix);
            }
            return logPrefix;
        }
        return null;
    }

    public static String getFormatLogSuffix(long logFormatId) throws DataAccessException {
        Iterator iterator;
        if (formatIdSuffixCache.containsKey(logFormatId) && formatIdSuffixCache.get(logFormatId) != null) {
            return formatIdSuffixCache.get(logFormatId);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_ID"), (Object)logFormatId, 0);
        DataObject dataObject = PERSISTENCELITE.get("Parser_LogFormats", criteria);
        if (dataObject != null && (iterator = dataObject.getRows("Parser_LogFormats")).hasNext()) {
            Row row = (Row)iterator.next();
            String logSuffix = (String)row.get("LOG_SUFFIX");
            if (logSuffix != null) {
                formatIdSuffixCache.put(logFormatId, logSuffix);
            }
            return logSuffix;
        }
        return null;
    }

    public static boolean isPredefinedReportAvailable(Long formatId) throws DataAccessException {
        Iterator iterator;
        Criteria criteria = new Criteria(Column.getColumn((String)"FormatDetails", (String)"FORMATID"), (Object)formatId, 0);
        DataObject dataObject = PERSISTENCELITE.get("FormatDetails", criteria);
        if (dataObject != null && (iterator = dataObject.getRows("FormatDetails")).hasNext()) {
            Row row = (Row)iterator.next();
            return (Boolean)row.get("PREDEFINED_REPORTS_AVAILABLE");
        }
        return false;
    }

    public static boolean isUserDefined(Long formatId) throws DataAccessException {
        Iterator iterator;
        if (formatIdUserDefined.containsKey(formatId) && formatIdUserDefined.get(formatId) != null) {
            return formatIdUserDefined.get(formatId);
        }
        Criteria criteria = new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_ID"), (Object)formatId, 0);
        DataObject dataObject = PERSISTENCELITE.get("Parser_LogFormats", criteria);
        if (dataObject != null && (iterator = dataObject.getRows("Parser_LogFormats")).hasNext()) {
            Row row = (Row)iterator.next();
            formatIdUserDefined.put(formatId, (Boolean)row.get("USER_DEFINED"));
            return (Boolean)row.get("USER_DEFINED");
        }
        formatIdUserDefined.put(formatId, true);
        return true;
    }
}

