/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.datasource.comparator;

import com.manageengine.ela.server.importlog.datasource.Constants;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Logger;

public class NaturalComparator
implements Comparator {
    private static final Logger LOGGER = Logger.getLogger(NaturalComparator.class.getName());
    private Comparator<String> monthCompare = (o1, o2) -> {
        try {
            SimpleDateFormat s = new SimpleDateFormat("MMM");
            Date s1 = s.parse(o1.substring(0, Math.min(3, o1.length())));
            Date s2 = s.parse(o2.substring(0, Math.min(3, o2.length())));
            return s1.compareTo(s2);
        }
        catch (Exception e) {
            LOGGER.info("IMPLOG : Exception on Natural Compare for month.");
            return 0;
        }
    };
    private Comparator<String> weekCompare = (weekDay1, weekDay2) -> {
        try {
            weekDay1 = weekDay1.substring(0, Math.min(3, weekDay1.length()));
            weekDay2 = weekDay2.substring(0, Math.min(3, weekDay2.length()));
            Integer weekDay1_index = Constants.DAY_LIST_SHORT.indexOf(weekDay1);
            Integer weekDay2_index = Constants.DAY_LIST_SHORT.indexOf(weekDay2);
            return weekDay1_index.compareTo(weekDay2_index);
        }
        catch (Exception e) {
            LOGGER.info("IMPLOG : Exception on Natural Compare for week.");
            return 0;
        }
    };

    private static char charAt(String s, int i) {
        return i >= s.length() ? (char)'\u0000' : s.charAt(i);
    }

    private int compareRight(String a, String b) {
        int bias = 0;
        int ia = 0;
        int ib = 0;
        while (true) {
            char ca = NaturalComparator.charAt(a, ia);
            char cb = NaturalComparator.charAt(b, ib);
            if (!Character.isDigit(ca) && !Character.isDigit(cb)) {
                return bias;
            }
            if (!Character.isDigit(ca)) {
                return -1;
            }
            if (!Character.isDigit(cb)) {
                return 1;
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return bias;
            }
            if (bias == 0) {
                if (ca < cb) {
                    bias = -1;
                } else if (ca > cb) {
                    bias = 1;
                }
            }
            ++ia;
            ++ib;
        }
    }

    public int compare(Object o1, Object o2) {
        String a = o1.toString();
        String b = o2.toString();
        int ia = 0;
        int ib = 0;
        while (true) {
            int bias;
            int nzb = 0;
            int nza = 0;
            char ca = NaturalComparator.charAt(a, ia);
            char cb = NaturalComparator.charAt(b, ib);
            while (Character.isSpaceChar(ca) || ca == '0') {
                nza = ca == '0' ? ++nza : 0;
                ca = NaturalComparator.charAt(a, ++ia);
            }
            while (Character.isSpaceChar(cb) || cb == '0') {
                nzb = cb == '0' ? ++nzb : 0;
                cb = NaturalComparator.charAt(b, ++ib);
            }
            if (Character.isDigit(ca) && Character.isDigit(cb) && (bias = this.compareRight(a.substring(ia), b.substring(ib))) != 0) {
                return bias;
            }
            StringBuilder stringBuilderOfa = new StringBuilder();
            StringBuilder stringBuilderOfb = new StringBuilder();
            while (Character.isAlphabetic(ca) && Character.isAlphabetic(cb)) {
                stringBuilderOfa.append(ca);
                ca = NaturalComparator.charAt(a, ++ia);
                stringBuilderOfb.append(cb);
                cb = NaturalComparator.charAt(b, ++ib);
            }
            String partOfa = stringBuilderOfa.toString();
            String partOfb = stringBuilderOfb.toString();
            if (partOfa.length() > 0 && partOfb.length() > 0 && partOfa.compareTo(partOfb) != 0) {
                if (Constants.DAY_LIST_SHORT.contains(partOfa) && Constants.DAY_LIST_SHORT.contains(partOfb) || Constants.DAY_LIST_LONG.contains(partOfa) && Constants.DAY_LIST_LONG.contains(partOfb)) {
                    return this.weekCompare.compare(partOfa, partOfb);
                }
                if (Constants.MONTH_LIST_SHORT.contains(partOfa) && Constants.MONTH_LIST_SHORT.contains(partOfb) || Constants.MONTH_LIST_LONG.contains(partOfa) && Constants.MONTH_LIST_LONG.contains(partOfb)) {
                    int bias2 = this.compare(a.substring(ia), b.substring(ib));
                    if (bias2 != 0) {
                        return bias2;
                    }
                    return this.monthCompare.compare(partOfa, partOfb);
                }
                return stringBuilderOfa.toString().compareTo(stringBuilderOfb.toString());
            }
            if (ca == '\u0000' && cb == '\u0000') {
                return nza - nzb;
            }
            if (ca < cb) {
                return -1;
            }
            if (ca > cb) {
                return 1;
            }
            ++ia;
            ++ib;
        }
    }
}

