/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.filter;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.manageengine.ela.server.importlog.filter.FilterInterface;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang3.math.NumberUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class TimeFilter
implements FilterInterface {
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();
    private static Long filterId = null;
    private static String filterTableName = null;
    private long startsFrom;
    private long endsAt;

    public TimeFilter(JSONObject filterValue) throws JSONException {
        if (filterValue == null) {
            throw new JSONException("Filter Value cannot be null");
        }
        try {
            this.startsFrom = filterValue.getLong("startTime");
            this.endsAt = filterValue.getLong("endTime");
        }
        catch (JSONException e) {
            throw new JSONException("Filter Value cannot be null");
        }
    }

    public TimeFilter(long startsFrom, long endsAt) {
        this.startsFrom = startsFrom;
        this.endsAt = endsAt;
    }

    public TimeFilter(Long filterId, String filterTableName) throws DataAccessException {
        Iterator iterator;
        if (filterTableName == null) {
            filterTableName = "ELAImportTimeFilter";
        }
        SelectQueryImpl timeFilterSelectQuery = new SelectQueryImpl(Table.getTable((String)filterTableName));
        timeFilterSelectQuery.addSelectColumn(Column.getColumn((String)filterTableName, (String)"*"));
        Criteria filterIdCriteria = new Criteria(Column.getColumn((String)filterTableName, (String)"FILTER_ID"), (Object)filterId, 0);
        timeFilterSelectQuery.setCriteria(filterIdCriteria);
        DataObject dataObject = PERSISTENCELITE.get((SelectQuery)timeFilterSelectQuery);
        if (!dataObject.isEmpty() && (iterator = dataObject.getRows(filterTableName)).hasNext()) {
            Row timeFilterRow = (Row)iterator.next();
            this.startsFrom = NumberUtils.toLong((String)String.valueOf(timeFilterRow.get("START_TIME")));
            this.endsAt = NumberUtils.toLong((String)String.valueOf(timeFilterRow.get("END_TIME")));
        }
    }

    @Override
    public boolean isFilterPassed(HashMap<String, Object> fields) {
        Long time = Long.parseLong(fields.get("TIME").toString());
        return time >= this.startsFrom && time <= this.endsAt;
    }

    @Override
    public void addToDb(Object import_id) throws DataAccessException {
        Criteria criteria;
        DataObject dataObject;
        if (filterId == null && !(dataObject = PERSISTENCELITE.get("ELAImportFilter", criteria = new Criteria(Column.getColumn((String)"ELAImportFilter", (String)"FILTER_NAME"), (Object)"TIME", 0))).isEmpty()) {
            Iterator iterator = dataObject.getRows("ELAImportFilter");
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                filterId = NumberUtils.toLong((String)row.get("FILTER_ID").toString(), (long)1L);
                filterTableName = row.get("FILTER_TABLE") != null ? row.get("FILTER_TABLE").toString() : "ELAImportTimeFilter";
            } else {
                throw new DataAccessException("Specified Filter Format is not defined");
            }
        }
        DataObject dataObject2 = PERSISTENCELITE.constructDataObject();
        Row timeFilterRow = new Row(filterTableName);
        timeFilterRow.set("START_TIME", (Object)this.startsFrom);
        timeFilterRow.set("END_TIME", (Object)this.endsAt);
        Row importFilter = new Row("ELAImportFilterDetails");
        importFilter.set("IMPORT_ID", import_id);
        importFilter.set("FILTER_TYPE", (Object)filterId);
        importFilter.set("FILTER_TYPE_ID", timeFilterRow.get("FILTER_ID"));
        dataObject2.addRow(timeFilterRow);
        dataObject2.addRow(importFilter);
        PERSISTENCELITE.add(dataObject2);
    }
}

