/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.parser;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.parser.Attribute;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.parser.ParserApplyWhenCondition;
import com.manageengine.ela.server.importlog.parser.ParserRule;
import com.manageengine.ela.server.importlog.parser.ParserRuleType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;

public class ImportParserRuleSet {
    private static final Persistence PERSISTENCE_LITE = PersistenceDBUtil.getPersistence();
    private static SelectQuery selectQuery = new SelectQueryImpl(Table.getTable((String)"Parser_Locale"));
    private final Long formatId;
    private ArrayList<ParserRule> primaryParserRuleList = null;
    private ArrayList<ParserRule> skipParserRuleList = null;
    private ArrayList<ParserRule> nonSkipParserRuleList = null;

    public ImportParserRuleSet(Long formatid) {
        this.formatId = formatid;
    }

    public ArrayList<ParserRule> getPrimaryParserRuleList() throws DataAccessException, BaseStatusCode {
        if (this.primaryParserRuleList == null) {
            this.primaryParserRuleList = this.getParserRules(this.formatId, 1);
        }
        return this.primaryParserRuleList;
    }

    public ArrayList<ParserRule> getSkipParserRuleList() throws DataAccessException, BaseStatusCode {
        if (this.skipParserRuleList == null) {
            this.skipParserRuleList = this.getParserRules(this.formatId, 2);
        }
        return this.skipParserRuleList;
    }

    public ArrayList<ParserRule> getNonSkipParserRuleList() throws DataAccessException, BaseStatusCode {
        if (this.nonSkipParserRuleList == null) {
            this.nonSkipParserRuleList = this.getParserRules(this.formatId, 3);
        }
        return this.nonSkipParserRuleList;
    }

    private ArrayList<ParserRule> getParserRules(Long formatId, Integer ruleCategory) throws DataAccessException, BaseStatusCode {
        ArrayList<ParserRule> parserRules = new ArrayList<ParserRule>();
        Criteria criteria = new Criteria(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_ID"), (Object)formatId, 0);
        criteria = criteria.and(Column.getColumn((String)"Parser_Rules", (String)"RULE_CATEGORY"), (Object)ruleCategory, 0);
        selectQuery.setCriteria(criteria);
        DataObject dataObject = PERSISTENCE_LITE.get(selectQuery);
        if (!dataObject.isEmpty()) {
            Iterator parserRulesIterator = dataObject.getRows("Parser_Rules");
            while (parserRulesIterator.hasNext()) {
                Row applyWhenRow;
                Row parserRuleRow = (Row)parserRulesIterator.next();
                Long ruleId = NumberUtils.toLong((String)String.valueOf(parserRuleRow.get("RULE_ID")));
                String applyOn = (String)parserRuleRow.get("APPLY_ON");
                int priority = NumberUtils.toInt((String)String.valueOf(parserRuleRow.get("PRIORITY")), (int)1);
                ParserRule parserRule = new ParserRule(ruleId);
                if (applyOn != null) {
                    parserRule.setApplyOn(applyOn);
                }
                parserRule.setPriority(priority);
                Row ruleTypeRow = dataObject.getRow("Parser_RuleType", new Criteria(Column.getColumn((String)"Parser_RuleType", (String)"RULE_ID"), (Object)ruleId, 0));
                if (ruleTypeRow != null) {
                    String parserType = String.valueOf(ruleTypeRow.get("TYPE"));
                    ParserRuleType parserRuleType = new ParserRuleType(ruleId, ParserRuleType.PARSER_TYPE.getParserType(parserType));
                    switch (ParserRuleType.PARSER_TYPE.getParserType(parserType)) {
                        case REGEX: {
                            Pattern pattern = Pattern.compile(String.valueOf(ruleTypeRow.get("RAW_PATTERN")));
                            parserRuleType.setPattern(pattern);
                            break;
                        }
                        case LOGFORMAT: {
                            String formatName = (String)ruleTypeRow.get("LOGFORMAT");
                            if (Strings.isNullOrEmpty((String)formatName)) break;
                            Long subFormatId = FormatIdentifier.getFormatId(formatName);
                            parserRuleType.setParserRules(this.getParserRules(subFormatId, ruleCategory));
                            break;
                        }
                        case SEPARATOR: {
                            String patternString = (String)ruleTypeRow.get("RAW_PATTERN");
                            if (!Strings.isNullOrEmpty((String)patternString)) {
                                Pattern rawPattern = Pattern.compile(patternString);
                                parserRuleType.setPattern(rawPattern);
                            }
                            parserRuleType.setKeySeparator((String)ruleTypeRow.get("KEY_SEPARATOR"));
                        }
                    }
                    parserRule.setParserRuleType(parserRuleType);
                }
                if ((applyWhenRow = dataObject.getRow("Parser_ApplyWhen", new Criteria(Column.getColumn((String)"Parser_ApplyWhen", (String)"RULE_ID"), (Object)ruleId, 0))) != null) {
                    String keyField = (String)applyWhenRow.get("FIELD");
                    String conditionType = (String)applyWhenRow.get("CONDITION");
                    String value = (String)applyWhenRow.get("VALUE");
                    ParserApplyWhenCondition applyWhenCondition = new ParserApplyWhenCondition(ruleId, keyField, ParserApplyWhenCondition.CONDITION.getConditionType(conditionType));
                    applyWhenCondition.setValue(value);
                    parserRule.setApplyWhenCondition(applyWhenCondition);
                }
                ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                Iterator attributeIterator = dataObject.getRows("Parser_Attributes", new Criteria(Column.getColumn((String)"Parser_Attributes", (String)"RULE_ID"), (Object)ruleId, 0));
                while (attributeIterator.hasNext()) {
                    Row attributeRow = (Row)attributeIterator.next();
                    Integer groupId = NumberUtils.toInt((String)attributeRow.get("GROUP_NUMBER").toString());
                    String groupName = (String)attributeRow.get("KEY");
                    String groupType = (String)attributeRow.get("TYPE");
                    String groupValue = (String)attributeRow.get("VALUE");
                    Attribute attribute = new Attribute(groupId, groupName);
                    attribute.setGroupType(groupType);
                    attribute.setGroupValue(groupValue);
                    attributes.add(attribute);
                }
                parserRule.setAttributes(attributes);
                parserRules.add(parserRule);
            }
        }
        return parserRules;
    }

    static {
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Locale", (String)"LOCALE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Locale", (String)"LOCALE"));
        selectQuery.addJoin(new Join("Parser_Locale", "Parser_Locale2FormatMapping", new String[]{"LOCALE_ID"}, new String[]{"LOCALE_ID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Locale2FormatMapping", (String)"LOCALEMAP_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Locale2FormatMapping", (String)"LOCALE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Locale2FormatMapping", (String)"FORMAT_ID"));
        selectQuery.addJoin(new Join("Parser_Locale2FormatMapping", "Parser_LogFormats", new String[]{"FORMAT_ID"}, new String[]{"FORMAT_ID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_LogFormats", (String)"FORMAT_NAME"));
        selectQuery.addJoin(new Join("Parser_Locale2FormatMapping", "Parser_Rules", new String[]{"LOCALEMAP_ID"}, new String[]{"LOCALEMAP_ID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Rules", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Rules", (String)"LOCALEMAP_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Rules", (String)"RULE_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Rules", (String)"RULE_CATEGORY"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Rules", (String)"APPLY_ON"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Rules", (String)"PRIORITY"));
        selectQuery.addJoin(new Join("Parser_Rules", "Parser_RuleType", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 2));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"TYPE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"TYPE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"RAW_PATTERN"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"VALUE_SEPARATOR"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"KEY_SEPARATOR"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"LOGFORMAT"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_RuleType", (String)"VALUE_GROUPING_CHAR"));
        selectQuery.addJoin(new Join("Parser_Rules", "Parser_Attributes", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Attributes", (String)"ATTR_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Attributes", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Attributes", (String)"GROUP_NUMBER"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Attributes", (String)"KEY"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Attributes", (String)"TYPE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_Attributes", (String)"VALUE"));
        selectQuery.addJoin(new Join("Parser_Rules", "Parser_ApplyWhen", new String[]{"RULE_ID"}, new String[]{"RULE_ID"}, 1));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_ApplyWhen", (String)"APPLY_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_ApplyWhen", (String)"RULE_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_ApplyWhen", (String)"FIELD"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_ApplyWhen", (String)"VALUE"));
        selectQuery.addSelectColumn(Column.getColumn((String)"Parser_ApplyWhen", (String)"CONDITION"));
    }
}

