/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.parser;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;

public class ParserApplyWhenCondition {
    private final Long ruleID;
    private final String keyField;
    private final CONDITION condition;
    private ListOrderedSet values = new ListOrderedSet();
    private Pattern pattern = null;
    private Matcher matcher = null;

    public ParserApplyWhenCondition(Long ruleID, String keyField, CONDITION condition) {
        this.ruleID = ruleID;
        this.keyField = keyField;
        this.condition = condition;
    }

    public Long getRuleID() {
        return this.ruleID;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public CONDITION getCondition() {
        return this.condition;
    }

    public ParserApplyWhenCondition setValue(String value) {
        this.values.clear();
        this.pattern = null;
        this.matcher = null;
        if (Strings.isNullOrEmpty((String)value)) {
            return this;
        }
        switch (this.condition) {
            case EQUALS: 
            case CONTAINS: 
            case REGEX: {
                this.values.add((Object)value);
                break;
            }
            case MULTI: {
                this.values.addAll((Collection)Strings.commaDelimitedListToSet((String)value));
                break;
            }
            case RANGE: 
            case MULTI_RANGE: {
                Set stringValues = Strings.commaDelimitedListToSet((String)value);
                for (String stringValue : stringValues) {
                    String[] pair = Strings.delimitedListToStringArray((String)stringValue, (String)"-");
                    if (pair.length == 2) {
                        Long startFrom = NumberUtils.toLong((String)pair[0]);
                        Long endsAt = NumberUtils.toLong((String)pair[1]);
                        if (startFrom > endsAt) {
                            Long temp = startFrom;
                            startFrom = endsAt;
                            endsAt = temp;
                        }
                        for (long index = startFrom.longValue(); index <= endsAt; ++index) {
                            this.values.add((Object)String.valueOf(index));
                        }
                        continue;
                    }
                    this.values.add((Object)stringValue);
                }
                break;
            }
        }
        return this;
    }

    public ListOrderedSet getValues() {
        return this.values;
    }

    public boolean isConditionSatisfied(Map<String, Object> fields) {
        if (this.values.isEmpty()) {
            return false;
        }
        String fieldValue = String.valueOf(fields.get(this.keyField));
        String firstValue = String.valueOf(this.values.get(0));
        switch (this.condition) {
            case EQUALS: {
                return fieldValue.equalsIgnoreCase(firstValue);
            }
            case CONTAINS: {
                return fieldValue.contains(firstValue);
            }
            case REGEX: {
                if (this.pattern == null) {
                    this.pattern = Pattern.compile(firstValue);
                    this.matcher = this.pattern.matcher(fieldValue);
                }
                this.matcher = this.matcher == null ? this.pattern.matcher(fieldValue) : this.matcher.reset(fieldValue);
                return this.matcher.find(0);
            }
            case MULTI: 
            case RANGE: 
            case MULTI_RANGE: {
                for (Object value : this.values) {
                    if (!value.equals(fieldValue)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static enum CONDITION {
        EQUALS,
        MULTI,
        RANGE,
        MULTI_RANGE,
        CONTAINS,
        REGEX;


        public static CONDITION getConditionType(String type) {
            switch (type) {
                case "EQUALS": {
                    return EQUALS;
                }
                case "MULTI": {
                    return MULTI;
                }
                case "RANGE": {
                    return RANGE;
                }
                case "MULTI_RANGE": {
                    return MULTI_RANGE;
                }
                case "CONTAINS": {
                    return CONTAINS;
                }
                case "REGEX": {
                    return REGEX;
                }
            }
            return null;
        }
    }
}

