/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.parser;

import com.google.common.base.Strings;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.parser.ParserRule;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserRuleType {
    private final Long ruleId;
    private final PARSER_TYPE parserType;
    private Pattern pattern = null;
    private Matcher matcher = null;
    private String keySeparator = null;
    private String valueSeparator = null;
    private ArrayList<ParserRule> parserRules = null;

    public ParserRuleType(Long ruleId, PARSER_TYPE parserType) {
        this.ruleId = ruleId;
        this.parserType = parserType;
    }

    public void setPattern(Pattern pattern) throws BaseStatusCode {
        if (pattern == null) {
            throw BaseStatusCode.getBaseStatusCode(7428);
        }
        this.pattern = pattern;
        this.matcher = pattern.matcher("");
    }

    public Long getRuleId() {
        return this.ruleId;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public PARSER_TYPE getParserType() {
        return this.parserType;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public ArrayList<ParserRule> getParserRules() {
        return this.parserRules;
    }

    public void setParserRules(ArrayList<ParserRule> parserRules) {
        this.parserRules = parserRules;
    }

    public String getKeySeparator() {
        return this.keySeparator;
    }

    public void setKeySeparator(String keySeparator) {
        if (Strings.isNullOrEmpty((String)keySeparator)) {
            this.keySeparator = null;
            return;
        }
        try {
            this.keySeparator = URLDecoder.decode(keySeparator, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            this.keySeparator = keySeparator;
            e.printStackTrace();
        }
    }

    public String getValueSeparator() {
        return this.valueSeparator;
    }

    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public static enum PARSER_TYPE {
        REGEX,
        LOGFORMAT,
        SEPARATOR;


        public static PARSER_TYPE getParserType(String type) {
            switch (type) {
                case "REGEX": {
                    return REGEX;
                }
                case "LOGFORMAT": {
                    return LOGFORMAT;
                }
                case "SEPARATOR": {
                    return SEPARATOR;
                }
            }
            return REGEX;
        }
    }
}

