/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.parser.field.extractor;

import com.adventnet.la.fieldgen.CustomLogTypePatterns;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.persistence.DataAccessException;
import com.google.code.regexp.NamedMatcher;
import com.google.code.regexp.NamedPattern;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import org.elasticsearch.common.Strings;

public abstract class BaseFieldExtractor {
    protected final Long formatId;
    protected String headerLine;
    TimeZone timeZone = TimeZone.getDefault();
    private final ArrayList<NamedMatcher> customMatcher = new ArrayList();

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public BaseFieldExtractor(Long formatId) throws DataAccessException {
        this.formatId = formatId;
        CustomLogTypePatterns logTypePatternsObj = SystemCustomPatternHandler.getInstance().getCustomLogTypePatternsObj(String.valueOf(FormatIdentifier.getReportID(formatId)));
        if (logTypePatternsObj != null) {
            for (Object pattern : logTypePatternsObj.getAllPatterns()) {
                NamedPattern namedPattern = NamedPattern.compile((String)pattern.toString());
                NamedMatcher matcher = namedPattern.matcher((CharSequence)"");
                this.customMatcher.add(matcher);
            }
        }
    }

    public abstract HashMap<String, Object> getFieldsAsMap(String var1) throws Exception;

    protected void applyCustomFields(HashMap<String, Object> fields, String line) {
        if (fields.containsKey("MESSAGE") && !Strings.isNullOrEmpty((String)((String)fields.get("MESSAGE")))) {
            line = fields.get("MESSAGE").toString();
        }
        for (NamedMatcher namedMatcher : this.customMatcher) {
            namedMatcher.reset((CharSequence)line);
            if (!namedMatcher.find(0)) continue;
            fields.putAll(namedMatcher.namedGroups());
        }
    }

    public String getHeaderLine() {
        return this.headerLine;
    }
}

