/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.parser.field.extractor;

import com.adventnet.persistence.DataAccessException;
import com.manageengine.ela.server.importlog.parser.field.extractor.BaseFieldExtractor;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.elasticsearch.common.Strings;

public class CSVFieldExtractor
extends BaseFieldExtractor {
    private final CSVRecord headerRecord;

    public CSVFieldExtractor(Long formatId, String headerLine) throws IOException, DataAccessException {
        super(formatId);
        headerLine = headerLine.replaceAll("\\.", "_");
        CSVParser csvHeader = CSVParser.parse((String)headerLine, (CSVFormat)CSVFormat.EXCEL);
        List headerList = csvHeader.getRecords();
        this.headerRecord = headerList.stream().findFirst().orElse(null);
    }

    @Override
    public HashMap<String, Object> getFieldsAsMap(String line) throws Exception {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (this.headerRecord == null || Strings.isNullOrEmpty((String)line)) {
            return fields;
        }
        CSVParser csvParser = CSVParser.parse((String)line, (CSVFormat)CSVFormat.EXCEL);
        for (CSVRecord csvRecord : csvParser) {
            for (int i = 0; i < this.headerRecord.size(); ++i) {
                fields.put(this.headerRecord.get(i), csvRecord.get(i));
            }
        }
        this.applyCustomFields(fields, line);
        return fields;
    }
}

