/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.parser.field.extractor;

import com.adventnet.la.univlogparser.TimeUtil;
import com.adventnet.sa.server.parser.Attribute;
import com.google.code.regexp.NamedMatcher;
import com.google.code.regexp.NamedPattern;
import com.google.common.base.Strings;
import com.manageengine.ela.server.importlog.datasource.Constants;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.parser.ImportParserRuleSet;
import com.manageengine.ela.server.importlog.parser.ParserApplyWhenCondition;
import com.manageengine.ela.server.importlog.parser.ParserRule;
import com.manageengine.ela.server.importlog.parser.ParserRuleType;
import com.manageengine.ela.server.importlog.parser.field.extractor.BaseFieldExtractor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;

public class LogFieldExtractor
extends BaseFieldExtractor {
    private static final Logger LOGGER = Logger.getLogger(LogFieldExtractor.class.getName());
    private static final Pattern SUB_PATTERN = Pattern.compile("_\\((.*?)\\)");
    private Matcher subMatcher = SUB_PATTERN.matcher("");
    private List<String> dynamicFields = null;
    private String keySeparator = null;
    private final SimpleDateFormat hourDf = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
    private final ArrayList<ParserRule> primaryParserRules;
    private final ArrayList<ParserRule> skipParserRules;
    private final ArrayList<ParserRule> nonSkipParserRules;
    private final HashMap<String, Object> fields = new HashMap();
    private ArrayList<String> dateFormatSet = new ArrayList();
    private NamedMatcher namedDatePrefixMatcher = null;

    public LogFieldExtractor(Long formatId, String headerLine) throws Exception {
        super(formatId);
        ImportParserRuleSet importParserRuleSet = new ImportParserRuleSet(formatId);
        this.primaryParserRules = importParserRuleSet.getPrimaryParserRuleList();
        this.skipParserRules = importParserRuleSet.getSkipParserRuleList();
        this.nonSkipParserRules = importParserRuleSet.getNonSkipParserRuleList();
        String prefixDatePattern = FormatIdentifier.getFormatLogPrefix(formatId);
        if (!Strings.isNullOrEmpty((String)prefixDatePattern) && prefixDatePattern.contains("<")) {
            NamedPattern namedPatternDatePrefix = NamedPattern.compile((String)prefixDatePattern);
            this.namedDatePrefixMatcher = namedPatternDatePrefix.matcher((CharSequence)"");
        }
        if (!Strings.isNullOrEmpty((String)headerLine)) {
            this.headerLine = headerLine;
            this.getFieldsAsMap(headerLine);
        }
    }

    private String getDerivedValue(String pattern, HashMap fields) {
        this.subMatcher = this.subMatcher.reset(pattern);
        String returnValue = pattern;
        ArrayList<String> matchList = new ArrayList<String>();
        while (this.subMatcher.find()) {
            matchList.add(this.subMatcher.group(1));
        }
        for (String s : matchList) {
            if (!fields.containsKey(s)) continue;
            returnValue = returnValue.replace("_(" + s + ")", (CharSequence)fields.get(s));
        }
        return returnValue;
    }

    @Override
    public HashMap<String, Object> getFieldsAsMap(String line) throws Exception {
        ParserApplyWhenCondition applyWhenCondition;
        if (Strings.isNullOrEmpty((String)line)) {
            return null;
        }
        this.fields.clear();
        this.dateFormatSet.clear();
        for (ParserRule primaryParserRule : this.primaryParserRules) {
            this.matchAndSetAttribute(primaryParserRule, line);
        }
        this.normalizeFields(line);
        for (ParserRule skipParserRule : this.skipParserRules) {
            applyWhenCondition = skipParserRule.getApplyWhenCondition();
            if (applyWhenCondition == null || !applyWhenCondition.isConditionSatisfied(this.fields)) continue;
            this.matchAndSetAttribute(skipParserRule, line);
        }
        for (ParserRule nonSkipParserRule : this.nonSkipParserRules) {
            applyWhenCondition = nonSkipParserRule.getApplyWhenCondition();
            if (applyWhenCondition != null && applyWhenCondition.isConditionSatisfied(this.fields)) {
                this.matchAndSetAttribute(nonSkipParserRule, line);
                continue;
            }
            if (applyWhenCondition != null) continue;
            this.matchAndSetAttribute(nonSkipParserRule, line);
        }
        if (!this.fields.isEmpty()) {
            this.resolveTime(line);
        } else if (this.namedDatePrefixMatcher != null) {
            this.resolveTime(line);
        }
        this.applyCustomFields(this.fields, line);
        return this.fields;
    }

    private void normalizeFields(String line) {
        if (this.fields.containsKey("_NORMALIZE_PRI")) {
            Integer priVal = NumberUtils.toInt((String)String.valueOf(this.fields.remove("_NORMALIZE_PRI")));
            Integer facility = priVal / 8;
            Integer severity = priVal % 8;
            this.fields.put("FACILITY", Constants.SYS_LOG_FACILITY_LIST.get(facility));
            this.fields.put("COMMON_SEVERITY", Constants.UNIX_SEVERITY_LIST.get(severity));
            this.fields.put("SEVERITY", severity);
        }
        if (this.fields.containsKey("PID") && this.fields.get("PID") != null && this.fields.containsKey("PROCESSID") && this.fields.get("PROCESSID") != null && this.fields.get("PID").equals(this.fields.get("PROCESSID"))) {
            this.fields.remove("PID");
        }
        if (this.dynamicFields != null && this.dynamicFields.size() > 0 && this.keySeparator != null && this.fields.get("PARSER_KEY") != null && !this.fields.get("PARSER_KEY").equals("HEADER")) {
            List<String> values = Arrays.asList(line.split(this.keySeparator));
            for (int index = 0; index < values.size() && index < this.dynamicFields.size(); ++index) {
                this.fields.put(this.dynamicFields.get(index), values.get(index));
            }
        }
    }

    private void matchAndSetAttribute(ParserRule parserRule, String line) {
        ParserRuleType parserRuleType = parserRule.getParserRuleType();
        ParserRuleType.PARSER_TYPE parserType = parserRuleType.getParserType();
        switch (parserType) {
            case REGEX: {
                this.regexMatchAndSet(parserRule, parserRuleType, line);
                break;
            }
            case LOGFORMAT: {
                ArrayList<ParserRule> subParserRules = parserRuleType.getParserRules();
                for (ParserRule subParserRule : subParserRules) {
                    this.matchAndSetAttribute(subParserRule, line);
                }
                break;
            }
            case SEPARATOR: {
                Matcher matcher = parserRuleType.getMatcher().reset(line);
                if (!matcher.find()) break;
                this.headerLine = line;
                String extractedHeader = matcher.group(1);
                this.keySeparator = parserRuleType.getKeySeparator();
                this.dynamicFields = Arrays.asList(extractedHeader.split(parserRuleType.getKeySeparator()));
                this.dynamicFields.replaceAll(field -> field.replace('-', '_'));
            }
        }
    }

    private void regexMatchAndSet(ParserRule parserRule, ParserRuleType parserRuleType, String line) {
        ArrayList<Attribute> attributes = parserRule.getAttributes();
        Matcher matcher = parserRule.getApplyOn() != null && this.fields.containsKey(parserRule.getApplyOn()) ? parserRuleType.getMatcher().reset(String.valueOf(this.fields.get(parserRule.getApplyOn()))) : parserRuleType.getMatcher().reset(line);
        if (matcher.find(0)) {
            for (Attribute attribute : attributes) {
                if (attribute.getGroupNumber() <= 0) continue;
                String value = matcher.group(attribute.getGroupNumber());
                if (Strings.isNullOrEmpty((String)value)) {
                    value = "-";
                }
                this.fields.put(attribute.getGroupName(), value);
            }
            for (Attribute attribute : attributes) {
                if (attribute.getGroupNumber() >= 0) continue;
                String groupType = attribute.getGroupType();
                String groupName = attribute.getGroupName();
                String groupValue = attribute.getGroupValue();
                if (groupType.equalsIgnoreCase("OPEN")) {
                    if (groupName.startsWith("DATE_FORMAT_")) {
                        this.dateFormatSet.add(groupValue);
                        continue;
                    }
                    this.fields.put(groupName, groupValue);
                    continue;
                }
                if (!groupType.equalsIgnoreCase("DERIVED")) continue;
                String value = this.getDerivedValue(groupValue, this.fields);
                if (groupName.equalsIgnoreCase("log_msg")) {
                    groupName = "MESSAGE";
                }
                this.fields.put(groupName, value);
            }
        }
    }

    private void resolveTime(String line) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        if (!this.dateFormatSet.isEmpty()) {
            this.dateFormatSet.stream().distinct().forEach(dateFormat -> {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)dateFormat);
                    simpleDateFormat.setTimeZone(this.timeZone);
                    Date date = simpleDateFormat.parse((String)this.fields.get("DATE_STRING"));
                    calendar.setTime(date);
                    calendar.setTimeZone(TimeZone.getDefault());
                    if (calendar.get(1) < 1980 || this.fields.containsKey("NO_YEAR")) {
                        calendar.set(1, year);
                    }
                }
                catch (Exception e) {
                    LOGGER.fine("IMPLOG : Exception while parsing date");
                }
            });
        } else if (this.fields.get("TIME_STRING") != null && this.fields.get("TIME_STRING").toString().length() > 0) {
            calendar.setTimeInMillis(NumberUtils.toLong((String)this.fields.get("TIME_STRING").toString()));
        }
        if (this.namedDatePrefixMatcher != null) {
            this.namedDatePrefixMatcher = this.namedDatePrefixMatcher.reset((CharSequence)line);
            if (this.namedDatePrefixMatcher.find(0) && this.namedDatePrefixMatcher.groupCount() > 0) {
                Long time = TimeUtil.generateParsedTime((Map)this.namedDatePrefixMatcher.namedGroups());
                calendar.setTimeInMillis(time);
            }
        }
        this.fields.put("TIME", calendar.getTimeInMillis());
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        this.fields.put("HOUR", this.hourDf.format(calendar.getTime()));
        this.fields.put("HOUROFDAY", "" + calendar.get(11));
    }
}

