/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.ela.server.importlog.processors;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LuceneUtil;
import com.adventnet.la.fieldgen.CustomLogTypePatterns;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.common.application.util.ApplicationUtil;
import com.manageengine.ela.server.common.device.util.DeviceUtil;
import com.manageengine.ela.server.common.executors.processor.ConcurrentQueueProcessor;
import com.manageengine.ela.server.common.executors.queue.ConcurrentQueue;
import com.manageengine.ela.server.common.io.file.parser.ExtractedResultListener;
import com.manageengine.ela.server.common.io.file.pattern.DynamicPattern;
import com.manageengine.ela.server.common.io.file.pattern.PatternDetailsBean;
import com.manageengine.ela.server.common.io.file.pattern.PatternUtils;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.importlog.ImportFile;
import com.manageengine.ela.server.importlog.ImportLogAuditDetails;
import com.manageengine.ela.server.importlog.ImportUtils;
import com.manageengine.ela.server.importlog.LogBuilder;
import com.manageengine.ela.server.importlog.LogProperties;
import com.manageengine.ela.server.importlog.datasource.FormatIdentifier;
import com.manageengine.ela.server.importlog.parser.field.extractor.BaseFieldExtractor;
import com.manageengine.ela.server.importlog.processors.BaseLogProcessorBean;
import com.manageengine.ela.server.importlog.report.ReportUtil;
import com.manageengine.ela.server.importlog.report.SubReportCounter;
import com.zoho.za.dae.elastic.LogIndexer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;

public class BaseLogProcessor
extends ConcurrentQueueProcessor<LogProperties> {
    private static final Logger LOGGER = Logger.getLogger(BaseLogProcessor.class.getName());
    private static final Persistence PERSISTENCELITE = PersistenceDBUtil.getPersistenceLite();

    public BaseLogProcessor(ConcurrentQueue<LogProperties> queue) throws IllegalArgumentException {
        super(queue);
    }

    @Override
    public void process(LogProperties logProperties) {
        block7: {
            try {
                if (this.checkCurrentRunningStatus(logProperties)) {
                    return;
                }
                ImportLogAuditDetails importLogAuditDetails = ImportLogAuditDetails.getLatestAuditDetails(logProperties.getSourceId());
                logProperties.setHeaderLine(importLogAuditDetails.getHeaderRow());
                logProperties.setLineCount(importLogAuditDetails.getLineCount());
                logProperties.setRecordMarker(importLogAuditDetails.getRecordMarker());
                DataObject dataObject = PERSISTENCELITE.constructDataObject();
                Row importLogAuditRow = new Row("ELAImportLogAudit");
                importLogAuditRow.set("SOURCE_ID", (Object)logProperties.getSourceId());
                importLogAuditRow.set("FILE_NAME", (Object)logProperties.getFileName());
                importLogAuditRow.set("STATUS", (Object)12194L);
                dataObject.addRow(importLogAuditRow);
                PERSISTENCELITE.add(dataObject);
                this.processNewSource(logProperties);
                PatternDetailsBean patternDetailsBean = logProperties.getDynamicPatternDetails();
                if (patternDetailsBean == null || patternDetailsBean.getDynamicPatterns() == null || patternDetailsBean.getDynamicPatterns().size() <= 0) break block7;
                ImportFile importFile = new ImportFile(logProperties.getCompleteFilePath(), logProperties.getFileSourceType());
                ArrayList<DynamicPattern> dynamicPatterns = patternDetailsBean.getDynamicPatterns();
                List<String> newFileList = PatternUtils.getNewFileList(dynamicPatterns, logProperties);
                boolean isWeekDayPattern = PatternUtils.isWeekDayPattern(dynamicPatterns);
                if (isWeekDayPattern) {
                    List<String> tempList = newFileList;
                    try {
                        newFileList = PatternUtils.sortFileListForWeekDayPattern(newFileList);
                    }
                    catch (Exception e) {
                        newFileList = tempList;
                    }
                }
                newFileList.remove(logProperties.getFileName());
                for (String newFileName : newFileList) {
                    logProperties.resetAuditDetails();
                    importFile.setFilename(newFileName);
                    logProperties.setImportFile(importFile);
                    dataObject = PERSISTENCELITE.constructDataObject();
                    importLogAuditRow = new Row("ELAImportLogAudit");
                    importLogAuditRow.set("SOURCE_ID", (Object)logProperties.getSourceId());
                    importLogAuditRow.set("FILE_NAME", (Object)logProperties.getFileName());
                    importLogAuditRow.set("STATUS", (Object)12194L);
                    dataObject.addRow(importLogAuditRow);
                    PERSISTENCELITE.add(dataObject);
                    this.processNewSource(logProperties);
                }
            }
            catch (Exception e) {
                logProperties.setStatus(12197L);
                ImportUtils.updateImportStatus(logProperties, null);
                e.printStackTrace();
            }
        }
    }

    private synchronized boolean checkCurrentRunningStatus(LogProperties logProperties) throws DataAccessException {
        Long status;
        Long sourceId = logProperties.getSourceId();
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogConfigurations", (String)"SOURCE_ID"), (Object)sourceId, 0);
        DataObject configDataObject = PersistenceDBUtil.getPersistence().get("ELAImportLogConfigurations", criteria);
        if (!(configDataObject.isEmpty() || (status = (Long)configDataObject.getFirstValue("ELAImportLogConfigurations", "IMPORT_STATUS")) != 12195L && status != 12145L)) {
            LOGGER.info("IMPLOG : Already importing.. Skipping this import");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processNewSource(LogProperties logProperties) throws Exception {
        LogBuilder logBuilder = null;
        BaseLogProcessorBean baseLogProcessorBean = new BaseLogProcessorBean();
        try {
            logProperties.setStatus(12145L);
            ImportUtils.updateDb(logProperties);
            Long initialLineCount = logProperties.getLineCount();
            if (initialLineCount == null) {
                initialLineCount = 0L;
            }
            boolean isEvt = logProperties.getFileName().toLowerCase().endsWith(".evtx") || logProperties.getFileName().toLowerCase().endsWith(".evt");
            LOGGER.info("IMPLOG : New Import Processing started for " + logProperties.getCompleteFilePath());
            logBuilder = new LogBuilder(logProperties);
            boolean isOpen = logBuilder.open();
            Long appId = ApplicationUtil.addAndGetAppId(logProperties.getAttachedDeviceId(), logProperties.getReportId());
            logProperties.setAppId(appId);
            ImportUtils.updateAppId(logProperties);
            boolean isUserDefined = FormatIdentifier.isUserDefined(logProperties.getLogFormatId());
            Iterator iterator = logBuilder.iterator();
            long start = System.currentTimeMillis();
            if (logProperties.getLogFormatId() < 0L || !isOpen) {
                logProperties.setStatus(12197L);
                this.closeProcess(logBuilder, logProperties, baseLogProcessorBean);
                this.closeProcess(logBuilder, logProperties, baseLogProcessorBean);
                return;
            }
            Long importedTime = System.currentTimeMillis();
            baseLogProcessorBean.importedTime = importedTime;
            baseLogProcessorBean.isThrowAway = logProperties.isThrowAway();
            BaseFieldExtractor fieldExtractor = ExtractedResultListener.getFieldExtractor(logProperties.getLogFormatId(), logBuilder);
            LOGGER.info("IMPLOG : " + logProperties.getCompleteFilePath() + " Import Started");
            logProperties.setStatus(12195L);
            logProperties.setSize(logBuilder.getTotalFileSize());
            baseLogProcessorBean.importFilters = logProperties.getImportFilters();
            ImportUtils.updateDb(logProperties);
            logProperties.setTotalParsedSize(0.0);
            Double completePercentage = 0.0;
            baseLogProcessorBean.indexCount = 0L;
            baseLogProcessorBean.severityCounter.reset();
            baseLogProcessorBean.reportApplyWhenConditions = ReportUtil.getApplyWhenConditions(logProperties.getReportId());
            baseLogProcessorBean.subReportCounter = new SubReportCounter(logProperties.getAppId());
            baseLogProcessorBean.colList.clear();
            SelectQuery selectCountQuery = this.getCountQuery(logProperties);
            ArchiveFileManager archiveFileManager = ArchiveFileManager.getInstance();
            LogForwarderFilter logforwarder = LogForwarderFilter.getInstance();
            NotificationManager nfManager = NotificationManager.getInstance();
            String formatDesc = FormatIdentifier.getFormatDesc(logProperties.getLogFormatId());
            String formatName = FormatIdentifier.getFormatName(logProperties.getLogFormatId());
            String deviceName = null;
            if (logProperties.getAttachedDeviceId() > 0L) {
                deviceName = DeviceUtil.getDeviceName(logProperties.getAttachedDeviceId()).getDeviceName();
            }
            String appKey = deviceName != null ? deviceName + "_" + formatName : formatName;
            boolean isRunning = true;
            String logLine = null;
            while (iterator.hasNext() && isRunning) {
                boolean indexStatus;
                logLine = iterator.next().toString();
                HashMap<String, Object> extractedFields = fieldExtractor.getFieldsAsMap(logLine);
                if (isUserDefined) {
                    CustomLogTypePatterns.applyAllCommonPatterns((String)logLine, extractedFields);
                }
                if (extractedFields == null || extractedFields.size() == 0 && !ImportUtils.hasAlphanumericCharacter(logLine) || extractedFields.containsKey("SKIP_THIS_LOG") && extractedFields.get("SKIP_THIS_LOG").equals("1")) continue;
                extractedFields.put("APPID", logProperties.getAppId());
                if (formatName.equals("ibm_as400") || formatName.equals("sys_archive") || formatName.equals("win_archive") || formatName.equals("syslog")) {
                    extractedFields.put("HOSTID", logProperties.getAttachedDeviceId());
                }
                if (isEvt || formatName.equals("win_archive")) {
                    extractedFields.put("HOSTTYPE", "Windows");
                    extractedFields.put("ISEVT", true);
                } else {
                    extractedFields.put("HOSTTYPE", formatDesc);
                }
                extractedFields.put("HOSTNAME", logProperties.getAttachedDeviceName());
                extractedFields.put("FORMATID", logProperties.getReportId());
                if (!extractedFields.containsKey("TIME")) {
                    extractedFields.put("TIME", System.currentTimeMillis());
                }
                if (!extractedFields.containsKey("RAWLOG")) {
                    extractedFields.put("RAWLOG", logLine);
                }
                extractedFields.put("IMPORTED_TIME", importedTime);
                if (logProperties.isThrowAway()) {
                    extractedFields.put("IS_THROWAWAY", true);
                    indexStatus = baseLogProcessorBean.insertToIndex(extractedFields, baseLogProcessorBean);
                } else {
                    indexStatus = baseLogProcessorBean.insertToIndex(extractedFields, baseLogProcessorBean);
                }
                Double totalParsedPercentage = 1.0 * (double)logBuilder.getTotalProcessedSize() / (double)logBuilder.getTotalFileSize() * 100.0;
                logProperties.setTotalParsedSize(totalParsedPercentage);
                if (Math.abs(totalParsedPercentage - completePercentage) > 1.0 && totalParsedPercentage <= 100.0) {
                    completePercentage = totalParsedPercentage;
                    isRunning = this.updateCount(logProperties, selectCountQuery);
                }
                if (!indexStatus) continue;
                if (extractedFields.containsKey("TIME")) {
                    logProperties.setLogTime(NumberUtils.toLong((String)String.valueOf(extractedFields.get("TIME"))));
                }
                if (baseLogProcessorBean.severityCounter.getTotal() > 1000000L) {
                    baseLogProcessorBean.updateDbTrendCount(logProperties, baseLogProcessorBean, true);
                }
                archiveFileManager.archiveAppLog(formatName, deviceName, appKey, logLine);
                nfManager.notify(new Hashtable<String, Object>(extractedFields));
                logforwarder.filterAndForward(new Hashtable<String, Object>(extractedFields));
            }
            logProperties.setRecordMarker(logLine);
            Long endInMillis = System.currentTimeMillis() - start;
            logProperties.setTotalParsedSize((double)logBuilder.getTotalProcessedSize() * 1.0);
            logProperties.setStatus(12196L);
            logProperties.setLastImport(System.currentTimeMillis());
            logProperties.setTimeTaken(endInMillis);
            logProperties.setHeaderLine(fieldExtractor.getHeaderLine());
            logProperties.setCurrentLineCount(logProperties.getLineCount() == null ? logBuilder.getLineCount() : logBuilder.getLineCount() - logProperties.getLineCount());
            logProperties.setLineCount(logBuilder.getLineCount());
            baseLogProcessorBean.updateDbTrendCount(logProperties, baseLogProcessorBean, true);
            LOGGER.info("IMPLOG : " + logProperties.getCompleteFilePath() + " Import Finished in(" + baseLogProcessorBean.indexCount + " logs indexed out of " + logBuilder.getLineCount() + " lines) :" + (double)endInMillis.longValue() / 1000.0 + " sec");
            this.closeProcess(logBuilder, logProperties, baseLogProcessorBean);
        }
        catch (BaseStatusCode be) {
            if (be.getOrgStatusCode() == 12033L) {
                logProperties.setStatus(12033L);
            } else {
                logProperties.setStatus(12197L);
            }
            be.printStackTrace();
            String customMsg = be.getDisplayText();
            ImportUtils.updateImportStatus(logProperties, customMsg);
        }
        catch (Throwable e) {
            logProperties.setStatus(12197L);
            e.printStackTrace();
            ImportUtils.updateImportStatus(logProperties, null);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            this.closeProcess(logBuilder, logProperties, baseLogProcessorBean);
        }
        finally {
            this.closeProcess(logBuilder, logProperties, baseLogProcessorBean);
        }
    }

    private synchronized SelectQuery getCountQuery(LogProperties logProperties) {
        SelectQueryImpl selectCountQuery = new SelectQueryImpl(Table.getTable((String)"ELAImportSourceConfigurations"));
        selectCountQuery.addJoin(new Join("ELAImportSourceConfigurations", "ELAImportLogAudit", new String[]{"SOURCE_ID"}, new String[]{"SOURCE_ID"}, 1));
        selectCountQuery.addJoin(new Join("ELAImportSourceConfigurations", "ELAImportLogConfigurations", new String[]{"SOURCE_ID"}, new String[]{"SOURCE_ID"}, 2));
        selectCountQuery.addSelectColumn(Column.getColumn((String)"ELAImportSourceConfigurations", (String)"*"));
        selectCountQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogConfigurations", (String)"*"));
        selectCountQuery.addSelectColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"*"));
        SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ELAImportLogAudit", (String)"AUDIT_ID"), false);
        selectCountQuery.addSortColumn(sortColumn);
        Criteria criteria = new Criteria(Column.getColumn((String)"ELAImportLogAudit", (String)"SOURCE_ID"), (Object)logProperties.getSourceId(), 0);
        selectCountQuery.setCriteria(criteria);
        return selectCountQuery;
    }

    private synchronized void closeProcess(LogBuilder logBuilder, LogProperties logProperties, BaseLogProcessorBean baseLogProcessorBean) throws DataAccessException {
        LogIndexer.flush();
        LogIndexingAPI.getInstance().fflush();
        if (logProperties.getReportId() > 0L) {
            baseLogProcessorBean.colList.removeAll(Arrays.asList("APPID", "HOSTID", "DATE_STRING", "PARSER_KEY", "IMPORTED_TIME", "IS_THROWAWAY", "ISEVT"));
            Criteria formatIdCriteria = new Criteria(Column.getColumn((String)"FormatFields", (String)"FORMATID"), (Object)logProperties.getReportId(), 0);
            DataObject formatFields = PERSISTENCELITE.get("FormatFields", formatIdCriteria);
            ArrayList<String> colList = new ArrayList<String>();
            if (!formatFields.isEmpty()) {
                Iterator formatFieldsIterator = formatFields.getRows("FormatFields");
                while (formatFieldsIterator.hasNext()) {
                    Row formatFieldRow = (Row)formatFieldsIterator.next();
                    String fieldName2 = (String)formatFieldRow.get("FIELDNAME");
                    if (Strings.isNullOrEmpty((String)fieldName2)) continue;
                    colList.add(fieldName2);
                }
            }
            List<String> newCol = baseLogProcessorBean.colList.stream().filter(p -> !colList.contains(p)).collect(Collectors.toList());
            newCol.forEach(fieldName -> {
                try {
                    Row row = new Row("FormatFields");
                    row.set("FORMATID", (Object)logProperties.getReportId());
                    row.set("FIELDNAME", fieldName);
                    formatFields.addRow(row);
                }
                catch (DataAccessException e) {
                    e.printStackTrace();
                }
            });
            if (newCol.size() > 0) {
                PERSISTENCELITE.update(formatFields);
            }
            List list = Stream.concat(baseLogProcessorBean.colList.stream(), colList.stream()).distinct().collect(Collectors.toList());
            LuceneUtil.addAppToColsMap((String)String.valueOf(logProperties.getReportId()), list);
            LuceneUtil.addViewColsMap((String)String.valueOf(logProperties.getReportId()), list);
        }
        if (logBuilder != null) {
            logBuilder.close();
        }
        ImportUtils.updateDb(logProperties);
    }

    private synchronized boolean updateCount(LogProperties logProperty, SelectQuery selectQuery) {
        boolean isRunning = false;
        try {
            DataObject dataObject = PERSISTENCELITE.get(selectQuery);
            if (!dataObject.isEmpty()) {
                Iterator importLogConfigurationIterator;
                Iterator importLogAuditDetailsIterator = dataObject.getRows("ELAImportLogAudit");
                if (importLogAuditDetailsIterator.hasNext()) {
                    Row importLogAuditDetailsRow = (Row)importLogAuditDetailsIterator.next();
                    importLogAuditDetailsRow.set("CONTENT_SIZE", (Object)logProperty.getTotalParsedSize());
                    if (logProperty.getLastImport() != null && logProperty.getTimeTaken() >= 0L) {
                        importLogAuditDetailsRow.set("START_TIME", (Object)(logProperty.getLastImport() - logProperty.getTimeTaken()));
                        importLogAuditDetailsRow.set("END_TIME", (Object)logProperty.getLastImport());
                        importLogAuditDetailsRow.set("TIME_TAKEN", (Object)logProperty.getTimeTaken());
                    }
                    if (logProperty.getLineCount() != null) {
                        importLogAuditDetailsRow.set("NO_OF_LINE_READ", (Object)logProperty.getLineCount());
                        importLogAuditDetailsRow.set("CURRENT_LINE_READ", (Object)logProperty.getCurrentLineCount());
                    }
                    dataObject.updateRow(importLogAuditDetailsRow);
                    PERSISTENCELITE.update(dataObject);
                }
                if ((importLogConfigurationIterator = dataObject.getRows("ELAImportLogConfigurations")).hasNext()) {
                    Row importLogConfigurationRow = (Row)importLogConfigurationIterator.next();
                    Long status = NumberUtils.toLong((String)String.valueOf(importLogConfigurationRow.get("IMPORT_STATUS")), (long)12193L);
                    isRunning = status != 12193L && status != 12196L && status != 12197L && status != 12198L && status != 12199L;
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("IMPLOG : Exception while updating count");
            e.printStackTrace();
        }
        return isRunning;
    }
}

